/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthState;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.exoplatform.outlook.OutlookUser;
import org.exoplatform.outlook.mail.BadCredentialsException;
import org.exoplatform.outlook.mail.ForbiddenException;
import org.exoplatform.outlook.mail.MailServerException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class MailAPI {
    protected static final Log LOG = ExoLogger.getLogger(MailAPI.class);
    protected static final String READ_ATTACHMENT_ERROR = "Error requesting message attachment";
    protected static final String READ_MESSAGE_ERROR = "Error requesting message";
    protected static final String MODELS_ERROR = "Error requesting workspace models";
    protected final CloseableHttpClient httpClient;
    protected final HttpClientContext httpContext;
    protected final Header acceptJsonHeader;

    MailAPI(CloseableHttpClient httpClient) throws MailServerException {
        if (httpClient == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setDefaultMaxPerRoute(10);
            connectionManager.setMaxTotal(100);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setExpectContinueEnabled(true).setStaleConnectionCheckEnabled(true).setAuthenticationEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("Basic")).build();
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).build();
        } else {
            this.httpClient = httpClient;
        }
        this.acceptJsonHeader = new BasicHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        this.httpContext = HttpClientContext.create();
    }

    public MailAPI() throws MailServerException {
        this(null);
    }

    public void close() throws MailServerException {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new MailServerException("Error closing HTTP client", e);
        }
    }

    public void reset() {
        AuthState authState = this.httpContext.getTargetAuthState();
        if (authState != null) {
            authState.reset();
        }
    }

    /*
     * Exception decompiling
     */
    public JsonValue getAttachment(OutlookUser user, String messageId, String attachmentToken, String attachmentId) throws BadCredentialsException, ForbiddenException, MailServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public JsonValue getMessage(OutlookUser user, String messageId, String messageToken) throws BadCredentialsException, ForbiddenException, MailServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected JsonValue readJson(InputStream content) throws JsonException {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler handler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(content, ContentType.APPLICATION_JSON.getCharset()), (JsonHandler)handler);
        return handler.getJsonObject();
    }

    protected String readText(HttpEntity entity) {
        String errorText;
        try {
            Header encodingHeader = entity.getContentEncoding();
            Charset encoding = encodingHeader != null ? Charset.forName(encodingHeader.getValue()) : Consts.UTF_8;
            errorText = EntityUtils.toString((HttpEntity)entity, (Charset)encoding);
        }
        catch (UnsupportedCharsetException e) {
            LOG.warn((Object)"Unsupported entity encoding", (Throwable)e);
            errorText = null;
        }
        catch (IllegalCharsetNameException e) {
            LOG.warn((Object)"Illageal entity encoding", (Throwable)e);
            errorText = null;
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)"Entity encoding is null", (Throwable)e);
            errorText = null;
        }
        catch (ParseException e) {
            LOG.warn((Object)"Error parsing entity as text", (Throwable)e);
            errorText = null;
        }
        catch (IOException e) {
            LOG.warn((Object)"Error reading entity as text", (Throwable)e);
            errorText = null;
        }
        return errorText;
    }

    protected void checkError(HttpResponse response, String errorBase) throws BadCredentialsException, ForbiddenException, MailServerException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 400) {
            String errorText = this.readText(response.getEntity());
            String userInfo = "";
            if (status == 401) {
                this.reset();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Mail server authentication failure " + userInfo + errorText));
                }
                String message = "Authentication failed. " + errorText;
                throw new BadCredentialsException(message);
            }
            if (status == 403) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Mail server access forbidden" + userInfo + errorText));
                }
                String message = "Access forbidden. " + errorText;
                throw new ForbiddenException(message);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Mail server error" + userInfo + errorText));
            }
            String message = errorBase + ". " + errorText;
            throw new MailServerException(message);
        }
    }
}

