/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook;

import com.ibm.icu.text.Transliterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.entity.ContentType;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.outlook.BadParameterException;
import org.exoplatform.outlook.OutlookEmail;
import org.exoplatform.outlook.OutlookException;
import org.exoplatform.outlook.OutlookFormatException;
import org.exoplatform.outlook.OutlookMessage;
import org.exoplatform.outlook.OutlookService;
import org.exoplatform.outlook.OutlookSpace;
import org.exoplatform.outlook.OutlookSpaceException;
import org.exoplatform.outlook.OutlookUser;
import org.exoplatform.outlook.jcr.File;
import org.exoplatform.outlook.jcr.Folder;
import org.exoplatform.outlook.jcr.HierarchyNode;
import org.exoplatform.outlook.jcr.NodeFinder;
import org.exoplatform.outlook.jcr.UserDocuments;
import org.exoplatform.outlook.mail.MailAPI;
import org.exoplatform.outlook.mail.MailServerException;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.picocontainer.Startable;

public class OutlookServiceImpl
implements OutlookService,
Startable {
    public static final String MAILSERVER_URL = "mailserver-url";
    protected static final String EXO_PRIVILEGEABLE = "exo:privilegeable";
    protected static final String OUTLOOK_MESSAGES_TITLE = "Outlook Messages";
    protected static final String OUTLOOK_MESSAGES_NAME = "outlook-messages";
    protected static final String UPLAODS_FOLDER_TITLE = "Uploads";
    protected static final String SPACES_HOME = "/Groups/spaces";
    protected static final String ROOT_USER = "root";
    protected static final String PERSONAL_DOCUMENTS = "Personal Documents";
    protected static final String[] READER_PERMISSION = new String[]{"read"};
    protected static final String[] MANAGER_PERMISSION = new String[]{"read", "remove"};
    protected static final Log LOG = ExoLogger.getLogger(OutlookServiceImpl.class);
    protected static final Random RANDOM = new Random();
    protected static final Transliterator accentsConverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeFinder finder;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final OrganizationService organization;
    protected final ManageDriveService driveService;
    protected final ListenerService listenerService;
    protected final TrashService trashService;
    protected final ResourceBundleService resourceBundleService;
    protected final DocumentService documentService;
    protected final PolicyFactory htmlPolicy = Sanitizers.BLOCKS.and(Sanitizers.FORMATTING).and(Sanitizers.IMAGES).and(Sanitizers.LINKS).and(Sanitizers.TABLES).and(new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(new String[]{"table", "th", "tr", "td"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing", "width", "height"}).onElements(new String[]{"table"}).allowAttributes(new String[]{"bgcolor", "width", "height", "colspan", "rowspan"}).onElements(new String[]{"td", "tr", "th"}).toFactory()).and(Sanitizers.STYLES);
    protected final PolicyFactory textPolicy = new HtmlPolicyBuilder().toFactory();
    protected final PolicyFactory activityPolicy = new HtmlPolicyBuilder().allowUrlProtocols(new String[]{"http", "https"}).allowElements(new String[]{"b", "i", "a", "span", "em", "strong", "p", "ol", "ul", "li", "br", "img", "blockquote", "q"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"target"}).matching(true, new String[]{"_blank"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"alt", "src"}).onElements(new String[]{"img"}).toFactory();
    protected final Pattern linkNotLocal = Pattern.compile("href=['\"][^#][.\\w\\W\\S]*?['\"]", 42);
    protected final Pattern linkWithTarget = Pattern.compile("<a(?=\\s).*?(target=['\"].*?['\"])[^>]*>", 42);
    protected final Pattern linkWithoutTarget = Pattern.compile("<a(?=\\s)(?:(?!target=).)*?([.\\W\\w\\S\\s[^>]])*?(>)", 42);
    protected final ConcurrentHashMap<String, OutlookSpaceImpl> spaces = new ConcurrentHashMap();
    protected MailAPI mailserverApi;
    protected String trashHomePath;

    public OutlookServiceImpl(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, NodeFinder finder, OrganizationService organization, ListenerService listenerService, ManageDriveService driveService, TrashService trashService, ResourceBundleService resourceBundleService, InitParams params, DocumentService documentService) throws ConfigurationException, MailServerException {
        MailAPI api;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.hierarchyCreator = hierarchyCreator;
        this.finder = finder;
        this.organization = organization;
        this.driveService = driveService;
        this.listenerService = listenerService;
        this.trashService = trashService;
        this.resourceBundleService = resourceBundleService;
        this.documentService = documentService;
        this.mailserverApi = api = new MailAPI();
    }

    @Override
    public List<File> saveAttachment(OutlookSpace space, Folder destFolder, OutlookUser user, String comment, String messageId, String attachmentToken, String ... attachmentIds) throws OutlookException, RepositoryException {
        ArrayList<File> files = new ArrayList<File>();
        Node parent = destFolder.getNode();
        for (String attachmentId : attachmentIds) {
            JsonValue vatt = this.mailserverApi.getAttachment(user, messageId, attachmentToken, attachmentId);
            JsonValue vName = vatt.getElement("Name");
            if (this.isNull(vName)) {
                throw new OutlookFormatException("Attachment doesn't contain Name");
            }
            String name = vName.getStringValue();
            JsonValue vContentType = vatt.getElement("ContentType");
            if (this.isNull(vContentType)) {
                throw new OutlookFormatException("Attachment (" + name + ") doesn't contain ContentType");
            }
            String contentType = vContentType.getStringValue();
            JsonValue vContentBytes = vatt.getElement("ContentBytes");
            if (this.isNull(vContentBytes)) {
                throw new OutlookFormatException("Attachment (" + name + ") doesn't contain ContentBytes");
            }
            String contentBytes = vContentBytes.getStringValue();
            byte[] decoded = Base64.decodeBase64((String)contentBytes);
            try (ByteArrayInputStream contentStream = new ByteArrayInputStream(decoded);){
                Node attachmentNode = this.addFile(parent, name, contentType, contentStream);
                if (space != null) {
                    this.setPermissions(attachmentNode, "member:" + space.getGroupId());
                } else {
                    this.setPermissions(attachmentNode, user.getLocalUser(), "member:/platform/users");
                }
                files.add(new UserFile(destFolder, attachmentNode));
            }
            catch (IOException e) {
                throw new OutlookException("Error saving attachment in a file " + name, e);
            }
        }
        parent.save();
        this.postAttachmentActivity(destFolder, files, user, this.safeText(comment));
        if (space != null) {
            for (File f : files) {
                this.initDocumentLink(space, (HierarchyNode)f);
            }
        }
        return files;
    }

    @Override
    public List<File> saveAttachment(Folder destFolder, OutlookUser user, String comment, String messageId, String attachmentToken, String ... attachmentIds) throws OutlookException, RepositoryException {
        return this.saveAttachment(null, destFolder, user, comment, messageId, attachmentToken, attachmentIds);
    }

    @Override
    public OutlookEmail getAddress(String email, String displayName) throws OutlookException {
        return new OutlookEmail(email, displayName);
    }

    @Override
    public OutlookUser getUser(String email, String displayName, String ewsUrl) throws OutlookException, RepositoryException {
        String exoUsername;
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null && !IdentityConstants.ANONIM.equals(exoUsername = contextState.getIdentity().getUserId())) {
            URI mailServerUrl;
            if (ewsUrl != null) {
                try {
                    URI ewsUri = new URI(ewsUrl);
                    String host = ewsUri.getHost();
                    String scheme = ewsUri.getScheme();
                    int port = ewsUri.getPort();
                    mailServerUrl = new URI(scheme, null, host, port, null, null, null);
                }
                catch (URISyntaxException e) {
                    throw new MailServerException("Error parsing EWS API URL " + ewsUrl, e);
                }
            } else {
                mailServerUrl = null;
            }
            UserImpl user = new UserImpl(email, displayName, exoUsername);
            if (mailServerUrl != null) {
                user.setMailServerUrl(mailServerUrl);
            }
            return user;
        }
        return null;
    }

    @Override
    public OutlookMessage buildMessage(String id, OutlookUser user, OutlookEmail from, List<OutlookEmail> to, Calendar created, Calendar modified, String title, String subject, String body) throws OutlookException {
        OutlookMessage message = new OutlookMessage(user);
        message.setId(id);
        message.setFrom(from);
        message.setTo(to);
        message.setTitle(title);
        message.setSubject(subject);
        message.setBody(body);
        message.setCreated(created);
        message.setModified(modified);
        return message;
    }

    @Override
    public OutlookMessage getMessage(OutlookUser user, String messageId, String messageToken) throws OutlookException {
        JsonValue vatt = this.mailserverApi.getMessage(user, messageId, messageToken);
        JsonValue vSubject = vatt.getElement("Subject");
        if (this.isNull(vSubject)) {
            throw new OutlookFormatException("Message " + messageId + " doesn't contain Subject");
        }
        String subject = vSubject.getStringValue();
        JsonValue vTo = vatt.getElement("ToRecipients");
        if (this.isNull(vTo)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain ToRecipients");
        }
        if (!vTo.isArray()) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ")'s ToRecipients isn't an array");
        }
        ArrayList<OutlookEmail> to = new ArrayList<OutlookEmail>(vTo.size());
        Iterator toiter = vTo.getElements();
        while (toiter.hasNext()) {
            to.add(this.readEmail((JsonValue)toiter.next()));
        }
        JsonValue vFrom = vatt.getElement("From");
        OutlookEmail from = this.isNull(vFrom) ? null : this.readEmail(vFrom);
        JsonValue vCreatedDateTime = vatt.getElement("CreatedDateTime");
        if (this.isNull(vCreatedDateTime)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain CreatedDateTime");
        }
        Calendar created = Calendar.getInstance();
        try {
            created.setTime(OutlookMessage.DATE_FORMAT.parse(vCreatedDateTime.getStringValue()));
        }
        catch (ParseException e) {
            LOG.error((Object)("Error parsing message date " + vCreatedDateTime.getStringValue()), (Throwable)e);
        }
        JsonValue vLastModifiedDateTime = vatt.getElement("LastModifiedDateTime");
        if (this.isNull(vLastModifiedDateTime)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain LastModifiedDateTime");
        }
        Calendar modified = Calendar.getInstance();
        try {
            modified.setTime(OutlookMessage.DATE_FORMAT.parse(vLastModifiedDateTime.getStringValue()));
        }
        catch (ParseException e) {
            LOG.error((Object)("Error parsing message date " + vCreatedDateTime.getStringValue()), (Throwable)e);
        }
        JsonValue vBody = vatt.getElement("Body");
        if (this.isNull(vBody)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ") doesn't contain Body");
        }
        JsonValue vContentType = vBody.getElement("ContentType");
        if (this.isNull(vContentType)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ")'s body doesn't contain ContentType");
        }
        String contentType = vContentType.getStringValue();
        JsonValue vContent = vBody.getElement("Content");
        if (this.isNull(vContent)) {
            throw new OutlookFormatException("Message (" + messageId + " : " + subject + ")'s body doesn't contain Content");
        }
        String content = vContent.getStringValue();
        OutlookMessage message = new OutlookMessage(user);
        message.setId(messageId);
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setBody(content);
        message.setType(contentType);
        message.setCreated(created);
        message.setModified(modified);
        return message;
    }

    public void start() {
        try {
            this.trashHomePath = this.trashService.getTrashHomeNode().getPath();
        }
        catch (RepositoryException e) {
            LOG.warn((Object)"Error getting Trash home node", (Throwable)e);
            this.trashHomePath = "/Trash";
        }
        LOG.info((Object)"Outlook service successfuly started");
    }

    public void stop() {
        try {
            this.mailserverApi.close();
            LOG.info((Object)"Outlook service successfuly stopped");
        }
        catch (MailServerException e) {
            LOG.warn((Object)"Outlook service stop encountered with API error", (Throwable)e);
        }
    }

    @Override
    public OutlookSpace getSpace(String groupId) throws OutlookSpaceException, RepositoryException, OutlookException {
        Space socialSpace;
        OutlookSpaceImpl space = this.spaces.get(groupId);
        if (space == null && (socialSpace = this.spaceService().getSpaceByGroupId(groupId)) != null) {
            space = new OutlookSpaceImpl(socialSpace);
            this.spaces.put(socialSpace.getGroupId(), space);
        }
        return space;
    }

    @Override
    public List<OutlookSpace> getUserSpaces() throws OutlookSpaceException {
        return this.userSpaces(this.currentUserId());
    }

    @Override
    public UserDocuments getUserDocuments() throws RepositoryException, OutlookException {
        String userName = this.currentUserId();
        try {
            Node userDocsNode = this.userDocumentsNode(userName);
            PersonalDocuments personalDocs = new PersonalDocuments(userDocsNode);
            return personalDocs;
        }
        catch (Exception e) {
            throw new OutlookException("Error reading user's Personal Documents node for " + userName, e);
        }
    }

    void setAPI(MailAPI mockedAPI) {
        this.mailserverApi = mockedAPI;
    }

    protected String nodeTitle(Node node) throws RepositoryException {
        return node.getProperty("exo:title").getString();
    }

    protected Node nodeContent(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }

    protected Calendar nodeCreated(Node node) throws RepositoryException {
        return node.getProperty("jcr:created").getDate();
    }

    protected String mimeType(Node content) throws RepositoryException {
        return content.getProperty("jcr:mimeType").getString();
    }

    protected Property data(Node content) throws RepositoryException {
        return content.getProperty("jcr:data");
    }

    protected UUID generateId(String workspace, String path) {
        StringBuilder s = new StringBuilder();
        s.append(workspace);
        s.append(path);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(RANDOM.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    protected User getExoUser(String userName) throws OutlookException {
        try {
            return this.organization.getUserHandler().findUserByName(userName);
        }
        catch (Exception e) {
            throw new OutlookException("Error searching user " + userName, e);
        }
    }

    protected Node node(String nodePath) throws BadParameterException, RepositoryException {
        String path;
        String workspace;
        if (nodePath.startsWith("/")) {
            workspace = this.jcrService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            path = nodePath;
        } else {
            int i = nodePath.indexOf(47);
            if (i > 0) {
                workspace = nodePath.substring(0, i);
                path = nodePath.substring(i);
            } else {
                throw new BadParameterException("Invalid path " + nodePath);
            }
        }
        return this.node(workspace, path);
    }

    protected Node node(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(userSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected Node systemNode(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSystemSessionProvider(null);
        Session sysSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(sysSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected boolean checkout(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return true;
        }
        return false;
    }

    protected boolean isNull(JsonValue json) {
        return json == null || json.isNull();
    }

    protected boolean isNotNull(JsonValue json) {
        return json != null && !json.isNull();
    }

    protected Locale currentUserLocale() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context != null ? context.getLocale() : null;
    }

    protected Node addFile(Node parent, String title, String contentType, InputStream content) throws RepositoryException {
        String baseName;
        String name = baseName = OutlookServiceImpl.cleanName(title);
        int siblingNumber = 0;
        try {
            while (true) {
                Node file = parent.getNode(name);
                ++siblingNumber;
                int extIndex = baseName.lastIndexOf(".");
                if (extIndex > 0 && extIndex != baseName.length() - 1) {
                    String jcrName = baseName.substring(0, extIndex);
                    String jcrExt = baseName.substring(extIndex + 1);
                    name = jcrName + '-' + siblingNumber + '.' + jcrExt;
                    continue;
                }
                name = baseName + '-' + siblingNumber;
            }
        }
        catch (PathNotFoundException e) {
            Node file = parent.addNode(name, "nt:file");
            Node resource = file.addNode("jcr:content", "nt:resource");
            resource.setProperty("jcr:mimeType", contentType != null ? contentType : ContentType.APPLICATION_OCTET_STREAM.getMimeType());
            Calendar fileDate = Calendar.getInstance();
            resource.setProperty("jcr:lastModified", fileDate);
            resource.setProperty("jcr:data", content);
            if (siblingNumber > 0) {
                int extIndex = title.lastIndexOf(".");
                if (extIndex > 0 && extIndex != title.length() - 1) {
                    String titleName = title.substring(0, extIndex);
                    String titleExt = title.substring(extIndex + 1);
                    title = titleName + " (" + siblingNumber + ")." + titleExt;
                } else {
                    title = title + " (" + siblingNumber + ')';
                }
            }
            if (!file.hasProperty("exo:title")) {
                file.addMixin("exo:rss-enable");
            }
            file.setProperty("exo:title", title);
            try {
                file.setProperty("exo:name", title);
            }
            catch (ValueFormatException | ConstraintViolationException e2) {
                LOG.warn((Object)("Cannot set exo:name property to '" + title + "' for file " + file.getPath() + ": " + e2));
            }
            if (file.isNodeType("exo:datetime")) {
                file.setProperty("exo:dateCreated", fileDate);
                file.setProperty("exo:dateModified", fileDate);
            }
            if (file.isNodeType("exo:modify")) {
                file.setProperty("exo:lastModifiedDate", fileDate);
                file.setProperty("exo:lastModifier", file.getSession().getUserID());
            }
            if (!file.isNodeType("mix:referenceable")) {
                file.addMixin("mix:referenceable");
            }
            if (!file.isNodeType("mix:commentable")) {
                file.addMixin("mix:commentable");
            }
            if (!file.isNodeType("mix:votable")) {
                file.addMixin("mix:votable");
            }
            if (!file.isNodeType("mix:i18n")) {
                file.addMixin("mix:i18n");
            }
            return file;
        }
    }

    protected Node addFolder(Node parent, String title, boolean forceNew) throws RepositoryException {
        Node folder;
        String baseName;
        String name = baseName = OutlookServiceImpl.cleanName(title);
        int siblingNumber = 0;
        try {
            while (true) {
                folder = parent.getNode(name);
                if (forceNew) {
                    ++siblingNumber;
                    int extIndex = baseName.lastIndexOf(".");
                    if (extIndex > 0 && extIndex < title.length()) {
                        String jcrName = baseName.substring(0, extIndex);
                        String jcrExt = baseName.substring(extIndex + 1);
                        name = jcrName + '-' + siblingNumber + '.' + jcrExt;
                        continue;
                    }
                    name = baseName + '-' + siblingNumber;
                    continue;
                }
                break;
            }
        }
        catch (PathNotFoundException e) {
            folder = parent.addNode(name, "nt:folder");
        }
        if (folder.isNew()) {
            if (siblingNumber > 0) {
                int extIndex = title.lastIndexOf(".");
                if (extIndex > 0 && extIndex < title.length()) {
                    String titleName = title.substring(0, extIndex);
                    String titleExt = title.substring(extIndex + 1);
                    title = titleName + " (" + siblingNumber + ")." + titleExt;
                } else {
                    title = title + " (" + siblingNumber + ')';
                }
            }
            folder.setProperty("exo:title", title);
            try {
                folder.setProperty("exo:name", title);
            }
            catch (ValueFormatException | ConstraintViolationException e) {
                LOG.warn((Object)("Cannot set exo:name property to '" + title + "' for folder " + folder.getPath() + ": " + e));
            }
            Calendar folderDate = Calendar.getInstance();
            if (folder.isNodeType("exo:datetime")) {
                folder.setProperty("exo:dateCreated", folderDate);
                folder.setProperty("exo:dateModified", folderDate);
            }
            if (folder.isNodeType("exo:modify")) {
                folder.setProperty("exo:lastModifiedDate", folderDate);
                folder.setProperty("exo:lastModifier", folder.getSession().getUserID());
            }
        }
        return folder;
    }

    protected String currentUserId() {
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null) {
            return contextState.getIdentity().getUserId();
        }
        return IdentityConstants.ANONIM;
    }

    protected SpaceService spaceService() {
        return (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    protected IdentityManager socialIdentityManager() {
        return (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
    }

    protected ActivityManager socialActivityManager() {
        return (ActivityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
    }

    protected RelationshipManager socialRelationshipManager() {
        return (RelationshipManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RelationshipManager.class);
    }

    protected List<OutlookSpace> userSpaces(String userId) throws OutlookSpaceException {
        ArrayList<OutlookSpace> spaces = new ArrayList<OutlookSpace>();
        ListAccess list = this.spaceService().getMemberSpaces(userId);
        try {
            for (Space socialSpace : (Space[])list.load(0, list.getSize())) {
                spaces.add(new OutlookSpaceImpl(socialSpace));
            }
            return spaces;
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error loading user spaces", e);
            }
            throw new OutlookSpaceException("Error loading user spaces", e);
        }
    }

    protected String groupDocsPath(String groupId) {
        return "/Groups${groupId}/Documents".replace("${groupId}", groupId);
    }

    protected String userDocsPath(String userId) {
        return "/Users/${userId}/Private".replace("${userId}", userId) + "/Documents";
    }

    protected String groupPath(String groupId) throws Exception {
        String groupsPath = this.hierarchyCreator.getJcrPath("groupsPath");
        return groupsPath + groupId;
    }

    protected void initWebDAVLink(HierarchyNode node) throws OutlookException {
        try {
            node.setWebdavUrl(Utils.getWebdavURL((Node)node.getNode(), (boolean)false, (boolean)true));
        }
        catch (Exception e) {
            throw new OutlookException("Error generating WebDav URL for node " + node.getFullPath(), e);
        }
    }

    protected void initDocumentLink(SiteType siteType, String driveName, String portalName, String nodeURI, HierarchyNode node) throws OutlookException {
        this.initWebDAVLink(node);
        String npath = node.getPath().replaceAll("/+", "/");
        String path = driveName + npath;
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        if (portalRequest != null) {
            NodeURL nodeURL = (NodeURL)portalRequest.createURL(NodeURL.TYPE);
            NavigationResource resource = new NavigationResource(siteType, portalName, nodeURI);
            nodeURL.setResource(resource);
            nodeURL.setQueryParameterValue("path", path);
            HttpServletRequest request = portalRequest.getRequest();
            try {
                URI requestUri = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), null, null, null);
                StringBuilder url = new StringBuilder();
                url.append(requestUri.toASCIIString());
                url.append(nodeURL.toString());
                node.setUrl(url.toString());
            }
            catch (URISyntaxException e) {
                throw new OutlookException("Error creating server URL " + request.getRequestURI().toString(), e);
            }
        } else {
            LOG.warn((Object)("Portal request not found. Node URL will be its WebDAV link. Node: " + node.getPath()));
            node.setUrl(node.getWebdavUrl());
        }
    }

    protected void initDocumentLink(OutlookSpace space, HierarchyNode file) throws OutlookException {
        this.initWebDAVLink(file);
        this.initDocumentLink(SiteType.GROUP, space.getGroupId().replace("/", "."), space.getGroupId(), space.getShortName() + "/documents", file);
    }

    protected void initDocumentLink(PersonalDocuments personalDocuments, HierarchyNode file) throws OutlookException {
        this.initWebDAVLink(file);
        this.initDocumentLink(SiteType.PORTAL, personalDocuments.getDriveName(), Util.getPortalRequestContext().getPortalOwner(), "drives", file);
    }

    protected Node userDocumentsNode(String userName) throws Exception {
        for (DriveData userDrive : this.driveService.getPersonalDrives(userName)) {
            String homePath = userDrive.getHomePath();
            if (!homePath.endsWith("/Private")) continue;
            String driveRootPath = org.exoplatform.services.cms.impl.Utils.getPersonalDrivePath((String)homePath, (String)userName);
            return this.node(driveRootPath);
        }
        return null;
    }

    protected Node spaceDocumentsNode(String groupId) throws Exception {
        return this.node(this.groupDocsPath(groupId));
    }

    protected void setPermissions(Node node, String ... identities) throws AccessControlException, RepositoryException {
        this.setPermissions(node, true, false, identities);
    }

    protected void setPermissions(Node node, boolean deep, boolean forcePrivilegeable, String ... identities) throws AccessControlException, RepositoryException {
        ExtendedNode target = (ExtendedNode)node;
        boolean setPermissions = true;
        if (target.canAddMixin(EXO_PRIVILEGEABLE)) {
            if (forcePrivilegeable) {
                target.addMixin(EXO_PRIVILEGEABLE);
            } else {
                setPermissions = false;
            }
        }
        if (setPermissions) {
            for (String identity : identities) {
                String[] ids = identity.split(":");
                if (ids.length == 2) {
                    String managerMembership;
                    try {
                        MembershipType managerType = this.organization.getMembershipTypeHandler().findMembershipType("manager");
                        managerMembership = managerType.getName();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error finding manager membership in organization service. Will use any (*) to allow remove shared cloud file link", (Throwable)e);
                        managerMembership = "*";
                    }
                    target.setPermission(managerMembership + ':' + ids[1], MANAGER_PERMISSION);
                    target.setPermission(identity, READER_PERMISSION);
                    continue;
                }
                target.setPermission(identity, MANAGER_PERMISSION);
            }
        }
        if (deep) {
            NodeIterator niter = target.getNodes();
            while (niter.hasNext()) {
                Node child = niter.nextNode();
                this.setPermissions(child, true, false, identities);
            }
        }
    }

    protected Node messagesFolder(Node parent, String ... identity) throws RepositoryException {
        Node messagesFolder;
        if (!parent.hasNode(OUTLOOK_MESSAGES_NAME)) {
            messagesFolder = parent.addNode(OUTLOOK_MESSAGES_NAME, "nt:folder");
            messagesFolder.setProperty("exo:title", OUTLOOK_MESSAGES_TITLE);
            try {
                messagesFolder.setProperty("exo:name", OUTLOOK_MESSAGES_TITLE);
            }
            catch (ValueFormatException | ConstraintViolationException e) {
                LOG.warn((Object)("Cannot set exo:name property for folder " + messagesFolder.getPath() + ": " + e));
            }
            if (identity != null) {
                this.setPermissions(messagesFolder, identity);
            }
            parent.save();
        } else {
            messagesFolder = parent.getNode(OUTLOOK_MESSAGES_NAME);
        }
        return messagesFolder;
    }

    protected Node addMessageFile(Node parent, OutlookMessage message) throws RepositoryException, UnsupportedEncodingException, IOException {
        String safeTitle = this.safeText(message.getSubject());
        String safeContent = this.safeHtml(message.getBody());
        try (ByteArrayInputStream content = new ByteArrayInputStream(safeContent.getBytes("UTF-8"));){
            Node messageFile = this.addFile(parent, safeTitle, "text/html", content);
            messageFile.addMixin("mso:message");
            messageFile.setProperty("mso:userEmail", message.getUser().getEmail());
            messageFile.setProperty("mso:userName", message.getUser().getDisplayName());
            messageFile.setProperty("mso:fromEmail", message.getFrom().getEmail());
            messageFile.setProperty("mso:fromName", message.getFrom().getDisplayName());
            messageFile.setProperty("mso:created", message.getCreated());
            messageFile.setProperty("mso:modified", message.getModified());
            messageFile.setProperty("mso:messageId", message.getId());
            Node node = messageFile;
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExoSocialActivity postAttachmentActivity(Folder destFolder, List<File> files, OutlookUser user, String comment) throws RepositoryException {
        String origType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getActivityType();
        try {
            String author = user.getLocalUser();
            IdentityManager identityManager = this.socialIdentityManager();
            Identity authorIdentity = identityManager.getOrCreateIdentity("organization", author, true);
            LinkedHashMap<String, String> activityParams = new LinkedHashMap<String, String>();
            Calendar activityDate = Calendar.getInstance();
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String fileName = "";
            String id = "";
            String doclink = "";
            String docpath = "";
            String mimeType = "";
            String contenLink = "";
            String workspace = "";
            String repository = "";
            String dateString = "";
            String owner = "";
            String isSymlink = "";
            String REGEX = "|@|";
            int i = 0;
            for (File f : files) {
                if (files.size() - 1 == i) {
                    REGEX = "";
                }
                fileName = fileName + f.getName() + REGEX;
                id = id + f.getNode().getUUID() + REGEX;
                mimeType = mimeType + f.getNode().getNode("jcr:content").getProperty("jcr:mimeType").getString() + REGEX;
                docpath = docpath + f.getNode().getPath() + REGEX;
                owner = owner + author + REGEX;
                isSymlink = isSymlink + false + REGEX;
                try {
                    contenLink = contenLink + this.documentService.getLinkInDocumentsApp(NodeLocation.getNodeLocationByNode((Node)f.getNode()).getPath()) + REGEX;
                    doclink = doclink + Utils.getWebdavURL((Node)f.getNode()) + REGEX;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error getting node download link " + f.getNode()), (Throwable)e);
                }
                dateString = dateString + dateFormatter.format(activityDate.getTime()) + REGEX;
                workspace = workspace + destFolder.getNode().getSession().getWorkspace().getName() + REGEX;
                repository = repository + ((ManageableRepository)destFolder.getNode().getSession().getRepository()).getConfiguration().getName() + REGEX;
                ++i;
            }
            activityParams.put("files", fileName);
            activityParams.put("docTitle", fileName);
            activityParams.put("workspace", workspace);
            activityParams.put("repository", repository);
            activityParams.put("comment", comment);
            activityParams.put("DOCLINK", doclink);
            activityParams.put("DOCNAME", fileName);
            activityParams.put("DOCPATH", docpath);
            activityParams.put("author", owner);
            activityParams.put("dateCreated", dateString);
            activityParams.put("lastModified", dateString);
            activityParams.put("id", id);
            activityParams.put("contentName", fileName);
            activityParams.put("MESSAGE", comment);
            activityParams.put("mimeType", mimeType);
            activityParams.put("contenLink", contenLink);
            activityParams.put("docTitle", fileName);
            activityParams.put("isSymlink", isSymlink);
            String title = comment != null && comment.length() > 0 ? comment : "User " + author + " has saved " + files.size() + (files.size() > 1 ? " files" : " file");
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(authorIdentity.getId(), "outlook:attachment", title, null);
            activity.setTemplateParams(activityParams);
            ActivityManager activityManager = this.socialActivityManager();
            String spaceGroupName = OutlookServiceImpl.getSpaceName(destFolder.getNode());
            Space space = this.spaceService().getSpaceByGroupId("/spaces/" + spaceGroupName);
            if (spaceGroupName != null && spaceGroupName.length() > 0 && space != null) {
                Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName(), true);
                activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            } else {
                activityManager.saveActivityNoReturn(authorIdentity, (ExoSocialActivity)activity);
            }
            ExoSocialActivityImpl exoSocialActivityImpl = activity = activityManager.getActivity(activity.getId());
            return exoSocialActivityImpl;
        }
        finally {
            org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
        }
    }

    protected OutlookEmail readEmail(JsonValue vElem) throws OutlookException {
        JsonValue vEmailAddress = vElem.getElement("EmailAddress");
        if (this.isNull(vEmailAddress)) {
            throw new OutlookFormatException("Element doesn't contain EmailAddress");
        }
        JsonValue vAddress = vEmailAddress.getElement("Address");
        if (this.isNull(vAddress)) {
            throw new OutlookFormatException("Element doesn't contain Address");
        }
        String email = vAddress.getStringValue();
        JsonValue vName = vEmailAddress.getElement("Name");
        String name = this.isNull(vName) ? "".intern() : vName.getStringValue();
        return this.getAddress(email, name);
    }

    protected void fetchQuery(QueryResult qr, int limit, Set<File> res) throws RepositoryException, OutlookException {
        this.fetchQuery(qr, limit, res, n -> true);
    }

    protected void fetchQuery(QueryResult qr, int limit, Set<File> res, Predicate<Node> acceptNode) throws RepositoryException, OutlookException {
        SpaceService spaceService = this.spaceService();
        NodeIterator niter = qr.getNodes();
        while (niter.getPosition() < (long)limit && niter.hasNext()) {
            Node node = niter.nextNode();
            try {
                if (acceptNode.test(node)) {
                    Space space;
                    block12: {
                        String path = node.getPath();
                        if (path.startsWith(SPACES_HOME)) {
                            try {
                                String groupId = path.substring(7, path.indexOf("/", SPACES_HOME.length() + 1));
                                space = spaceService.getSpaceByGroupId(groupId);
                                if (space == null) break block12;
                                HashSet<String> allMemembers = new HashSet<String>();
                                for (String s : space.getManagers()) {
                                    allMemembers.add(s);
                                }
                                for (String s : space.getMembers()) {
                                    allMemembers.add(s);
                                }
                                if (!allMemembers.contains(this.currentUserId())) {
                                    ++limit;
                                    continue;
                                }
                                break block12;
                            }
                            catch (IndexOutOfBoundsException e) {
                                space = null;
                                break block12;
                            }
                        }
                        space = null;
                    }
                    UserFile file = new UserFile(node.getParent().getPath(), node);
                    if (space != null) {
                        this.initDocumentLink(SiteType.GROUP, space.getGroupId().replace("/", "."), space.getGroupId(), space.getShortName() + "/documents", file);
                    } else {
                        this.initDocumentLink(SiteType.PORTAL, PERSONAL_DOCUMENTS, Util.getPortalRequestContext().getPortalOwner(), "drives", file);
                    }
                    res.add(file);
                    continue;
                }
                ++limit;
            }
            catch (RepositoryException e) {
                LOG.warn((Object)("Error read queried node " + e.getMessage() + ". Node skipped: " + node));
                ++limit;
            }
        }
    }

    protected String messageSummary(OutlookMessage message) {
        String fromEmail = message.getFrom().getEmail();
        String fromName = message.getFrom().getDisplayName();
        Date time = message.getCreated().getTime();
        Locale locale = Locale.ENGLISH;
        ResourceBundle res = this.resourceBundleService.getResourceBundle("locale.outlook.Outlook", locale);
        DateFormat dateFormat = DateFormat.getDateInstance(0, locale);
        DateFormat timeFormat = DateFormat.getTimeInstance(3, locale);
        StringBuilder fromLine = new StringBuilder();
        fromLine.append(fromName);
        fromLine.append('<');
        fromLine.append(fromEmail);
        fromLine.append('>');
        StringBuilder summary = new StringBuilder();
        summary.append(res.getString("Outlook.activity.from"));
        summary.append(": <a href='mailto:");
        summary.append(fromEmail);
        summary.append("' target='_top'>");
        summary.append(ContentReader.simpleEscapeHtml((String)fromLine.toString()));
        summary.append("</a> ");
        summary.append(res.getString("Outlook.activity.on"));
        summary.append(' ');
        summary.append(dateFormat.format(time));
        summary.append(' ');
        summary.append(res.getString("Outlook.activity.at"));
        summary.append(' ');
        summary.append(timeFormat.format(time));
        return summary.toString();
    }

    protected boolean isHTML(String content) {
        int istart = content.indexOf("<html");
        int iend = content.indexOf("</html>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<body");
        iend = content.indexOf("</body>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<div");
        iend = content.indexOf("</div>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<table");
        iend = content.indexOf("</table>");
        if (istart >= 0 && iend > 0 && istart < iend) {
            return true;
        }
        istart = content.indexOf("<style");
        iend = content.indexOf("</style>");
        return istart >= 0 && iend > 0 && istart < iend;
    }

    protected String safeHtml(String content) {
        String safe = this.htmlPolicy.sanitize(content);
        safe = this.makeLinksOpenNewWindow(safe);
        return safe;
    }

    protected String safeText(String content) {
        String safe = this.textPolicy.sanitize(content);
        safe = this.makeLinksOpenNewWindow(safe);
        safe = StringEscapeUtils.unescapeHtml((String)safe);
        return safe;
    }

    protected String safeActivityMessage(String text) {
        String safe = this.activityPolicy.sanitize(text);
        safe = this.makeLinksOpenNewWindow(safe);
        safe = StringEscapeUtils.unescapeHtml((String)safe);
        return safe;
    }

    protected String makeLinksOpenNewWindow(String text) {
        int end;
        int start;
        Matcher m = this.linkWithTarget.matcher(text);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (m.find()) {
            if (!this.linkNotLocal.matcher(m.group()).find()) continue;
            start = m.start(1);
            end = m.end(1);
            if (start >= 0 && end >= 0) {
                sb.append(text.substring(pos, start));
                sb.append("target=\"_blank\"");
                pos = end;
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Cannot find link target group in " + m.group(1)));
        }
        if (pos < text.length()) {
            sb.append(text.substring(pos));
        }
        text = sb.toString();
        m = this.linkWithoutTarget.matcher(text);
        sb = new StringBuilder();
        pos = 0;
        while (m.find()) {
            if (!this.linkNotLocal.matcher(m.group()).find()) continue;
            start = m.start(2);
            end = m.end(2);
            if (start >= 0 && end >= 0) {
                sb.append(text.substring(pos, start));
                sb.append(" target=\"_blank\"");
                sb.append(text.substring(start, end));
                pos = end;
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Cannot find link end group in " + m.group(2)));
        }
        if (pos < text.length()) {
            sb.append(text.substring(pos));
        }
        return sb.toString();
    }

    private static String getSpaceName(Node node) throws RepositoryException {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        String spacesFolder = groupPath + "/spaces/";
        String spaceName = "";
        String nodePath = node.getPath();
        if (nodePath.startsWith(spacesFolder)) {
            spaceName = nodePath.substring(spacesFolder.length());
            spaceName = spaceName.substring(0, spaceName.indexOf("/"));
        }
        return spaceName;
    }

    public static String cleanName(String name) {
        String str = accentsConverter.transliterate(name.trim());
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        if (cleanedStr.length() == 1) {
            char c = cleanedStr.charAt(0);
            if (c == '.' || c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                cleanedStr.deleteCharAt(0);
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        } else {
            char c;
            for (int i = 0; i < cleanedStr.length(); ++i) {
                c = cleanedStr.charAt(i);
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '*' || c == '\'' || c == '\"' || c == '|') {
                    cleanedStr.deleteCharAt(i);
                    cleanedStr.insert(i, '_');
                    continue;
                }
                if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || c == '.' || c == '-' || c == '_') continue;
                cleanedStr.deleteCharAt(i--);
            }
            for (int lastCharIndex = cleanedStr.length() - 1; lastCharIndex >= 0 && (c = cleanedStr.charAt(lastCharIndex)) == '.'; --lastCharIndex) {
                cleanedStr.deleteCharAt(lastCharIndex);
                if (lastCharIndex != 0) continue;
                cleanedStr.append('_');
                cleanedStr.append(Integer.toHexString(c).toUpperCase());
            }
        }
        return cleanedStr.toString().trim();
    }

    protected class OutlookSpaceImpl
    extends OutlookSpace {
        protected final String rootPath;
        protected final ThreadLocal<RootFolder> rootFolder;
        protected final IdentityManager socialIdentityManager;
        protected final ActivityManager socialActivityManager;

        protected OutlookSpaceImpl(Space socialSpace) throws RepositoryException, OutlookException {
            super(socialSpace.getGroupId(), socialSpace.getDisplayName(), socialSpace.getShortName(), socialSpace.getPrettyName());
            this.rootFolder = new ThreadLocal();
            this.rootPath = OutlookServiceImpl.this.groupDocsPath(this.groupId);
            this.socialIdentityManager = OutlookServiceImpl.this.socialIdentityManager();
            this.socialActivityManager = OutlookServiceImpl.this.socialActivityManager();
        }

        @Override
        public SpaceFolder getFolder(String path) throws OutlookException, RepositoryException {
            SpaceFolder folder;
            RootFolder parent = this.getRootFolder();
            String folderPath = HierarchyNode.getPath(path);
            if (this.rootPath.equals(folderPath)) {
                folder = parent;
            } else if (folderPath.startsWith(this.rootPath)) {
                folder = new SpaceFolder((Folder)parent, OutlookServiceImpl.this.node(folderPath));
            } else {
                throw new BadParameterException("Path does not belong to space documents: " + path);
            }
            OutlookServiceImpl.this.initDocumentLink(this, (HierarchyNode)folder);
            return folder;
        }

        @Override
        public RootFolder getRootFolder() throws OutlookException, RepositoryException {
            RootFolder root = this.rootFolder.get();
            if (root != null) {
                try {
                    root.getNode().getIndex();
                    return root;
                }
                catch (InvalidItemStateException invalidItemStateException) {
                    // empty catch block
                }
            }
            root = new RootFolder(this.rootPath, OutlookServiceImpl.this.node(this.rootPath));
            this.rootFolder.set(root);
            return root;
        }

        @Override
        public Collection<File> findLastDocuments(String text) throws RepositoryException, OutlookException {
            RootFolder root = this.getRootFolder();
            QueryManager qm = root.getNode().getSession().getWorkspace().getQueryManager();
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            if (text == null || text.length() == 0) {
                Query qOwn = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' AND jcr:path LIKE '" + root.getPath() + "/%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOwn.execute(), 3, res);
                Query qOthers = qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + root.getPath() + "/%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOthers.execute(), 20 - res.size(), res);
            } else {
                Query qOwn = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' AND jcr:path LIKE '" + root.getPath() + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOwn.execute(), 3, res);
                Query qOthers = qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + root.getPath() + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOthers.execute(), 20 - res.size(), res);
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExoSocialActivity postActivity(OutlookMessage message) throws Exception {
            Node spaceDocs = OutlookServiceImpl.this.spaceDocumentsNode(this.groupId);
            Node messagesFolder = OutlookServiceImpl.this.messagesFolder(spaceDocs, this.groupId);
            Node messageFile = OutlookServiceImpl.this.addMessageFile(messagesFolder, message);
            OutlookServiceImpl.this.setPermissions(messageFile, "member:" + this.groupId);
            messagesFolder.save();
            message.setFileNode(messageFile);
            String userMessage = message.getTitle();
            userMessage = userMessage != null && userMessage.length() > 0 ? OutlookServiceImpl.this.safeText(userMessage) : null;
            String origType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getActivityType();
            try {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)"outlook:message");
                ExoSocialActivity activity = org.exoplatform.wcm.ext.component.activity.listener.Utils.postFileActivity((Node)messageFile, (String)userMessage, (boolean)true, (boolean)false, (String)"", (String)"");
                activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
                ExoSocialActivity exoSocialActivity = activity;
                return exoSocialActivity;
            }
            finally {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
            }
        }

        @Override
        public ExoSocialActivity postActivity(OutlookUser user, String title, String body) throws Exception {
            Identity spaceIdentity = this.socialIdentityManager.getOrCreateIdentity("space", this.prettyName, true);
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeTitle = OutlookServiceImpl.this.safeText(title);
            String safeBody = OutlookServiceImpl.this.safeHtml(body);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "exosocial:spaces", safeTitle, safeBody);
            this.socialActivityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public ExoSocialActivity postActivity(OutlookUser user, String text) throws Exception {
            Identity spaceIdentity = this.socialIdentityManager.getOrCreateIdentity("space", this.prettyName, true);
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeText = OutlookServiceImpl.this.safeActivityMessage(text);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "exosocial:spaces", safeText, null);
            activity.setType("DEFAULT_ACTIVITY");
            this.socialActivityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        class RootFolder
        extends SpaceFolder {
            protected RootFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
                super(rootPath, node);
                OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)this);
                this.hasSubfolders();
            }

            @Override
            protected Set<Folder> readSubnodes() throws RepositoryException, OutlookException {
                Folder uploads = null;
                Set<Folder> subfolders = super.readSubnodes();
                for (Folder sf : subfolders) {
                    if (!sf.getTitle().equals(OutlookServiceImpl.UPLAODS_FOLDER_TITLE)) continue;
                    uploads = this.defaultSubfolder = sf;
                    break;
                }
                if (uploads == null) {
                    try {
                        Node subfolderNode = OutlookServiceImpl.this.addFolder(this.node, OutlookServiceImpl.UPLAODS_FOLDER_TITLE, false);
                        uploads = this.newFolder(this, subfolderNode);
                        this.node.save();
                        OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)uploads);
                        subfolders.add(uploads);
                        this.defaultSubfolder = uploads;
                    }
                    catch (AccessDeniedException e) {
                        if (LOG.isDebugEnabled()) {
                            String currentUserId = OutlookServiceImpl.this.currentUserId();
                            StringBuilder userInfo = new StringBuilder();
                            userInfo.append(currentUserId);
                            try {
                                userInfo.append('[');
                                for (Membership m : OutlookServiceImpl.this.organization.getMembershipHandler().findMembershipsByUser(OutlookServiceImpl.this.currentUserId())) {
                                    userInfo.append(m.getMembershipType());
                                    userInfo.append(':');
                                    userInfo.append(m.getGroupId());
                                    userInfo.append(' ');
                                }
                                userInfo.setCharAt(userInfo.length() - 1, ']');
                            }
                            catch (Exception oe) {
                                LOG.warn((Object)("Error getting organization user " + currentUserId), (Throwable)e);
                            }
                            LOG.debug((Object)("Error creating Uploads folder in " + this.getPath() + ". User: " + userInfo.toString() + ". Parent node: " + this.node), (Throwable)e);
                        }
                        this.defaultSubfolder = null;
                    }
                }
                return subfolders;
            }
        }

        class SpaceFolder
        extends UserFolder {
            protected SpaceFolder(Folder parent, Node node) throws RepositoryException, OutlookException {
                super(parent, node);
            }

            protected SpaceFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
                super(rootPath, node);
            }

            @Override
            protected void readChildNodes() throws RepositoryException, OutlookException {
                super.readChildNodes();
                for (Folder sf : (Set)this.subfolders.get()) {
                    OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)sf);
                }
                for (File f : (Set)this.files.get()) {
                    OutlookServiceImpl.this.initDocumentLink(OutlookSpaceImpl.this, (HierarchyNode)f);
                }
            }
        }
    }

    protected class UserImpl
    extends OutlookUser {
        protected final IdentityManager socialIdentityManager;
        protected final ActivityManager socialActivityManager;
        protected final RelationshipManager socialRelationshipManager;

        protected UserImpl(String email, String displayName, String userName) throws OutlookException {
            super(email, displayName, userName);
            this.socialIdentityManager = OutlookServiceImpl.this.socialIdentityManager();
            this.socialActivityManager = OutlookServiceImpl.this.socialActivityManager();
            this.socialRelationshipManager = OutlookServiceImpl.this.socialRelationshipManager();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ExoSocialActivity postActivity(OutlookMessage message) throws OutlookException {
            ExoSocialActivity exoSocialActivity;
            Node userDocs = OutlookServiceImpl.this.userDocumentsNode(this.localUser);
            if (userDocs == null) throw new OutlookException("Has no Personal Documents folder for user " + this.localUser);
            Node sysPublicFolder = OutlookServiceImpl.this.systemNode(userDocs.getSession().getWorkspace().getName(), userDocs.getPath() + "/Public");
            Node sysMessagesFolder = OutlookServiceImpl.this.messagesFolder(sysPublicFolder, this.localUser, "member:/platform/users");
            Node sysMessageFile = OutlookServiceImpl.this.addMessageFile(sysMessagesFolder, message);
            OutlookServiceImpl.this.setPermissions(sysMessageFile, this.localUser, "member:/platform/users");
            sysMessagesFolder.save();
            Node messageFile = OutlookServiceImpl.this.node(sysMessageFile.getSession().getWorkspace().getName(), sysMessageFile.getPath());
            message.setFileNode(messageFile);
            String userMessage = message.getTitle();
            userMessage = userMessage != null && userMessage.length() > 0 ? OutlookServiceImpl.this.safeText(userMessage) : null;
            String origType = org.exoplatform.wcm.ext.component.activity.listener.Utils.getActivityType();
            try {
                org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)"outlook:message");
                ExoSocialActivity activity = org.exoplatform.wcm.ext.component.activity.listener.Utils.postFileActivity((Node)messageFile, (String)userMessage, (boolean)true, (boolean)false, (String)"", (String)"");
                activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
                exoSocialActivity = activity;
            }
            catch (Throwable throwable) {
                try {
                    org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
                    throw throwable;
                }
                catch (Exception e) {
                    throw new OutlookException("Error posting activity for user " + this.localUser, e);
                }
            }
            org.exoplatform.wcm.ext.component.activity.listener.Utils.setActivityType((String)origType);
            return exoSocialActivity;
        }

        @Override
        public ExoSocialActivity postActivity(String title, String body) throws Exception {
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeTitle = OutlookServiceImpl.this.safeText(title);
            String safeBody = OutlookServiceImpl.this.safeHtml(body);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), null, safeTitle, safeBody);
            this.socialActivityManager.saveActivityNoReturn(userIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public ExoSocialActivity postActivity(String text) throws Exception {
            Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", OutlookServiceImpl.this.currentUserId(), true);
            String safeText = OutlookServiceImpl.this.safeActivityMessage(text);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), "exosocial:people", safeText, null);
            activity.setType("DEFAULT_ACTIVITY");
            this.socialActivityManager.saveActivityNoReturn(userIdentity, (ExoSocialActivity)activity);
            activity.setPermanLink(LinkProvider.getSingleActivityUrl((String)activity.getId()));
            return activity;
        }

        @Override
        public Identity getSocialIdentity() throws Exception {
            return this.socialIdentityManager.getOrCreateIdentity("organization", this.getLocalUser(), true);
        }
    }

    protected class UserFile
    extends File {
        protected UserFile(Folder parent, Node node) throws RepositoryException, OutlookException {
            super(parent, node);
        }

        protected UserFile(String parentPath, Node node) throws RepositoryException, OutlookException {
            super(parentPath, node);
        }

        @Override
        protected Locale userLocale() {
            return OutlookServiceImpl.this.currentUserLocale();
        }
    }

    protected class PersonalDocuments
    implements UserDocuments {
        protected final Node driveNode;

        protected PersonalDocuments(Node node) throws RepositoryException, OutlookException {
            this.driveNode = node;
        }

        @Override
        public PersonalFolder getRootFolder() throws OutlookException, RepositoryException {
            return new PersonalFolder(this.driveNode);
        }

        @Override
        public Folder getFolder(String path) throws OutlookException, RepositoryException {
            PersonalFolder folder;
            String folderPath;
            PersonalFolder theRoot = this.getRootFolder();
            String rootPath = theRoot.getPath();
            if (rootPath.equals(folderPath = HierarchyNode.getPath(path))) {
                folder = theRoot;
            } else if (folderPath.startsWith(rootPath)) {
                Node node = OutlookServiceImpl.this.node(folderPath);
                folder = new PersonalFolder(node.getParent().getPath(), node);
            } else {
                throw new BadParameterException("Path does not belong to space documents: " + path);
            }
            OutlookServiceImpl.this.initDocumentLink(this, (HierarchyNode)folder);
            return folder;
        }

        @Override
        public Collection<File> findAllLastDocuments(String text) throws RepositoryException, OutlookException {
            QueryManager qm = this.driveNode.getSession().getWorkspace().getQueryManager();
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            if (text == null || text.length() == 0) {
                Query q = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                String currentUser = OutlookServiceImpl.this.currentUserId();
                OutlookServiceImpl.this.fetchQuery(q.execute(), 20, res, node -> {
                    try {
                        String path = node.getPath();
                        if (path.indexOf("/ApplicationData") >= 0 || path.indexOf("exo:applications") >= 0) {
                            return false;
                        }
                        if (org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)node)) {
                            return false;
                        }
                        AccessControlList acl = ((ExtendedNode)node).getACL();
                        String owner = acl.getOwner();
                        if (currentUser.equals(owner)) {
                            return true;
                        }
                        return !OutlookServiceImpl.ROOT_USER.equals(owner);
                    }
                    catch (RepositoryException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Error getting ACL/owner of " + node), (Throwable)e);
                        }
                        return false;
                    }
                });
            } else {
                String drivePath = this.driveNode.getPath();
                Query qOwn = qm.createQuery("SELECT * FROM nt:file WHERE exo:lastModifier='" + OutlookServiceImpl.this.currentUserId() + "' AND jcr:path LIKE '" + drivePath + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOwn.execute(), 3, res);
                Query qOthers = qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + drivePath + "/%' AND exo:title LIKE '%" + text + "%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql");
                OutlookServiceImpl.this.fetchQuery(qOthers.execute(), 20 - res.size(), res);
            }
            if (res.size() < 20) {
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM nt:file WHERE jcr:path LIKE '");
                sql.append(OutlookServiceImpl.SPACES_HOME);
                sql.append("/%/Documents/%'");
                if (text != null && text.length() > 0) {
                    sql.append(" AND exo:title LIKE '%");
                    sql.append(text);
                    sql.append("%'");
                }
                sql.append(" ORDER BY exo:lastModifiedDate DESC, exo:title ASC");
                Query qSpaces = qm.createQuery(sql.toString(), "sql");
                OutlookServiceImpl.this.fetchQuery(qSpaces.execute(), 20 - res.size(), res);
            }
            return res;
        }

        @Override
        public Collection<File> findLastDocuments(String text) throws RepositoryException, OutlookException {
            QueryManager qm = this.driveNode.getSession().getWorkspace().getQueryManager();
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            String drivePath = this.driveNode.getPath();
            Query q = text == null || text.length() == 0 ? qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + drivePath + "/%' ORDER BY exo:lastModifiedDate DESC, exo:title ASC", "sql") : qm.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + drivePath + "/%' AND exo:title LIKE '%" + text + "%'", "sql");
            OutlookServiceImpl.this.fetchQuery(q.execute(), 20, res);
            return res;
        }

        protected String getDriveName() {
            return OutlookServiceImpl.PERSONAL_DOCUMENTS;
        }

        class PersonalFolder
        extends UserFolder {
            protected PersonalFolder(Node node) throws RepositoryException, OutlookException {
                super(node);
            }

            protected PersonalFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
                super(rootPath, node);
            }

            @Override
            protected void readChildNodes() throws RepositoryException, OutlookException {
                super.readChildNodes();
                for (Folder sf : (Set)this.subfolders.get()) {
                    OutlookServiceImpl.this.initDocumentLink(PersonalDocuments.this, (HierarchyNode)sf);
                }
                for (File f : (Set)this.files.get()) {
                    OutlookServiceImpl.this.initDocumentLink(PersonalDocuments.this, (HierarchyNode)f);
                }
            }
        }
    }

    protected class UserFolder
    extends Folder {
        protected UserFolder(Folder parent, Node node) throws RepositoryException, OutlookException {
            super(parent, node);
        }

        protected UserFolder(String parentPath, Node node) throws RepositoryException, OutlookException {
            super(parentPath, node);
        }

        protected UserFolder(Node node) throws RepositoryException, OutlookException {
            super(node.getPath(), node);
        }

        @Override
        public Folder addSubfolder(String name) throws RepositoryException, OutlookException {
            Node parent = this.getNode();
            Node subfolderNode = OutlookServiceImpl.this.addFolder(parent, name, true);
            Folder subfolder = this.newFolder(this, subfolderNode);
            parent.save();
            Set subfolders = (Set)this.subfolders.get();
            if (subfolders != null) {
                subfolders.add(subfolder);
            }
            return subfolder;
        }

        @Override
        protected Locale userLocale() {
            return OutlookServiceImpl.this.currentUserLocale();
        }

        @Override
        protected Folder newFolder(Folder parent, Node node) throws RepositoryException, OutlookException {
            UserFolder folder = new UserFolder(parent, node);
            return folder;
        }

        @Override
        protected Folder newFolder(String rootPath, Node node) throws RepositoryException, OutlookException {
            UserFolder folder = new UserFolder(rootPath, node);
            return folder;
        }

        @Override
        protected File newFile(Folder parent, Node node) throws RepositoryException, OutlookException {
            UserFile file = new UserFile(parent, node);
            return file;
        }
    }
}

