/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.portlet;

import java.util.LinkedHashSet;
import java.util.Set;

public class MenuItem {
    protected final String name;
    protected String title;
    @Deprecated
    protected String link;
    protected final Set<MenuItem> submenu;

    public MenuItem(String name) {
        this(name, null, null, new LinkedHashSet());
    }

    public MenuItem(String name, Set<MenuItem> submenu) {
        this(name, null, null, submenu);
    }

    public MenuItem(String name, String title) {
        this(name, title, null, new LinkedHashSet());
    }

    public MenuItem(String name, String title, Set<MenuItem> submenu) {
        this(name, title, null, submenu);
    }

    @Deprecated
    protected MenuItem(String name, String title, String link) {
        this(name, title, link, new LinkedHashSet());
    }

    protected MenuItem(String name, String title, String link, Set<MenuItem> submenu) {
        this.name = name;
        this.title = title;
        this.link = link;
        this.submenu = submenu;
    }

    public MenuItem clone() {
        LinkedHashSet<MenuItem> submenu = new LinkedHashSet<MenuItem>();
        for (MenuItem sm : this.submenu) {
            submenu.add(sm.clone());
        }
        return new MenuItem(this.name, this.title, submenu);
    }

    public void addSubmenu(String name, String title, Set<MenuItem> submenu) {
        this.submenu.add(new MenuItem(name, title, submenu));
    }

    public void addSubmenu(String name, String title) {
        this.submenu.add(new MenuItem(name, title));
    }

    public void addSubmenu(String name) {
        this.submenu.add(new MenuItem(name));
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Deprecated
    public String getLink() {
        return this.link;
    }

    @Deprecated
    public void setLink(String link) {
        this.link = link;
    }

    public Set<MenuItem> getSubmenu() {
        return this.submenu;
    }

    public boolean hasSubmenu() {
        return this.submenu != null && this.submenu.size() > 0;
    }
}

