/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.outlook.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import juzu.MimeType;
import juzu.Path;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.request.RequestContext;
import org.exoplatform.outlook.server.templates.index;
import org.exoplatform.outlook.server.templates.login;

@Singleton
public class OutlookServer {
    private static final Logger LOG = Logger.getLogger(OutlookServer.class.getSimpleName());
    @Inject
    @Path(value="index.gtmpl")
    index index;
    @Inject
    @Path(value="login.gtmpl")
    login login;

    @View
    @MimeType.HTML
    @Route(value="/menu")
    public Response index() throws IOException {
        return this.index.ok();
    }

    @View
    @MimeType.HTML
    @Route(value="/")
    public Response login(RequestContext context) throws IOException {
        Charset charset;
        block3: {
            try {
                charset = Charset.forName("UTF-8");
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                charset = Charset.defaultCharset();
                if (!LOG.isLoggable(Level.FINE)) break block3;
                LOG.fine("Encoding not supported: UTF-8. " + e.getMessage() + ". Will use " + charset);
            }
        }
        ResourceBundle i18n = context.getApplicationContext().resolveBundle(context.getUserContext().getLocale());
        String title = i18n.getString("Outlook.welcome.title");
        if (title == null || title.length() == 0) {
            title = "Welcome to eXo Platform Add-in";
        }
        return this.login.ok().withCharset(charset).withTitle(title);
    }
}

