/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.activity.processor;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.rest.model.PollOptionRestEntity;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.RestEntityBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class PollActivityProcessor
extends BaseActivityProcessorPlugin {
    private PollService pollService;
    private static final Log LOG = ExoLogger.getLogger(PollActivityProcessor.class);

    public PollActivityProcessor(PollService pollService, InitParams initParams) {
        super(initParams);
        this.pollService = pollService;
    }

    public void processActivity(ExoSocialActivity activity) {
        PollRestEntity pollRestEntity;
        if (activity.isComment() || activity.getType() == null || !activity.getTemplateParams().containsKey("pollId")) {
            return;
        }
        if (activity.getLinkedProcessedEntities() == null) {
            activity.setLinkedProcessedEntities(new HashMap());
        }
        if ((pollRestEntity = (PollRestEntity)activity.getLinkedProcessedEntities().get("poll")) == null) {
            Identity currentIdentity = ConversationState.getCurrent().getIdentity();
            String pollId = (String)activity.getTemplateParams().get("pollId");
            try {
                Poll poll = this.pollService.getPollById(Long.parseLong(pollId), currentIdentity);
                List pollOptions = this.pollService.getPollOptionsByPollId(Long.parseLong(pollId), currentIdentity);
                ArrayList<PollOptionRestEntity> pollOptionRestEntities = new ArrayList<PollOptionRestEntity>();
                for (PollOption pollOption : pollOptions) {
                    int pollOptionVotes = this.pollService.getPollOptionTotalVotes(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                    boolean isPollOptionVoted = this.pollService.isPollOptionVoted(pollOption.getId(), String.valueOf(poll.getSpaceId()), currentIdentity);
                    PollOptionRestEntity pollOptionRestEntity = RestEntityBuilder.fromPollOption(pollOption, pollOptionVotes, isPollOptionVoted);
                    pollOptionRestEntities.add(pollOptionRestEntity);
                }
                pollRestEntity = RestEntityBuilder.fromPoll(poll, pollOptionRestEntities);
            }
            catch (IllegalAccessException e) {
                LOG.warn("User {} attempt to access a non authorized poll with id {}", new Object[]{currentIdentity.getUserId(), pollId, e});
            }
            activity.getLinkedProcessedEntities().put("poll", pollRestEntity);
        }
    }
}

