/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.listener;

import io.meeds.poll.model.Poll;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class GamificationPollListener
extends Listener<String, Poll> {
    private static final Log LOG = ExoLogger.getLogger(GamificationPollListener.class);
    private static final String[] LISTENER_EVENTS = new String[]{"meeds.poll.createPoll", "meeds.poll.votePoll"};
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        for (String eventName : LISTENER_EVENTS) {
            this.listenerService.addListener(eventName, (Listener)this);
        }
    }

    public void onEvent(Event<String, Poll> event) {
        Poll poll = (Poll)event.getData();
        String activityId = String.valueOf(poll.getActivityId());
        String creatorIdentityId = String.valueOf(poll.getCreatorId());
        String eventDetails = "{spaceId: " + poll.getSpaceId() + ", activityId: " + activityId + "}";
        if (event.getEventName().equals("meeds.poll.createPoll")) {
            this.createRealizations("createPoll", activityId, creatorIdentityId, creatorIdentityId, eventDetails);
        } else if (event.getEventName().equals("meeds.poll.votePoll")) {
            Identity identity = this.identityManager.getOrCreateUserIdentity((String)event.getSource());
            this.createRealizations("votePoll", activityId, identity.getId(), creatorIdentityId, eventDetails);
            this.createRealizations("receivePollVote", activityId, creatorIdentityId, identity.getId(), eventDetails);
        }
    }

    private void createRealizations(String gamificationEventName, String activityId, String earnerUsername, String receiverUsername, String eventDetails) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectType", "activity");
            gam.put("objectId", activityId);
            gam.put("senderType", "organization");
            gam.put("senderId", earnerUsername);
            gam.put("receiverType", "organization");
            gam.put("receiverId", receiverUsername);
            gam.put("eventDetails", eventDetails);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting gamification event: {}", new Object[]{gam, e});
        }
    }
}

