/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.plugin;

import io.meeds.gamification.plugin.EventPlugin;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PollEventPlugin
extends EventPlugin {
    public static final String EVENT_TYPE = "poll";

    public String getEventType() {
        return EVENT_TYPE;
    }

    public List<String> getTriggers() {
        return List.of("createPoll", "votePoll", "receivePollVote");
    }

    public boolean isValidEvent(Map<String, String> eventProperties, String triggerDetails) {
        String desiredActivityId = eventProperties.get("activityId");
        List desiredSpaceIds = eventProperties.get("spaceIds") != null ? Arrays.asList(eventProperties.get("spaceIds").split(",")) : Collections.emptyList();
        Map<String, String> triggerDetailsMop = PollEventPlugin.stringToMap(triggerDetails);
        return desiredActivityId != null && desiredActivityId.equals(triggerDetailsMop.get("activityId")) || CollectionUtils.isNotEmpty(desiredSpaceIds) && desiredSpaceIds.contains(triggerDetailsMop.get("spaceId"));
    }

    private static Map<String, String> stringToMap(String mapAsString) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        mapAsString = mapAsString.substring(1, mapAsString.length() - 1);
        for (String pair : pairs = mapAsString.split(", ")) {
            String[] keyValue = pair.split(": ");
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            map.put(key, value);
        }
        return map;
    }
}

