package org.exoplatform.ps.DAO;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.SubCatEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;

public class SubCatDAO extends GenericDAOJPAImpl<SubCatEntity, String> {

    private static final Logger LOG = LoggerFactory.getLogger(SubCatDAO.class);
    private SubCatEntity subCatEntity = new SubCatEntity();


    public List<SubCatEntity> getSubCatBySubId(String subId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatEntity.getBySub", SubCatEntity.class)
                        .setParameter("subId",subId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatEntity.getBySub", SubCatEntity.class)
                        .setParameter("subId",subId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and SubtId = '" + subId + "'.", e);
            throw e;
        }
    }



    public List<SubCatEntity> getSubCatByCatId(String catId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatEntity.getByCat", SubCatEntity.class)
                        .setParameter("catId",catId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatEntity.getByCat", SubCatEntity.class)
                        .setParameter("catId",catId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit +"'." + "' and CattId = '" + catId + "'.", e);
            throw e;
        }
    }
    public List<SubCatEntity> getSubCatBymail(String email, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatEntity.getByMail", SubCatEntity.class)
                        .setParameter("email",email)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatEntity.getByMail", SubCatEntity.class)
                        .setParameter("email",email)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit +"'." + "' and email = '" + email + "'.", e);
            throw e;
        }
    }

    public List<SubCatEntity> getSubCatByGc(Long gc, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatEntity.getSubCatByGc", SubCatEntity.class)
                        .setParameter("gc",gc)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatEntity.getSubCatByGc", SubCatEntity.class)
                        .setParameter("gc",gc)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit +"'." + "' and email = '" + gc + "'.", e);
            throw e;
        }
    }

    public SubCatEntity getSubCatByonemail(String email) {
                return getEntityManager().createNamedQuery("psSubCatEntity.getByoneMail", SubCatEntity.class)
                        .setParameter("email",email)
                        .getSingleResult();

    }


    public int subCatSearchCount() {
        return  getEntityManager().createNamedQuery("psSubCatEntity.serch", Long.class)
                .getSingleResult().intValue();
    }

}