package org.exoplatform.ps.DAO;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;

public class SubCatGroupDAO extends GenericDAOJPAImpl<SubCatGroupEntity, String> {

    private static final Logger LOG = LoggerFactory.getLogger(SubCatGroupDAO.class);


    public List<SubCatGroupEntity> getRelationShipBySubCatId(String subCatId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatGroupEntity.getBySubCatId", SubCatGroupEntity.class)
                        .setParameter("subCatId",subCatId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatGroupEntity.getBySubCatId", SubCatGroupEntity.class)
                        .setParameter("subCatId",subCatId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit +"'." + "' and subCatId = '" + subCatId + "'.", e);
            throw e;
        }
    }


    public List<SubCatGroupEntity> getRelationShipBySubGroupId(String subGroupId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatGroupEntity.getBySubGroupId", SubCatGroupEntity.class)
                        .setParameter("subGroupId",subGroupId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatGroupEntity.getBySubGroupId", SubCatGroupEntity.class)
                        .setParameter("subGroupId",subGroupId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit +"'." + "' and subGroupId = '" + subGroupId + "'.", e);
            throw e;
        }
    }


    public List<SubCatGroupEntity> getRelationShipBySubId(String subId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubCatGroupEntity.getBySubId", SubCatGroupEntity.class)
                        .setParameter("subId",subId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubCatGroupEntity.getBySubId", SubCatGroupEntity.class)
                        .setParameter("subId",subId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit +"'." + "' and subId = '" + subId + "'.", e);
            throw e;
        }
    }




}
