/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;

/**
 */
@PrimaryType(name = "tbb:subCat")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class SubCat {

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();


    @Property(name = "tbb:subId")
    public abstract String getSubId();

    public abstract void setSubId(String subId);

    @Property(name = "tbb:subCatId")
    public abstract String getSubCatId();

    public abstract void setSubCatId(String subCatId);

    @Property(name = "tbb:catId")
    public abstract String getCatId();

    public abstract void setCatId(String catId);


    @Property(name = "tbb:subName")
    public abstract String getSubName();

    public abstract void setSubName(String subName);

    @Property(name = "tbb:subCompany")
    public abstract String getSubCompany();

    public abstract void setSubCompany(String subCompany);

    @Property(name = "tbb:subRank")
    public abstract String getSubRank();

    public abstract void setSubRank(String subRank);

    @Property(name = "tbb:catAbrDesc")
    public abstract String getCatAbrDesc();

    public abstract void setCatAbrDesc(String catAbrDesc);

    @Property(name = "tbb:catFullDesc")
    public abstract String getCatFullDesc();

    public abstract void setCatFullDesc(String catFullDesc);


    @Property(name = "tbb:catCsiDesc")
    public abstract String getCatCsiDesc();

    public abstract void setCatCsiDesc(String catCsiDesc);

    @Property(name = "tbb:subPhone")
    public abstract String getSubPhone();

    public abstract void setSubPhone(String subPhone);

    @Property(name = "tbb:subCity")
    public abstract String getSubCity();

    public abstract void setSubCity(String subCity);

    @Property(name = "tbb:subState")
    public abstract String getSubState();

    public abstract void setSubState(String subState);

    @Property(name = "tbb:subCounty")
    public abstract String getSubCounty();

    public abstract void setSubCounty(String subCounty);

    @Property(name = "tbb:subZip")
    public abstract String getSubZip();

    public abstract void setSubZip(String subZip);

    @Property(name = "tbb:subWeburl")
    public abstract String getSubWeburl();

    public abstract void setSubWeburl(String subWeburl);

    @Property(name = "tbb:subProview")
    public abstract String getSubProview();

    public abstract void setSubProview(String subProview);

    @Property(name = "tbb:subUnion")
    public abstract String getSubUnion();

    public abstract void setSubUnion(String subUnion);

    @Property(name = "tbb:subNonUnion")
    public abstract String getSubNonUnion();

    public abstract void setSubNonUnion(String subNonUnion);
}