package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;

@Entity(name = "PSStaffEntity")
@ExoEntity
@Table(name = "PS_ADDON_STAFF")
@Data
@NamedQueries({
        @NamedQuery(name = "pSStaffEntity.getStaffByGcAndRole", query = "SELECT a FROM PSStaffEntity a where a.role = :role"),
        @NamedQuery(name = "pSStaffEntity.getGcCompanyByStaff", query = "SELECT a.generalContractorEntity FROM PSStaffEntity a where a.id = :staffId"),
        @NamedQuery(name = "pSStaffEntity.getStaffByGc", query = "SELECT a FROM PSStaffEntity a where a.generalContractorEntity.id = :gcId")

})



public class StaffEntity {

    @Id
    @Column(name = "STAFF_ID",nullable = false)
    private String id;


    @ManyToOne
    @JoinColumn(name = "GENERAL_CONTRACTOR_ID")
    private GeneralContractorEntity generalContractorEntity;


    @Column(name = "FIRST_NAME",nullable = false)
    private String  firstName;

    @Column(name = "LAST_NAME")
    private String  lastName;

    @Column(name = "POSITION")
    private String  position;

    @Column(name = "ROLE")
    private String  role;



}
