package org.exoplatform.ps.integration.notification;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PSSendITBPlugin extends BaseNotificationPlugin {

    private static final Log LOG = ExoLogger.getLogger(PSSendITBPlugin.class);

    public final static String ID = "PSSendITBPlugin";

    public final static ArgumentLiteral<ProjectSubEntity> PROJECT = new ArgumentLiteral<ProjectSubEntity>(ProjectSubEntity.class, "PROJECT");
    public final static ArgumentLiteral<StaffEntity> STAFF = new ArgumentLiteral<StaffEntity>(StaffEntity.class, "STAFF");

    public final static ArgumentLiteral<String> POSTER = new ArgumentLiteral<String>(String.class, "poster");
    public final static ArgumentLiteral<String> END_DATE = new ArgumentLiteral<String>(String.class, "time");
    public final static ArgumentLiteral<String> CREATORSTAFF = new ArgumentLiteral<String>(String.class, "creatorStaff");
    public final static ArgumentLiteral<String> GC_PHONE = new ArgumentLiteral<String>(String.class, "gc_phone");
    public final static ArgumentLiteral<String> GC_CONTACT = new ArgumentLiteral<String>(String.class, "gc_contact");
    public final static ArgumentLiteral<String> COMPANY_NAME = new ArgumentLiteral<String>(String.class, "companyname");



    IdentityManager identityManager;

    public PSSendITBPlugin(InitParams initParams, IdentityManager identityManager) {

        super(initParams);
        this.identityManager = identityManager;

    }


    @Override

    public String getId() {

        return ID;

    }

    @Override
    public boolean isValid(NotificationContext ctx) {

        return true;

    }


    @Override
    protected NotificationInfo makeNotification(NotificationContext ctx) {

        ProjectSubEntity projectSubEntity = ctx.value(PROJECT);
        Set<String> receivers = new HashSet<String>();

        receivers.add(projectSubEntity.getSubContractor().getManager());
        StringBuilder projectId = new StringBuilder("SendITB");
        projectId.append("-").append(projectSubEntity.getId());
        String poster = ctx.value(POSTER);
        String creatorStaff = ctx.value(CREATORSTAFF);
        String gc_phone = ctx.value(GC_PHONE);
        String gc_contact = ctx.value(GC_CONTACT);
        String companyname = ctx.value(COMPANY_NAME);
        String time = ctx.value(END_DATE);
        String projectid=projectSubEntity.getProjectId();

        final String portalContainerName = "portal";
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        Space project_ = spaceService.getSpaceByPrettyName(projectid);
        Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, project_.getPrettyName(), true);
        Profile sProfile = prIdentity.getProfile();

        String link = CommonsUtils.getCurrentDomain()+"/portal/g/:spaces:";


        return NotificationInfo.instance()

                .setFrom("SendITB")
                .to(new LinkedList<String>(receivers))
                .with(NotificationUtils.CREATOR, poster!= null ? poster:"")
                .with(NotificationUtils.PERIOD, time!= null ? project_.getDescription():"")
                .with(NotificationUtils.CREATORSTAFF, creatorStaff!= null ? creatorStaff:"")
                .with(NotificationUtils.GC_CONTACT, gc_contact!= null ? gc_contact:"")
                .with(NotificationUtils.GC_PHONE, gc_phone!= null ? gc_phone:"")
                .with(NotificationUtils.COMPANY_NAME, companyname!= null ? companyname:"")
                .with(NotificationUtils.SUB_CONTRACTOR,projectSubEntity.getSubContractor().getManager()!= null ? projectSubEntity.getSubContractor().getManager():"")
                .with(NotificationUtils.SUB_COMPANY,projectSubEntity.getSubContractor().getCompany()!= null ? projectSubEntity.getSubContractor().getCompany():"")
                .with(NotificationUtils.BIDS_DUE, sProfile.getProperty("bidsDueDate")!= null ? sProfile.getProperty("bidsDueDate").toString():"")
                .with(NotificationUtils.CATEGORIE, projectSubEntity.getCategory().getCatCsiDesc()!= null ? projectSubEntity.getCategory().getCatCsiDesc():"")
                .with(NotificationUtils.PROJECTNAME, project_.getDisplayName()!= null ? project_.getDisplayName():"")
                .with(NotificationUtils.PROJECT_DESCRIPTION, project_.getDescription()!= null ? project_.getDescription():"")
                .with(NotificationUtils.PHONE, projectSubEntity.getSubContractor().getPhone()!= null ? projectSubEntity.getSubContractor().getPhone():"")
                .with(NotificationUtils.CONTACT, projectSubEntity.getSubContractor().getCountry()+""+projectSubEntity.getSubContractor().getCountry()+""+projectSubEntity.getSubContractor().getState())
                .with(NotificationUtils.EMAIL, projectSubEntity.getSubContractor().getEmail()!= null ? projectSubEntity.getSubContractor().getEmail():"")
                .with(NotificationUtils.PROJECTURL, project_.getUrl()!= null ? project_.getUrl():"")
                .with(NotificationUtils.PROJECTSTATUS, sProfile.getProperty("projectStatus") != null ? sProfile.getProperty("projectStatus").toString():"")
                .with(NotificationUtils.PROJECTTYPE, sProfile.getProperty("projectType") != null ? sProfile.getProperty("projectType").toString():"")
                .with(NotificationUtils.PRE_BID_MEETING, sProfile.getProperty("preBidMeetingDate") != null ? sProfile.getProperty("preBidMeetingDate").toString():"")
                .with(NotificationUtils.STORIES_ABOVE_GRD, sProfile.getProperty("storiesAboveGrd") != null ? sProfile.getProperty("storiesAboveGrd").toString():"")
                .with(NotificationUtils.NBRBUILDING, sProfile.getProperty("nbBuildings") != null ? sProfile.getProperty("nbBuildings").toString():"")
                .with(NotificationUtils.START_DATE, sProfile.getProperty("startDate") != null ? sProfile.getProperty("startDate").toString():"")
                .with(NotificationUtils.TOTALSQFT, sProfile.getProperty("totalSqFt") != null ? sProfile.getProperty("totalSqFt").toString():"")
                .with(NotificationUtils.PRE_BID, sProfile.getProperty("bidsDueDate") != null ? sProfile.getProperty("bidsDueDate").toString():"")
                .with(NotificationUtils.OWNERTYPE, sProfile.getProperty("ownerType") != null ? sProfile.getProperty("ownerType").toString():"")
                .with(NotificationUtils.URLPROJECT, link+project_.getUrl()+"/"+project_.getUrl()+"/projectSettings")
                .key(getKey()).end();

    }

}
