/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.rest;

import com.sun.star.uno.Exception;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.ps.DAO.*;
import org.exoplatform.ps.DTO.GeneralContractor;
import org.exoplatform.ps.chromattic.entity.SubUserInfo;
import org.exoplatform.ps.entity.*;
import org.exoplatform.ps.model.BbMessage;
import org.exoplatform.ps.model.BbUser;
import org.exoplatform.ps.model.StaffUser;
import org.exoplatform.ps.storage.api.SubGcStorage;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.*;

import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;

@Path("/generalcontarctorsservice")
public class GeneralContarctorsRestService implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String DEFAULT_AVATAR_ICON_MIME_TYPE     = "image/png";
    private static final String DEFAULT_AVATAR_ICON_NAMESPACE     = "projectspace";
    private static final Log LOG = ExoLogger.getLogger(GeneralContarctorsRestService.class.getName());
    private final CacheControl cacheControl;
    private final GeneralContractorDAO generalContractorDAO;
    private final UploadService uploadService;
    private final FileService fileService;
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public GeneralContarctorsRestService(GeneralContractorDAO generalContractorDAO, UploadService uploadService, FileService fileService) {

        this.cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        this.generalContractorDAO = generalContractorDAO;
        this.uploadService = uploadService;
        this.fileService = fileService;

    }

    @GET
    @Path("getcompanies")
    public Response getCompanies(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        try {
            for (GeneralContractorEntity generalContractorEntity : generalContractorDAO.findAll()) {
                JSONObject data = new JSONObject();
                data.put("id",generalContractorEntity.getId());
                data.put("companyName",generalContractorEntity.getCompanyName());
                data.put("adress",generalContractorEntity.getCompanyStreet());
                data.put("city",generalContractorEntity.getCompanyCity());
                data.put("state",generalContractorEntity.getCompanyState());
                data.put("companyPhone",generalContractorEntity.getCompanyPhone());
                data.put("webSite",generalContractorEntity.getCompanyWebSite());

                    jsonArray.put(data);

            }
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords",jsonArray.length());
            jsonGlobal.put("iTotalDisplayRecords", jsonArray.length());
            jsonGlobal.put("aaData", jsonArray);

            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (JSONException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }


    @GET
    @Path("getgclist")
    public Response getCompaniesList(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
/*            for (GeneralContractorEntity generalContractorEntity : generalContractorDAO.findAll()) {
                JSONObject data = new JSONObject();
                data.put("id",generalContractorEntity.getId());
                data.put("companyName",generalContractorEntity.getCompanyName());
                data.put("adress",generalContractorEntity.getCompanyStreet());
                data.put("city",generalContractorEntity.getCompanyCity());
                data.put("state",generalContractorEntity.getCompanyState());
                data.put("companyPhone",generalContractorEntity.getCompanyPhone());
                data.put("webSite",generalContractorEntity.getCompanyWebSite());
                data.put("gcUser",generalContractorEntity.getGcUser());

                    jsonArray.put(data);

            }*/
     return Response.ok(generalContractorDAO.findAll(), mediaType).build();
 }

   @GET
    @Path("get/{id}")
    public Response getCompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 @PathParam("id") Long id) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
       try {
           GeneralContractorEntity generalContractorEntity =generalContractorDAO.find(id);
           if(generalContractorEntity==null) return Response.status(Response.Status.NO_CONTENT).build();
           JSONObject data = new JSONObject();
           data.put("id",generalContractorEntity.getId());
           data.put("companyName",generalContractorEntity.getCompanyName());
           data.put("companyStreet",generalContractorEntity.getCompanyStreet());
           data.put("companyCity",generalContractorEntity.getCompanyCity());
           data.put("companyState",generalContractorEntity.getCompanyState());
           data.put("companyPhone",generalContractorEntity.getCompanyPhone());
           data.put("companyWebsite",generalContractorEntity.getCompanyWebSite());
           data.put("companyProview",generalContractorEntity.getCompanyProview());
           data.put("companyZip",generalContractorEntity.getCompanyZip());
           data.put("companyCountry",generalContractorEntity.getCompanyCountry());
           data.put("gcUser",generalContractorEntity.getGcUser());

           return Response.ok(data.toString(), mediaType).build();
       } catch (JSONException e) {
           return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
       }
   }


    @GET
    @Path("getcurrentsub")
    public Response getCurrentSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = getService(StaffDAO.class,null);

        return Response.ok(staffDAO.find(sourceIdentity.getRemoteId()).getGeneralContractorEntity(), mediaType).build();
    }



    @GET
    @Path("getcompany/{id}")
    public Response getCompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam("id") String id) throws Exception {

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Long gcId=new Long(0);
        try {
            gcId = Long.valueOf(id);
        } catch (NumberFormatException e) {
            id="";
        }
        if(id != null && id !=""){
            GeneralContractorEntity generalContractorEntity =generalContractorDAO.find(gcId);
            if(generalContractorEntity==null) return Response.status(Response.Status.NO_CONTENT).build();
            return  Response.ok(generalContractorEntity, mediaType).build();
        }else{
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            StaffDAO staffDAO = getService(StaffDAO.class,null);

            return Response.ok(staffDAO.find(sourceIdentity.getRemoteId()).getGeneralContractorEntity(), mediaType).build();
        }

    }



    @POST
    @Path("addgc")
    public Response add (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                         GeneralContractorEntity gcuser) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }


        try {

            GeneralContractorDAO generalContractorDAO = getService(GeneralContractorDAO.class,null);
            gcuser.setCreatedDate(new Date());
            gcuser = generalContractorDAO.create(gcuser);
            OrganizationService organizationService = getService(OrganizationService.class, null);
            StaffDAO staffDAO = getService(StaffDAO.class,null);
            StaffEntity staffEntity = staffDAO.find(gcuser.getGcUser());
            List<StaffEntity> staffList = new ArrayList<>();
            if (staffEntity!=null){
                staffList.add(staffEntity);
            }else{
                try {

                User user = organizationService.getUserHandler().findUserByName(gcuser.getGcUser());
                if(user!=null){

                        ((ComponentRequestLifecycle) organizationService).startRequest(PortalContainer.getInstance());
                        GroupHandler gh = organizationService.getGroupHandler();
                        MembershipHandler mh = organizationService.getMembershipHandler();
                        MembershipTypeHandler mth = organizationService.getMembershipTypeHandler();
                        mh.linkMembership(user, gh.findGroupById("/organization/gcs"), mth.findMembershipType("manager"), true);

                        staffEntity=new StaffEntity();
                        staffEntity.setId(gcuser.getGcUser());
                        staffEntity.setFirstName(user.getFirstName());
                        staffEntity.setLastName(user.getLastName());
                        staffEntity.setRole("manager");
                        staffEntity.setGeneralContractorEntity(gcuser);
                        staffEntity = staffDAO.create(staffEntity);
                    }else if(staffEntity.getGeneralContractorEntity().getId()!=gcuser.getId()){
                        staffEntity.setGeneralContractorEntity(gcuser);
                        staffEntity = staffDAO.update(staffEntity);


                    }
                } catch (java.lang.Exception e) {
                    e.printStackTrace();
                } finally {
                    ((ComponentRequestLifecycle) organizationService).endRequest(PortalContainer.getInstance());
                }
                }

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " User Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (JSONException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }


    @POST
    @Path("creategcstaff")
    public Response creategcstaff (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                    StaffUser staffUser) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        GeneralContractorEntity generalContractorEntity = generalContractorDAO.find(staffUser.getGcId());
        if(generalContractorEntity==null){
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        try {

            OrganizationService organizationService = getService(OrganizationService.class, null);
            StaffDAO staffDAO = getService(StaffDAO.class,null);
            StaffEntity staffEntity = staffDAO.find(staffUser.getUserid());
            if (staffEntity!=null){
                return Response.status(Response.Status.NOT_MODIFIED).build();
            }else{
                try {

                User user = organizationService.getUserHandler().findUserByName(staffUser.getUserid());
                if(user==null){

                        ((ComponentRequestLifecycle) organizationService).startRequest(PortalContainer.getInstance());
                    UserHandler uh = organizationService.getUserHandler();
                        user = uh.createUserInstance(staffUser.getUserid());
                        user.setFirstName(staffUser.getFirstName());
                        user.setLastName(staffUser.getLastName());
                        user.setEmail(staffUser.getEmail());
                        user.setPassword(staffUser.getPassword());

                        uh.createUser(user, true);
                        GroupHandler gh = organizationService.getGroupHandler();
                        MembershipHandler mh = organizationService.getMembershipHandler();
                        MembershipTypeHandler mth = organizationService.getMembershipTypeHandler();
                        mh.linkMembership(user, gh.findGroupById("/organization/gcs"), mth.findMembershipType("manager"), true);

                        staffEntity=new StaffEntity();
                        staffEntity.setId(staffUser.getUserid());
                        staffEntity.setFirstName(user.getFirstName());
                        staffEntity.setLastName(user.getLastName());
                        staffEntity.setRole("manager");
                        staffEntity.setGeneralContractorEntity(generalContractorEntity);
                        staffEntity = staffDAO.create(staffEntity);
                    }
                } catch (java.lang.Exception e) {
                    e.printStackTrace();
                } finally {
                    ((ComponentRequestLifecycle) organizationService).endRequest(PortalContainer.getInstance());
                }
                }

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " User Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (JSONException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }



    @GET
    @Path("getmystaff")
    public Response getmystaff(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @QueryParam("projectid") String projectId) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        JSONArray jsonArray = new JSONArray();
        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        StaffEntity staff = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
        if (staff == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        Space project = null;
        if (projectId != null) {
            project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

        }
        try{
            MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
            List<StaffEntity> StaffList =  staffDAO.getStaffByGc(staff.getGeneralContractorEntity().getId(), 0, 0);

            for (StaffEntity staff_ : StaffList) {
                JSONObject json = new JSONObject();
                json.put("userName", staff_.getId());
                json.put("fullName", staff_.getFirstName() +" "+ staff_.getLastName());
                json.put("company", staff_.getGeneralContractorEntity().getCompanyName());
                json.put("position", staff_.getPosition());
                json.put("role", staff_.getRole());
                json.put("isMember", "Not invited");
                if (project != null) {
                    if (spaceService.isInvitedUser(project, staff_.getId()))
                        json.put("isMember", "Invited");
                    if (spaceService.isMember(project, staff_.getId()))
                        json.put("isMember", "Member");
                    if (spaceService.isManager(project, staff_.getId()))
                        json.put("isMember", "Manager");
                }
                json.put("status", "Not Invited");
                jsonArray.put(json);
            }

            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonArray.toString(), mediaType).build();

        } catch (
                java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("editgc")
    public Response edit (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                          GeneralContractor gcuser) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        try {

            /** we rely on FileService, thus we don't need to persist icon in Gamification DB*/
            FileItem fileItem = null;
            if (gcuser.getUploadId() != null) {
                UploadResource uploadResource = uploadService.getUploadResource(gcuser.getUploadId());

                if (uploadResource != null) {

                    fileItem = new FileItem(null,
                            Long.toString(gcuser.getId()),
                            uploadResource.getMimeType(),
                            DEFAULT_AVATAR_ICON_NAMESPACE,
                            (long)uploadResource.getUploadedSize(),
                            new Date(),
                            sourceIdentity.getRemoteId(),
                            false,
                            new FileInputStream(uploadResource.getStoreLocation()));
                    fileItem = fileService.writeFile(fileItem);
                    LOG.info("================================="+fileItem.getFileInfo().getId());

                }
            }

            /** END upload */
            gcuser.setAvatarId(fileItem.getFileInfo().getId());
        } catch (java.lang.Exception e) {
            e.printStackTrace();
        }
        try {
            GeneralContractorEntity generalContractorEntity = generalContractorDAO.find(gcuser.getId());
            generalContractorEntity.setId(gcuser.getId());
            generalContractorEntity.setCompanyName(gcuser.getCompanyName());
            generalContractorEntity.setCompanyStreet(gcuser.getCompanyStreet());
            generalContractorEntity.setCompanyCity(gcuser.getCompanyCity());
            generalContractorEntity.setCompanyState(gcuser.getCompanyState());
            generalContractorEntity.setCompanyZip(gcuser.getCompanyZip());
            generalContractorEntity.setCompanyCountry(gcuser.getCompanyCountry());
            generalContractorEntity.setCompanyWebSite(gcuser.getCompanyWebSite());
            generalContractorEntity.setCompanyProview(gcuser.getCompanyProview());
            generalContractorEntity.setCompanyPhone(gcuser.getCompanyPhone());
            generalContractorEntity.setEmail(gcuser.getEmail());
            generalContractorEntity.setProjectExp(gcuser.getProjectExp());
            generalContractorEntity.setAssoMbr(gcuser.getAssoMbr());
            generalContractorEntity.setEntrepriseType(gcuser.getEntrepriseType());
            generalContractorEntity.setStory(gcuser.getStory());
            generalContractorEntity.setUnionStatus(gcuser.getUnionStatus());
            generalContractorEntity.setServiceArea(gcuser.getServiceArea());
            generalContractorEntity.setAvatarId(gcuser.getAvatarId());
            generalContractorDAO.update(generalContractorEntity);
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " User Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (JSONException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }


    @GET
    @Path("gc/{gc}/avatar")
    public Response getSpaceAvatarById(@Context UriInfo uriInfo,
                                       @Context Request request,
                                       @PathParam("gc") Long gc) throws IOException {

        ConversationState conversationState = ConversationState.getCurrent();

        if (conversationState != null) {

            InputStream stream = null;

            try {
                GeneralContractorEntity gc_ = generalContractorDAO.find(gc);

                Long lastUpdated = null;
                if (gc_ != null && gc_.getAvatarId() != null) {
                    lastUpdated = gc_.getLastModifiedDate().getTime();
                } else {
                    stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                //
                Response.ResponseBuilder builder = (eTag == null ? null : request.evaluatePreconditions(eTag));
                if (builder == null) {
                    if (stream == null) {
                        if(gc_!=null){
                            stream = Utils.getAvatarInputStream(gc_.getAvatarId());
                        }else{
                            throw new WebApplicationException(Response.Status.NOT_FOUND);
                        }
                    }

                    builder = Response.ok(stream, "image/png");
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();

            } catch (java.lang.Exception e) {

                LOG.error("Error getting badge's avatar", e);

                return Response.serverError()
                        .entity("Error getting badge's avatar")
                        .build();
            }

        } else {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("Unauthorized user")
                    .build();
        }

    }




    @GET
    @Path("getcurrentcompany/avatar")
    public Response getCurrentCompany(@Context UriInfo uriInfo,
                                       @Context Request request) throws IOException {

        ConversationState conversationState = ConversationState.getCurrent();

        StaffDAO staffDAO = getService(StaffDAO.class,null);


        SubStaffCompanyDAO subStaffCompanyDAO = getService(SubStaffCompanyDAO.class,null);



        if (conversationState != null) {
            InputStream stream = null;

            String currentUser= conversationState.getIdentity().getUserId();

            StaffEntity staff = staffDAO.find(currentUser);

            if(staff!=null){
                try {
                    Long lastUpdated =  lastUpdated = staff.getGeneralContractorEntity().getLastModifiedDate().getTime();

                    EntityTag eTag = null;
                    if (lastUpdated != null) {
                        eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                    }
                    //
                    Response.ResponseBuilder builder = (eTag == null ? null : request.evaluatePreconditions(eTag));
                    if (builder == null) {
                        if (staff.getGeneralContractorEntity().getAvatarId() != null) {
                            stream = Utils.getAvatarInputStream(staff.getGeneralContractorEntity().getAvatarId());
                        }else{
                            stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                        }

                        builder = Response.ok(stream, "image/png");
                        builder.tag(eTag);
                    }
                    CacheControl cc = new CacheControl();
                    cc.setMaxAge(86400);
                    builder.cacheControl(cc);
                    return builder.cacheControl(cc).build();

                } catch (java.lang.Exception e) {

                    LOG.error("Error getting badge's avatar", e);

                    return Response.serverError()
                            .entity("Error getting badge's avatar")
                            .build();
                }
            }else{
                SubStaffCompanyEntity sub = subStaffCompanyDAO.find(currentUser);
                if(sub!=null){
                    try {
                        SubContractorEntity sub_ = sub.getSubContractorEntity();

                        Long lastUpdated = sub_.getLastModifiedDate().getTime();

                        EntityTag eTag = null;
                        if (lastUpdated != null) {
                            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                        }
                        //
                        Response.ResponseBuilder builder = (eTag == null ? null : request.evaluatePreconditions(eTag));
                        if (builder == null) {
                            if (sub_.getAvatarId() != null) {
                                stream = Utils.getAvatarInputStream(sub_.getAvatarId());
                            }else  {
                                stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                            }

                            builder = Response.ok(stream, "image/png");
                            builder.tag(eTag);
                        }
                        CacheControl cc = new CacheControl();
                        cc.setMaxAge(86400);
                        builder.cacheControl(cc);
                        return builder.cacheControl(cc).build();

                    } catch (java.lang.Exception e) {

                        LOG.error("Error getting badge's avatar", e);

                        return Response.serverError()
                                .entity("Error getting badge's avatar")
                                .build();
                    }
                } else{
                        stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                        Response.ResponseBuilder builder = Response.ok(stream, "image/png");
                    CacheControl cc = new CacheControl();
                    cc.setMaxAge(86400);
                    builder.cacheControl(cc);
                    return builder.cacheControl(cc).build();
                }

            }
        } else {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("Unauthorized user")
                    .build();
        }
    }


    @POST
    @Path("addstaff/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addNotInvited(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @PathParam("projectId") String projectId,
                                  List<String> users) throws Exception {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

            if (sourceIdentity == null) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn("Project not found");
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }


            for (String user : users) {
                spaceService.addInvitedUser(project,user);
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("invitebymail")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response inviteByMail(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 BbUser userIn) throws java.lang.Exception {
        try {
            StaffDAO staffDAO = getService(StaffDAO.class,null);
            StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());

            if(staffEntity!=null){
                sendEmail(userIn,staffEntity.getGeneralContractorEntity().getId());
                return Response.ok("mail sent").build();
            }else{
                return Response.status(Response.Status.UNAUTHORIZED).entity("Not A staff on any gc").build();
            }

        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }



    private String generateBodyEmail(BbUser user, Long gcId) throws FileNotFoundException {

        BbMessage message = null ;
        ProjectSubDAO projectSubDAO = (ProjectSubDAO) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class);
        SubCatDAO subCatDAO = (SubCatDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class);
        SubGcDAO subGcDAO = (SubGcDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubGcDAO.class);




        StaffDAO staffDAO = getService(StaffDAO.class,null);
        StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
       /* SpaceService spaceService = Util.getSpaceService(portalContainerName);
        Space space =  spaceService.getSpaceByPrettyName(projectId);*/

        String base_url= System.getProperty("gatein.email.domain.url");
        String confirmUrl = base_url+"/portal/gc-portal/subscribe?gcid="+gcId+"&staff=true";



        String creator = staffEntity.getFirstName()+" "+staffEntity.getLastName()!= null ? staffEntity.getLastName():"";
        String phone = staffEntity.getGeneralContractorEntity().getCompanyPhone()!= null ? staffEntity.getGeneralContractorEntity().getCompanyPhone():"";
        String mail = staffEntity.getGeneralContractorEntity().getEmail()!= null ? staffEntity.getGeneralContractorEntity().getEmail():"";
        String companyName = staffEntity.getGeneralContractorEntity().getCompanyName()!= null ? staffEntity.getGeneralContractorEntity().getCompanyName():"";
        String contact = staffEntity.getGeneralContractorEntity().getCompanyCountry()+""+staffEntity.getGeneralContractorEntity().getCompanyState()+" "+staffEntity.getGeneralContractorEntity().getCompanyCity();
        LOG.info(" send email hello "+user.getEmail()+" for gc = "+gcId);
        String imagePath = base_url+"/exo-community-webui-portlet/skin/images";
        Map<String, String> props = new HashMap<String, String>();
        props.put("imagepath",imagePath);

        props.put("confirmUrl",confirmUrl);
        props.put("CREATOR",creator);
        props.put("MAIL",mail);
        props.put("FULL_NAME",user.getFirstName()+ " "+ user.getLastName());
        props.put("FIRST_NAME",user.getFirstName());
        props.put("CONTACT",contact);
        props.put("PHONE",phone);
        props.put("COMPANYNAME",companyName);

        return this.resolveTemplate(props);
    }
    private String resolveTemplate(Map<String, String> properties) throws FileNotFoundException {

        String templateContent = generateBodyEmailContent();
        if (templateContent != null) {
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if(null != property.getKey() && null != property.getValue())
                    templateContent = templateContent.replace("${" + property.getKey() + "}", property.getValue());
            }
        }
        return templateContent;
    }

    private String generateBodyEmailContent(){
        try {
            InputStream bodyEmailIS =  this.getClass().getResourceAsStream("/html/template_gc_register_email.html");
            Scanner scanner = new Scanner(bodyEmailIS);
            StringBuilder sb = new StringBuilder();

            try {
                while (scanner.hasNextLine()) {
                    sb.append(scanner.nextLine()).append(System.getProperty("line.separator"));
                }
            } finally {
                scanner.close();
            }
            return sb.toString();

        } catch (java.lang.Exception e) {
            LOG.error(" ==== ERR cannot get body email content ", e);
        }
        return null;

    }

    public void sendEmail(BbUser user, Long gcId) {
        LOG.debug("=== send register  email to "+user.getEmail()+") ");
        MailService mailService = getService(MailService.class,null);
        Message message = new Message();
        message.setReceiver(user.getEmail());
        message.setTo(user.getEmail());
        try {
            String body = this.generateBodyEmail(user,gcId);
            message.setBody(body);
            message.setFrom(System.getProperty("gatein.email.smtp.from"));
            message.setMimeType("text/html");
            message.setSubject("INVITATION TO COLLABORATE");
            mailService.sendMessage(message);
        } catch (FileNotFoundException e) {
            LOG.error("=== register: send confirmation email: cannot file email temmplate ");
        } catch (java.lang.Exception e) {
            LOG.error("=== Registration process: send confirmation email "+e.getMessage());
        }
    }



    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }
}
