/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.rest;


import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.ps.DAO.ProjectSubDAO;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubContractorDAO;
import org.exoplatform.ps.chromattic.entity.*;
import org.exoplatform.ps.entity.*;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.storage.api.*;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.impl.DefaultSpaceApplicationHandler;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Path("/bbprojectservice")

public class ProjectRestService implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String DefaultAvatar = "/Project-Space-portlets/skin/images/form-aside.png";
    private static final Log LOG = ExoLogger.getLogger(ProjectRestService.class.getName());
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String REPOSITORY = "repository";
    private static final String SOCIAL_WORKSPACE = "social";
    private static final String COLLABORATION_WORKSPACE = "collaboration";
    private static final String TITLE = "dc:title";
    private static final String TOTAL_VISITS = "exo:totalVisits";
    private static final String LAST_VISIT = "exo:lastVisit";
    private static final String TOTAL_VIEWS = "exo:totalViews";
    private static final String TOTAL_DOWNLOADS = "exo:totalDownloads";
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String SUBS_GROUP = "/organization/subcontractors";
    private static final String ADMIN_GROUP = "/platform/administrators";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    private static final String socialNameSpace = "social";
    // The width and height of resized avatar fix 200px like facebook avatar
    public static final int WIDTH = 200;
    public static final int HEIGHT = 200;
    OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    RepositoryService repositoryService = (RepositoryService) PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);

    public static String getStructure(Object structure) {
        try {
            if (structure == null) return "";
            String structureId = structure.toString();
            if (structureId.equals("RSB")) return ("Residential Building");
            if (structureId.equals("RSB1")) return ("House");
            if (structureId.equals("RSB2")) return ("Tract Housing");
            if (structureId.equals("RSB3")) return ("Apartments & Condominiums");
            if (structureId.equals("NRS")) return ("Non-Residential Building");
            if (structureId.equals("NRS01")) return ("Animal Hospital / Kennel");
            if (structureId.equals("NRS03")) return ("Arena / Stadium");
            if (structureId.equals("NRS95")) return ("Assisted Living");
            if (structureId.equals("NRS02")) return ("Auto Dealership / Service");
            if (structureId.equals("NRS04")) return ("Bank");
            if (structureId.equals("NRS91")) return ("Casino");
            if (structureId.equals("NRS06")) return ("Church / Synagogue");
            if (structureId.equals("NRS09")) return ("City / Town Hall");
            if (structureId.equals("NRS12")) return ("Club House / Community Center");
            if (structureId.equals("NRS92")) return ("Convention Center");
            if (structureId.equals("NRS21")) return ("Court House");
            if (structureId.equals("NRS24")) return ("Fitness Center");
            if (structureId.equals("NRS27")) return ("Fire / Police Station");
            if (structureId.equals("NRS28")) return ("Gas Station");
            if (structureId.equals("NRS30")) return ("Hospital / Nursing Home");
            if (structureId.equals("NRS34")) return ("Hotel / Motel");
            if (structureId.equals("NRS32")) return ("Industrial Maintenance");
            if (structureId.equals("NRS38")) return ("Jail / Prison");
            if (structureId.equals("NRS42")) return ("Laboratory");
            if (structureId.equals("NRS43")) return ("Library");
            if (structureId.equals("NRS46")) return ("Manufacturing Plant");
            if (structureId.equals("NRS48")) return ("Medical Office");
            if (structureId.equals("NRS49")) return ("Mixed Use");
            if (structureId.equals("NRS50")) return ("Museum");
            if (structureId.equals("NRS58")) return ("Office Building");
            if (structureId.equals("NRS62")) return ("Parking Garage");
            if (structureId.equals("NRS67")) return ("Post Office");
            if (structureId.equals("NRS68")) return ("Radio / Television Station");
            if (structureId.equals("NRS70")) return ("Restaurant");
            if (structureId.equals("NRS74")) return ("Retail Store");
            if (structureId.equals("NRS78")) return ("School / College / University");
            if (structureId.equals("NRS82")) return ("Sewage / Water Treatment Plant");
            if (structureId.equals("NRS83")) return ("Storage Facility / Warehouse");
            if (structureId.equals("NRS84")) return ("Terminal - Airport / Bus / Railroad");
            if (structureId.equals("NRS86")) return ("Theater");
            if (structureId.equals("NRS90")) return ("Theme Park");
            if (structureId.equals("NBC")) return ("Non-Building Construction");
            if (structureId.equals("NBC10")) return ("Airport Runway");
            if (structureId.equals("NBC20")) return ("Athletic Field");
            if (structureId.equals("NBC25")) return ("Bridge");
            if (structureId.equals("NBC40")) return ("Golf Course");
            if (structureId.equals("NBC50")) return ("Marine");
            if (structureId.equals("NBC52")) return ("Park / Playground");
            if (structureId.equals("NBC60")) return ("Road / Highway");
            if (structureId.equals("NBC61")) return ("Parking Lots");
            if (structureId.equals("NBC62")) return ("Swimming Pool");
            if (structureId.equals("NBC68")) return ("Tennis Court");
            if (structureId.equals("NBC70")) return ("Tunnel");
            if (structureId.equals("NBC80")) return ("Utilities");
            return (structureId);
        } catch (Exception e) {
            return ("");
        }
    }

    private static String getType(Object type) {
        try {
            if (type == null) return "";
            String typeId = type.toString();
            if (typeId.equals("NEW")) return ("New");
            if (typeId.equals("AAP")) return ("Addition");
            if (typeId.equals("IFV")) return ("Interior Fit-Up");
            if (typeId.equals("TNI")) return ("Tenant Improvements");
            if (typeId.equals("RNR")) return ("Alterations / Renovations");
            if (typeId.equals("IMP")) return ("Improvements");
            if (typeId.equals("SCN")) return ("Service Contract");
            if (typeId.equals("IVT")) return ("Individual Trade");
            if (typeId.equals("EQP")) return ("Equipment");
            if (typeId.equals("MAT")) return ("Material");
            return (typeId);
        } catch (Exception e) {
            return ("");
        }
    }

    private static String getOwnerType(Object oType) {
        try {
            if (oType == null) return "";
            String oTypeId = oType.toString();
            if (oTypeId.equals("PRV")) return ("Private");
            if (oTypeId.equals("LOG")) return ("Local Government");
            if (oTypeId.equals("STA")) return ("State Government");
            if (oTypeId.equals("FED")) return ("Federal Government");
            if (oTypeId.equals("MIL")) return ("Military");

            return (oTypeId);
        } catch (Exception e) {
            return ("");
        }
    }

    private static boolean isLowerCaseLetter(char character) {
        return (character >= 'a' && character <= 'z');
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");  //match a number with optional '-' and decimal.
    }

    public static boolean isAdmin(org.exoplatform.services.security.Identity userId) {
        if(userId.isMemberOf(ADMIN_GROUP)||userId.isMemberOf(GCS_GROUP)||userId.getUserId().equals(PropertyManager.getProperty("exo.super.user"))||userId.getUserId().equals(PLAN_ROOM_TEAM)||userId.getUserId().equals(INTEGRATION_USER))
            return true;
        return false;
    }

    /**
     * This method create a project
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/private/bbprojectservice/create
     * {
     * "projectName":"projectName",
     * "projectDescription":"projectDescription",
     * "ownerType":"ownerType",
     * "projectType":"projectType",
     * "StructureEntity":"StructureEntity",
     * "nbBuildings":"nbBuildings",
     * "storiesAboveGrd":"storiesAboveGrd",
     * "storiesBelowGrd":"storiesBelowGrd",
     * "totalSqFt":"totalSqFt",
     * "projectValuation":"projectValuation",
     * "projectStatus":"projectStatus",
     * "bidsDueDate":"bidsDueDate",
     * "startDate":"startDate",
     * "preBidMeetingDate":"preBidMeetingDate",
     * "union":"union",
     * "nonUnion":"nonUnion",
     * "prevailingWage":"prevailingWage",
     * "bidSecurity":"bidSecurity",
     * "performanceBond":"performanceBond",
     * "paymentBond":"paymentBond",
     * "mbeGoal":"mbeGoal",
     * "dbeGoal":"dbeGoal",
     * "hubzone":"hubzone",
     * "leed":"leed",
     * "bim":"bim",
     * "adress":"adress",
     * "city":"city",
     * "state":"state",
     * "zip":"zip",
     * "country":"country",
     * "architect":"architect",
     * "engineer":"engineer",
     * "owner":"owner",
     * "geoPosition":{
     * "k":40.69443569856639,
     * "B":-73.94365310668945
     * },
     * "avatar":"/social-resources/skin/images/ShareImages/SpaceAvtDefault.png"
     * }
     *
     * @return Project info:
     * <p/>
     * {
     * "projectDisplayName":"projectDisplayName",
     * "projectDescription":"projectDescription",
     * "projectName":"projectName"
     * }
     * @throws Exception
     */
    @POST
    @Path("create")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo,
                                Map<String, String> project) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ListenerService listenerService = (ListenerService) PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
        UploadService uploadService = (UploadService) PortalContainer.getInstance().getComponentInstanceOfType(UploadService.class);
        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());

        if (staffEntity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            String owner = sourceIdentity.getRemoteId();
            Calendar cal = Calendar.getInstance();
            Date date = cal.getTime();
            User oUser = uh.findUserByName(owner);
            String name = String.valueOf(oUser.getFirstName().toLowerCase().charAt(0)) + String.valueOf(oUser.getLastName().toLowerCase().charAt(0)) + String.valueOf(date.getTime());
            while (!isLowerCaseLetter(name.charAt(0))) {
                name = name.substring(1);
            }
            while (spaceService.getSpaceByPrettyName(name) != null) {

                name = String.valueOf(oUser.getFirstName().toLowerCase().charAt(0)) + String.valueOf(oUser.getLastName().toLowerCase().charAt(0)) + String.valueOf(date.getTime() + 1);
                while (!isLowerCaseLetter(name.charAt(0))) {
                    name = name.substring(1);
                }

            }
            // If There is no space with the provided Pretty Name, Create a new Space
            Space project_ = new Space();
            project_.setDisplayName(project.get("projectName"));
            project_.setPrettyName(name);
            project_.setRegistration(Space.OPEN);
            project_.setDescription(project.get("projectDescription"));
            project_.setType(DefaultSpaceApplicationHandler.NAME);
            project_.setVisibility(Space.PUBLIC);
            project_.setRegistration(Space.VALIDATION);
            project_.setPriority(Space.INTERMEDIATE_PRIORITY);
            spaceService.createSpace(project_, owner);

            //Get the new Space Identity
            Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, project_.getPrettyName(), true);





           /* if (project.get("avatar").compareTo(DefaultAvatar) != 0) {
                try {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService) PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String userId = (state != null) ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment(inputStream,
                                200,
                                0,
                                null,
                                "avatar",
                                "image/png",
                                null);
                        project_.setAvatarAttachment(avatar);
                        spaceService.updateSpace(project_);
                        project_.setEditor(userId);
                        spaceService.updateSpaceAvatar(project_);
                    }
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    //throw e;
                }
            }*/
            // GEt the Space Identity Profile
            Profile sProfile = prIdentity.getProfile();
            // Set all Project Properties in the Space Identity Profile
            sProfile.setProperty("ownerType", project.get("ownerType"));
            sProfile.setProperty("ownerTypeId", project.get("ownerTypeId"));
            sProfile.setProperty("projectType", project.get("projectType"));
            sProfile.setProperty("projectTypeId", project.get("projectTypeId"));
/*          sProfile.setProperty("StructureEntity", project.get("StructureEntity"));
            sProfile.setProperty("structureId", project.get("structureId"));
            sProfile.setProperty("addstructure", project.get("addstructure"));
            sProfile.setProperty("addstructureId", project.get("addstructureId"));*/
            sProfile.setProperty("nbBuildings", project.get("nbBuildings"));
            sProfile.setProperty("storiesAboveGrd", project.get("storiesAboveGrd"));
            sProfile.setProperty("storiesBelowGrd", project.get("storiesBelowGrd"));
            sProfile.setProperty("totalSqFt", project.get("totalSqFt"));
            sProfile.setProperty("projectValuation", project.get("projectValuation"));
            sProfile.setProperty("projectStatus", project.get("projectStatus"));
            sProfile.setProperty("projectStatusId", project.get("projectStatusId"));
            sProfile.setProperty("preBidMeetingDate", project.get("preBidMeetingDate"));
            sProfile.setProperty("bidsDueDate", project.get("bidsDueDate"));
            sProfile.setProperty("startDate", project.get("startDate"));
            sProfile.setProperty("creator", owner);
            sProfile.setProperty("union", project.get("union"));
            sProfile.setProperty("nonUnion", project.get("nonUnion"));
            sProfile.setProperty("prevailingWage", project.get("prevailingWage"));
            sProfile.setProperty("chkleed", project.get("chkleed"));
            sProfile.setProperty("chkbim", project.get("chkbim"));
            sProfile.setProperty("goal1", project.get("goal1"));
            sProfile.setProperty("goal1Id", project.get("goal1Id"));
            sProfile.setProperty("goal2", project.get("goal2"));
            sProfile.setProperty("goal2Id", project.get("goal2Id"));
            sProfile.setProperty("goal3", project.get("goal3"));
            sProfile.setProperty("goal3Id", project.get("goal3Id"));
            sProfile.setProperty("goal1pct", project.get("goal1pct"));
            sProfile.setProperty("goal2pct", project.get("goal2pct"));
            sProfile.setProperty("goal3pct", project.get("goal3pct"));
            sProfile.setProperty("bidSecurity", project.get("bidSecurity"));
            sProfile.setProperty("performanceBond", project.get("performanceBond"));
            sProfile.setProperty("paymentBond", project.get("paymentBond"));
            sProfile.setProperty("mbeGoal", project.get("mbeGoal"));
            sProfile.setProperty("dbeGoal", project.get("dbeGoal"));
            sProfile.setProperty("hubzone", project.get("hubzone"));
            sProfile.setProperty("leed", project.get("leed"));
            sProfile.setProperty("bim", project.get("bim"));
            sProfile.setProperty("adress", project.get("adress"));
            sProfile.setProperty("city", project.get("city"));
            sProfile.setProperty("state", project.get("state"));
            sProfile.setProperty("zip", project.get("zip"));
            sProfile.setProperty("country", project.get("country"));
            sProfile.setProperty("architect", project.get("architect"));
            sProfile.setProperty("engineer", project.get("engineer"));
            sProfile.setProperty("owner", project.get("owner"));
            sProfile.setProperty("geoPosition", project.get("geoPosition"));
            sProfile.setProperty("url", project.get("url"));
            sProfile.setProperty("gc", staffEntity.getGeneralContractorEntity().getId());
            // Save the Space Identity Profile
            Util.getIdentityManager(portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
            LOG.info("Project has been created successfully");
            Space createdSpace = spaceService.getSpaceByPrettyName(name);
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("projectName", createdSpace.getPrettyName());
            jsonGlobal.put("projectDisplayName", createdSpace.getDisplayName());
            jsonGlobal.put("projectDescription", createdSpace.getDescription());
            jsonGlobal.put("projectUrl", "/portal/g/:spaces:"+createdSpace.getPrettyName()+"/"+createdSpace.getPrettyName());

            try {

                /** we rely on FileService, thus we don't need to persist icon in our DB*/
                FileItem fileItem = null;

                if (project.get("uploadId") != null) {
                    UploadResource uploadResource = uploadService.getUploadResource(project.get("uploadId"));

                    String mimeType = uploadResource.getMimeType();
                    InputStream uploadedStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
                    AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment(uploadedStream, WIDTH, HEIGHT, null,
                            uploadResource.getFileName(), mimeType, null);
                    if (avatarAttachment == null) {
                        avatarAttachment = new AvatarAttachment(null, uploadResource.getFileName(), mimeType, uploadedStream, null, System.currentTimeMillis());
                    }

                    createdSpace.setAvatarAttachment(avatarAttachment);
                    spaceService.updateSpace(createdSpace);
                    spaceService.updateSpaceAvatar(createdSpace);
                }


            } catch (java.lang.Exception e) {
                e.printStackTrace();
            }

            listenerService.broadcast("CreateProject", createdSpace , sourceIdentity.getRemoteId());

            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method get a project by the project name
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/private/bbprojectservice/get/dddddddddd
     *
     * @param projectId
     * @return Project:
     * <p/>
     * {
     * "startDate":"",
     * "leed":"TBD",
     * "hubzone":"%",
     * "state":"NY",
     * "projectType":"Addition",
     * "projectId":"projectId",
     * "paymentBond":"%",
     * "canEdit":true,
     * "bidsDueDate":"07/29/2014 12:00 am MST",
     * "city":"New York",
     * "projectStatus":"Bidding-Owner",
     * "isSub":false,
     * "union":"false",
     * "zip":"11206",
     * "StructureEntity":"Arena/Stadium",
     * "totalSqFt":"totalSqFt",
     * "storiesBelowGrd":"",
     * "status":"",
     * "storiesAboveGrd":"",
     * "performanceBond":"%",
     * "ownerType":"Local Government",
     * "nbBuildings":"",
     * "mbeGoal":"%",
     * "engineer":"",
     * "url":"url",
     * "preBidMeetingDate":"",
     * "bidSecurity":"%",
     * "country":"US",
     * "architect":"",
     * "adress":"642 Willoughby Avenue",
     * "prevallingWage":"false",
     * "owner":"",
     * "projectDescription":"dddd",
     * "nonUnion":"false",
     * "bim":"TBD",
     * "dbeGoal":"%",
     * "projectValuation":"",
     * "projectName":"projectName"
     * }
     * @throws Exception
     */
    @GET
    @Path("get/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo,
                                @PathParam("projectId") String projectId) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        String status = "";
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubContractorDAO subContractorDAO = (SubContractorDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubContractorDAO.class);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            MembershipHandler mHandler = orgService.getMembershipHandler();
            MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
            boolean canEdit = false;
            boolean isSub = false;
            if (subContractorDAO.find(sourceIdentity.getRemoteId())!= null) {
                isSub = true;
                ListAccess<ProjectSubEntity> relations = projectSubRelationShipStorage.getRelationShipByProjectIdAndSubIdListAccess(project.getPrettyName(), sourceIdentity.getRemoteId());

                for (ProjectSubEntity rel : relations.load(0, relations.getSize())) {
                    status = rel.getStatus();
                    if (rel.getStatus().equals("INVITED")) {
                        projectSubRelationShipStorage.updateProjectSubRelationShip(rel.getId(), null, "REVIEWING", null, null, null, null);
                    }
                }

            }

            // Create the Json Object with Project properties
            JSONObject json = new JSONObject();
            json.put("projectId", project.getPrettyName());
            json.put("projectName", project.getDisplayName());
            json.put("projectDescription", project.getDescription());
            json.put("url", project.getUrl());
            json.put("avatar", project.getAvatarUrl());
            Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, projectId, true);
            Profile sProfile = prIdentity.getProfile();
            json.put("ownerType", getOwnerType(sProfile.getProperty("ownerTypeId")));
            json.put("ownerTypeId", sProfile.getProperty("ownerTypeId"));
            json.put("projectStatus", sProfile.getProperty("projectStatus"));
            json.put("projectStatusId", sProfile.getProperty("projectStatusId"));
            json.put("projectType", getType(sProfile.getProperty("projectTypeId")));
            json.put("projectTypeId", sProfile.getProperty("projectTypeId"));
/*            json.put("StructureEntity", getStructure(sProfile.getProperty("structureId").toString()));
            json.put("structureId", sProfile.getProperty("structureId").toString());
            json.put("addstructure", (sProfile.getProperty("addstructureId") != null) ? getStructure(sProfile.getProperty("addstructureId").toString()) : "");
            json.put("addstructureId", sProfile.getProperty("addstructureId"));*/
            json.put("nbBuildings", sProfile.getProperty("nbBuildings"));
            json.put("storiesAboveGrd", sProfile.getProperty("storiesAboveGrd"));
            json.put("storiesBelowGrd", sProfile.getProperty("storiesBelowGrd"));
            json.put("totalSqFt", sProfile.getProperty("totalSqFt"));
            json.put("projectValuation", sProfile.getProperty("projectValuation"));
            json.put("preBidMeetingDate", sProfile.getProperty("preBidMeetingDate"));
            json.put("bidsDueDate", sProfile.getProperty("bidsDueDate"));
            json.put("startDate", sProfile.getProperty("startDate"));
            json.put("creator", sProfile.getProperty("creator"));
            json.put("union", Boolean.parseBoolean((String) sProfile.getProperty("union")));
            json.put("nonUnion", Boolean.parseBoolean((String) sProfile.getProperty("nonUnion")));
            json.put("prevailingWage", Boolean.parseBoolean((String) sProfile.getProperty("prevailingWage")));
            json.put("chkleed", Boolean.parseBoolean((String) sProfile.getProperty("chkleed")));
            json.put("chkbim", Boolean.parseBoolean((String) sProfile.getProperty("chkbim")));
            json.put("goal1", sProfile.getProperty("goal1"));
            json.put("goal1Id", sProfile.getProperty("goal1Id"));
            json.put("goal2", sProfile.getProperty("goal2"));
            json.put("goal2Id", sProfile.getProperty("goal2Id"));
            json.put("goal3", sProfile.getProperty("goal3"));
            json.put("goal3Id", sProfile.getProperty("goal3Id"));
            json.put("goal1pct", sProfile.getProperty("goal1pct"));
            json.put("goal2pct", sProfile.getProperty("goal2pct"));
            json.put("goal3pct", sProfile.getProperty("goal3pct"));
            json.put("bidSecurity", sProfile.getProperty("bidSecurity"));
            json.put("performanceBond", sProfile.getProperty("performanceBond"));
            json.put("paymentBond", sProfile.getProperty("paymentBond"));
            json.put("mbeGoal", sProfile.getProperty("mbeGoal"));
            json.put("dbeGoal", sProfile.getProperty("dbeGoal"));
            json.put("hubzone", sProfile.getProperty("hubzone"));
            json.put("leed", sProfile.getProperty("leed"));
            json.put("bim", sProfile.getProperty("bim"));
            json.put("adress", sProfile.getProperty("adress"));
            json.put("city", sProfile.getProperty("city"));
            json.put("state", sProfile.getProperty("state"));
            json.put("zip", sProfile.getProperty("zip"));
            json.put("country", sProfile.getProperty("country"));
            json.put("architect", sProfile.getProperty("architect"));
            json.put("engineer", sProfile.getProperty("engineer"));
            json.put("owner", sProfile.getProperty("owner"));
            json.put("geoPosition", sProfile.getProperty("geoPosition"));
            json.put("url", sProfile.getProperty("url"));
            json.put("bidScop", (sProfile.getProperty("bidScop") != null) ? getStructure(sProfile.getProperty("bidScop")) : "false");
            json.put("canEdit", spaceService.isManager(project, sourceIdentity.getRemoteId()));
            json.put("isSub", isSub);
            json.put("status", status);
            return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("archive/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response archiveProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo,
                                    @PathParam("projectId") String projectId) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);

            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            Session session = manageableRepository.getSystemSession(SOCIAL_WORKSPACE);
            Node socialRootNode = (Node) session.getRootNode();
            if (!socialRootNode.hasNode("soc:archive")) {
                socialRootNode.addNode("soc:archive", "soc:archive");
                session.save();
            }
            Node socArchiveNode = socialRootNode.getNode("soc:archive");
            if (!socArchiveNode.hasNode("soc:archivedSpaces")) {
                socArchiveNode.addNode("soc:archivedSpaces", "soc:spaces");
                session.save();
            }
            session.move("/production/soc:spaces/soc:" + projectId, "/soc:archive/soc:archivedSpaces/soc:" + projectId);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String query = "select * from soc:spaceref where jcr:path like '/production/soc:providers/soc:organization/%' and exo:name = 'soc:" + projectId + "' order by exo:dateCreated DESC";
            QueryImpl queryImpl = (QueryImpl) queryManager.createQuery(query, Query.SQL);
            QueryResult queryResult = queryImpl.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (node.getParent().getName().equals("soc:spacemember")) {
                    if (!socArchiveNode.hasNode("soc:" + node.getProperty("exo:lastModifier").getString())) {
                        socArchiveNode.addNode("soc:" + node.getProperty("exo:lastModifier").getString(), "soc:spaceslist");
                        session.save();
                    }
                    session.move(node.getPath(), "/soc:archive/soc:" + node.getProperty("exo:lastModifier").getString() + "/soc:" + projectId);
                }
            }
            session.save();
            return Response.ok("Archived").build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("delete/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response deleteProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo,
                                   @PathParam("projectId") String projectId) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            spaceService.deleteSpace(project);
            ListAccess<ProjectSubEntity> relations = projectSubRelationShipStorage.getRelationShipByProjectIdListAccess(projectId);

            for (ProjectSubEntity rel : relations.load(0, relations.getSize())) {
                projectSubRelationShipStorage.deleteProjectSubRelationShip(rel.getId());
            }
            return Response.ok("Deleted").build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method get a space by the pretty name
     * <p/>
     * eg: request: http://localhost:8080/rest/private/bbprojectservice/update/projectId
     * {
     * "projectName":"projectName",
     * "projectDescription":"projectDescription",
     * "owner":"owner",
     * "projectType":"projectType",
     * "StructureEntity":"StructureEntity",
     * "nbBuildings":"nbBuildings",
     * "storiesAboveGrd":"storiesAboveGrd",
     * "storiesBelowGrd":"storiesBelowGrd",
     * "totalSqFt":"totalSqFt",
     * "projectValuation":"projectValuation",
     * "projectStatus":"",
     * "preBidMeetingDate":"",
     * "bidsDueDate":"",
     * "startDate":"",
     * "union":"",
     * "nonUnion":"",
     * "prevailingWage":"",
     * "bidSecurity":"",
     * "performanceBond":"",
     * "paymentBond":"",
     * "mbeGoal":"",
     * "dbeGoal":"",
     * "hubzone":"",
     * "leed":"",
     * "bim":"",
     * "adress":"",
     * "city":"",
     * "state":"",
     * "zip":"",
     * "country":"",
     * "architect":"",
     * "engineer":"",
     * "owner":"",
     * }
     *
     * @param uriInfo
     * @return
     * @throws Exception
     */
    @POST
    @Path("update/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response updateProject_(@Context HttpServletRequest request, @Context UriInfo uriInfo,
                                   @PathParam("projectId") String projectId,
                                   Map<String, String> project) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            //Get the Space by its Pretty Name
            Space project_ = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            // Update the space data
            project_.setDisplayName(project.get("projectName"));
            project_.setDescription(project.get("projectDescription"));
      /*      if (project.get("avatar").compareTo(DefaultAvatar) != 0) {
                try {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService) PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String userId = (state != null) ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && project.get("avatar").contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment(inputStream,
                                200,
                                0,
                                null,
                                "avatar",
                                "image/png",
                                null);
                        project_.setAvatarAttachment(avatar);
                        spaceService.updateSpace(project_);
                        project_.setEditor(userId);
                        spaceService.updateSpaceAvatar(project_);
                    }
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    //throw e;
                }
            }*/
            spaceService.updateSpace(project_);
            Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, projectId, true);
            Profile sProfile = prIdentity.getProfile();
            sProfile.setProperty("ownerType", project.get("ownerType"));
            sProfile.setProperty("projectType", project.get("projectType"));
/*            sProfile.setProperty("StructureEntity", project.get("StructureEntity"));
            sProfile.setProperty("structureId", project.get("structureId"));
            sProfile.setProperty("addstructure", project.get("addstructure"));
            sProfile.setProperty("addstructureId", project.get("addstructureId"));*/
            sProfile.setProperty("nbBuildings", project.get("nbBuildings"));
            sProfile.setProperty("storiesAboveGrd", project.get("storiesAboveGrd"));
            sProfile.setProperty("storiesBelowGrd", project.get("storiesBelowGrd"));
            sProfile.setProperty("totalSqFt", project.get("totalSqFt"));
            sProfile.setProperty("projectValuation", project.get("projectValuation"));
            sProfile.setProperty("projectStatus", project.get("projectStatus"));
            sProfile.setProperty("projectStatusId", project.get("projectStatusId"));
            sProfile.setProperty("preBidMeetingDate", project.get("preBidMeetingDate"));
            sProfile.setProperty("bidsDueDate", project.get("bidsDueDate"));
            sProfile.setProperty("startDate", project.get("startDate"));
            //sProfile.setProperty("projectScope",project.get("projectScope"));
            sProfile.setProperty("union", project.get("union"));
            sProfile.setProperty("nonUnion", project.get("nonUnion"));
            sProfile.setProperty("prevailingWage", project.get("prevailingWage"));
            sProfile.setProperty("chkleed", project.get("chkleed"));
            sProfile.setProperty("chkbim", project.get("chkbim"));
            sProfile.setProperty("goal1", project.get("goal1"));
            sProfile.setProperty("goal1Id", project.get("goal1Id"));
            sProfile.setProperty("goal2", project.get("goal2"));
            sProfile.setProperty("goal2Id", project.get("goal2Id"));
            sProfile.setProperty("goal3", project.get("goal3"));
            sProfile.setProperty("goal3Id", project.get("goal3Id"));
            sProfile.setProperty("goal1pct", project.get("goal1pct"));
            sProfile.setProperty("goal2pct", project.get("goal2pct"));
            sProfile.setProperty("goal3pct", project.get("goal3pct"));

            sProfile.setProperty("bidSecurity", project.get("bidSecurity"));
            sProfile.setProperty("performanceBond", project.get("performanceBond"));
            sProfile.setProperty("paymentBond", project.get("paymentBond"));
            sProfile.setProperty("mbeGoal", project.get("mbeGoal"));
            sProfile.setProperty("dbeGoal", project.get("dbeGoal"));
            sProfile.setProperty("hubzone", project.get("hubzone"));
            sProfile.setProperty("leed", project.get("leed"));
            sProfile.setProperty("bim", project.get("bim"));
            sProfile.setProperty("adress", project.get("adress"));
            sProfile.setProperty("city", project.get("city"));
            sProfile.setProperty("state", project.get("state"));
            sProfile.setProperty("zip", project.get("zip"));
            sProfile.setProperty("country", project.get("country"));
            sProfile.setProperty("architect", project.get("architect"));
            sProfile.setProperty("engineer", project.get("engineer"));
            sProfile.setProperty("owner", project.get("owner"));
            sProfile.setProperty("geoPosition", project.get("geoPosition"));
            Util.getIdentityManager(portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
            LOG.info("Project has been Updated successfully");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Project Updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method return the list of spaces where user is e member
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/getallprojects
     *
     * @param limit
     * @param offset
     * @return - list of Spaces
     */
    @GET
    @Path("getallprojects")
    public Response getAllProjects(@Context HttpServletRequest request,
                                   @QueryParam("beginby") String beginby,
                                   @QueryParam("searchcondition") String searchCondition,
                                   @QueryParam("limit") int limit,
                                   @QueryParam("offset") int offset) {

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        try {
            List<Space> projects = null;
            SpaceService spaceservice = Util.getSpaceService(portalContainerName);
            SettingService settingService = (SettingService) PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);

            JSONArray jsonArray = new JSONArray();
            JSONObject jsonGlobal = new JSONObject();
            int totalNumber = 0;
            SpaceFilter spaceFilter = new SpaceFilter();
            ListAccess<Space> projects_ = null;
            if (searchCondition != null && !searchCondition.equals("") && !searchCondition.equals("undefined")) {
                spaceFilter.setSpaceNameSearchCondition(searchCondition);
                projects_ = spaceservice.getAllSpacesByFilter(spaceFilter);
            } else if ((beginby != null && !beginby.equals("") && !beginby.equals("undefined")))

            {
                spaceFilter.setFirstCharacterOfSpaceName(beginby.charAt(0));
                projects_ = spaceservice.getAllSpacesByFilter(spaceFilter);
            } else

            {
                projects_ = spaceservice.getAllSpacesWithListAccess();

            }
            String accountSequence = "";
            totalNumber = projects_.getSize();
            if (limit == 0) limit = projects_.getSize();
            projects = Arrays.asList(projects_.load(offset, limit));
            for (Space project : projects) {
                JSONObject json = new JSONObject();

                json.put("projectId", project.getPrettyName());
                json.put("projectName", project.getDisplayName());
                json.put("projectDescription", project.getDescription());
                json.put("url", project.getUrl());
                json.put("avatar", project.getAvatarUrl());
                json.put("contact", project.getEditor());
                Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), true);
                Profile sProfile = prIdentity.getProfile();
                json.put("ownerType", getOwnerType(sProfile.getProperty("ownerTypeId")));
                json.put("ownerTypeId", sProfile.getProperty("ownerTypeId").toString());
                json.put("projectStatus", sProfile.getProperty("projectStatus"));
                json.put("projectStatusId", sProfile.getProperty("projectStatusId").toString());
                json.put("projectType", getType(sProfile.getProperty("projectTypeId")));
                json.put("projectTypeId", sProfile.getProperty("projectTypeId").toString());
/*                json.put("StructureEntity", getStructure(sProfile.getProperty("structureId").toString()));
                json.put("structureId", sProfile.getProperty("structureId").toString());
                json.put("addstructure", (sProfile.getProperty("addstructureId") != null) ? getStructure(sProfile.getProperty("addstructureId").toString()) : "");
                json.put("addstructureId", sProfile.getProperty("addstructureId"));*/
                json.put("nbBuildings", sProfile.getProperty("nbBuildings"));
                json.put("storiesAboveGrd", sProfile.getProperty("storiesAboveGrd"));
                json.put("storiesBelowGrd", sProfile.getProperty("storiesBelowGrd"));
                json.put("totalSqFt", sProfile.getProperty("totalSqFt"));
                json.put("projectValuation", sProfile.getProperty("projectValuation"));
                CalendarService calService = (CalendarService) PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                CalendarEvent duedateevent = calService.getEventById(project.getPrettyName() + " - bidsDueDate");
                CalendarEvent prebiddateevent = calService.getEventById(project.getPrettyName() + " - preBidMeeting");
                CalendarEvent startdateevent = calService.getEventById(project.getPrettyName() + " - startDate");
                DateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
                DateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy");
                formatter1.setTimeZone(TimeZone.getTimeZone("GMT"));
                json.put("bidsDueDate", duedateevent != null ? formatter1.format(duedateevent.getFromDateTime()) : "");
                json.put("preBidMeetingDate", prebiddateevent != null ? formatter1.format(prebiddateevent.getFromDateTime()) : "");
                json.put("startDate", startdateevent != null ? formatter2.format(startdateevent.getFromDateTime()) : "");
                json.put("creator", sProfile.getProperty("creator"));
                json.put("union", Boolean.parseBoolean((String) sProfile.getProperty("union")));
                json.put("nonUnion", Boolean.parseBoolean((String) sProfile.getProperty("nonUnion")));
                json.put("prevailingWage", Boolean.parseBoolean((String) sProfile.getProperty("prevailingWage")));
                json.put("chkleed", Boolean.parseBoolean((String) sProfile.getProperty("chkleed")));
                json.put("chkbim", Boolean.parseBoolean((String) sProfile.getProperty("chkbim")));
                json.put("goal1", sProfile.getProperty("goal1"));
                json.put("goal1Id", sProfile.getProperty("goal1Id"));
                json.put("goal2", sProfile.getProperty("goal2"));
                json.put("goal2Id", sProfile.getProperty("goal2Id"));
                json.put("goal3", sProfile.getProperty("goal3"));
                json.put("goal3Id", sProfile.getProperty("goal3Id"));
                json.put("goal1pct", sProfile.getProperty("goal1pct"));
                json.put("goal2pct", sProfile.getProperty("goal2pct"));
                json.put("goal3pct", sProfile.getProperty("goal3pct"));
                json.put("bidSecurity", sProfile.getProperty("bidSecurity"));
                json.put("performanceBond", sProfile.getProperty("performanceBond"));
                json.put("paymentBond", sProfile.getProperty("paymentBond"));
                json.put("mbeGoal", sProfile.getProperty("mbeGoal"));
                json.put("dbeGoal", sProfile.getProperty("dbeGoal"));
                json.put("hubzone", sProfile.getProperty("hubzone"));
                json.put("leed", sProfile.getProperty("leed"));
                json.put("bim", sProfile.getProperty("bim"));
                json.put("adress", sProfile.getProperty("adress"));
                json.put("city", sProfile.getProperty("city"));
                json.put("state", sProfile.getProperty("state"));
                json.put("zip", sProfile.getProperty("zip"));
                json.put("country", sProfile.getProperty("country"));
                json.put("architect", sProfile.getProperty("architect"));
                json.put("engineer", sProfile.getProperty("engineer"));
                json.put("owner", sProfile.getProperty("owner"));
                json.put("geoPosition", sProfile.getProperty("geoPosition"));
                json.put("url", sProfile.getProperty("url"));
                json.put("bidScop", (sProfile.getProperty("bidScop") != null) ? getStructure(sProfile.getProperty("bidScop")) : "false");
                if (settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "accountSequence") != null) {
                    accountSequence = (String) settingService.get(org.exoplatform.commons.api.settings.data.Context.GLOBAL, Scope.GLOBAL, "accountSequence")
                            .getValue();
                }
                json.put("accountSequence", accountSequence);

                jsonArray.put(json);
            }
            jsonGlobal.put("totalNbOfProjects", totalNumber);
            jsonGlobal.put("projects", jsonArray);
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method return the list of spaces where user is e member
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}//getmyspaces?type={type}&name={name}&limit={limit}&offset={offset}&owner=true
     *
     * @param limit
     * @param offset
     * @return - list of Spaces
     */
    @GET
    @Path("getmyspaces")
    public Response getMySpaces(@Context HttpServletRequest request,
                                @QueryParam("beginby") String beginby,
                                @QueryParam("searchcondition") String searchCondition,
                                @QueryParam("limit") int limit,
                                @QueryParam("offset") int offset) {


        Identity userIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (userIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        try {
            List<Space> mySpaces = null;
            SpaceService spaceservice = Util.getSpaceService(portalContainerName);
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonGlobal = new JSONObject();
            int totalNumber = 0;
            SpaceFilter spaceFilter = new SpaceFilter();
            ListAccess<Space> mySpaces_ = null;
            if (searchCondition != null && !searchCondition.equals("") && !searchCondition.equals("undefined")) {
                spaceFilter.setSpaceNameSearchCondition(searchCondition);
                mySpaces_ = spaceservice.getMemberSpacesByFilter(userIdentity.getRemoteId(), spaceFilter);

            } else if ((beginby != null && !beginby.equals("") && !beginby.equals("undefined")))

            {
                spaceFilter.setFirstCharacterOfSpaceName(beginby.charAt(0));
                mySpaces_ = spaceservice.getMemberSpacesByFilter(userIdentity.getRemoteId(), spaceFilter);
            } else

            {
                mySpaces_ = spaceservice.getMemberSpaces(userIdentity.getRemoteId());

            }
            boolean isgcmember = false;
            MembershipHandler mHandler = orgService.getMembershipHandler();
            if (mHandler.findMembershipByUserGroupAndType(userIdentity.getRemoteId(), "/organization/subcontractors", "member") == null)
                isgcmember = true;
            jsonGlobal.put("isgcmember", isgcmember);
            totalNumber = mySpaces_.getSize();
            if (limit == 0) limit = mySpaces_.getSize();
            mySpaces = Arrays.asList(mySpaces_.load(offset, limit));
            for (Space space : mySpaces) {
                Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, space.getPrettyName(), true);
                Profile sProfile = prIdentity.getProfile();
                JSONObject json = new JSONObject();
                json.put("projectName", space.getPrettyName());
                json.put("projectDisplayName", space.getDisplayName());
                json.put("projectDescription", space.getDescription());
                json.put("projectLocation", sProfile.getProperty("city") + ", " + sProfile.getProperty("state"));
                json.put("projectBidDue", sProfile.getProperty("bidsDueDate"));
                json.put("projectPreBidMeeting", sProfile.getProperty("preBidMeetingDate"));
                jsonArray.put(json);
            }
            jsonGlobal.put("totalNbOfMySpaces", totalNumber);
            jsonGlobal.put("mySpaces", jsonArray);
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method return the list of subs by status in a project
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/getsubsbystatus/{projectId}/{status}
     * Status can be: "NOT_MESS", "INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "SUBMITTED",
     *
     * @return - list of Subs by Status
     */

    @GET
    @Path("getsubsbystatus/{projectId}/{status}")
    public Response getSubsbyStatus(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam("projectId") String projectId, @PathParam("status") String status,
                                    @QueryParam("isinvitedtable") boolean isinvitedtable,
                                    @QueryParam("isvendor") boolean isvendor,
                                    @QueryParam("filteredgroups") String filteredgroups,
                                    @QueryParam("filteredclassif") String filteredclassifications,
                                    @QueryParam("searchkey") String SearchKey,
                                    @QueryParam("isreport") Boolean isreport,
                                    @QueryParam("limit") int limit,
                                    @QueryParam("offset") int offset) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);


        try {
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = (request.getParameter("iSortCol_0") == null) ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = (request.getParameter("sSortDir_0") == null) ? "" : request.getParameter("sSortDir_0");
            String sortBy;

            if (isinvitedtable) {
                switch (iSortCol) {
                    case 1:
                        sortBy = "tbb:relCompany";
                        break;
                    case 2:
                        sortBy = "tbb:subName";
                        break;
                    case 3:
                        sortBy = "tbb:catCsiDesc";
                        break;
                    case 4:
                        sortBy = "tbb:status";
                        break;
                    case 5:
                        sortBy = "tbb:note";
                        break;
                    case 6:
                        sortBy = "tbb:bid";
                        break;
                    default:
                        sortBy = "";
                        break;
                }
            } else {
                switch (iSortCol) {
                    case 0:
                        sortBy = "tbb:subId";
                        break;
                    case 1:
                        sortBy = "tbb:relCompany";
                        break;
                    case 2:
                        sortBy = "tbb:subName";
                        break;
                    case 3:
                        sortBy = "tbb:catCsiDesc";
                        break;
                    case 4:
                        sortBy = "tbb:relPhone";
                        break;
                    case 5:
                        sortBy = "tbb:relCity";
                        break;
                    case 6:
                        sortBy = "tbb:relState";
                        break;
                    case 7:
                        sortBy = "tbb:relCounty";
                        break;
                    case 8:
                        sortBy = "tbb:relRank";
                        break;
                    default:
                        sortBy = "";
                        break;
                }
            }
            filteredclassifications = (filteredclassifications == null || filteredclassifications.equals("undefined")) ? "" : filteredclassifications;

            SearchKey = (SearchKey == null || SearchKey.equals("undefined")) ? (request.getParameter("sSearch") == null) ? "" : request.getParameter("sSearch") : SearchKey;

            List<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add((request.getParameter("sSearch_1") == null) ? "" : request.getParameter("sSearch_1"));
            SearchConditions.add((request.getParameter("sSearch_2") == null) ? "" : request.getParameter("sSearch_2"));
            SearchConditions.add((request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("")) ? filteredclassifications : request.getParameter("sSearch_3"));
            SearchConditions.add((status == null) ? "" : status);
            SearchConditions.add((request.getParameter("sSearch_4") == null) ? "" : request.getParameter("sSearch_4"));
            SearchConditions.add((request.getParameter("sSearch_5") == null) ? "" : request.getParameter("sSearch_5"));
            SearchConditions.add((request.getParameter("sSearch_6") == null) ? "" : request.getParameter("sSearch_6"));
            SearchConditions.add((request.getParameter("sSearch_7") == null) ? "" : request.getParameter("sSearch_7"));
            SearchConditions.add((request.getParameter("sSearch_9") == null) ? "" : request.getParameter("sSearch_9"));
            SearchConditions.add((request.getParameter("sSearch_10") == null) ? "" : request.getParameter("sSearch_10"));

            List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            if (filteredgroups != null && filteredgroups.compareTo("") != 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                String[] filteredarraygroups = filteredgroups.split("\\,");

                for (String filteredgroup : filteredarraygroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                        if (relationShip != null)
                            included.add(relationShip);
                    }
                }
                if (included.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok(jsonGlobal.toString(), mediaType).build();
                }
            }

            ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(isinvitedtable, isvendor, false, SearchKey, SearchConditions, included, sortBy, sortDir, projectId);
            int displaylength = (request.getParameter("iDisplayLength") == null) ? relList.getSize() : Integer.parseInt(request.getParameter("iDisplayLength"));

            if (isreport != null && isreport) {
                String[] categoriesinproject = filteredclassifications.split(",");
                int total = 0;
                for (String categoryId : categoriesinproject) {
                    List<ProjectSubEntity> relcatList = projectSubRelationShipStorage.getRelationShipByProjectIdAndCatId(projectId, categoryId, displaystart, displaylength);
                    JSONArray jsoncategories = new JSONArray();
                    for (ProjectSubEntity sub : relcatList) {
                        if (sub.getStatus().equals("NOT_MESS")) {
                            total++;
                            JSONObject json = new JSONObject();
                            json.put("company", sub.getSubContractor().getCompany());
                            json.put("rank", sub.getSubContractor().getRank());
                            json.put("phone", sub.getSubContractor().getPhone());
                            json.put("faxnumber", "");
                            json.put("notes", sub.getNote());
                            json.put("bid", ((sub.getBid() != null) ? sub.getBid() : ""));
                            json.put("contact", sub.getSubContractor().getDisplayName());
                            json.put("categories", sub.getCategory().getId()+"-"+sub.getCategory().getCatCsiDesc());
                            json.put("status", sub.getStatus());
                            json.put("union", sub.getSubContractor().getUnion());
                            json.put("nonUnion", sub.getSubContractor().getNonUnion());
                            if (json.get("categories").toString().contains("(DBE,WBE)"))
                                json.put("cat_minority", true);
                            else
                                json.put("cat_minority", false);
                            jsoncategories.put(json);
                        }
                    }
                    if (!jsoncategories.isNull(0))
                        jsonArray.put(jsoncategories);
                }
            } else {
                for (ProjectSubEntity sub : relList.load(displaystart, displaylength)) {
                    SubCatEntity subCat = subCatStorage.getSubCat(sub.getSubContractor().getId() + "_" + sub.getCategory().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", sub.getSubContractor().getId());
                    json.put("categories", sub.getCategory().getId()+"-"+sub.getCategory().getCatCsiDesc());
                    json.put("relName", sub.getId());
                    json.put("company", sub.getSubContractor().getCompany());
                    json.put("weburl", subCat.getSubContractor().getWeburl());
                    json.put("proview", subCat.getSubContractor().getProview());
                    json.put("union", subCat.getSubContractor().getUnion());
                    json.put("nonUnion", subCat.getSubContractor().getNonUnion());
                    json.put("phone", sub.getSubContractor().getPhone());
                    json.put("contact", sub.getSubContractor().getDisplayName());
                    json.put("subCatId", sub.getSubContractor().getId()  + "_" + sub.getCategory().getId());
                    json.put("notes", sub.getNote());
                    json.put("bid", ((sub.getBid() != null && !sub.getBid().equals("0")) ? sub.getBid() : ""));
                    json.put("city", sub.getSubContractor().getCity());
                    json.put("state", sub.getSubContractor().getState());
                    json.put("county", (sub.getSubContractor().getCountry() != null) ? sub.getSubContractor().getCountry() : "");
                    json.put("rank", sub.getSubContractor().getRank());
                    json.put("categoryId", sub.getCategory().getId());
                    json.put("status", sub.getStatus());
                    json.put("selected", "true");

                    json.put("bbgroups", "");
                    Boolean isgcmember = (orgService.getMembershipHandler().findMembershipByUserGroupAndType(sourceIdentity.getRemoteId(), "/organization/gcs", "gcmember") != null) ? true : false;
                    json.put("isgcmember", isgcmember);
                    jsonArray.put(json);
                }
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", relList.getSize());
            jsonGlobal.put("iTotalDisplayRecords", relList.getSize());
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method return the list of subs by status in a project
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/getsubsbystatus/{projectId}/{status}
     * Status can be: "NOT_MESS", "INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "SUBMITTED",
     *
     * @return - list of Subs by Status
     */

    @GET
    @Path("getallinvitedsubs/{projectId}")
    public Response getAllInvitedSubs(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam("projectId") String projectId,
                                      @QueryParam("isvendor") boolean isvendor,
                                      @QueryParam("filteredgroups") String filteredgroups,
                                      @QueryParam("filteredclassif") String filteredclassifications,
                                      @QueryParam("searchkey") String SearchKey,
                                      @QueryParam("isreport") Boolean isreport,
                                      @QueryParam("limit") int limit,
                                      @QueryParam("offset") int offset) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = (request.getParameter("iSortCol_0") == null) ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = (request.getParameter("sSortDir_0") == null) ? "" : request.getParameter("sSortDir_0");
            String sortBy;

            switch (iSortCol) {
                case 1:
                    sortBy = "tbb:relCompany";
                    break;
                case 2:
                    sortBy = "tbb:subName";
                    break;
                case 3:
                    sortBy = "tbb:catCsiDesc";
                    break;
                case 4:
                    sortBy = "tbb:status";
                    break;
                case 5:
                    sortBy = "tbb:note";
                    break;
                case 6:
                    sortBy = "tbb:bid";
                    break;
                default:
                    sortBy = "";
                    break;
            }

            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            filteredclassifications = (filteredclassifications == null || filteredclassifications.equals("undefined")) ? "" : filteredclassifications;
            SearchKey = (SearchKey == null || SearchKey.equals("undefined")) ? (request.getParameter("sSearch") == null) ? "" : request.getParameter("sSearch") : SearchKey;
            List<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add((request.getParameter("sSearch_1") == null) ? "" : request.getParameter("sSearch_1"));
            SearchConditions.add((request.getParameter("sSearch_2") == null) ? "" : request.getParameter("sSearch_2"));
            SearchConditions.add((request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("")) ? filteredclassifications : request.getParameter("sSearch_3"));
            SearchConditions.add((request.getParameter("sSearch_4") == null) ? "" : request.getParameter("sSearch_4"));
            SearchConditions.add((request.getParameter("sSearch_5") == null) ? "" : request.getParameter("sSearch_5"));
            SearchConditions.add((request.getParameter("sSearch_6") == null) ? "" : request.getParameter("sSearch_6"));
            SearchConditions.add("");
            SearchConditions.add("");
            SearchConditions.add((request.getParameter("sSearch_7") == null) ? "" : request.getParameter("sSearch_7"));
            SearchConditions.add((request.getParameter("sSearch_8") == null) ? "" : request.getParameter("sSearch_8"));
            List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            if (filteredgroups != null && filteredgroups.compareTo("") != 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                String[] filteredarraygroups = filteredgroups.split("\\,");

                for (String filteredgroup : filteredarraygroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShiptoinclude = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                        // Prevent 500 error Have to check if the relation exist before adding it
                        if (relationShiptoinclude != null)
                            included.add(relationShiptoinclude);
                    }
                }
                if (included.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok(jsonGlobal.toString(), mediaType).build();
                }
            }
            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = (request.getParameter("iDisplayLength") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayLength"));
            int total = 0;
            if (isreport == null || !isreport) {
                ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(true, isvendor, true, SearchKey, SearchConditions, included, sortBy, sortDir, projectId);
                total = relList.getSize();
                for (ProjectSubEntity sub : relList.load(displaystart, displaylength)) {
                    SubCatEntity subCat = subCatStorage.getSubCat(sub.getSubContractor().getId() + "_" + sub.getCategory().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", sub.getSubContractor().getId());
                    json.put("company", sub.getSubContractor().getCompany());
                    json.put("weburl", subCat.getSubContractor().getWeburl());
                    json.put("proview", subCat.getSubContractor().getProview());
                    json.put("union", subCat.getSubContractor().getUnion());
                    json.put("nonUnion", subCat.getSubContractor().getNonUnion());
                    json.put("refUID", "");
                    json.put("rank", sub.getSubContractor().getRank());
                    json.put("email", "");
                    json.put("phone", sub.getSubContractor().getPhone());
                    json.put("faxnumber", "");
                    json.put("itbsent", "");
                    json.put("notes", sub.getNote());
                    json.put("bid", ((sub.getBid() != null && !sub.getBid().equals("0")) ? sub.getBid() : ""));
                    json.put("contact", sub.getSubContractor().getDisplayName());
                    json.put("categories", sub.getCategory().getId()+"-"+sub.getCategory().getCatCsiDesc());
                    json.put("categoryId", sub.getCategory().getId());
                    json.put("relName", sub.getId());
                    json.put("status", sub.getStatus());
                    json.put("union", sub.getSubContractor().getUnion());
                    json.put("nonUnion", sub.getSubContractor().getNonUnion());
                    json.put("bidScoped", (sub.getBidScoped() != null) ? sub.getBidScoped() : "no");
                    json.put("selected", "true");
                    json.put("bbgroups", "");
                    if (json.get("categories").toString().contains("(DBE,WBE)"))
                        json.put("cat_minority", true);
                    else
                        json.put("cat_minority", false);
                    jsonArray.put(json);
                }
            } else {
                String[] categoriesinproject = filteredclassifications.split(",");
                for (String categoryId : categoriesinproject) {
                    List<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndCatId(projectId, categoryId, displaystart, displaylength);
                    JSONArray jsoncategories = new JSONArray();
                    for (ProjectSubEntity sub : relList) {
                        if (!sub.getStatus().equals("NOT_MESS")) {
                            total++;
                            JSONObject json = new JSONObject();
                            json.put("company",sub.getSubContractor().getCompany());
                            json.put("rank", sub.getSubContractor().getRank());
                            json.put("phone", sub.getSubContractor().getPhone());
                            json.put("faxnumber", "");
                            json.put("notes", sub.getNote());
                            json.put("bid", ((sub.getBid() != null) ? sub.getBid() : ""));
                            json.put("contact", sub.getSubContractor().getDisplayName());
                            json.put("categories", sub.getCategory().getCatCsiDesc());
                            json.put("status", sub.getStatus());
                            if (json.get("categories").toString().contains("(DBE,WBE)"))
                                json.put("cat_minority", true);
                            else
                                json.put("cat_minority", false);
                            jsoncategories.put(json);
                        }
                    }
                    jsonArray.put(jsoncategories);
                }
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", total);
            jsonGlobal.put("iTotalDisplayRecords", total);
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }



    @POST
    @Path("getinvitedsubsforreport/{projectId}")
    public Response getInvitedSubsForReport(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam("projectId") String projectId,
                                            @QueryParam("filteredclassif") String filteredclassifications,
                                            @QueryParam("notinvited") boolean notinvited,
                                            BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);

            boolean filtred=false;
            int total = 0;
            try {

                List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();

                List<String> filteredgroups = searchRequest.getFilteredGroups();
                if (filteredgroups != null && filteredgroups.size() > 0) {
                    SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                    for (String filteredgroup : filteredgroups) {
                        List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                        for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                            ProjectSubEntity relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                if (included.contains(relationShip.getId())) {
                                    continue;
                                } else {
                                    included.add(relationShip);
                                }


                            } catch (Exception e) {
                                LOG.error(e.getMessage(), e);
                            }
                        }
                    }
                }
                if (!(searchRequest.getsSearch_3() == null || searchRequest.getsSearch_3().equals(""))) {

                    filteredclassifications = searchRequest.getsSearch_3();
                    filtred = true;
                }
                String[] categoriesinproject;
                if (filtred) {
                    categoriesinproject = filteredclassifications.split("\\|");
                } else {
                    categoriesinproject = filteredclassifications.split(",");

                }
                if(notinvited==true){
                for (String categoryId : categoriesinproject) {
                    if (!filtred) categoryId = bBCategoryStorage.getBBCategory(categoryId).getCatCsiDesc();
                    List<String> SearchConditions = new ArrayList<String>();
                    SearchConditions.add(searchRequest.getsSearch_1());
                    SearchConditions.add(searchRequest.getsSearch_2());
                    SearchConditions.add(categoryId);
                    SearchConditions.add("NOT_MESS");
                    SearchConditions.add(searchRequest.getsSearch_5());
                    SearchConditions.add(searchRequest.getsSearch_6());
                    SearchConditions.add(searchRequest.getsSearch_7());
                    SearchConditions.add(searchRequest.getsSearch_9());
                    SearchConditions.add(searchRequest.getsSearch_10());
                    SearchConditions.add(searchRequest.getSearchsubs());


                    ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, false, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
                    JSONArray jsoncategories = new JSONArray();
                    if (relList.getSize() > 0) {
                        for (ProjectSubEntity sub : relList.load(0, relList.getSize())) {
                                total++;
                                JSONObject json = new JSONObject();
                                json.put("company", sub.getSubContractor().getCompany());
                                json.put("rank", sub.getSubContractor().getRank());
                                json.put("phone", sub.getSubContractor().getPhone());
                                json.put("faxnumber", "");
                                json.put("notes", sub.getNote());
                                json.put("bid", ((sub.getBid() != null) ? sub.getBid() : ""));
                                json.put("contact", sub.getSubContractor().getDisplayName());
                                json.put("categories", sub.getCategory().getCatCsiDesc());
                                json.put("status", sub.getStatus());
                                json.put("city", sub.getSubContractor().getCity());
                                if (json.get("categories").toString().contains("(DBE,WBE)"))
                                    json.put("cat_minority", true);
                                else
                                    json.put("cat_minority", false);
                                jsoncategories.put(json);

                        }
                    }
                    jsonArray.put(jsoncategories);
                }
            }else{
                    for (String categoryId : categoriesinproject) {
                        if (!filtred) categoryId = bBCategoryStorage.getBBCategory(categoryId).getCatCsiDesc();
                        List<String> SearchConditions = new ArrayList<String>();
                        SearchConditions.add(searchRequest.getsSearch_1());
                        SearchConditions.add(searchRequest.getsSearch_2());
                        SearchConditions.add(categoryId);
                        SearchConditions.add(searchRequest.getsSearch_4());
                        SearchConditions.add(searchRequest.getsSearch_5());
                        SearchConditions.add(searchRequest.getsSearch_6());
                        SearchConditions.add(searchRequest.getsSearch_7());
                        SearchConditions.add(searchRequest.getsSearch_9());
                        SearchConditions.add(searchRequest.getsSearch_10());
                        SearchConditions.add(searchRequest.getSearchsubs());


                        ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, true, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
                        JSONArray jsoncategories = new JSONArray();
                        if (relList.getSize() > 0) {
                            for (ProjectSubEntity sub : relList.load(0, relList.getSize())) {
                                if (!sub.getStatus().equals("NOT_MESS")) {
                                    total++;
                                    JSONObject json = new JSONObject();
                                    json.put("company", sub.getSubContractor().getCompany());
                                    json.put("rank",  sub.getSubContractor().getRank());
                                    json.put("phone", sub.getSubContractor().getPhone());
                                    json.put("faxnumber", "");
                                    json.put("notes", sub.getNote());
                                    json.put("bid", ((sub.getBid() != null) ? sub.getBid() : ""));
                                    json.put("contact",sub.getSubContractor().getDisplayName());
                                    json.put("categories", sub.getCategory().getCatCsiDesc());
                                    json.put("status", sub.getStatus());
                                    json.put("city", sub.getSubContractor().getCity());
                                    if (json.get("categories").toString().contains("(DBE,WBE)"))
                                        json.put("cat_minority", true);
                                    else
                                        json.put("cat_minority", false);
                                    jsoncategories.put(json);
                                }
                            }
                        }
                        jsonArray.put(jsoncategories);
                    }
                }

            } catch (Exception e) {
                LOG.error("Error ", e.getMessage());
            }



            jsonGlobal.put("iTotalRecords", total);
            jsonGlobal.put("iTotalDisplayRecords", total);
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }



    /**
     * This method is used to get the list of subs by project Id from one instance to demo connection
     * <p/>
     * eg: request: http://localhost:8080/rest/private/bbprojectservice/getbbsubs/{projectId}?status={status}
     *
     * @param request
     * @param response
     * @param projectId
     * @param status
     * @return
     * @throws Exception
     */

    @GET
    @Path("getbbsubs/{projectId}")
    public Response getBbSubs(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam("projectId") String projectId,
                              @QueryParam("status") String status) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            //Get the Space by its Pretty Name
            Space project_ = spaceService.getSpaceByPrettyName(projectId);
            if (project_ == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            Identity prIdentity = identityManager.getOrCreateIdentity(SpaceIdentityProvider.NAME, project_.getPrettyName(), true);
            Profile sProfile = prIdentity.getProfile();

            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);

            if ((status != null && !status.equals("") && !status.equals("undefined"))) {
                if (status.equals("notmess")) {
                    status = "NOT_MESS";

                } else if (status.equals("invited")) {
                    status = "INVITED";

                } else if (status.equals("rev")) {
                    status = "REVIEWING";

                } else if (status.equals("bid")) {
                    status = "BIDDING";

                } else if (status.equals("nbid")) {
                    status = "NOT_BIDDING";

                } else if (status.equals("submit")) {
                    status = "AWARDED";

                } else {
                    LOG.info("Unknown Status");
                    return Response.status(Response.Status.BAD_REQUEST).entity("Unknown Status").build();
                }
                ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndStatusListAccess(projectId, status);
                JSONObject jsonGlobal = new JSONObject();
                JSONArray jsonArray = new JSONArray();
                for (ProjectSubEntity sub : relList.load(0, relList.getSize())) {
                    SubContractorEntity subinfo = subUserInfoStorage.getSubUserInfo(sub.getSubContractor().getId());
                    JSONObject json = new JSONObject();
                    json.put("userName", sub.getSubContractor().getId());
                    if (subinfo.getCompany() == null) json.put("company", "");
                    else json.put("company", subinfo.getCompany());
                    if (subinfo.getRefUID() == null) json.put("refUID", "");
                    else json.put("refUID", subinfo.getRefUID());
                    if (subinfo.getDisplayName() == null) json.put("contact", "");
                    else json.put("contact", subinfo.getDisplayName());
                    json.put("categories", sub.getCategory().getId());
                    json.put("email", subinfo.getEmail());
                    if (!status.equals("NOT_MESS")) {
                        json.put("accessUrl", URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + sub.getSubContractor().getId() + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings"));
                    }
                    if (subinfo.getRank() == null) json.put("rank", 8);
                    else json.put("rank", subinfo.getRank());
                    if (sProfile.getProperty("url") == null) json.put("projectUrl", "");
                    else json.put("projectUrl", sProfile.getProperty("url"));

                    jsonArray.put(json);
                }
                jsonGlobal.put(status, jsonArray);
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "no-store");
                return Response.ok(jsonGlobal.toString(), mediaType).build();

            } else {
                String[] status_ = new String[]{"NOT_MESS", "INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "AWARDED"};
                JSONObject jsonGlobal = new JSONObject();
                JSONObject jsonByStat = new JSONObject();

                for (String st : status_) {

                    ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndStatusListAccess(projectId, st);
                    JSONArray jsonArray = new JSONArray();
                    for (ProjectSubEntity sub : relList.load(0, relList.getSize())) {
                        SubContractorEntity subinfo = subUserInfoStorage.getSubUserInfo(sub.getSubContractor().getId());
                        JSONObject json = new JSONObject();
                        json.put("userName", sub.getSubContractor().getId());
                        if (subinfo.getCompany() == null) json.put("company", "");
                        else json.put("company", subinfo.getCompany());
                        if (subinfo.getRefUID() == null) json.put("refUID", "");
                        else json.put("refUID", subinfo.getRefUID());
                        if (subinfo.getDisplayName() == null) json.put("contact", "");
                        else json.put("contact", subinfo.getDisplayName());
                        if (subinfo.getFirstName() == null) json.put("firstname", "");
                        else json.put("firstname", subinfo.getFirstName());
                        if (subinfo.getLastName() == null) json.put("lastname", "");
                        else json.put("lastname", subinfo.getLastName());
                        if (subinfo.getPhone() == null) json.put("phone", "");
                        else json.put("phone", subinfo.getPhone());
                        if (subinfo.getStreet() == null) json.put("address", "");
                        else if (subinfo.getAddress2() == null || subinfo.getAddress2().equals(""))
                            json.put("address", subinfo.getStreet());
                        else json.put("address", subinfo.getStreet() + " ; " + subinfo.getAddress2());
                        if (subinfo.getCity() == null) json.put("city", "");
                        else json.put("city", subinfo.getCity());
                        if (subinfo.getState() == null) json.put("state", "");
                        else json.put("state", subinfo.getState());
                        if (subinfo.getZip() == null) json.put("zip", "");
                        else json.put("zip", subinfo.getZip());
                        json.put("categories", sub.getCategory().getId());
                        json.put("bidScoped", sub.getBidScoped());
                        json.put("email", subinfo.getEmail());
                        if (!st.equals("NOT_MESS")) {
                            json.put("accessUrl", URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + sub.getSubContractor().getId() + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings"));
                        }
                        if (subinfo.getRank() == null) json.put("rank", 8);
                        else json.put("rank", subinfo.getRank());
                        if (sProfile.getProperty("url") == null) json.put("projectUrl", "");
                        else json.put("projectUrl", sProfile.getProperty("url"));
                        jsonArray.put(json);
                    }
                    jsonByStat.put(st, jsonArray);

                }
                jsonGlobal.put("vendors", jsonByStat);
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "no-store");
                return Response.ok(jsonGlobal.toString(), mediaType).build();
            }


        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("setbidscop/{projectId}/{bidscop}")
    public Response setBidscop(@Context HttpServletRequest request, @PathParam("projectId") String projectId, @PathParam("bidscop") String bidscop) {
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        if (!(bidscop.equals("true") || bidscop.equals("false"))) {
            return Response.status(Response.Status.NOT_ACCEPTABLE).entity("Bid Scope should be true or false").build();
        }
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, projectId, true);
            Profile sProfile = prIdentity.getProfile();
            sProfile.setProperty("bidScop", bidscop);
            Util.getIdentityManager(portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
            LOG.info("Project bidScop has been Updated successfully");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Project bidScop Updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method set the sub status in a project
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/setsubstatus/{projectId}/{status}
     * Status can be: "NOT_MESS", "INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "SUBMITTED",
     *
     * @return - list of Subs by Status
     */
    @POST
    @Path("setsubstatus/{projectId}/{status}/{catId}")
    public Response setsubstatus(@Context HttpServletRequest request, @PathParam("projectId") String projectId, @PathParam("status") String status, @PathParam("catId") String catId, @QueryParam("subId") String subId, @QueryParam("notes") String notes, @QueryParam("bid") String bid) {
        Identity userIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (userIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        if (bid != null && !isNumeric(bid)) {
            return Response.status(Response.Status.NOT_ACCEPTABLE).entity("Bid Ammount should be a number").build();
        }
        if (subId == null) {
            subId = userIdentity.getRemoteId();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            if (status.equals("null"))
                status = projectSubRelationShipStorage.getRelationShip(subId, projectId, catId).getStatus();
            //if(bid == null) bid = "0";
            projectSubRelationShipStorage.updateProjectSubRelationShip(subId + "_" + projectId + "_" + catId, null, status, notes, bid, null, null);
/*            if (!status.equals("null")) {
                updateBidScopStatus(userIdentity.getRemoteId(), projectId, subId, status);
            }*/
            LOG.info("Sub Field has been updated successfully");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Field Updated Successfully");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    /**
     * This method set the sub status in a project
     * <p/>
     * eg: request: http://{domain_name}/{rest_context_name}/setsubstatus/{projectId}/{status}
     * Status can be: "NOT_MESS", "INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "SUBMITTED",
     *
     * @return - list of Subs by Status
     */
    @GET
    @Path("emailsetsubstatus/{projectId}/{catId}/{subId}/{status}")
    public Response emailSetsubstatus(@Context HttpServletRequest request,
                                      @PathParam("projectId") String projectId,
                                      @PathParam("status") String status,
                                      @PathParam("catId") String catId,
                                      @PathParam("subId") String subId) {


        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {
            projectSubRelationShipStorage.updateProjectSubRelationShip(subId + "_" + projectId + "_" + catId, null, status, null, null, null, null);
            //updateBidScopStatus(subId, projectId, subId, status);
            LOG.info("Sub status has been updated successfully");
            return Response.seeOther(URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + subId + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings")).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @GET
    @Path("bidscopesubstatus/{projectId}/{subId}/{status}")
    public Response bidScopeSubStatus(@Context HttpServletRequest request,
                                      @PathParam("projectId") String projectId,
                                      @PathParam("status") String status,
                                      @PathParam("subId") String subId) {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        try {

            ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSubIdListAccess(projectId, subId);

            if (status.equals("UNDECIDED")) status="REVIEWING";
            if (!(status.equals("BIDDING")||status.equals("NOT_BIDDING")||status.equals("REVIEWING")))   return Response.status(Response.Status.BAD_REQUEST).entity("Wrong Status").build();

        if(relList.getSize()>0)
            {
                for(ProjectSubEntity projectSubRelationShip:relList.load(0,relList.getSize()))
                {
                    projectSubRelationShipStorage.updateProjectSubRelationShip(subId + "_" + projectId + "_" + projectSubRelationShip.getCategory().getId(), null, status, null, null, null, null);

                }
                LOG.info("Sub status has been updated successfully");
                return Response.seeOther(URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + subId + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings")).build();
            }else     return Response.status(Response.Status.NOT_FOUND).entity("No Trades Founds for this Sub in this project").build();


        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("getusersreports/{projectId}")
    public Response getUsersReports(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam("projectId") String projectId,
                                    @QueryParam("categoriesId") String categoriesId,
                                    BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {

            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            boolean filtred=false;
            int total = 0;

                List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();

                List<String> filteredgroups = searchRequest.getFilteredGroups();
                if (filteredgroups != null && filteredgroups.size() > 0) {
                    SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                    for (String filteredgroup : filteredgroups) {
                        List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                        for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                            ProjectSubEntity relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                if (included.contains(relationShip.getId())) {
                                    continue;
                                } else {
                                    included.add(relationShip);
                                }


                            } catch (Exception e) {
                                LOG.error(e.getMessage(), e);
                            }
                        }
                    }
                }
                if (!(searchRequest.getsSearch_3() == null || searchRequest.getsSearch_3().equals(""))) {

                    categoriesId = searchRequest.getsSearch_3();
                    filtred = true;
                }
                String[] categoriesinproject;
                if (filtred) {
                    categoriesinproject = categoriesId.split("\\|");
                } else {
                    categoriesinproject = categoriesId.split(",");

                }

            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = (request.getParameter("iDisplayLength") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayLength"));
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            Session socialSession = manageableRepository.getSystemSession(SOCIAL_WORKSPACE);
            Node socialProductionNode = (Node) socialSession.getItem("/production");
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            if (socialProductionNode.hasNode("reporting")) {
                Node reportingNode = socialProductionNode.getNode("reporting");
                if (reportingNode.hasNode(projectId)) {
                    Node projectReportingNode = reportingNode.getNode(projectId);
                    for (String categoryId : categoriesinproject) {
                        if (!filtred) categoryId = bBCategoryStorage.getBBCategory(categoryId).getCatCsiDesc();
                        List<String> SearchConditions = new ArrayList<String>();
                        SearchConditions.add(searchRequest.getsSearch_1());
                        SearchConditions.add(searchRequest.getsSearch_2());
                        SearchConditions.add(categoryId);
                        SearchConditions.add(searchRequest.getsSearch_4());
                        SearchConditions.add(searchRequest.getsSearch_5());
                        SearchConditions.add(searchRequest.getsSearch_6());
                        SearchConditions.add(searchRequest.getsSearch_7());
                        SearchConditions.add(searchRequest.getsSearch_9());
                        SearchConditions.add(searchRequest.getsSearch_10());
                        SearchConditions.add(searchRequest.getSearchsubs());
                        ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, true, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);
                        JSONArray jsoncategories = new JSONArray();
                        for (ProjectSubEntity sub : relList.load(0,relList.getSize())) {
                         //   if (sub.getStatus().equals("NOT_MESS"))
                          //      continue;
                            JSONObject json = new JSONObject();
                            JSONArray docsJsonArray = new JSONArray();
                            json.put("category", sub.getCategory().getCatCsiDesc());
                            Identity subIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, sub.getSubContractor().getId(), true);
                            String subIndentityRemoteId = subIdentity.getRemoteId();
                            if (projectReportingNode.hasNode(subIndentityRemoteId)) {
                                Node userReportingNode = projectReportingNode.getNode(subIndentityRemoteId);
                                json.put("totalVisits", userReportingNode.hasProperty(TOTAL_VISITS) ? userReportingNode.getProperty(TOTAL_VISITS).getString() : "0");
                                json.put("lastVisit", userReportingNode.hasProperty(LAST_VISIT) ? userReportingNode.getProperty(LAST_VISIT).getString() : "");
                                NodeIterator nodeIterator = userReportingNode.getNodes();
                                while (nodeIterator.hasNext()) {
                                    Node docReportingNode = nodeIterator.nextNode();
                                    JSONObject docJson = new JSONObject();
                                    Session collaborationSession = manageableRepository.getSystemSession(COLLABORATION_WORKSPACE);
                                    Node docNode = collaborationSession.getNodeByUUID(docReportingNode.getName());
                                    docJson.put("documentTitle", docNode.getName());
                                    docJson.put("documentParentPath", docNode.getParent().getPath());
                                    docJson.put("totalViews", docReportingNode.hasProperty(TOTAL_VIEWS) ? docReportingNode.getProperty(TOTAL_VIEWS).getString() : "0");
                                    docJson.put("totalDownloads", docReportingNode.hasProperty(TOTAL_DOWNLOADS) ? docReportingNode.getProperty(TOTAL_DOWNLOADS).getString() : "0");
                                    docsJsonArray.put(docJson);
                                }
                            } else {
                                json.put("totalVisits", "0");
                                json.put("lastVisit", "");
                            }
                            json.put("company", sub.getSubContractor().getCompany());
                            json.put("vendor", sub.getSubContractor().getDisplayName());
                            json.put("docs", docsJsonArray);
                            jsoncategories.put(json);
                        }
                        jsonArray.put(jsoncategories);
                    }
                }
            }
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getcategories")
    public Response getCategories(@Context HttpServletRequest request, @Context HttpServletResponse response, @QueryParam("projectId") String projectId, @QueryParam("notmessaged") Boolean notmessaged) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            List<String> catList = new ArrayList<String>();
            //JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            if (projectId != null) {
                ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
                List<ProjectSubEntity> relList = null;
                if (notmessaged != null && notmessaged) {
                    relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndStatus(projectId, "NOT_MESS", 0, 0);
                    for (ProjectSubEntity sub : relList) {
                        if (!catList.contains(sub.getCategory().getId())) catList.add(sub.getCategory().getId());
                    }
                } else {
                    relList = projectSubRelationShipStorage.getRelationShipByProjectId(projectId, 0, 0);
                    for (ProjectSubEntity sub : relList) {
                        if (!catList.contains(sub.getCategory().getId()) && !sub.getStatus().equals("NOT_MESS"))
                            catList.add(sub.getCategory().getId());
                    }
                }
                for (ProjectSubEntity sub : relList) {
                    if (!catList.contains(sub.getCategory().getId()) && !sub.getStatus().equals("NOT_MESS"))
                        catList.add(sub.getCategory().getId());
                }
                for (String cat : catList) {
                    if (bBCategoryStorage.getBBCategory(cat) != null) {
                        JSONObject json = new JSONObject();
                        json.put("CategoryId", cat);
                        json.put("Category", bBCategoryStorage.getBBCategory(cat).getCatCsiDesc());
                        jsonArray.put(json);
                    } else {
                        LOG.error("Can not get Category with ID: " + cat);
                    }
                }
            } else {
                for (CategoryEntity bbcat : bBCategoryStorage.getBBCategories(0, 0)) {
                    JSONObject json = new JSONObject();
                    json.put("CategoryId", bbcat.getFieldName());
                    json.put("Category", bbcat.getCatCsiDesc());
                    jsonArray.put(json);
                }
            }

            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonArray.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path(">/{projectId}")
    public Response getCategoriesStats(@Context HttpServletRequest request, @Context HttpServletResponse response,
                                       @PathParam("projectId") String projectId,
                                       @QueryParam("notinvited") boolean notinvited,
                                       BbFilteredSearchRequest searchRequest
                                       ) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {

            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();

            List<String> filteredgroups = searchRequest.getFilteredGroups();
            if (filteredgroups != null && filteredgroups.size() > 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                for (String filteredgroup : filteredgroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        ProjectSubEntity relationShip = null;
                        try {
                            relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                            if (included.
                                    contains(relationShip.getId())) {
                                continue;
                            } else {
                                included.add(relationShip);
                            }


                        } catch (Exception e) {
                            LOG.error(e.getMessage(), e);
                        }
                    }
                }
            }

            ListAccess<ProjectSubEntity> relList = null;

                List<String> SearchConditions = new ArrayList<String>();
                SearchConditions.add(searchRequest.getsSearch_1());
                SearchConditions.add(searchRequest.getsSearch_2());
                SearchConditions.add(searchRequest.getsSearch_3());
                SearchConditions.add(searchRequest.getsSearch_4());
                SearchConditions.add(searchRequest.getsSearch_5());
                SearchConditions.add(searchRequest.getsSearch_6());
                SearchConditions.add(searchRequest.getsSearch_7());
                SearchConditions.add(searchRequest.getsSearch_9());
                SearchConditions.add(searchRequest.getsSearch_10());
                SearchConditions.add(searchRequest.getSearchsubs());
                relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, !notinvited, searchRequest.getSearchsubs(), SearchConditions, included, "tbb:subId", "asc", projectId);

            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = (request.getParameter("iDisplayLength") == null) ? relList.getSize() : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            List<String> catList = new ArrayList<String>();
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (ProjectSubEntity sub : relList.load(displaystart, displaylength)) {
                if (!notinvited) {
                    if (sub.getStatus().equals("NOT_MESS")) {
                        continue;
                    }
                }
                if (!catList.contains(sub.getCategory().getId())) catList.add(sub.getCategory().getId());
            }
            List<String> status = null;
            if (notinvited)
                status = Arrays.asList("NOT_MESS");
            else
                status = Arrays.asList("INVITED", "REVIEWING", "UNDECIDED", "BIDDING", "NOT_BIDDING", "AWARDED");
            for (String cat : catList) {
                if (bBCategoryStorage.getBBCategory(cat) == null) {
                    LOG.warn("Can not find the category with this ID: " + cat);
                    continue;
                }
                JSONObject json = new JSONObject();
                for (String status_ : status) {
                    //    json.put("Category",bBCategoryStorage.getBBCategory(cat).getCsiDesc());
                    json.put("Category", bBCategoryStorage.getBBCategory(cat).getCatCsiDesc());
                    json.put(status_, projectSubRelationShipStorage.getRelationShipsCountbyProjectIdCatIdAndstatus(projectId, cat, status_));
                }

                jsonArray.put(json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", catList.size());
            jsonGlobal.put("iTotalDisplayRecords", catList.size());
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getmessinfo/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getMessInfo(@Context HttpServletRequest request, @Context UriInfo uriInfo,
                                @PathParam("projectId") String projectId) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null||!isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        String status = "";
        CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }


            JSONObject jsGlobal = new JSONObject();
            JSONObject sender = new JSONObject();
            JSONObject company = new JSONObject();
            // Create the Json Object with Project properties
            JSONObject json = new JSONObject();
            json.put("projectId", project.getPrettyName());
            json.put("projectName", project.getDisplayName());
            json.put("projectDescription", project.getDescription());
            json.put("url", project.getUrl());
            if (project.getAvatarUrl() != null && project.getAvatarUrl() != "") {
                json.put("avatar", project.getAvatarUrl());
            } else {
                json.put("avatar", "/ProjectSpace-portlets/skin/images/article-cnt1.jpg");
            }

            Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, projectId, true);
            Profile sProfile = prIdentity.getProfile();
            json.put("ownerType", getOwnerType(sProfile.getProperty("ownerType")));
            json.put("ownerTypeId", sProfile.getProperty("ownerTypeId").toString());
            json.put("projectStatus", sProfile.getProperty("projectStatus").toString());
            json.put("projectStatusId", sProfile.getProperty("projectStatusId").toString());
            json.put("projectType", getType(sProfile.getProperty("projectType")));
            json.put("projectTypeId", sProfile.getProperty("projectTypeId").toString());
/*            json.put("StructureEntity", getStructure(sProfile.getProperty("StructureEntity").toString()));
            json.put("structureId", sProfile.getProperty("structureId").toString());*/
            json.put("nbBuildings", sProfile.getProperty("nbBuildings"));
            json.put("storiesAboveGrd", sProfile.getProperty("storiesAboveGrd"));
            json.put("storiesBelowGrd", sProfile.getProperty("storiesBelowGrd"));
            json.put("totalSqFt", sProfile.getProperty("totalSqFt"));
            json.put("projectValuation", sProfile.getProperty("projectValuation"));
            /*CalendarService calService = (CalendarService) PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(sourceIdentity.getRemoteId());
            CalendarEvent duedateevent = calService.getEventById(project.getPrettyName() + " - bidsDueDate");
            CalendarEvent prebiddateevent = calService.getEventById(project.getPrettyName() + " - preBidMeeting");
            CalendarEvent startdateevent = calService.getEventById(project.getPrettyName() + " - startDate");
            DateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
            DateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy");
            formatter1.setTimeZone(TimeZone.getTimeZone(setting.getTimeZone()));
            json.put("bidsDueDate",duedateevent != null ? formatter1.format(duedateevent.getFromDateTime()) : "");
            json.put("preBidMeetingDate",prebiddateevent != null ? formatter1.format(prebiddateevent.getFromDateTime()) : "");
            json.put("startDate",startdateevent != null ? formatter2.format(startdateevent.getFromDateTime()) : "");*/
            json.put("preBidMeetingDate", sProfile.getProperty("preBidMeetingDate"));
            json.put("bidsDueDate", sProfile.getProperty("bidsDueDate"));
            json.put("startDate", sProfile.getProperty("startDate"));
            json.put("creator", sProfile.getProperty("creator"));
            json.put("union", Boolean.parseBoolean((String) sProfile.getProperty("union")));
            json.put("nonUnion", Boolean.parseBoolean((String) sProfile.getProperty("nonUnion")));
            json.put("prevailingWage", Boolean.parseBoolean((String) sProfile.getProperty("prevailingWage")));
            json.put("chkleed", Boolean.parseBoolean((String) sProfile.getProperty("chkleed")));
            json.put("chkbim", Boolean.parseBoolean((String) sProfile.getProperty("chkbim")));
            json.put("goal1", sProfile.getProperty("goal1"));
            json.put("goal1Id", sProfile.getProperty("goal1Id"));
            json.put("goal2", sProfile.getProperty("goal2"));
            json.put("goal2Id", sProfile.getProperty("goal2Id"));
            json.put("goal3", sProfile.getProperty("goal3"));
            json.put("goal3Id", sProfile.getProperty("goal3Id"));
            json.put("goal1pct", sProfile.getProperty("goal1pct"));
            json.put("goal2pct", sProfile.getProperty("goal2pct"));
            json.put("goal3pct", sProfile.getProperty("goal3pct"));
            json.put("bidSecurity", sProfile.getProperty("bidSecurity"));
            json.put("performanceBond", sProfile.getProperty("performanceBond"));
            json.put("paymentBond", sProfile.getProperty("paymentBond"));
            json.put("mbeGoal", sProfile.getProperty("mbeGoal"));
            json.put("dbeGoal", sProfile.getProperty("dbeGoal"));
            json.put("hubzone", sProfile.getProperty("hubzone"));
            json.put("leed", sProfile.getProperty("leed"));
            json.put("bim", sProfile.getProperty("bim"));
            json.put("adress", sProfile.getProperty("adress"));
            json.put("city", sProfile.getProperty("city"));
            json.put("state", sProfile.getProperty("state"));
            json.put("zip", sProfile.getProperty("zip"));
            json.put("country", sProfile.getProperty("country"));
            json.put("architect", sProfile.getProperty("architect"));
            json.put("engineer", sProfile.getProperty("engineer"));
            json.put("owner", sProfile.getProperty("owner"));
            json.put("geoPosition", sProfile.getProperty("geoPosition"));
            json.put("url", sProfile.getProperty("url"));
            json.put("status", status);

            JSONArray qualification = new JSONArray();
            List<String> qualiList = new ArrayList<String>();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);

            ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdListAccess(projectId);
            for (ProjectSubEntity rel : relList.load(0, relList.getSize())) {
                if (!qualiList.contains(rel.getCategory().getId())) {
                    JSONObject cat = new JSONObject();
                    if (bBCategoryStorage.getBBCategory(rel.getCategory().getId()) != null) {
                        cat.put("categorieName", bBCategoryStorage.getBBCategory(rel.getCategory().getId()).getCatCsiDesc());
                        cat.put("categoryId", rel.getCategory().getId());
                        qualiList.add(rel.getCategory().getId());
                        qualification.put(cat);
                    } else {
                        LOG.error("Can not get Category with ID: " + rel.getCategory().getId());
                    }
                }
            }
            json.put("classifications", qualification);
            UserHandler uh = orgService.getUserHandler();
            User user = uh.findUserByName(sourceIdentity.getRemoteId());
            if (user == null) {
                return Response.status(Response.Status.NOT_FOUND).build();
            }
            Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user.getUserName());
            sender.put("senderId", sourceIdentity.getRemoteId());
            sender.put("firstName", user.getFirstName());
            sender.put("lastName", user.getLastName());
            sender.put("displayName", user.getDisplayName());
            sender.put("email", user.getEmail());
            Profile uProfile = userId.getProfile();
            if (uProfile.getPhones() != null) {
                sender.put("phone", uProfile.getPhones().get(0).get("value"));
            }
            sender.put("fax", (uProfile.getProperty("faxnumber") == null) ? "" : uProfile.getProperty("faxnumber"));
            HashMap<String, Object> uiMap = new HashMap<String, Object>();
           /* if (((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).size() > 0) {
                uiMap = ((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).get(0);
                sender.put("company", uiMap.get(Profile.EXPERIENCES_COMPANY));
                sender.put("position", uiMap.get(Profile.EXPERIENCES_POSITION));
            }*/
            if (!sender.has("position") || sender.get("position") == null) sender.put("position", "Employee");
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            company.put("companyName", companyInfo.getCompanyName());
            company.put("companyProview", companyInfo.getCompanyProview());
            company.put("companyStreet", companyInfo.getCompanyStreet());
            company.put("companyState", companyInfo.getCompanyState());
            company.put("companyCity", companyInfo.getCompanyCity());
            company.put("companyZip", companyInfo.getCompanyZip());
            company.put("companyWebSite", companyInfo.getCompanyWebSite());
            company.put("companyPhone", companyInfo.getCompanyPhone());
            company.put("companyAvatar", "/portal/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png");


            jsGlobal.put("project", json);
            jsGlobal.put("sender", sender);
            jsGlobal.put("company", company);

            return Response.ok(jsGlobal.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    public void updateBidScopStatus(String uid, String projectId, String refuid, String bidStatus) {
        ChangeBidScopeStatusRunner changeBidScopeStatusRunner = new ChangeBidScopeStatusRunner(uid, projectId, refuid, bidStatus, ConversationState.getCurrent());
        Thread changeBidScopeStatusThread = new Thread(changeBidScopeStatusRunner, "Change BidScope Status Runner Thread");
        changeBidScopeStatusThread.start();
    }

}
