/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.rest;

import com.sun.star.uno.Exception;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.ps.DAO.*;
import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.entity.*;
import org.exoplatform.ps.model.StaffUser;
import org.exoplatform.ps.storage.api.*;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Path("/subcontarctorsservice")
public class SubContarctorsRestService implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final Log LOG = ExoLogger.getLogger(SubContarctorsRestService.class.getName());
    private static Boolean requestStarted = false;
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String ADMIN_GROUP = "/platform/administrators";

    private static final String DEFAULT_AVATAR_ICON_MIME_TYPE   = "image/png";
    private static final String DEFAULT_AVATAR_ICON_NAMESPACE     = "projectspace";
    private final CacheControl cacheControl;
    private final GeneralContractorDAO generalContractorDAO;
    private final UploadService uploadService;
    private final FileService fileService;
    private final SubGcDAO subGcDAO;
    private final SubStaffCompanyDAO subStaffCompanyDAO;
    private final SubCatDAO subCatDAO;
    private final SubContractorDAO subContractorDAO;
    private final OrganizationService orgService;
    private final SubCatStorage subCatStorage;
    private final ProjectSubDAO projectSubDAO;

    public SubContarctorsRestService(SubContractorDAO subContractorDAO,SubCatDAO subCatDAO, GeneralContractorDAO generalContractorDAO,  SubCatStorage subCatStorage, SubGcDAO subGcDAO,SubStaffCompanyDAO subStaffCompanyDAO, OrganizationService orgService,  UploadService uploadService, FileService fileService, ProjectSubDAO projectSubDAO) {

        this.cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        this.generalContractorDAO = generalContractorDAO;
        this.subContractorDAO = subContractorDAO;
        this.subGcDAO = subGcDAO;
        this.subCatDAO = subCatDAO;
        this.subStaffCompanyDAO = subStaffCompanyDAO;
        this.uploadService = uploadService;
        this.fileService = fileService;
        this.orgService = orgService;
        this.subCatStorage = subCatStorage;
        this.projectSubDAO = projectSubDAO;

    }



    @POST
    @Path("createsubstaff")
    public Response add (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                         StaffUser subStaffUser) throws Exception {
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        try {
                    UserHandler uh = orgService.getUserHandler();
                    try {
                        Query query = new Query();
                        query.setEmail(subStaffUser.getEmail());
                        if (uh.findUsersByQuery(query).getSize() > 0) {
                            LOG.warn("A Vendor with the email: " + subStaffUser.getEmail() + " exists");
                            return Response.status(Response.Status.BAD_REQUEST).entity("A Vendor with the email: " + subStaffUser.getUserid() + " exists").build();
                        }
                        if(uh.findUserByName(subStaffUser.getUserid())!=null){
                            LOG.warn("A Vendor with the login  exists");
                            return Response.status(Response.Status.BAD_REQUEST).entity("A Vendor with the email: " + subStaffUser.getUserid() + " exists").build();
                        }
                        startRequest();
                        //Creation of the new user
                        User user = uh.createUserInstance(subStaffUser.getUserid());
                        user.setPassword(subStaffUser.getPassword());
                        user.setEmail(subStaffUser.getEmail());
                        user.setLastName(subStaffUser.getLastName());
                        user.setFirstName(subStaffUser.getFirstName());
                        user.setDisplayName(subStaffUser.getFirstName() + " " + subStaffUser.getLastName());
                        uh.createUser(user, true);
                        GroupHandler gHandler = orgService.getGroupHandler();
                        MembershipHandler mHandler = orgService.getMembershipHandler();
                        MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
                        Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                        mHandler.linkMembership(user, subGroup, mtHandler.findMembershipType("member"), false);
                        LOG.info("SubContractor " + subStaffUser.getFirstName() + " " + subStaffUser.getFirstName() + " imported");
                        endRequest();

                        SubContractorEntity subContractorEntity = null;

                        if (subStaffUser.getCompanyId()!=null){
                            subContractorEntity = subContractorDAO.find(subStaffUser.getCompanyId());
                        }

                        if(subContractorEntity==null){
                            subContractorEntity = new SubContractorEntity();
                            subContractorEntity.setId(subStaffUser.getCompany().replaceAll("\\W", ""));
                            subContractorEntity.setCompany(subStaffUser.getCompany());
                            subContractorEntity.setEmail(subStaffUser.getCompanyEmail());
                            subContractorEntity.setManager(user.getUserName());
                            subContractorEntity=subContractorDAO.create(subContractorEntity);
                            GeneralContractorEntity generalContractorEntity = generalContractorDAO.find(subStaffUser.getGcId());
                            if(generalContractorEntity!=null){
                                SubGcEntity subGcEntity = new SubGcEntity(subContractorEntity,generalContractorEntity);
                                subGcDAO.create(subGcEntity);
                            }

                        }

                        SubStaffCompanyEntity subStaffCompanyEntity = new SubStaffCompanyEntity(subContractorEntity, user.getUserName());
                        subStaffCompanyDAO.create(subStaffCompanyEntity);


                } catch (java.lang.Exception e) {
                    e.printStackTrace();
                } finally {
                        endRequest();
                }


            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " User Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (JSONException e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("getallsubcats")
    public Response getAllSubcats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @QueryParam("projectId") String projectId) throws java.lang.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        JSONArray jsonArray = new JSONArray();
        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        SubCatDAO subCatDAO = (SubCatDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class);
        StaffEntity staff = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
        if (staff == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
try{
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        List<SubCatEntity> subCats = new ArrayList<SubCatEntity>();
        subCats = subCatDAO.getSubCatByGc(staff.getGeneralContractorEntity().getId(), 0, 0);

        for (SubCatEntity subCat_ : subCats) {
            JSONObject json = new JSONObject();
            String status = "Not Selected";
            try {
                if (projectSubRelationShipStorage.getRelationShip(subCat_.getSubContractor().getId(), projectId, subCat_.getCategory().getId()) != null) {
                    status = projectSubRelationShipStorage.getRelationShip(subCat_.getSubContractor().getId(), projectId, subCat_.getCategory().getId()).getStatus();
                }
            } catch (java.lang.Exception nse) {

            }
            json.put("userName", subCat_.getSubContractor().getId());
            json.put("weburl", subCat_.getSubContractor().getWeburl());
            json.put("proview", subCat_.getSubContractor().getProview());
            json.put("company", subCat_.getSubContractor().getCompany());
            json.put("contact", subCat_.getSubContractor().getDisplayName());
            json.put("categories", subCat_.getCategory().getCatCsiDesc());
            json.put("phone", subCat_.getSubContractor().getPhone());
            json.put("rank", subCat_.getSubContractor().getRank());
            json.put("city", subCat_.getSubContractor().getCity());
            json.put("state", subCat_.getSubContractor().getState());
            json.put("county", subCat_.getSubContractor().getCountry());
            json.put("union", subCat_.getSubContractor().getUnion());
            json.put("nonUnion", subCat_.getSubContractor().getNonUnion());
            json.put("subCatId", subCat_.getId());
            json.put("status", status);
            jsonArray.put(json);
        }

        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        return Response.ok(jsonArray.toString(), mediaType).build();

    } catch (
    java.lang.Exception e) {
        LOG.error(e.getMessage(), e);
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
    }
}

    @GET
    @Path("getcurrentsub")
    public Response getCurrentSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubStaffCompanyDAO subStaffCompanyDAO = getService(SubStaffCompanyDAO.class,null);
        SubStaffCompanyEntity subStaffCompanyEntity= subStaffCompanyDAO.find(sourceIdentity.getRemoteId());
        if (subStaffCompanyEntity == null){
            return Response.noContent().build();
        }
        return Response.ok(subStaffCompanyEntity.getSubContractorEntity(), mediaType).build();
    }


    @GET
    @Path("getcompany/{id}")
    public Response getcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo , @PathParam("id") String id) throws Exception {

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        if(id != null && id !=""){
            SubContractorEntity subContractorEntity =subContractorDAO.find(id);
            if(subContractorEntity==null) return Response.status(Response.Status.NO_CONTENT).build();
            return  Response.ok(subContractorEntity, mediaType).build();
        }else {

            Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            SubStaffCompanyDAO subStaffCompanyDAO = getService(SubStaffCompanyDAO.class, null);
            SubStaffCompanyEntity subStaffCompanyEntity = subStaffCompanyDAO.find(sourceIdentity.getRemoteId());
            if (subStaffCompanyEntity == null) {
                return Response.noContent().build();
            }
            return Response.ok(subStaffCompanyEntity.getSubContractorEntity(), mediaType).build();
        }
    }



    @GET
    @Path("getcurrentsubconnect")
    public Response getCurrentSubConnect(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubStaffCompanyDAO subStaffCompanyDAO = getService(SubStaffCompanyDAO.class,null);
        SubStaffCompanyEntity subStaffCompanyEntity= subStaffCompanyDAO.find(sourceIdentity.getRemoteId());
        if (subStaffCompanyEntity == null){
            return Response.noContent().build();
        }
        return Response.ok(subStaffCompanyEntity.getSubContractorEntity(), mediaType).build();
    }

    @GET
    @Path("getcurrentconnectrole")
    public Response getCurrentConnect(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = getService(StaffDAO.class,null);
        StaffEntity staffEntity= staffDAO.find(sourceIdentity.getRemoteId());
        if (staffEntity == null){
            return Response.noContent().build();
        }
        return Response.ok(staffEntity, mediaType).build();
    }

    @GET
    @Path("getallsub")
    public Response getAllSub(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }


        return Response.ok(subContractorDAO.findAll(), mediaType).build();
    }

    @GET
    @Path("getallsubCat")
    public Response getAllSubCat(@Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }


        return Response.ok(subCatDAO.findAll(), mediaType).build();
    }


    @GET
    @Path("deletesubCat/{subcatid}")
    public Response DeleteSubCat(@Context HttpServletRequest request, @Context HttpServletResponse response,
                                 @PathParam("subcatid") String subcatid) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        try {
            subCatStorage.deleteSubCat(subcatid);

            LOG.info("SubCatEntity is deleted");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubCatEntity is deleted");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }


    }


    @GET
    @Path("getcurrentsubcategories/{subid}")
    public Response getcurrentsubCategorie(@Context HttpServletRequest request,
                                           @Context HttpServletResponse response,
                                           @Context UriInfo uriInfo,
                                           @PathParam("subid") String sub) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        try {
            return Response.ok(subCatStorage.getSubCatsBySubId(sub,0,0), mediaType).build();

        }  catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


    @GET
    @Path("getcurrentsubprojectcats/{subid}/{projectid}")
    public Response getCurrentSubProjectCats(@Context HttpServletRequest request,
                                           @Context HttpServletResponse response,
                                           @Context UriInfo uriInfo,
                                           @PathParam("subid") String sub,@PathParam("projectid") String projectid) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        try {
            return Response.ok(projectSubDAO.getRelationShipByProjectIdAndSubId(projectid,sub,0,0), mediaType).build();

        }  catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("savesub")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response saveSub (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                             SubContractor userIn) throws java.lang.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = getService(BBCategoryStorage.class,null);
        SubUserInfoStorage subUserInfoStorage = getService(SubUserInfoStorage.class,null);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        try {

            /** we rely on FileService, thus we don't need to persist icon in our DB*/
            FileItem fileItem = null;
            if (userIn.getUploadId() != null) {
                UploadResource uploadResource = uploadService.getUploadResource(userIn.getUploadId());

                if (uploadResource != null) {

                    fileItem = new FileItem(null,
                            userIn.getId(),
                            uploadResource.getMimeType(),
                            DEFAULT_AVATAR_ICON_NAMESPACE,
                            (long)uploadResource.getUploadedSize(),
                            new Date(),
                            sourceIdentity.getRemoteId(),
                            false,
                            new FileInputStream(uploadResource.getStoreLocation()));
                    fileItem = fileService.writeFile(fileItem);
                    LOG.info("================================="+fileItem.getFileInfo().getId());
                    /** END upload */
                    userIn.setAvatarId(fileItem.getFileInfo().getId());
                }
            }


        } catch (java.lang.Exception e) {
            e.printStackTrace();
        }
        try {
            //Create Categories
            userIn.setUserid(userIn.getCompany().replaceAll("\\W", ""));
            SubContractorEntity subUserInfo = subUserInfoStorage.updateSubUserInfo(userIn.getId(), userIn);
            if (userIn.getSelectedCats() != null) {
                for (String cat : userIn.getSelectedCats()) {

                        CategoryEntity cat_ = bBCategoryStorage.getBBCategory(cat);
                        String subcatis = cat_.getId()+userIn.getUserid();
                            SubCatEntity subCatEntity = subCatStorage.createSubCat(subcatis, cat_, subUserInfo, "0");

                }

            }

            LOG.info("SubContractor imported");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("updateprojectsub")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response updateProjectSub (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                      ProjectSubEntity proSub) throws java.lang.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }


        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        try {
            //Create Categories

            projectSubDAO.update(proSub);


            LOG.info("ProjectSubEntity updated");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SProjectSubEntity updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("deleteprojectsubcat/{ProjectSubReltId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response DeleteProjectSubcat (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                         @PathParam("ProjectSubReltId") String ProjectSubReltId[]) throws java.lang.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        try {
          for(String id : ProjectSubReltId ) {
            projectSubRelationShipStorage.deleteProjectSubRelationShip(id);}

            LOG.info("SubCatEntity is deleted");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubCatEntity is deleted");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


    @GET
    @Path("sub/{sub}/avatar")
    public Response getSpaceAvatarById(@Context UriInfo uriInfo,
                                       @Context Request request,
                                       @PathParam("sub") String sub) throws IOException {

        ConversationState conversationState = ConversationState.getCurrent();

        if (conversationState != null) {

            InputStream stream = null;

            try {
                SubContractorEntity sub_ = subContractorDAO.find(sub);

                Long lastUpdated = null;
                if (sub_ != null && sub_.getAvatarId() != null) {
                    lastUpdated = sub_.getLastModifiedDate().getTime();
                } else {
                    stream = GeneralContarctorsRestService.class.getClassLoader().getResourceAsStream("medias/images/logo_default.png");
                }
                EntityTag eTag = null;
                if (lastUpdated != null) {
                    eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
                }
                //
                Response.ResponseBuilder builder = (eTag == null ? null : request.evaluatePreconditions(eTag));
                if (builder == null) {
                    if (stream == null) {
                        if(sub_!=null){
                            stream = Utils.getAvatarInputStream(sub_.getAvatarId());
                        }else{
                            throw new WebApplicationException(Response.Status.NOT_FOUND);
                        }
                    }

                    builder = Response.ok(stream, "image/png");
                    builder.tag(eTag);
                }
                CacheControl cc = new CacheControl();
                cc.setMaxAge(86400);
                builder.cacheControl(cc);
                return builder.cacheControl(cc).build();


            } catch (java.lang.Exception e) {

                LOG.error("Error getting badge's avatar", e);

                return Response.serverError()
                        .entity("Error getting badge's avatar")
                        .build();
            }

        } else {
            return Response.status(Response.Status.UNAUTHORIZED)
                    .entity("Unauthorized user")
                    .build();
        }

    }



    @POST
    @Path("addnotinvited/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addNotInvited(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @PathParam("projectId") String projectId,
                                List<String> relations) throws Exception {
        try {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        UserHandler uh = orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        if (sourceIdentity == null) {
            LOG.warn("UNAUTHORIZED");
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        //Get the Space by its Pretty Name
        Space project = spaceService.getSpaceByPrettyName(projectId);
        if (project == null) {
            LOG.warn("Project not found");
            return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
        }
        //Invite all selected users to join the Project
        Boolean isMulti = false;

        for (String subcat : relations) {


                SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "NOT_MESS", "", "0", "no");
                } else LOG.warn("Sub Id or categorie is null, relationship will not be created");


        }
        JSONObject jsonGlobal = new JSONObject();
        jsonGlobal.put("message", "Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
        return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
        LOG.error(e.getMessage(), e);
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
    }
    }



    @POST
    @Path("addinvited/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addInvited(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @PathParam("projectId") String projectId,
                                  List<String> relations) throws Exception {
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
            UserHandler uh = orgService.getUserHandler();
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            ListenerService listenerService = (ListenerService) PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
            ProjectSubDAO projectSubDAO = (ProjectSubDAO) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class);

            if (sourceIdentity == null) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn("Project not found");
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

            for (String subcat : relations) {

                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);

                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    ProjectSubEntity projectSubEntity = projectSubDAO.find(subcat_.getSubContractor().getId()+ "_" + project.getPrettyName() + "_" + subcat_.getCategory().getId());
                    if (projectSubEntity==null) {
                        projectSubEntity = projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "INVITED", "", "0", "no");
                    } else {
                        projectSubEntity.setStatus("INVITED");
                        projectSubEntity = projectSubDAO.update(projectSubEntity);
                    }
                    spaceService.addMember(project,projectSubEntity.getSubContractor().getManager());
                    listenerService.broadcast("sendItb", projectSubEntity, sourceIdentity.getRemoteId());
                } else LOG.warn("Sub Id or categorie is null, relationship will not be created");





            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }



    @GET
    @Path("getbidmgndata/{projectId}")
    public Response getBidData (@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @PathParam("projectId") String projectId) throws java.lang.Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        JSONArray jsonAllArray = new JSONArray();
        JSONArray jsonNotInvitedArray = new JSONArray();
        JSONArray jsonInvitedArray = new JSONArray();
        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        SubCatDAO subCatDAO = (SubCatDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class);
        ProjectSubDAO projectSubDAO = (ProjectSubDAO) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class);
        StaffEntity staff = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
        if (staff == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        List<String>  massaged = new ArrayList<>();

        List<ProjectSubEntity> subs = projectSubDAO.getRelationShipByProjectId(projectId,0,0);

        for(ProjectSubEntity sub : subs){
            JSONObject json = new JSONObject();
            json.put("userName", sub.getSubContractor().getId());
            json.put("company", sub.getSubContractor().getCompany());
            json.put("rank", sub.getSubContractor().getRank());
            json.put("email", "");
            json.put("phone", sub.getSubContractor().getPhone());
            json.put("faxnumber", "");
            json.put("itbsent", "");
            json.put("notes", sub.getNote());
            json.put("bid", ((sub.getBid() != null && !sub.getBid().equals("0")) ? sub.getBid() : ""));
            json.put("contact", sub.getSubContractor().getDisplayName());
            json.put("categories", sub.getCategory().getId()+"-"+sub.getCategory().getCatCsiDesc());
            json.put("categoryId", sub.getCategory().getId());
            json.put("relName", sub.getId());
            json.put("status", sub.getStatus());
            json.put("union", sub.getSubContractor().getUnion());
            json.put("nonUnion", sub.getSubContractor().getNonUnion());
            json.put("bidScoped", (sub.getBidScoped() != null) ? sub.getBidScoped() : "no");
            json.put("subCatId", sub.getSubContractor().getId()+ "_" + sub.getCategory().getId());
            json.put("selected", "true");
            json.put("bbgroups", "");
            if(sub.getStatus().equals("NOT_MESS")){
                jsonNotInvitedArray.put(json);
            }else{
                jsonInvitedArray.put(json);
            }
            massaged.add(sub.getSubContractor().getId()+ "_" + sub.getCategory().getId());
        }


        try{

            List<SubCatEntity> subCats = new ArrayList<SubCatEntity>();
            subCats = subCatDAO.getSubCatByGc(staff.getGeneralContractorEntity().getId(), 0, 0);

            for (SubCatEntity subCat_ : subCats) {
                if(!massaged.contains(subCat_.getId())){
                    JSONObject json = new JSONObject();
                    json.put("userName", subCat_.getSubContractor().getId());
                    json.put("weburl", subCat_.getSubContractor().getWeburl());
                    json.put("proview", subCat_.getSubContractor().getProview());
                    json.put("company", subCat_.getSubContractor().getCompany());
                    json.put("contact", subCat_.getSubContractor().getDisplayName());
                    json.put("categories", subCat_.getCategory().getId()+"-"+subCat_.getCategory().getCatCsiDesc());
                    json.put("phone", subCat_.getSubContractor().getPhone());
                    json.put("rank", subCat_.getSubContractor().getRank());
                    json.put("city", subCat_.getSubContractor().getCity());
                    json.put("state", subCat_.getSubContractor().getState());
                    json.put("county", subCat_.getSubContractor().getCountry());
                    json.put("union", subCat_.getSubContractor().getUnion());
                    json.put("nonUnion", subCat_.getSubContractor().getNonUnion());
                    json.put("subCatId", subCat_.getId());
                    jsonAllArray.put(json);
                }

            }

            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("notInvited", jsonNotInvitedArray);
            jsonGlobal.put("invited", jsonInvitedArray);
            jsonGlobal.put("allCats", jsonAllArray);
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (
                java.lang.Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }








    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }


    private void endRequest() {
        if (requestStarted && orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle) orgService).endRequest(PortalContainer.getInstance());
            } catch (java.lang.Exception e) {
                LOG.warn(e.getMessage(), e);
            }
            requestStarted = false;
        }
    }

    private void startRequest() {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    public static boolean isAdmin(org.exoplatform.services.security.Identity userId) {
        if (userId.isMemberOf(ADMIN_GROUP) || userId.isMemberOf(GCS_GROUP) || userId.getUserId().equals(PropertyManager.getProperty("exo.super.user")))
            return true;
        return false;
    }


}
