/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.rest;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.ps.DAO.*;
import org.exoplatform.ps.DTO.Category;
import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.chromattic.entity.*;
import org.exoplatform.ps.entity.*;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.model.BbMessage;
import org.exoplatform.ps.model.BbSerachResult;
import org.exoplatform.ps.model.BbUser;
import org.exoplatform.ps.storage.UsersSearch;
import org.exoplatform.ps.storage.api.*;
import org.exoplatform.ps.utils.RelationShipType;
import org.exoplatform.ps.utils.Utils;
import org.apache.commons.lang.StringEscapeUtils;
import org.chromattic.api.DuplicateNameException;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.lifecycle.SocialChromatticLifeCycle;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
//import org.exoplatform.social.webui.activity.UIBBNDefaultActivity;
import org.exoplatform.webui.exception.MessageException;
import org.json.JSONArray;
import org.json.JSONObject;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import java.io.*;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;

import static org.exoplatform.commons.api.settings.data.Context.GLOBAL;

/**
 * Created by MedAmine on 07/04/14.
 */
@Path("/bbusersservice")
public class UsersRestService implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final Log LOG = ExoLogger.getLogger(UsersRestService.class.getName());
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String DefaultAvatar = "/project-space-portlets/skin/images/user-image-placeholder-large.png";
    private static final String BBIMPORT_NOTIF_TYPE = "bbimport-success";
    private static final String BSIMPORT_NOTIF_TYPE = "bsimport-success";
    private static final String SUPPORT_MAIL = "oneteamdbddd@oneteam.build";
    private static String MASTER_HOST_VARIABLE_NAME = "tenant.masterhost";
    private static String DEFAULT_MASTER_HOST_NAME = "localhost";
    private static Boolean requestStarted = false;
    private static final String LAST_ACCESS = "lastAccess";
    private static final String GCS_GROUP = "/organization/gcs";
    private static final String ADMIN_GROUP = "/platform/administrators";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    private final CacheControl cacheControl;


    public UsersRestService() {
        this.cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);

    }

    OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    RepositoryService repositoryService = (RepositoryService) PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);

    public static boolean isAdmin(org.exoplatform.services.security.Identity userId) {
        if (userId.isMemberOf(ADMIN_GROUP) || userId.isMemberOf(GCS_GROUP) || userId.getUserId().equals(PropertyManager.getProperty("exo.super.user")) || userId.getUserId().equals(PLAN_ROOM_TEAM) || userId.getUserId().equals(INTEGRATION_USER))
            return true;
        return false;
    }

    public static boolean sendMail(String to, String subject, String mailText, Boolean isDaily) {

        try {


/*            if (!isDaily) {
                NotificationContext ctx = NotificationContextImpl.cloneInstance().

                        append(BBNotificationUtils.MailText, mailText).
                        append(BBNotificationUtils.Subject, subject).
                        append(BBNotificationUtils.TO, to);

                ctx.getNotificationExecutor().with(ctx.makeCommand(NotificationKey.key(BBNotificationPlugin.ID))).execute(ctx);
            } else {
                NotificationContext ctx = NotificationContextImpl.cloneInstance().

                        append(BBNotificationUtils.MailText, mailText).
                        append(BBNotificationUtils.Subject, subject).
                        append(BBNotificationUtils.TO, to);

                ctx.getNotificationExecutor().with(ctx.makeCommand(NotificationKey.key(BBDigestNotificationPlugin.ID))).execute(ctx);

            }*/
        } catch (Exception exception) {
            LOG.error(exception.getMessage(), exception);
            LOG.warn("ITB not sent to " + to);
            return (false);
        }
        LOG.info("ITB sent to " + to);
        return (true);
    }

    private static boolean isLowerCaseLetterOrDigit(char character) {
        return Character.isDigit(character) || (character >= 'a' && character <= 'z');
    }


    private static boolean isLowerCaseLetter(char character) {
        return (character >= 'a' && character <= 'z');
    }

    @GET
    @Path("geteveryone")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getEveryone(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @QueryParam("projectId") String projectId,
                                @QueryParam("searchkey") String searchKey,
                                @QueryParam("limit") int limit,
                                @QueryParam("offset") int offset) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);

            UsersSearch mvSearch = new UsersSearch();
            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = (request.getParameter("iDisplayLength") == null) ? 30 : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = (request.getParameter("iSortCol_0") == null) ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = (request.getParameter("sSortDir_0") == null) ? "" : request.getParameter("sSortDir_0");

            ProfileFilter filter = new ProfileFilter();
            List<Identity> ecxluded = new ArrayList<Identity>();
            if (projectId != null) {
                SpaceService spaceService = Util.getSpaceService(portalContainerName);
                Space project = spaceService.getSpaceByPrettyName(projectId);
                if (project == null) {
                    return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
                }
                ListAccess<Identity> members = identityManager.getSpaceIdentityByProfileFilter(project, filter, SpaceMemberFilterListAccess.Type.MEMBER, true);
                ecxluded.addAll(Arrays.asList(members.load(0, members.getSize())));
                if (project.getInvitedUsers() != null) {
                    for (String invitedUser : project.getInvitedUsers()) {
                        ecxluded.add(identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, invitedUser, true));
                    }
                }
            }
            UserHandler uh = orgService.getUserHandler();
            ListAccess<User> staffList = uh.findUsersByGroupId("/organization/gcs");
            for (User staff : staffList.load(0, staffList.getSize())) {
                ecxluded.add(identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, staff.getUserName(), true));
            }
            ecxluded.add(identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, "root", true));
            String sortBy;
            if (projectId != null) {
                switch (iSortCol) {
                    case 0:
                        sortBy = "void-userName";
                        break;
                    case 1:
                        sortBy = "void-fullName";
                        break;
                    case 2:
                        sortBy = "void-company";
                        break;
                    case 3:
                        sortBy = "void-categories";
                        break;
                    case 4:
                        sortBy = "void-rank";
                        break;

                    default:
                        sortBy = "";
                        break;
                }
            } else {
                switch (iSortCol) {
                    case 0:
                        sortBy = "void-userName";
                        break;
                    case 1:
                        sortBy = "void-fullName";
                        break;
                    case 2:
                        sortBy = "void-company";
                        break;
                    case 3:
                        sortBy = "void-categories";
                        break;
                    case 4:
                        sortBy = "void-rank";
                        break;

                    default:
                        sortBy = "";
                        break;
                }
            }
            List<Identity> users = mvSearch.search(false, searchKey, ecxluded, displaystart, displaylength, sortBy, sortDir);
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (Identity user : users) {
                Profile uProfile = user.getProfile();
                JSONObject json = new JSONObject();
                json.put("userName", user.getRemoteId());
                if (uProfile.getProperty("company") == null) json.put("company", "");
                else json.put("company", uProfile.getProperty("company"));
                if (uProfile.getFullName() == null) json.put("contact", "");
                else json.put("contact", uProfile.getFullName());
                if (uProfile.getProperty("categories") == null) json.put("categories", "");
                else json.put("categories", uProfile.getProperty("categories"));
                if (uProfile.getProperty("rank") == null) json.put("rank", 8);
                else json.put("rank", uProfile.getProperty("rank"));
                json.put("selected", false);
                jsonArray.put(json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", mvSearch.getSize());
            jsonGlobal.put("iTotalDisplayRecords", mvSearch.getSize());
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getallsubcats")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getAllSubcats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @QueryParam("projectId") String projectId,
                                  @QueryParam("searchkey") String searchKey,
                                  @QueryParam("isvendor") boolean isvendor,
                                  @QueryParam("notinvited") boolean notinvited,
                                  @QueryParam("filteredgroups") String filteredgroups,
                                  @QueryParam("filteredclassif") String filteredclassifications,
                                  @QueryParam("limit") int limit,
                                  @QueryParam("offset") int offset,
                                  @QueryParam("selectall") boolean selectall) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }


        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        SubCatDAO subCatDAO = (SubCatDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class);
        StaffEntity staff = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
        if (staff == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = (request.getParameter("iDisplayLength") == null) ? 30 : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            int iSortCol = (request.getParameter("iSortCol_0") == null) ? 0 : Integer.parseInt(request.getParameter("iSortCol_0"));
            String sortDir = (request.getParameter("sSortDir_0") == null) ? "" : request.getParameter("sSortDir_0");
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            List<SubCatEntity> excluded = new ArrayList<SubCatEntity>();
            List<SubCatEntity> includedStatus = new ArrayList<SubCatEntity>();
            List<SubCatEntity> includedGroups = new ArrayList<SubCatEntity>();
            List<SubCatEntity> included = new ArrayList<SubCatEntity>();
            List<ProjectSubEntity> includedRel = new ArrayList<ProjectSubEntity>();

            if (filteredgroups != null && filteredgroups.compareTo("") != 0) {
                String[] filteredarraygroups = filteredgroups.split(",");
                ProjectSubEntity projectSubRelationShip_ = null;
                for (String filteredgroup : filteredarraygroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        SubCatEntity subCat = subCatStorage.getSubCat(subCatGroupRelation.getSubCat().getId());
                        if (subCat != null) {
                            includedGroups.add(subCat);
                            if (null != projectId) {
                                projectSubRelationShip_ = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                if (projectSubRelationShip_ != null) includedRel.add(projectSubRelationShip_);
                            }
                        }
                    }
                }
                if (includedGroups.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok(jsonGlobal.toString(), mediaType).build();
                }
            }


            String sortBy;

            switch (iSortCol) {
                case 0:
                    sortBy = "tbb:subId";
                    break;
                case 1:
                    sortBy = "tbb:subCompany";
                    break;
                case 2:
                    sortBy = "tbb:subName";
                    break;
                case 3:
                    sortBy = "tbb:catCsiDesc";
                    break;
                case 4:
                    sortBy = "tbb:subPhone";
                    break;
                case 5:
                    sortBy = "tbb:subCity";
                    break;
                case 6:
                    sortBy = "tbb:subState";
                    break;
                case 7:
                    sortBy = "tbb:subCounty";
                    break;
                case 8:
                    sortBy = "tbb:subRank";
                    break;
                case 9:
                    sortBy = "tbb:subUnion";
                    break;
                case 10:
                    sortBy = "tbb:subNonUnion";
                    break;
                default:
                    sortBy = "";
                    break;
            }
            filteredclassifications = (filteredclassifications == null || filteredclassifications.equals("undefined")) ? "" : filteredclassifications;

            List<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add((request.getParameter("sSearch_1") == null) ? "" : request.getParameter("sSearch_1"));
            SearchConditions.add((request.getParameter("sSearch_2") == null) ? "" : request.getParameter("sSearch_2"));
            SearchConditions.add((request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("")) ? filteredclassifications : request.getParameter("sSearch_3"));
            SearchConditions.add((request.getParameter("sSearch_4") == null) ? "" : request.getParameter("sSearch_4"));
            SearchConditions.add((request.getParameter("sSearch_5") == null) ? "" : request.getParameter("sSearch_5"));
            SearchConditions.add((request.getParameter("sSearch_6") == null) ? "" : request.getParameter("sSearch_6"));
            SearchConditions.add((request.getParameter("sSearch_7") == null) ? "" : request.getParameter("sSearch_7"));
            SearchConditions.add((request.getParameter("sSearch_9") == null) ? "" : request.getParameter("sSearch_9"));
            SearchConditions.add((request.getParameter("sSearch_10") == null) ? "" : request.getParameter("sSearch_10"));


            List<String> RelSearchConditions = new ArrayList<String>();
            RelSearchConditions.add((request.getParameter("sSearch_1") == null) ? "" : request.getParameter("sSearch_1"));
            RelSearchConditions.add((request.getParameter("sSearch_2") == null) ? "" : request.getParameter("sSearch_2"));
            RelSearchConditions.add((request.getParameter("sSearch_3") == null || request.getParameter("sSearch_3").equals("")) ? filteredclassifications : request.getParameter("sSearch_3"));
            RelSearchConditions.add("");
            RelSearchConditions.add((request.getParameter("sSearch_4") == null) ? "" : request.getParameter("sSearch_4"));
            RelSearchConditions.add((request.getParameter("sSearch_5") == null) ? "" : request.getParameter("sSearch_5"));
            RelSearchConditions.add((request.getParameter("sSearch_6") == null) ? "" : request.getParameter("sSearch_6"));
            RelSearchConditions.add((request.getParameter("sSearch_7") == null) ? "" : request.getParameter("sSearch_7"));
            RelSearchConditions.add((request.getParameter("sSearch_9") == null) ? "" : request.getParameter("sSearch_9"));
            RelSearchConditions.add((request.getParameter("sSearch_10") == null) ? "" : request.getParameter("sSearch_10"));

            if (null != projectId && request.getParameter("sSearch_11") != null && request.getParameter("sSearch_11") != "") {
                List<String> SearchConditions1 = new ArrayList<String>();
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add((request.getParameter("sSearch_11") == null) ? "" : request.getParameter("sSearch_11"));
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                SearchConditions1.add("");
                ListAccess<ProjectSubEntity> byStatusList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(true, isvendor, notinvited, null, SearchConditions1, null, sortBy, sortDir, projectId);

                for (ProjectSubEntity relationShip : byStatusList.load(0, byStatusList.getSize())) {
                    String subcatid = relationShip.getSubContractor().getId() + "_" + relationShip.getCategory().getId();

                    SubCatEntity subcat = subCatStorage.getSubCat(subcatid);

                    if (subcat != null) includedStatus.add(subcat);
                }

                if (includedStatus.size() == 0) {
                    jsonGlobal.put("sEcho", sEcho);
                    jsonGlobal.put("iTotalRecords", 0);
                    jsonGlobal.put("iTotalDisplayRecords", 0);
                    jsonGlobal.put("aaData", jsonArray);
                    response.setContentType("application/json");
                    response.setHeader("Cache-Control", "no-store");
                    return Response.ok(jsonGlobal.toString(), mediaType).build();
                }

            }

            if (includedGroups.size() == 0 && includedStatus.size() > 0) {
                included = includedStatus;
            }
            if (includedGroups.size() > 0 && includedStatus.size() == 0) {
                included = includedGroups;
            }
            if (includedGroups.size() > 0 && includedStatus.size() > 0) {
                for (SubCatEntity subCat : includedGroups) {
                    if (includedStatus.contains(subCat)) included.add(subCat);
                }
            }
            List<SubCatEntity> subCats = new ArrayList<SubCatEntity>();
            int total = subCatStorage.subCatSearchCount(isvendor, searchKey, SearchConditions, excluded, included);

            int notInvitedCount = 0;
            if (null != projectId) {
                ListAccess<ProjectSubEntity> tmpList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, isvendor, false, searchKey, RelSearchConditions, includedRel, sortBy, sortDir, projectId);
                if (notinvited) {
                    for (ProjectSubEntity relationShip : tmpList.load(0, tmpList.getSize())) {
                        String subcatid = relationShip.getSubContractor().getId() + "_" + relationShip.getCategory().getId();
                        excluded.add(subCatStorage.getSubCat(subcatid));
                    }

                }
                if (request.getParameter("notInvitedCount") != null) {
                    notInvitedCount = Integer.parseInt(request.getParameter("notInvitedCount"));
                }

                if (notInvitedCount == -1) {
                    notInvitedCount = total - tmpList.getSize();
                }

                if (notInvitedCount <= 0) {
                    notInvitedCount = 0;
                    if (filteredgroups != null) {
                        for (String filteredgroup : filteredgroups.split("\\,")) {
                            List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                            for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                                ProjectSubEntity relationShip = null;
                                try {
                                    relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                    if (relationShip == null) notInvitedCount++;
                                } catch (Exception e) {
                                    notInvitedCount++;
                                }

                                try {
                                    if (relationShip != null && relationShip.getStatus().equals("NOT_MESS")) {
                                        notInvitedCount++;
                                    }
                                } catch (Exception e) {
                                    LOG.error(e.getMessage(), e);
                                }
                            }
                        }
                    }
                }

            }

/*            subCats = subCatStorage.subCatSearch(isvendor, searchKey, SearchConditions, excluded, included, sortBy, sortDir, displaystart, displaylength);
            int subCatsSize = subCatStorage.subCatSearchCount(isvendor, searchKey, SearchConditions, excluded, included);*/


            SubGcDAO subGcDAO = (SubGcDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubGcDAO.class);

            subCats = subCatDAO.getSubCatByGc(staff.getGeneralContractorEntity().getId(), displaystart, displaylength);

            int subCatsSize = subCats.size();

            Boolean isgcmember = (orgService.getMembershipHandler().findMembershipByUserGroupAndType(sourceIdentity.getRemoteId(), "/organization/gcs", "gcmember") != null) ? true : false;
            for (SubCatEntity subCat_ : subCats) {
                JSONObject json = new JSONObject();
                String status = "Not Selected";
                try {
                    if (projectSubRelationShipStorage.getRelationShip(subCat_.getSubContractor().getId(), projectId, subCat_.getCategory().getId()) != null) {
                        status = projectSubRelationShipStorage.getRelationShip(subCat_.getSubContractor().getId(), projectId, subCat_.getCategory().getId()).getStatus();
                    }
                } catch (Exception nse) {

                }
                json.put("userName", subCat_.getSubContractor().getId());
                json.put("weburl", subCat_.getSubContractor().getWeburl());
                json.put("proview", subCat_.getSubContractor().getProview());
                json.put("company", subCat_.getSubContractor().getCompany());
                json.put("contact", subCat_.getSubContractor().getDisplayName());
                json.put("categories", subCat_.getCategory().getCatCsiDesc());
                json.put("phone", subCat_.getSubContractor().getPhone());
                json.put("rank", subCat_.getSubContractor().getRank());
                json.put("city", subCat_.getSubContractor().getCity());
                json.put("state", subCat_.getSubContractor().getState());
                json.put("county", subCat_.getSubContractor().getCountry());
                json.put("union", subCat_.getSubContractor().getUnion());
                json.put("nonUnion", subCat_.getSubContractor().getNonUnion());
                json.put("subCatId", subCat_.getId());
                json.put("status", status);
                //json.put("selected", !status.equals("Not Invited"));
                json.put("selected", selectall);
                json.put("isgcmember", isgcmember);
                json.put("bbgroups", "");
                jsonArray.put(json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", subCatsSize);
            jsonGlobal.put("iTotalDisplayRecords", subCatsSize);
            jsonGlobal.put("iTotalNotInvited", notInvitedCount);
            jsonGlobal.put("aaData", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("get/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                            @PathParam("userName") String userName) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            JSONObject json = new JSONObject();
            identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, userName);
            SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(userName);
            if (userInfo == null) {
                //return Response.status(Response.Status.NOT_FOUND).build();
                Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, userName);
                if (userId == null) {
                    return Response.status(Response.Status.NOT_FOUND).build();
                }

                UserHandler uh = orgService.getUserHandler();
                User user = uh.findUserByName(userName);
                if (user == null) {
                    return Response.status(Response.Status.NOT_FOUND).build();
                }
                json.put("firstName", user.getFirstName());
                json.put("lastName", user.getLastName());
                json.put("displayName", user.getDisplayName());
                json.put("email", user.getEmail());
                Profile uProfile = userId.getProfile();
                if (uProfile.getPhones() != null) {
                    json.put("phone", uProfile.getPhones().get(0).get("value"));
                }
/*                HashMap<String, Object> uiMap = new HashMap<String, Object>();
                if (((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).size() > 0) {
                    uiMap = ((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).get(0);
                    json.put("company", uiMap.get(Profile.EXPERIENCES_COMPANY));
                    json.put("position", uiMap.get(Profile.EXPERIENCES_POSITION));
                }*/
                json.put("avatar", uProfile.getAvatarUrl());
                json.put("gcgroup", getGcGroup(userName));
                return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();


            }

            json.put("firstName", userInfo.getFirstName());
            json.put("lastName", userInfo.getLastName());
            json.put("displayName", userInfo.getDisplayName());
            json.put("email", userInfo.getEmail());
            json.put("secondemail", userInfo.getSecondemail());
            json.put("webSite", userInfo.getWebSite());
            json.put("notes", userInfo.getNotes());
            json.put("phone", userInfo.getPhone());
            json.put("mainPhoneType", userInfo.getMainPhoneType());
            json.put("secondPhone", userInfo.getSecondPhone());
            json.put("secondPhoneType", userInfo.getSecondPhoneType());
            json.put("faxnumber", userInfo.getFaxnumber());
            json.put("company", userInfo.getCompany());
            json.put("refUID", userInfo.getRefUID());
            json.put("city", userInfo.getCity());
            json.put("state", userInfo.getState());
            json.put("county", userInfo.getCountry());
            json.put("country", userInfo.getCountry());
            json.put("lonlat", userInfo.getLonlat());
            json.put("street", userInfo.getStreet());
            json.put("address2", userInfo.getAddress2());
            json.put("zip", userInfo.getZip());
            //json.put("skills", userInfo.getSkills());
            json.put("rank", userInfo.getRank());
            json.put("weburl", userInfo.getWeburl());
            json.put("proview", userInfo.getProview());
            json.put("prevailingWage", userInfo.getPrevailingWage());
            json.put("union", userInfo.getUnion());
            json.put("nonUnion", userInfo.getNonUnion());
            //json.put("tagsArray", userInfo.getTagsArray());
            //json.put("StructureEntity", userInfo.getStructure());
            //json.put("structureId", userInfo.getStructureId());

            JSONArray subbbgroups = new JSONArray();

            List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(userName, 0, 0);
            String categories = "";
            String categoriesId = "";
            for (SubCatEntity subcat : subcats) {
                if (categories.equals(""))
                    categories = subcat.getCategory().getCatCsiDesc();
                else
                    categories = categories + ";" + subcat.getCategory().getCatCsiDesc();
                if (categoriesId.equals(""))
                    categoriesId = subcat.getCategory().getId();
                else
                    categoriesId = categoriesId + ";" + subcat.getCategory().getId();

                List<SubCatGroupEntity> subgroups = subCatGroupRelationStorage.getRelationShipBySubCatId(subcat.getId(), 0, 0);

                for (SubCatGroupEntity group : subgroups) {
                    subbbgroups.put(group.getId());
                }
            }
            json.put("categories", categories);
            json.put("categoriesId", categoriesId);

            /*if (userInfo.getStructure() != null && userInfo.getStructure() != "") {
                json.put("StructureEntity", ProjectRestService.getStructure(userInfo.getStructure()));
                json.put("structureId", userInfo.getStructureId());
            } else {
                json.put("StructureEntity", "");
                json.put("structureId", "");
            }*/

            json.put("bbgroups", subbbgroups);

            Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, userName, true);
            if (userId != null) {
                Profile uSProfile = userId.getProfile();
                if (uSProfile.getAvatarUrl() != null)
                    json.put("avatar", uSProfile.getAvatarUrl());
                else
                    json.put("avatar", DefaultAvatar);
            } else
                json.put("avatar", DefaultAvatar);
            return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getgcuser/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getGCUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                              @PathParam("userName") String userName) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
            Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, userName);
            if (userId == null) {
                return Response.status(Response.Status.NOT_FOUND).build();
            }
            JSONObject json = new JSONObject();
            UserHandler uh = orgService.getUserHandler();
            User user = uh.findUserByName(userName);
            if (user == null) {
                return Response.status(Response.Status.NOT_FOUND).build();
            }
            json.put("firstName", user.getFirstName());
            json.put("lastName", user.getLastName());
            json.put("displayName", user.getDisplayName());
            json.put("email", user.getEmail());
            json.put("userId", user.getUserName());
            String companyname = "";
            String position = "Employee";
            if (companyInfoStorage.getCompanyInfo() != null) {
                companyname = companyInfoStorage.getCompanyInfo().getCompanyName();
            }
            Profile uProfile = userId.getProfile();
            if (uProfile.getPhones() != null) {
                json.put("phone", uProfile.getPhones().get(0).get("value"));
            }
/*            HashMap<String, Object> uiMap = new HashMap<String, Object>();
            if (((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).size() > 0) {
                uiMap = ((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).get(0);
                json.put("company", uiMap.get(Profile.EXPERIENCES_COMPANY));
                json.put("position", uiMap.get(Profile.EXPERIENCES_POSITION));
            }*/
            if (!json.has("company") || json.get("company").equals("")) json.put("company", companyname);
            if (!json.has("position") || json.get("position").equals("")) json.put("position", position);
            if (uProfile.getAvatarUrl() != null)
                json.put("avatar", uProfile.getAvatarUrl());
            else
                json.put("avatar", DefaultAvatar);
            json.put("gcgroup", getGcGroup(userName));
            if (uProfile.getProperty("deleted") != null) json.put("deleted", uProfile.getProperty("deleted"));
            return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("senditb")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response sendItb(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam("addall") boolean addall, @QueryParam("bidscop") boolean bidScop,
                            BbMessage message) throws Exception {

        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ListenerService listenerService = (ListenerService) PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
        ProjectSubDAO projectSubDAO = (ProjectSubDAO) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class);

        Response tmpResponse = null;
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        Space project = spaceService.getSpaceByPrettyName(message.getProjectId());
        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        StaffEntity staff = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());

        if (addall) {


            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

            MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
            LOG.info("Conversation state messaging in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
            String bidscoped = "no";
            if (bidScop == true) bidscoped = "yes";
            MessagingRunner messagingRunner = new MessagingRunner(project, portalContainerName, message, ConversationState.getCurrent().getIdentity(), false, Util.getBaseUrl(), bidscoped, ConversationState.getCurrent());
            Thread messagingRunnerThread = new Thread(messagingRunner, "Messaging Runner Thread");
            messagingRunnerThread.start();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Mails sent");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } else {
            //Changes user status to NOT_MESS
            tmpResponse = addEveryone(request, response, uriInfo, message.getProjectId(), message.getRelations());

            if (tmpResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return tmpResponse;
            }

            List<ProjectSubEntity> relations = new ArrayList<ProjectSubEntity>();

            for (String subCat : message.getRelations()) {
                SubCatEntity subcat_ = subCatStorage.getSubCat(subCat);

                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    ProjectSubEntity relationShip = projectSubRelationShipStorage.getRelationShip(subcat_.getSubContractor().getId(), message.getProjectId(), subcat_.getCategory().getId());


                    if (relationShip.getStatus().equals("NOT_MESS")) {
                        relations.add(relationShip);
                    }
                }
            }


            if (relations.size() == 0) {
                return tmpResponse;
            }

            //Send email if the status was previously "NOT_MESS" and change status to "INVITED"
            // tmpResponse = addNonMsgd(request,response,uriInfo,projectId,gcHost,projectUrl,relations);
/*            BbMessage bbMessage = message;
            bbMessage.setAddNonInv(true);
            bbMessage.setRelations(relations);

            tmpResponse = sendMessage(request, response, uriInfo, false, bidScop, bbMessage);*/
            for (ProjectSubEntity projectSubEntity : relations) {

                spaceService.addMember(project, projectSubEntity.getSubContractor().getId());
                projectSubEntity.setStatus("INVITED");
                projectSubDAO.update(projectSubEntity);

                listenerService.broadcast("sendItb", projectSubEntity, sourceIdentity.getRemoteId());

            }

        }

        return tmpResponse;

    }

    private Response addEveryone(HttpServletRequest request, HttpServletResponse response, UriInfo uriInfo, String projectId, List<String> relations) throws Exception {
        BbFilteredSearchRequest searchRequest = new BbFilteredSearchRequest();
        searchRequest.setSubcats(relations);
        return addEveryone(request, response, uriInfo, projectId, false, searchRequest);
    }

    @POST
    @Path("addeveryone/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addEveryone(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @PathParam("projectId") String projectId,
                                @QueryParam("addall") boolean addall,
                                BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        UserHandler uh = orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        List<String> subCats = searchRequest.getSubcats();

        try {
            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn("Project not found");
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            //Invite all selected users to join the Project
            Boolean isMulti = false;
            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));

            if (addall) {
                LOG.info("Conversation state subcat in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant"));

                SubCatRunner subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.PROJECT_SUB, ConversationState.getCurrent());

                Thread createSubCatRelation = new Thread(subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();

                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", searchRequest.getTotRecords() + " Company Contacts have now been added to your project " + project.getPrettyName() + " To message those vendors please click on the \"Not Yet Invited\" tab");
                LOG.info(jsonGlobal.get("message"));
                return Response.ok(jsonGlobal.toString(), mediaType).build();
            }

            for (String subcat : subCats) {

                SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "NOT_MESS", "", subcat_.getSubContractor().getRank(), "no");
                } else LOG.warn("Sub Id or categorie is null, relationship will not be created");

            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }

    }

    @POST
    @Path("addtoproject/{projectId}/{status}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addToProject(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 @PathParam("projectId") String projectId,
                                 @PathParam("status") String status,
                                 @QueryParam("gcHost") String gcHost,
                                 @QueryParam("projectUrl") String projectUrl,
                                 List<String> subCats) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        UserHandler uh = orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        int i = 0;
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                LOG.warn("Project not found");
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

            //Invite all selected users to join the Project
            Boolean isMulti = false;


            if (status.equals("invited")) {
                status = "INVITED";

            } else if (status.equals("rev")) {
                status = "REVIEWING";

            } else if (status.equals("bid")) {
                status = "BIDDING";

            } else if (status.equals("nbid")) {
                status = "NOT_BIDDING";

            } else if (status.equals("submit")) {
                status = "AWARDED";

            } else {
                return Response.status(Response.Status.BAD_REQUEST).entity("status should be in: {notmess,invited,rev,nbid,submit} ").build();

            }


            for (String subcat : subCats) {


                SubCatEntity subcat_ = subCatStorage.getSubCat(subcat);
                if (subcat_.getSubContractor().getId() != "" && subcat_.getCategory().getId() != "") {
                    try {
                        User user_ = uh.findUserByName(subcat_.getSubContractor().getId());
                        projectUrl = projectUrl.replaceAll("portal/", "");
                        Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), true);
                        Profile prProfile = prIdentity.getProfile();
                        Profile uProfile = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(OrganizationIdentityProvider.NAME, user_.getUserName(), true).getProfile();
                        uProfile.setProperty("itbsent", (new SimpleDateFormat("dd/MM/yy")).format(Utils.getTime()));
                        Util.getIdentityManager(portalContainerName).updateProfile(uProfile);
                        String url = "http://" + gcHost + "/portal/invitations?userName=" + subcat_.getSubContractor().getId() + "&initialURI=" + projectUrl + "/projectSettings";
                        String to = user_.getUserName();
                        String subject = "Invitation to bid on the " + project.getPrettyName() + " project";
                        String mailText = " <div align=center>\n" +
                                "\n" +
                                "        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:90%; max-width:790px;\">\n" +
                                "          <tr>\n" +
                                "            <td width=\"100%\" style=\"border-top: 4px solid #707070; border-right: 4px solid #707070; border-bottom: 4px solid #707070; border-left: 4px solid #707070; padding: 8px 12px;\">\n" +
                                "\n" +
                                "\n" +
                                "        \t\t\n" +
                                "                  <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"8\">\n" +
                                "                    <tr>\n" +
                                "                      <td width=\"50%\" align=\"left\" style=\" border-right: 1px solid #c2c2c2;  border-bottom: 1px solid #c2c2c2;\">\n" +
                                "   \n" +
                                "                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n" +
                                "                          <tr>\n" +
                                "                            <td colspan=\"2\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px\">INVITATION TO BID</td>             \n" +
                                "                          </tr>\n" +
                                "                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>To</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + uProfile.getProperty("company") + "</td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>ATTN</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getDisplayName() + "</td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b>&nbsp;&nbsp;&nbsp;</td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(123) 456-7890</td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Email</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getEmail() + "</td>\n" +
                                "                          </tr>\n" +
                                "                        </table>\n" +
                                "                      </td>\n" +
                                "                      <td width=\"50%\" align=\"center\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; border-bottom: 1px solid #c2c2c2; padding-left: 18px\">\n" +
                                "                        <IMG style=\"-ms-interpolation-mode: bicubic; width:55%; max-width:180px; max-height:60px\"\n" +
                                "                        border=0 \n" +
                                "                        \n" +
                                "                        align=\"middle\" src=\"http://" + gcHost + "/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png\">\n" +
                                "                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n" +
                                "\n" +
                                "                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>From</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">General Contractor Inc<br><a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">ProView Listing</a></td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Contact</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getFullName() + "</td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Title</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getPosition() + "</td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b></td>\n" +
                                "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(866) 558-5515 / (866) 558-5516</td>\n" +
                                "                          </tr>\n" +
                                "                          <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                                "                        </table>\n" +
                                "                      </td>\n" +
                                "                    </tr>\n" +
                                "                    <tr>\n" +
                                "                      <td colspan=\"2\" align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                        Hi, <b>" + user_.getFirstName() + "</b>,\n" +
                                "                        <br><br>\n" +
                                "                        We have selected your company to submit a bid on the project listed below.  Please click on the &#8216;Project Details&#8217; for the full project overview and documents.\n" +
                                "                      </td>\n" +
                                "                    </tr>\n" +
                                "                    <tr>\n" +
                                "                      <td colspan=\"2\">\n" +
                                "                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n" +
                                "                          <tr>\n" +
                                "                            <td width=\"15.5%\" valign=\"top\"><img style=\"-ms-interpolation-mode: bicubic; width:100%; max-width:101px; max-height:101px\"\n" +
                                "                                border=0 \n" +
                                "                                alt=\"\" \n" +
                                "                                align=middle src=\"http://\"" + gcHost + project.getAvatarUrl() + ">\n" +
                                "                            </td>\n" +
                                "                            <td width=\"84.5%\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px; line-height: 18px;\">\n" +
                                "                              <b>" + project.getDisplayName() + "</b><br>\n" +
                                "                              <span style=\"font-size: 14px; line-height: 16px;\">" + prProfile.getProperty("adress") + "</span>\n" +
                                "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n" +
                                "                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Bids Due</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    " + prProfile.getProperty("bidsDueDate") + "\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Start Date:</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                   " + prProfile.getProperty("startDate") + "\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                                "                              </table>\n" +
                                "                            </td>\n" +
                                "                          </tr>\n" +
                                "                          <tr>\n" +
                                "                            <td colspan=\"2\">\n" +
                                "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n" +
                                "                                \n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Project Status</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                   " + prProfile.getProperty("projectStatus") + "\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Number of Buildings</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    " + prProfile.getProperty("nbBuildings") + "\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Stories above ground</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    " + prProfile.getProperty("storiesAboveGrd") + "\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Square Footage</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    " + prProfile.getProperty("totalSqFt") + " sq. ft.\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" width=\"30%\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    <b>Project Description</b>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                                "                                    " + project.getDescription() + "\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td colspan=\"2\" align=\"center\" valign=\"middle\" bgcolor=\"#e0e0e0\" style=\"border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2; padding: 8px 0px\">\n" +
                                "                                    <a href=\"" + url + "\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:184px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/details.jpg\" target=\"_blank\"></a>\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td colspan=\"2\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; padding: 10px 0px\">\n" +
                                "                                    You&#8217;ve been selected to bid on the following trade(s). Please respond by clicking on one of the options below.\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr>  \n" +
                                "                              </table>\n" +
                                "\n" +
                                "                              <h1 style=\"text-align: center;\">" + bBCategoryStorage.getBBCategory(subcat_.getCategory().getId()).getCatCsiDesc() + "</h1>            \n" +
                                "\n" +
                                "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n" +
                                "                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"right\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + subcat_.getCategory().getId() + "/" + subcat_.getSubContractor().getId() + "/NOT_BIDDING\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"center\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + subcat_.getCategory().getId() + "/" + subcat_.getSubContractor().getId() + "/UNDECIDED\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + subcat_.getCategory().getId() + "/" + subcat_.getSubContractor().getId() + "/BIDDING\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td colspan=\"3\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; padding: 10px 0px;\">\n" +
                                "                                    If you no longer would lid to receive bid invitations <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">click here</a> or call (888) 303-2243\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                              </table>\n" +
                                "\n" +
                                "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" bgcolor=\"#055092\">\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"left\" bgcolor=\"#055092\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:110px; height:44px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/tbb.jpg\">\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" valign=\"middle\" bgcolor=\"#055092\" style=\"font-family:Helvetica, Arial, sans-serif; color:#FFFFFF; font-size: 12px;\">\n" +
                                "                                    <b>AndersonConstruction, Inc</b> has shared this project opportunity with you using BB-Build.  If you need  technical help, please call BB-Build Support at (888) 303-2243\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                              </table>\n" +
                                "                            </td>\n" +
                                "                          </tr>\n" +
                                "                        </table>\n" +
                                "                      </td>\n" +
                                "                    </tr>\n" +
                                "                  </table>\n" +
                                "          \n" +
                                "  \n" +
                                "\n" +
                                "\n" +
                                "        </td>\n" +
                                "        </tr>\n" +
                                "        </table>\n" +
                                "\n" +
                                "    </div>";
                        if (sendMail(to, subject, mailText, false)) {
                            spaceService.addInvitedUser(project, subcat_.getSubContractor().getId());
                            projectSubRelationShipStorage.createProjectSubRelationShip(subcat_, project.getPrettyName(), "NOT_MESS", "", subcat_.getSubContractor().getRank(), "no");

                        }
                    } catch (Exception e) {
                        LOG.error(e.getMessage(), e);
                        i++;
                    }
                } else LOG.warn("Sub Id or categorie is null, relationship will not be created");

            }
            JSONObject jsonGlobal = new JSONObject();
            if (i == 0) {
                jsonGlobal.put("message", "Company Contacts have now been added to your project. To message those vendors please click on the \"Not Yet Invited\" tab");
            } else {
                jsonGlobal.put("message", "Some vendors were not added to the project, Please contact the support for assistance");
            }
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }

    }

    @POST
    @Path("importusers")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response importUsers(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @QueryParam("projectid") String projectId,
                                List<SubContractor> users) throws Exception {
        if (users == null)
            return Response.status(Response.Status.BAD_REQUEST).entity("Please select a CSV file").build();

        LOG.info("service started");
        LOG.info(orgService.getClass().getName());
        Long start = System.currentTimeMillis();
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Node catLocationNode = null;
        Node subCatLocationNode = null;
        Node subUserInfoLocationNode = null;
        try {
            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            Session session = manageableRepository.getSystemSession("social");
            Node socialProductionNode = (Node) session.getItem("/production");

            if (!socialProductionNode.hasNode("bbcategories")) {
                catLocationNode = socialProductionNode.addNode("bbcategories", "tbb:catLocation");
                catLocationNode.addMixin("mix:referenceable");
                catLocationNode.getSession().save();
            } else {
                catLocationNode = socialProductionNode.getNode("bbcategories");
            }

            if (!socialProductionNode.hasNode("subcategories")) {
                subCatLocationNode = socialProductionNode.addNode("subcategories", "tbb:subCatLocation");
                subCatLocationNode.addMixin("mix:referenceable");
                subCatLocationNode.getSession().save();
            } else {
                subCatLocationNode = socialProductionNode.getNode("subcategories");
            }

            if (!socialProductionNode.hasNode("subUserInfos")) {
                subUserInfoLocationNode = socialProductionNode.addNode("subUserInfos", "tbb:subUserInfoLocation");
                subUserInfoLocationNode.addMixin("mix:referenceable");
                subUserInfoLocationNode.getSession().save();
            } else {
                subUserInfoLocationNode = socialProductionNode.getNode("subUserInfos");
            }

            int i = 0;
            boolean save = false;
            try {
                for (SubContractor userIn : users) {

                    String name = "gc_" + userIn.getUserid();
                    String categories = "";
                    String categoriesId = "";
                    name = name.toLowerCase();
                    boolean ch = true;
                    name = name.replace(" ", "");
                    name = name.replace(".", "");
                    if (userIn.getCompany() != null) {
                        userIn.setCompany(StringEscapeUtils.unescapeHtml(userIn.getCompany()));
                    }
                    createUserInfo(subUserInfoLocationNode, name, userIn, false);
                    if (userIn.getCategories() != null) {
                        userIn.setCategories(StringEscapeUtils.unescapeHtml(userIn.getCategories()));
                        for (String cat : userIn.getCategories().split("\\^")) {

                            try {
                                String catId = cat.toLowerCase();

                                while (ch == true) {
                                    ch = false;
                                    if (!isLowerCaseLetterOrDigit(catId.charAt(catId.length() - 1))) {
                                        catId = catId.substring(0, catId.length() - 1);
                                        ch = true;
                                    }

                                }

                                catId = catId.replace(" ", "");
                                if (!catId.split("\\|")[0].equals("")) catId = catId.split("\\|")[0];

                                if (cat.split("\\|").length > 1) {
                                    createBBCategory(catLocationNode, catId, cat.split("\\|")[1], "", "", "", save);
                                    if (!createSubCat(subCatLocationNode, name, catId, userIn, "0", "", "", cat.split("\\|")[1], save))
                                        LOG.info("Vendor " + userIn.getFirstName() + " " + userIn.getLastName() + " with category " + cat.split("\\|")[1] + " already exists");


                                    if (categories.equals("")) {
                                        categories = cat.split("\\|")[1];
                                        categoriesId = catId;
                                    } else {
                                        categories = categories + ";" + cat.split("\\|")[1];
                                        categoriesId = categoriesId + ";" + catId;
                                    }
                                } else {
                                    createBBCategory(catLocationNode, catId, cat, "", "", "", save);
                                    if (!createSubCat(subCatLocationNode, name, catId, userIn, "0", "", "", cat, save))
                                        LOG.info("Vendor " + userIn.getFirstName() + " " + userIn.getLastName() + " with category " + cat + " already exists");
                                    if (categories.equals("")) {
                                        categories = cat;
                                        categoriesId = catId;
                                    } else {
                                        categories = categories + ";" + cat;
                                        categoriesId = categoriesId + ";" + catId;
                                    }
                                }
                            } catch (Exception e) {
                                LOG.error(e.getMessage(), e);
                            }

                        }
                    }

                    i++;

                    LOG.info(i);
                }
            } catch (Exception e) {
                LOG.error(e.getMessage(), e);
            } finally {
                catLocationNode.getSession().save();
                subCatLocationNode.getSession().save();
                subUserInfoLocationNode.getSession().save();
            }
            LOG.info("Conversation state import in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant"));

            ImportRunner importRunner = new ImportRunner(users, projectId, sourceIdentity, ConversationState.getCurrent());
            Thread importRunnerThread = new Thread(importRunner, "Import Runner Thread");
            importRunnerThread.start();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", i + " Users Imported");
            LOG.info("Importing done " + String.valueOf(System.currentTimeMillis() - start) + " ms");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("importbbusers")
    @Consumes({"application/json"})
    public Response importBbUsers(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                  @QueryParam("maxvendors") int maxVendors,
                                  BbSerachResult result)
            throws Exception {
        LOG.info("service started");
        LOG.info(this.orgService.getClass().getName());
        request.getRequestURI();
        Long start = Long.valueOf(System.currentTimeMillis());
        SpaceService spaceService = Util.getSpaceService("portal");
        org.exoplatform.social.core.identity.model.Identity sourceIdentity = Util.getIdentityManager("portal").getOrCreateIdentity("organization", result.getUid(), true);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Space project = null;
        User user_ = null;
        try {
            if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            if ((result.getProjectId() != null) && (!result.getProjectId().equals(""))) {
                project = spaceService.getSpaceByPrettyName(result.getProjectId());
                if (project == null) {
                    return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
                }
            }
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = manageableRepository.getSystemSession("social");
            Node socialProductionNode = (Node) session.getItem("/production");
            Node catLocationNode = null;
            Node subCatLocationNode = null;
            Node subUserInfoLocationNode = null;
            Node relationShipLocationNode = null;
            if (!socialProductionNode.hasNode("bbcategories")) {
                catLocationNode = socialProductionNode.addNode("bbcategories", "tbb:catLocation");
                catLocationNode.addMixin("mix:referenceable");
                catLocationNode.getSession().save();
            } else {
                catLocationNode = socialProductionNode.getNode("bbcategories");
            }
            if (!socialProductionNode.hasNode("subcategories")) {
                subCatLocationNode = socialProductionNode.addNode("subcategories", "tbb:subCatLocation");
                subCatLocationNode.addMixin("mix:referenceable");
                subCatLocationNode.getSession().save();
            } else {
                subCatLocationNode = socialProductionNode.getNode("subcategories");
            }
            if (!socialProductionNode.hasNode("subUserInfos")) {
                subUserInfoLocationNode = socialProductionNode.addNode("subUserInfos", "tbb:subUserInfoLocation");
                subUserInfoLocationNode.addMixin("mix:referenceable");
                subUserInfoLocationNode.getSession().save();
            } else {
                subUserInfoLocationNode = socialProductionNode.getNode("subUserInfos");
            }
            if (!socialProductionNode.hasNode("relationships")) {
                relationShipLocationNode = socialProductionNode.addNode("relationships", "tbb:relationShipLocation");
                relationShipLocationNode.addMixin("mix:referenceable");
                relationShipLocationNode.getSession().save();
            } else {
                relationShipLocationNode = socialProductionNode.getNode("relationships");
            }
            if (maxVendors == 0) maxVendors = 200;
            LOG.info("Number of Vendors saved per transaction = " + maxVendors);
            int i = 0;
            int j = 0;
            boolean save = false;
            try {
                for (SubContractor userIn : result.getVendors()) {
                    LOG.info("Importing user " + userIn.getFirstName() + " " + userIn.getLastName());

                    String name = "gc_" + userIn.getUserid();
                    String categories = "";
                    String categoriesId = "";
                    name = name.toLowerCase();
                    boolean ch = true;
                    name = name.replace(" ", "");
                    name = name.replace(".", "");
                    if (userIn.getCompany() != null) {
                        userIn.setCompany(StringEscapeUtils.unescapeHtml(userIn.getCompany()));
                    }

                    createUserInfo(subUserInfoLocationNode, name, userIn, false);
                    if (userIn.getCategories() != null) {
                        userIn.setCategories(StringEscapeUtils.unescapeHtml(userIn.getCategories()));

                        for (String cat : userIn.getCategories().split("\\^")) {
                            try {

                                String catId = cat.toLowerCase();
                                String catName = "";
                                while (ch == true) {
                                    ch = false;
                                    if (!isLowerCaseLetterOrDigit(catId.charAt(catId.length() - 1))) {
                                        catId = catId.substring(0, catId.length() - 1);
                                        ch = true;
                                    }

                                }
                                catId = catId.replace(" ", "");
                                if (!catId.split("\\|")[0].equals("")) {
                                    catId = catId.split("\\|")[0];
                                }
                                if (cat.split("\\|").length > 1) {
                                    catName = cat.split("\\|")[1];
                                } else {
                                    LOG.warn("A category found without pipe delimeter: " + cat);
                                    catName = cat;
                                }
                                createBBCategory(catLocationNode, catId, catName, "", "", "", save);
                                if (!createSubCat(subCatLocationNode, name, catId, userIn, "0", "", "", catName, save)) {
                                    LOG.info("Vendor " + userIn.getFirstName() + " " + userIn.getLastName() + " with category " + catName + " already exists");
                                }
                                if (categories.equals("")) {
                                    categories = catName;
                                    categoriesId = catId;
                                } else {
                                    categories = categories + ";" + catName;
                                    categoriesId = categoriesId + ";" + catId;
                                }
                                String status = "NOT_MESS";
                                if (project != null) {
                                    try {
                                        if (userIn.getStatus() != null) {
                                            if (userIn.getStatus().equals("notmess")) {
                                                status = "NOT_MESS";
                                            } else if (userIn.getStatus().equals("invited")) {
                                                status = "INVITED";
                                            } else if (userIn.getStatus().equals("rev")) {
                                                status = "REVIEWING";
                                            } else if (userIn.getStatus().equals("bid")) {
                                                status = "BIDDING";
                                            } else if (userIn.getStatus().equals("nbid")) {
                                                status = "NOT_BIDDING";
                                            } else if (userIn.getStatus().equals("submit")) {
                                                status = "SUBMITTED";
                                            } else {
                                                LOG.info("Unknown Status, the vendor will be added to the project with not messaged status");
                                            }
                                        }
                                        createProjectSubRelationShip(relationShipLocationNode, name, project.getPrettyName(), catId, catName, status, "0", userIn, save);

                                        LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " added to " + result.getProjectId());
                                    } catch (DuplicateNameException e) {
                                        LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " already invited, status has been changed ");
                                    }
                                }
                            } catch (Exception e) {
                                LOG.error(e.getMessage(), e);
                            }
                        }
                    }
                    i++;
                    j++;
                    LOG.info(Integer.valueOf(i));
                    if (j > maxVendors) {
                        catLocationNode.getSession().save();
                        subCatLocationNode.getSession().save();
                        subUserInfoLocationNode.getSession().save();
                        relationShipLocationNode.getSession().save();
                        j = 0;
                    }
                }
            } catch (Exception e) {
                LOG.error(e.getMessage(), e);
            } finally {
                catLocationNode.getSession().save();
                LOG.info("*Categories Created*");
                subCatLocationNode.getSession().save();
                LOG.info("*Categories Relations Created*");
                subUserInfoLocationNode.getSession().save();
                LOG.info("*Vendors Profiles Created*");
                relationShipLocationNode.getSession().save();
                LOG.info("*Vendors added to project*");
            }
            LOG.info("Conversation state import in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
            LOG.info("Conversation userid import in rest:   " + ConversationState.getCurrent().getIdentity().getUserId());
            LOG.info("request url import in rest:   " + request.getRequestURL().toString());

            if (System.getProperty(MASTER_HOST_VARIABLE_NAME) != null && ConversationState.getCurrent().getAttribute("currentTenant") == null) {

                ConversationState.getCurrent().setAttribute("currentTenant", getTenantName(request.getRequestURL().toString()));

            }
            ImportRunner importRunner = new ImportRunner(result.getVendors(), result.getProjectId(), sourceIdentity, ConversationState.getCurrent());
            Thread importRunnerThread = new Thread(importRunner, "Import Runner Thread");
            importRunnerThread.start();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", i + " Users Imported");
            LOG.info("Importing done " + String.valueOf(System.currentTimeMillis() - start.longValue()) + " ms");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
    }

    @POST
    @Path("importbidscoped/{projectId}")
    @Consumes({"application/json"})
    public Response importBidScoped(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                    @PathParam("projectId") String projectId,
                                    SubContractor userIn)
            throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            LOG.warn("UNAUTHORIZED");
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        LOG.info(this.orgService.getClass().getName());
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        UserHandler uh = orgService.getUserHandler();
        MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
        GroupHandler gHandler = orgService.getGroupHandler();
        MembershipHandler mHandler = orgService.getMembershipHandler();
        request.getRequestURI();
        SpaceService spaceService = Util.getSpaceService("portal");
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Space project = null;
        User user_ = null;

        if ((projectId != null) && (!projectId.equals(""))) {
            project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
        }

        try {
            LOG.info("Importing user " + userIn.getFirstName() + " " + userIn.getLastName() + " from BidScop");
            String name = "gc_" + userIn.getUserid();
            String categories = "";
            String categoriesId = "";
            name = name.toLowerCase();
            boolean ch = true;
            name = name.replace(" ", "");
            name = name.replace(".", "");
            if (userIn.getCompany() != null) {
                userIn.setCompany(StringEscapeUtils.unescapeHtml(userIn.getCompany()));
            }
            Query query = new Query();
            query.setEmail(userIn.getEmail().toLowerCase());

            try {
                if (!orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                    if (uh.findUserByName(name) == null) {
                        user_ = uh.findUsersByQuery(query).load(0, 1)[0];
                        LOG.warn(userIn.getEmail() + " already exists, Email should be changed");
                        String newEmail = "change_me" + user_.getUserName() + "@gmail.com";
                        user_.setEmail(newEmail);
                        startRequest();
                        uh.saveUser(user_, true);
                        endRequest();

                    }
                }
            } catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
            try {
                if (uh.findUserByName(name) != null) {
                    startRequest();
                    user_ = uh.findUserByName(name);

                    user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
                    user_.setPassword(name);
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.saveUser(user_, true);
                    endRequest();

                } else {
                    startRequest();
                    user_ = uh.createUserInstance(name);
                    user_.setDisplayName(userIn.getDisplayName());
                    user_.setPassword(name);
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.createUser(user_, true);
                    Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                    mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                    Group usersGroup = gHandler.findGroupById("/platform/users");
                    mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                    LOG.info("SubContractor " + userIn.getDisplayName() + " imported");
                    LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " created");
                }
            } catch (Exception e) {

                LOG.error(e.getMessage(), e);
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();

            } finally {
                endRequest();
            }
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(name, userIn);
            if (userIn.getCategories() != null) {
                userIn.setCategories(StringEscapeUtils.unescapeHtml(userIn.getCategories()));

                for (String cat : userIn.getCategories().split("\\^")) {
                    try {

                        String catId = cat.toLowerCase();
                        String catName = "";
                        while (ch == true) {
                            ch = false;
                            if (!isLowerCaseLetterOrDigit(catId.charAt(catId.length() - 1))) {
                                catId = catId.substring(0, catId.length() - 1);
                                ch = true;
                            }

                        }
                        catId = catId.replace(" ", "");
                        if (!catId.split("\\|")[0].equals("")) {
                            catId = catId.split("\\|")[0];
                        }
                        if (cat.split("\\|").length > 1) {
                            catName = cat.split("\\|")[1];
                        } else {
                            LOG.warn("A category found without pipe delimeter: " + cat);
                            catName = cat;
                        }
                        bBCategoryStorage.createBBCategory(catId, catName, "", "", "");
                        SubCatEntity subCat = subCatStorage.createSubCat(name, catId, subUserInfo, "0", "", "", catName);
                        if (categories.equals("")) {
                            categories = catName;
                            categoriesId = catId;
                        } else {
                            categories = categories + ";" + catName;
                            categoriesId = categoriesId + ";" + catId;
                        }
                        String status = "NOT_MESS";
                        if (project != null) {
                            try {
                                if (userIn.getStatus() != null) {
                                    if (userIn.getStatus().equals("notmess")) {
                                        status = "NOT_MESS";
                                    } else if (userIn.getStatus().equals("invited")) {
                                        status = "INVITED";
                                    } else if (userIn.getStatus().equals("rev")) {
                                        status = "REVIEWING";
                                    } else if (userIn.getStatus().equals("bid")) {
                                        status = "BIDDING";
                                    } else if (userIn.getStatus().equals("nbid")) {
                                        status = "NOT_BIDDING";
                                    } else if (userIn.getStatus().equals("submit")) {
                                        status = "SUBMITTED";
                                    } else {
                                        LOG.info("Unknown Status, the vendor will be added to the project with not messaged status");
                                    }
                                }
                                projectSubRelationShipStorage.createProjectSubRelationShip(subCat, project.getPrettyName(), status, "", "0", "yes");
                                if (!userIn.getStatus().equals("notmess")) {
                                    Utils.addToSpace(project, user_.getUserName());
                                }
                                LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " added to " + projectId);
                            } catch (DuplicateNameException e) {
                                LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " already invited, status has been changed ");
                            }
                        }
                    } catch (Exception e) {
                        LOG.error(e.getMessage(), e);
                    }
                }
            }
            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage) PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);
            simpleNotifServiceStorage.createSimpleNotification(project.getEditor(), "New Vendor is imported fom Bidscop", BSIMPORT_NOTIF_TYPE, 1);
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("accessUrl", URI.create(Util.getBaseUrl() + "/portal/invitations?userName=" + name + "&initialURI=/g/:spaces:" + projectId + "/" + projectId + "/projectSettings"));
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("create")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                               SubContractor userIn) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());

        if (staffEntity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubGcStorage subGcStorage = (SubGcStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
        CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        UserHandler uh = orgService.getUserHandler();
        MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
        GroupHandler gHandler = orgService.getGroupHandler();
        MembershipHandler mHandler = orgService.getMembershipHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();

        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);

            if (userIn.getUnion() == "true") {
                userIn.setUnion("yes");
            }
            if (userIn.getUnion() == "false") {
                userIn.setUnion("no");
            }
            if (userIn.getUnion() == "") {
                userIn.setUnion("unknown");
            }

            if (userIn.getNonUnion() == "true") {
                userIn.setNonUnion("yes");
            }
            if (userIn.getNonUnion() == "false") {
                userIn.setNonUnion("no");
            }
            if (userIn.getNonUnion() == "") {
                userIn.setNonUnion("unknown");
            }
            // Before Creating user, chek if the userName and the email are alredy used or not

            Query query = new Query();
            query.setEmail(userIn.getEmail());
            if (!orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                LOG.warn("A Vendor with the email: " + userIn.getEmail() + " exists");
                return Response.status(Response.Status.BAD_REQUEST).entity("A Vendor with the email: " + userIn.getEmail() + " exists").build();
            }

            String name = "gc_" + String.valueOf(date.getTime());
            while (!isLowerCaseLetter(name.charAt(0))) {
                name = name.substring(1);
            }

            startRequest();

            //Creation of the new user

            User user = uh.createUserInstance(name);
            user.setPassword(name);
            user.setEmail(userIn.getEmail());
            user.setLastName(userIn.getLastName());
            user.setFirstName(userIn.getFirstName());
            user.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
            uh.createUser(user, true);

            //SubContractor is created
            //Adding new user to the sub group

            Group subGroup = gHandler.findGroupById("/organization/subcontractors");
            mHandler.linkMembership(user, subGroup, mtHandler.findMembershipType("member"), false);
            if (userIn.getWebSite() != null && !userIn.getWebSite().equals("") && !userIn.getWebSite().contains("http"))
                userIn.setWebSite("http://" + userIn.getWebSite());
            if (userIn.getProview() != null && !userIn.getProview().equals("") && !userIn.getProview().contains("http"))
                userIn.setProview("http://" + userIn.getProview());
            //Create UserInfo node
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(name, userIn);
            //Create eXo Social Identity for the new user
            Profile uProfile = null;
            try {
                Identity userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user.getUserName(), true);
                uProfile = userIdentity.getProfile();
            } catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }

/*            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<HashMap<String, Object>> experiences = new ArrayList<HashMap<String, Object>>();
            map.put(Profile.EXPERIENCES_COMPANY, userIn.getCompany());
            map.put(Profile.EXPERIENCES_POSITION, "Employee");
            experiences.add(map);
            uProfile.setProperty(Profile.EXPERIENCES, experiences);*/
            if (userIn.getAvatar() != null && userIn.getAvatar().compareTo(DefaultAvatar) != 0) {
                try {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService) PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String userId = (state != null) ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && userIn.getAvatar().contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment(inputStream,
                                200,
                                0,
                                null,
                                "avatar",
                                "image/png",
                                null);
                        uProfile.setProperty(Profile.AVATAR, avatar);
                    }
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    throw e;
                }
                identityManager.updateProfile(uProfile);
            }
            Util.getIdentityManager(portalContainerName).updateProfile(uProfile);
            //Create Categories
            // Create SubCatGc

            String[] categoriesId = userIn.getCategoriesId().split(";");
            String[] categories = userIn.getCategories().split(";");
            if (userIn.getCategoriesId() != null && userIn.getCategoriesId().compareTo("") != 0) {
                for (int i = 0; i < categoriesId.length; i++) {

                    if (bBCategoryStorage.getBBCategory(categoriesId[i]) == null) {
                        CategoryEntity cat = bBCategoryStorage.createBBCategory(categoriesId[i], categories[i], "", "", "");
                        SubCatEntity subCatEntity = subCatStorage.createSubCat(name, cat, subUserInfo, "0");
                        String idSubCatGC = staffEntity.getId() + "_" + subCatEntity.getId();
                        //subGcStorage.createSubGc(idSubCatGC,subCatEntity,staffEntity.getGeneralContractorEntity());
                    }
                }

            }

            LOG.info("SubContractor " + userIn.getFirstName() + " " + userIn.getFirstName() + " imported");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("createsub")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                              SubContractor userIn) throws Exception {


        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        SubGcStorage subGcStorage = (SubGcStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
        GeneralContractorDAO generalContractorDAO = (GeneralContractorDAO) PortalContainer.getInstance().getComponentInstanceOfType(GeneralContractorDAO.class);
        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            Query query = new Query();
            query.setEmail(userIn.getEmail());
            if (uh.findUsersByQuery(query).getSize() > 0) {
                LOG.warn("A Vendor with the email: " + userIn.getEmail() + " exists");
                return Response.status(Response.Status.BAD_REQUEST).entity("A Vendor with the email: " + userIn.getUserid() + " exists").build();
            }
            if (uh.findUserByName(userIn.getUserid()) != null) {
                LOG.warn("A Vendor with the login  exists");
                return Response.status(Response.Status.BAD_REQUEST).entity("A Vendor with the email: " + userIn.getUserid() + " exists").build();
            }
            startRequest();
            //Creation of the new user
            User user = uh.createUserInstance(userIn.getUserid());
            user.setPassword(userIn.getPassword());
            user.setEmail(userIn.getEmail());
            user.setLastName(userIn.getLastName());
            user.setFirstName(userIn.getFirstName());
            user.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
            uh.createUser(user, true);
            SubStaffCompanyDAO subStaffCompanyDAO = getService(SubStaffCompanyDAO.class, null);
            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(userIn.getUserid(), userIn);
            SubStaffCompanyEntity subStaffCompanyEntity = new SubStaffCompanyEntity(subUserInfo, userIn.getUserid());
            subStaffCompanyDAO.create(subStaffCompanyEntity);

            LOG.info("SubContractor " + userIn.getFirstName() + " " + userIn.getFirstName() + " imported");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


    @POST
    @Path("createsubcompany")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createsubcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                     SubContractor userIn) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        SubGcStorage subGcStorage = (SubGcStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
        GeneralContractorDAO generalContractorDAO = (GeneralContractorDAO) PortalContainer.getInstance().getComponentInstanceOfType(GeneralContractorDAO.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            //Create Categories
            userIn.setUserid(userIn.getCompany().replaceAll("\\W", ""));
            SubContractorEntity subUserInfo = subUserInfoStorage.updateSubUserInfo(userIn.getUserid(), userIn);
            if (userIn.getSelectedCats() != null) {
                for (String cat : userIn.getSelectedCats()) {
                    CategoryEntity cat_ = bBCategoryStorage.getBBCategory(cat);
                    if (cat_ != null) {
                        String subcatis = cat_.getId() + userIn.getUserid();
                        SubCatEntity subCatEntity = subCatStorage.createSubCat(subcatis, cat_, subUserInfo, "0");


                    }
                }

            }

            LOG.info("SubContractor imported");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }

    @POST
    @Path("editsubcompany")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response editsubcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                   SubContractor userIn) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        GeneralContractorDAO generalContractorDAO = (GeneralContractorDAO) PortalContainer.getInstance().getComponentInstanceOfType(GeneralContractorDAO.class);
        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            //Create Categories

            SubContractorEntity subUserInfo = subUserInfoStorage.createSubUserInfo(userIn.getUserid(), userIn);
            LOG.info("SubCompany created");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " Company Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


   /* @GET
    @Path("getcompanyinfo")
    public Response getcompanyinfo(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, String userid) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubContractorDAO subContractorDAO = getService(SubContractorDAO.class,null);

        return Response.ok(subUserInfoStorage.getSubUserInfo(userid), mediaType).build();
    }*/


    @GET
    @Path("getsubcompany")
    public Response getsubcompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        JSONObject jsonGlobal = new JSONObject();
        JSONArray jsonArray = new JSONArray();

        SubContractorDAO subContractorDAO = getService(SubContractorDAO.class, null);

        return Response.ok(subContractorDAO.getAll(0, 0), mediaType).build();
    }

    @POST
    @Path("createcats")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createCats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                               CategoryEntity[] cats) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);


        try {

            for (CategoryEntity category : cats) {

                if (bBCategoryStorage.getBBCategory(category.getId()) == null) {
                    CategoryEntity cat = bBCategoryStorage.createBBCategory(category.getId(), category.getCatCsiDesc(), "", "", "");
                }
            }


            LOG.info("cats  imported");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


    @GET
    @Path("getallcats")
    public Response getAllCats(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        try {
            List<CategoryEntity> cats = bBCategoryStorage.getBBCategories(0, 0);
            List<Category> catsDTOs = new ArrayList<>();
            for (CategoryEntity cat : cats) {
                catsDTOs.add(bBCategoryStorage.convert(cat));
            }
            return Response.ok(catsDTOs, mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


    @POST
    @Path("creategc")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createGCUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 Map<String, String> gcuser) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            String name = gcuser.get("userId");
            //name = name.toLowerCase().trim();
            User user = null;
            Identity userIdentity = null;
            Profile uProfile = null;
            // Before Creating user, check if the userName and the email are already used or not
            if (uh.findUserByName(name) != null) {
                userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, name, true);
                uProfile = userIdentity.getProfile();
                if (uProfile.getProperty("deleted") == null || uProfile.getProperty("deleted").equals("true")) {
                    user = uh.findUserByName(name);
                    startRequest();
                    user.setPassword(gcuser.get("password"));
                    uh.saveUser(user, true);
                    endRequest();
                    uProfile.setProperty("deleted", "false");
                } else {
                    LOG.warn(name + " user name already exists, SubContractor will not be Created");
                    return Response.status(Response.Status.BAD_REQUEST).entity(gcuser.get("firstname") + gcuser.get("lastname") + " user name already exists, SubContractor will not be Created").build();

                }
            }
            if (user != null) {
                Query query = new Query();
                query.setEmail(gcuser.get("email"));
                if (!orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                    userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, uh.findUsersByQuery(query).load(0, 1)[0].getUserName(), true);
                    uProfile = userIdentity.getProfile();
                    if (uProfile.getProperty("deleted") != null && uProfile.getProperty("deleted").toString().equals("true")) {
                        user = uh.findUserByName(userIdentity.getRemoteId());
                        startRequest();
                        user.setPassword(gcuser.get("password"));
                        uh.saveUser(user, true);
                        endRequest();
                        uProfile.setProperty("deleted", "false");
                    } else {
                        LOG.warn(gcuser.get("email") + " already exists, SubContractor will not be Created");
                        return Response.status(Response.Status.BAD_REQUEST).entity(gcuser.get("email") + " already exists, SubContractor will not be Created").build();
                    }
                }
            }
            if (user == null) {
                startRequest();
                //Creation of the new user

                user = uh.createUserInstance(name);
                user.setDisplayName(gcuser.get("firstname") + " " + gcuser.get("lastname"));
                user.setPassword(gcuser.get("password"));
                user.setEmail(gcuser.get("email"));
                user.setLastName(gcuser.get("lastname"));
                user.setFirstName(gcuser.get("firstname"));
                uh.createUser(user, true);
                userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user.getUserName(), true);
                uProfile = userIdentity.getProfile();
                //Create the SubContractor Identity to be able to add properties to the user profile
            }
            //Update Phone
            if (gcuser.get("phone").compareTo("") != 0) {
                List<Map<String, String>> phones = new ArrayList<Map<String, String>>();
                Map<String, String> phone1 = new HashMap<String, String>();
                phone1.put("key", "Work");
                phone1.put("value", gcuser.get("phone"));
                phones.add(phone1);
                uProfile.setProperty(Profile.CONTACT_PHONES, phones);
            }
/*            if (gcuser.get("company").compareTo("") != 0) {
                ArrayList<HashMap<String, Object>> experiences = new ArrayList<HashMap<String, Object>>();
                HashMap<String, Object> uiMap = new HashMap<String, Object>();
                uiMap.put(Profile.EXPERIENCES_COMPANY, StringEscapeUtils.escapeHtml(gcuser.get("company")));
                if (gcuser.get("position").compareTo("") != 0) {
                    uiMap.put(Profile.EXPERIENCES_POSITION, StringEscapeUtils.escapeHtml(gcuser.get("position")));
                }
                experiences.add(uiMap);
                uProfile.setProperty(Profile.EXPERIENCES, experiences);
            }*/
            //Upload avatar
            if (gcuser.get("avatar").compareTo(DefaultAvatar) != 0) {
                try {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService) PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String userId = (state != null) ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment(inputStream,
                                200,
                                0,
                                null,
                                "avatar",
                                "image/png",
                                null);
                        uProfile.setProperty(Profile.AVATAR, avatar);
                    }
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    throw e;
                }
            }
            String gcgroup = (gcuser.get("gcgroup") != "" && gcuser.get("gcgroup") != null) ? gcuser.get("gcgroup") : "gcmember";
            if (gcgroup != "" && gcgroup != null) {
                GroupHandler gh = orgService.getGroupHandler();
                MembershipHandler mh = orgService.getMembershipHandler();
                MembershipTypeHandler mth = orgService.getMembershipTypeHandler();
                mh.linkMembership(user, gh.findGroupById("/organization/gcs"), mth.findMembershipType(gcgroup), true);
            }
            identityManager.updateProfile(uProfile);
            User user_ = uh.findUserByName(user.getUserName());
            if (gcuser.get("projectId") != null) {
                try {
                    SpaceService spaceService = Util.getSpaceService(portalContainerName);
                    Space project = spaceService.getSpaceByPrettyName(gcuser.get("projectId"));
                    Utils.addToSpace(project, user_.getUserName());
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            LOG.info("SubContractor " + gcuser.get("firstname") + gcuser.get("lastname") + " created");
            endRequest();
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("update/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response updateUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                               @PathParam("userName") String userName,
                               SubContractor userIn) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);

        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);

            if (userIn.getUnion() == "true") {
                userIn.setUnion("yes");
            }
            if (userIn.getUnion() == "false") {
                userIn.setUnion("no");
            }
            if (userIn.getUnion() == "") {
                userIn.setUnion("unknown");
            }

            if (userIn.getNonUnion() == "true") {
                userIn.setNonUnion("yes");
            }
            if (userIn.getNonUnion() == "false") {
                userIn.setNonUnion("no");
            }
            if (userIn.getNonUnion() == "") {
                userIn.setNonUnion("unknown");
            }
            // Before updating  user, check if the userName exists or not

            User user_ = uh.findUserByName(userName);
            if (user_ == null) {
                startRequest();
                MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
                GroupHandler gHandler = orgService.getGroupHandler();
                MembershipHandler mHandler = orgService.getMembershipHandler();
                ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
                //Creation of the new user

                user_ = uh.createUserInstance(userName);
                user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());

                if (orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                    user_.setPassword(Utils.getMd5(userName));
                } else {
                    user_.setPassword(userName);
                }
                user_.setEmail(userIn.getEmail());
                user_.setLastName(userIn.getLastName());
                user_.setFirstName(userIn.getFirstName());
                Date now = new Date();
                user_.setCreatedDate(now);
                uh.createUser(user_, false);
                Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                Group usersGroup = gHandler.findGroupById("/platform/users");
                mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " imported");
                endRequest();
            } else {
                Query query = new Query();
                query.setEmail(userIn.getEmail());

                if (!orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                    if (!uh.findUsersByQuery(query).load(0, 1)[0].getUserName().equals(userName))
                        return Response.status(Response.Status.BAD_REQUEST).entity("Email Already used").build();
                }

                startRequest();
                user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());

                user_.setEmail(userIn.getEmail());
                user_.setLastName(userIn.getLastName());
                user_.setFirstName(userIn.getFirstName());
                uh.saveUser(user_, true);
                endRequest();
            }
            userIn.setWeburl(userIn.getWebSite());
            if (userIn.getWebSite() != null && !userIn.getWebSite().equals("") && !userIn.getWebSite().contains("http"))
                userIn.setWebSite("shttp://" + userIn.getWebSite());
            if (userIn.getWebSite() != null && !userIn.getWebSite().equals("") && !userIn.getWebSite().contains("http"))
                userIn.setWeburl("http://" + userIn.getWebSite());
            if (userIn.getProview() != null && !userIn.getProview().equals("") && !userIn.getProview().contains("http"))
                userIn.setProview("http://" + userIn.getProview());

            //if (!subUserInfoStorage.updateSubUserInfo(userName, userIn))
            subUserInfoStorage.createSubUserInfo(userName, userIn);
            SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(userName);
            Identity userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user_.getUserName(), true);
            Profile uProfile = userIdentity.getProfile();

            if (userIn.getAvatar() != null) {
                try {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService) PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String userId = (state != null) ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && userIn.getAvatar().contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment(inputStream,
                                200,
                                0,
                                null,
                                "avatar",
                                "image/png",
                                null);
                        uProfile.setProperty(Profile.AVATAR, avatar);
                    }
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    throw e;
                }
            }

            Util.getIdentityManager(portalContainerName).updateProfile(uProfile);

            boolean ch = true;
            String[] categoriesId = userIn.getCategoriesId().split(";");
            String[] categories = userIn.getCategories().split(";");
            if (userIn.getCategoriesId() != null && userIn.getCategoriesId().compareTo("") != 0) {
                for (SubCatEntity subcat : subCatStorage.getSubCatsBySubId(userName, 0, 0)) {
                    if (!Arrays.asList(categoriesId).contains(subcat.getCategory().getId())) {
                        List<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(subcat.getSubContractor().getId(), subcat.getCategory().getId(), 0, 0);
                        for (ProjectSubEntity sub : sublist) {
                            projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                        }
                        subCatStorage.deleteSubCat(subcat.getSubContractor().getId());
                    }
                }
                for (int i = 0; i < categoriesId.length; i++) {


                    if (bBCategoryStorage.getBBCategory(categoriesId[i]) == null)
                        bBCategoryStorage.createBBCategory(categoriesId[i], categories[i], "", "", "");
                    SubCatEntity subcat = subCatStorage.getSubCat(user_.getUserName() + "_" + categoriesId[i]);
                    if (subcat == null)
                        subCatStorage.createSubCat(user_.getUserName(), categoriesId[i], subUserInfo, "0", "", "", categories[i]);
                    else
                        subCatStorage.updateSubCat(subcat.getId(), subUserInfo, userIn.getRank());
                    subcat = subCatStorage.getSubCat(user_.getUserName() + "_" + categoriesId[i]);
                    List<ProjectSubEntity> SubCatRelationShips = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(userName, categoriesId[i], 0, 0);
                    for (ProjectSubEntity subcatrelation : SubCatRelationShips) {
                        projectSubRelationShipStorage.updateProjectSubRelationShip(subcatrelation.getId(), subcat, null, null, null, null, null);
                    }
                }

            }


            LOG.info("SubContractor " + userIn.getFirstName() + " " + userIn.getFirstName() + " updated");


            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("updategc/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response updateGCUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 @PathParam("userName") String userName,
                                 Map<String, String> userIn) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            // Before updating  user, check if the userName exists or not
            User user = uh.findUserByName(userName);
            if (user == null) {
                LOG.warn(userName + " user name don't exists");
                return Response.status(Response.Status.BAD_REQUEST).entity(userIn.get("firstname") + userIn.get("lastname") + " user name don't exists").build();

            }

            startRequest();

            user.setDisplayName(userIn.get("firstname") + " " + userIn.get("lastname"));
            user.setEmail(userIn.get("email"));
            if (!userIn.get("password").equals("")) {
                user.setPassword(userIn.get("password"));
            }
            user.setFirstName(userIn.get("firstname"));
            user.setLastName(userIn.get("lastname"));
            uh.saveUser(user, true);

            Identity userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user.getUserName(), true);
            Profile uProfile = userIdentity.getProfile();
            //Update Phone
            if (userIn.get("phone").compareTo("") != 0) {
                List<Map<String, String>> phones = new ArrayList<Map<String, String>>();
                Map<String, String> phone1 = new HashMap<String, String>();
                phone1.put("key", "Work");
                phone1.put("value", userIn.get("phone"));
                phones.add(phone1);
                uProfile.setProperty(Profile.CONTACT_PHONES, phones);
            }
/*            if (userIn.get("company").compareTo("") != 0) {
                ArrayList<HashMap<String, Object>> experiences = new ArrayList<HashMap<String, Object>>();
                HashMap<String, Object> uiMap = new HashMap<String, Object>();
                uiMap.put(Profile.EXPERIENCES_COMPANY, StringEscapeUtils.escapeHtml(userIn.get("company")));
                if (userIn.get("position").compareTo("") != 0) {
                    uiMap.put(Profile.EXPERIENCES_POSITION, StringEscapeUtils.escapeHtml(userIn.get("position")));
                }
                experiences.add(uiMap);
                uProfile.setProperty(Profile.EXPERIENCES, experiences);
            }*/
            if (userIn.get("avatar") != null) {
                try {
                    ManageableRepository repository = repositoryService.getCurrentRepository();
                    SessionProviderService sessionProviderService = (SessionProviderService) PortalContainer.getInstance().getComponentInstanceOfType(SessionProviderService.class);
                    SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
                    Session session = sProvider.getSession("collaboration", repository);
                    Node rootNode = session.getRootNode();
                    ConversationState state = ConversationState.getCurrent();
                    String userId = (state != null) ? state.getIdentity().getUserId() : null;
                    if (rootNode.hasNode("Application Data/avatars/" + userId + "_avatar_preview.png") && userIn.get("avatar").contains("avatar_preview.png")) {
                        InputStream inputStream = rootNode.getNode("Application Data/avatars/" + userId + "_avatar_preview.png").getNode("jcr:content").getProperty("jcr:data").getStream();
                        AvatarAttachment avatar = ImageUtils.createResizedAvatarAttachment(inputStream,
                                200,
                                0,
                                null,
                                "avatar",
                                "image/png",
                                null);
                        uProfile.setProperty(Profile.AVATAR, avatar);
                    }
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                    throw e;
                }
            }
            String gcgroup = (userIn.get("gcgroup") != "") ? userIn.get("gcgroup") : "gcmember";
            if (gcgroup != "" && gcgroup != null) {
                GroupHandler gh = orgService.getGroupHandler();
                MembershipHandler mh = orgService.getMembershipHandler();
                MembershipTypeHandler mth = orgService.getMembershipTypeHandler();
                Membership gcmembership = mh.findMembershipByUserGroupAndType(userName, "/organization/gcs", gcgroup);
                if (gcmembership == null) {
                    mh.removeMembership(((Membership) mh.findMembershipsByUserAndGroup(userName, "/organization/gcs").toArray()[0]).getId(), true);
                    mh.linkMembership(user, gh.findGroupById("/organization/gcs"), mth.findMembershipType(gcgroup), true);
                }
            }
            identityManager.updateProfile(uProfile);

            LOG.info("SubContractor " + userIn.get("firstname") + userIn.get("lastname") + " updated");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("delete/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response deleteUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                               @PathParam("userName") String userName,
                               @QueryParam("projectId") String projectId,
                               @QueryParam("selectall") boolean selectall,
                               BbFilteredSearchRequest searchRequest) throws Exception {


        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = orgService.getUserHandler();
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            Space project = spaceService.getSpaceByPrettyName(projectId);

            if (projectId != null && project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);

            if (selectall) {

                if (searchRequest.getSubSelect().size() > 0) {
                    BBCategoryStorage bbCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);


                    for (String uName : searchRequest.getSubSelect()) {
                        if (searchRequest.getSubcats().contains(uName)) continue;
                        ListAccess<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdListAccess(uName);
                        for (ProjectSubEntity sub : sublist.load(0, sublist.getSize())) {
                            if (null != project) {
                                if (spaceService.isInvitedUser(project, sub.getSubContractor().getId())) {
                                    spaceService.removeInvitedUser(project, sub.getSubContractor().getId());
                                } else if (spaceService.isMember(project, sub.getSubContractor().getId())) {
                                    spaceService.removeMember(project, sub.getSubContractor().getId());
                                }
                            }
                            projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                        }

                        List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(uName, 0, 0);

                        List<String> subscategories = new ArrayList<String>();
                        for (SubCatEntity subcat : subcats) {
                            if (!subscategories.contains(subcat.getCategory().getId()))
                                subscategories.add(subcat.getCategory().getId());
                            subCatStorage.deleteSubCat(subcat.getId());
                        }
                        for (String catid : subscategories) {
                            if (subCatStorage.getSubCatsByCatId(catid, 0, 0).size() == 0) {
                                bbCategoryStorage.deleteBBCategory(catid);
                            }
                        }

                        // Before updating  user, check if the userName exists or not
                        User user = uh.findUserByName(uName);
                        if (user == null) {
                            LOG.warn(uName + " user name don't exists");
                            continue;
                        }
                        user.setPassword("pass");
                        uh.saveUser(user, true);
                        LOG.info("SubContractor  deleted");
                    }

                    JSONObject jsonGlobal = new JSONObject();
                    jsonGlobal.put("message", " SubContractor deleted");
                    return Response.ok(jsonGlobal.toString(), mediaType).build();

                } else {

                    SubCatRunner subCatRunner = null;

                    if (null != projectId) {
                        subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.DELETE_ALL, ConversationState.getCurrent());
                    } else {
                        subCatRunner = new SubCatRunner(searchRequest, RelationShipType.DELETE_ALL, ConversationState.getCurrent());
                    }

                    Thread createSubCatRelation = new Thread(subCatRunner, "Sub Cat Runner Thread");
                    createSubCatRelation.start();

                    JSONObject jsonGlobal = new JSONObject();
                    jsonGlobal.put("message", searchRequest.getTotRecords() + " Users Deleted");

                    while (subCatRunner.isRunning()) {
                        Thread.sleep(1000);
                    }
                    return Response.ok(jsonGlobal.toString(), mediaType).build();

                }

            }

            BBCategoryStorage bbCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
            ListAccess<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdListAccess(userName);
            for (ProjectSubEntity sub : sublist.load(0, sublist.getSize())) {

                if (null != project) {
                    if (spaceService.isInvitedUser(project, sub.getSubContractor().getId())) {
                        spaceService.removeInvitedUser(project, sub.getSubContractor().getId());
                    } else if (spaceService.isMember(project, sub.getSubContractor().getId())) {
                        spaceService.removeMember(project, sub.getSubContractor().getId());
                    }
                }
                projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
            }

            List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(userName, 0, 0);

            List<String> subscategories = new ArrayList<String>();
            for (SubCatEntity subcat : subcats) {
                if (!subscategories.contains(subcat.getCategory().getId()))
                    subscategories.add(subcat.getCategory().getId());
                subCatStorage.deleteSubCat(subcat.getCategory().getId());
            }
            for (String catid : subscategories) {
                if (subCatStorage.getSubCatsByCatId(catid, 0, 0).size() == 0) {
                    bbCategoryStorage.deleteBBCategory(catid);
                }
            }

            // Before updating  user, check if the userName exists or not
            User user = uh.findUserByName(userName);
            if (user == null) {
                LOG.warn(userName + " user name don't exists");
                return Response.status(Response.Status.BAD_REQUEST).entity("user don't exists").build();

            }
            user.setPassword("pass");
            uh.saveUser(user, true);
            LOG.info("SubContractor  deleted");

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor deleted");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("deletegc/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response deleteGcUser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 @PathParam("userName") String userName) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        UserHandler uh = orgService.getUserHandler();
        MembershipHandler mh = orgService.getMembershipHandler();
        try {

            User user = uh.findUserByName(userName);
            if (user == null) {
                return Response.status(Response.Status.NOT_FOUND).build();
            }
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            ListAccess<Space> spaces = spaceService.getMemberSpaces(userName);
            for (Space space : spaces.load(0, spaces.getSize())) {
                if (spaceService.isOnlyManager(space, userName))
                    return Response.status(Response.Status.BAD_REQUEST).entity("This Gc is the Only Manager of the project " + space.getDisplayName()).build();
                spaceService.removeMember(space, userName);
            }
            Collection<Membership> memberships = mh.findMembershipsByUserAndGroup(userName, "/organization/gcs");

            for (Membership membership : memberships) {
                mh.removeMembership(membership.getId(), true);
            }
            startRequest();
            user.setPassword("pass1234");
            uh.saveUser(user, true);
            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            Identity userIdentity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, userName, true);
            Profile uProfile = userIdentity.getProfile();
            uProfile.setProperty("deleted", "true");
            identityManager.updateProfile(uProfile);
            endRequest();

            return Response.status(Response.Status.OK).entity("Gc SubContractor deleted").build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("updaterank/{subCatId}/{rank}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response updateRank(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,

                               @PathParam("subCatId") String subCatId, @PathParam("rank") String rank) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            // Before Creating user, chek if the userName and the email are alredy used or not
            subCatStorage.updateSubCat(subCatId, null, rank);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            List<ProjectSubEntity> SubCatRelationShips = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(subCatId.split("_")[0], subCatId.split("_")[1], 0, 0);
            for (ProjectSubEntity subcatrelation : SubCatRelationShips) {
                projectSubRelationShipStorage.updateProjectSubRelationShip(subcatrelation.getId(), null, null, null, null, rank, null);
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Rank Updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("updateranks/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response updateRanks(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @PathParam("userName") String userName,
                                String[][] ranks) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(userName);

        if (subUserInfo == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }

        try {

            for (String[] rank : ranks) {
                subCatStorage.updateSubCat(rank[0], null, rank[1]);
                List<ProjectSubEntity> SubCatRelationShips = projectSubRelationShipStorage.getRelationShipBySubIdAndCatId(rank[0].split("_")[0], rank[0].split("_")[1], 0, 0);
                for (ProjectSubEntity subcatrelation : SubCatRelationShips) {
                    projectSubRelationShipStorage.updateProjectSubRelationShip(subcatrelation.getId(), null, null, null, null, rank[1], null);
                }
                subUserInfo.setRank(rank[1]);
                LOG.info("Rank Updated");
            }

            LOG.info("SubContractor " + userName + " updated rank");

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Rank Updated");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getmystaff")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getMyStaff(@Context HttpServletRequest request,
                               @Context HttpServletResponse response,
                               @QueryParam("projectId") String projectId,
                               @Context UriInfo uriInfo
    ) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {

            IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
            UserHandler uh = orgService.getUserHandler();
            ListAccess<User> staffList = uh.findUsersByGroupId("/organization/gcs");
            int displaystart = (request.getParameter("iDisplayStart") == null) ? 0 : Integer.parseInt(request.getParameter("iDisplayStart"));
            int displaylength = (request.getParameter("iDisplayLength") == null) ? staffList.getSize() : Integer.parseInt(request.getParameter("iDisplayLength"));
            int sEcho = (request.getParameter("sEcho") == null) ? 0 : Integer.parseInt(request.getParameter("sEcho"));
            if (displaylength > staffList.getSize() - displaystart) displaylength = staffList.getSize() - displaystart;
            List<User> staffList_ = Arrays.asList(staffList.load(displaystart, displaylength));
            SpaceService spaceService = Util.getSpaceService(portalContainerName);
            Space project = null;
            if (projectId != null) {
                project = spaceService.getSpaceByPrettyName(projectId);
                if (project == null) {
                    return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
                }

            }
            List<Identity> users = new ArrayList<Identity>();
            for (User staff : staffList_) {
                try {
                    Identity uid = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, staff.getUserName(), true);
                    users.add(uid);
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (Identity user : users) {
                Profile uProfile = user.getProfile();
                if (uProfile.getProperty("deleted") != null && uProfile.getProperty("deleted").toString().equals("true"))
                    continue;
                JSONObject json = new JSONObject();
                json.put("userName", user.getRemoteId());
                json.put("fullName", uProfile.getFullName());
/*                HashMap<String, Object> uiMap = new HashMap<String, Object>();
                if (((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).size() > 0) {
                    uiMap = ((ArrayList<HashMap<String, Object>>) uProfile.getProperty(Profile.EXPERIENCES)).get(0);
                    json.put("company", uiMap.get(Profile.EXPERIENCES_COMPANY));
                    json.put("position", uiMap.get(Profile.EXPERIENCES_POSITION) == null ? "Employee" : uiMap.get(Profile.EXPERIENCES_POSITION));
                } else {*/
                json.put("company", "");
                json.put("position", "Employee");
                /* }*/
                if (null != uProfile.getProperty("status")) {
                    json.put("status", uProfile.getProperty("status"));
                } else {
                    json.put("status", "Not Invited");
                }
                json.put("isMember", false);
                if (project != null) {
                    if (spaceService.isInvitedUser(project, user.getRemoteId()) || spaceService.isMember(project, user.getRemoteId()))
                        json.put("isMember", true);
                }
                jsonArray.put(json);
            }
            jsonGlobal.put("sEcho", sEcho);
            jsonGlobal.put("iTotalRecords", staffList.getSize());
            jsonGlobal.put("iTotalDisplayRecords", staffList.getSize());
            jsonGlobal.put("aaData", jsonArray);

            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getstaffrole")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getStaffRole(@Context HttpServletRequest request,
                                 @Context HttpServletResponse response,
                                 @Context UriInfo uriInfo
    ) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        try {
            MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
            String gcRole = "";
            String currentUser = "";
            if (getGcGroup(sourceIdentity.getRemoteId()) != null) {
                gcRole = getGcGroup(sourceIdentity.getRemoteId());
                currentUser = sourceIdentity.getRemoteId();
            }
            if (sourceIdentity.getRemoteId().equals(PropertyManager.getProperty("exo.super.user"))) gcRole = "gcadmin";
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("gcRole", gcRole);
            jsonGlobal.put("currentUser", currentUser);
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("cancelorreject/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response CancelOrReject(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                   @PathParam("projectId") String projectId, @QueryParam("addall") boolean addall,
                                   BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            SpaceService spaceService = Util.getSpaceService(portalContainerName);

            Space project = spaceService.getSpaceByPrettyName(projectId);

            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

            if (addall) {

                SubCatRunner subCatRunner = null;
                subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.CANCEL_REJECT, ConversationState.getCurrent());

                Thread createSubCatRelation = new Thread(subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();

                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", searchRequest.getTotRecords() + " Users canceled or rejected");

                return Response.ok(jsonGlobal.toString(), mediaType).build();

            }

            JSONObject jsonGlobal = new JSONObject();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            for (String rel : searchRequest.getSubSelect()) {
                ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                if (projectSubRelationShipStorage.getRelationShipCountBySubId(rel_.getSubContractor().getId()) == 0) {
                    if (spaceService.isInvitedUser(project, rel_.getSubContractor().getId())) {
                        spaceService.removeInvitedUser(project, rel_.getSubContractor().getId());
                        jsonGlobal.put("message", "invitation cancelled");
                    } else if (spaceService.isMember(project, rel_.getSubContractor().getId())) {
                        spaceService.removeMember(project, rel_.getSubContractor().getId());
                        jsonGlobal.put("message", "SubContractor removed from the project");
                    }
                }
                projectSubRelationShipStorage.deleteProjectSubRelationShip(rel);
            }
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("addstaff/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addStaff(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                             @PathParam("projectId") String projectId,
                             @QueryParam("gcHost") String gcHost,
                             @QueryParam("projectUrl") String projectUrl,
                             @QueryParam("addall") boolean addall,
                             BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        UserHandler uh = orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        List<String> users = searchRequest.getSubcats();
        try {

            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }

            if (addall) {
                ListAccess<User> staffList = uh.findUsersByGroupId("/organization/gcs");
                List<User> userList = Arrays.asList(staffList.load(0, staffList.getSize()));
                for (User user : userList) {
                    if (users.contains(user.getUserName())) continue;
                    projectUrl = projectUrl.replaceAll("portal/", "");
                    String to = user.getUserName();
                    String url = "http://" + gcHost + "/portal/invitations?userName=" + to + "&initialURI=" + projectUrl + "/projectSettings";
                    String fullName = (user.getDisplayName() != null) ? user.getDisplayName() : user.getFirstName() + " " + user.getLastName();
                    String subject = "Invitation to Join";
                    String mailText = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"660\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#666666;line-height:20px;font-family:HelveticaNeue,verdana,arial,tahoma\">\n" +
                            "\t\t<tbody><tr>\n" +
                            "\t\t\t<td align=\"center\" valign=\"middle\">\n" +
                            "\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"#fff\" align=\"center\" style=\"border:1px solid #d8d8d8\">\n" +
                            "\t\t\t\t\t<tbody><tr>\n" +
                            "\t\t\t\t\t\t<td height=\"45\" valign=\"middle\" style=\"margin:0;height:45px;font-weight:bold;vertical-align:middle;background-color:#efefef;font-family:HelveticaNeue,arial,tahoma,serif;color:#2f5e92;font-size:18px;text-align:center\">\n" +
                            "\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\tInvitation to Join\n" +
                            "\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t</td>\n" +
                            "\t\t\t\t\t</tr>\n" +
                            "\t\t\t\t</tbody></table>\n" +
                            "\t\t\t\t\n" +
                            "\t\t\t</td>\n" +
                            "\t\t</tr>\n" +
                            "\t\t<tr>\n" +
                            "\t\t\t<td align=\"center\">\n" +
                            "\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                            "\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                            "\t\t\t\t</font></span><table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" align=\"center\" style=\"border-left:1px solid #d8d8d8;border-right:1px solid #d8d8d8\">\n" +
                            "\t\t\t\t\t<tbody><tr>\n" +
                            "\t\t\t\t\t\t<td>\n" +
                            "\t\t\t\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                            "\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t</font></span><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"92%\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#333;line-height:20px\">\n" +
                            "\t\t\t\t\t\t\t\t<tbody><tr>\n" +
                            "\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t\t<td>\n" +
                            "\t\t\t\t\t\t\t\t\t <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Hi " + fullName + ",</p>\n" +
                            "\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">\n" +
                            "\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t\t\t You are invited to participate in the project " + project.getDisplayName() + ". To see the Project details, please click on <strong><a href=\"" + url + "\" target=\"_blank\">this link</a></strong> \n" +
                            "\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t\t  </p>\n" +
                            "\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\"><strong>" + sourceIdentity.getProfile().getFullName() + "</strong></p><span class=\"HOEnZb\"><font color=\"#888888\"><br>\n" +
                            "\n" +
                            "\t\t\t\t\t\t\t\t\t\t\n" +
                            "\t\t\t\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                            "\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\n" +
                            "\t\t\t\t\n" +
                            "\t\t\t</font></span></td></tr><tr> ";
                    if (sendMail(to, subject, mailText, false)) {
                        try {
                            Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user.getUserName(), true);
                            Profile uProfile = userId.getProfile();
                            Utils.addToSpace(project, user.getUserName());
                            spaceService.setManager(project, user.getUserName(), true);
                            uProfile.setProperty("status", "Invited");
                            identityManager.updateProfile(uProfile);
                        } catch (MessageException e) {
                            LOG.error(e.getMessage(), e);
                        }
                    }
                }

                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", "Invitation(s) sent successfully.");
                return Response.ok(jsonGlobal.toString(), mediaType).build();

            }

            for (String user : users) {

                User user_ = uh.findUserByName(user);
                projectUrl = projectUrl.replaceAll("portal/", "");
                String to = user_.getUserName();
                String url = "http://" + gcHost + "/portal/invitations?userName=" + to + "&initialURI=" + projectUrl + "/projectSettings";
                String fullName = (user_.getDisplayName() != null) ? user_.getDisplayName() : user_.getFirstName() + " " + user_.getLastName();
                String subject = "Invitation to Join";
                String mailText = "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"660\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#666666;line-height:20px;font-family:HelveticaNeue,verdana,arial,tahoma\">\n" +
                        "\t\t<tbody><tr>\n" +
                        "\t\t\t<td align=\"center\" valign=\"middle\">\n" +
                        "\t\t\t\t<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" bgcolor=\"#fff\" align=\"center\" style=\"border:1px solid #d8d8d8\">\n" +
                        "\t\t\t\t\t<tbody><tr>\n" +
                        "\t\t\t\t\t\t<td height=\"45\" valign=\"middle\" style=\"margin:0;height:45px;font-weight:bold;vertical-align:middle;background-color:#efefef;font-family:HelveticaNeue,arial,tahoma,serif;color:#2f5e92;font-size:18px;text-align:center\">\n" +
                        "\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\tInvitation to Join\n" +
                        "\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t</td>\n" +
                        "\t\t\t\t\t</tr>\n" +
                        "\t\t\t\t</tbody></table>\n" +
                        "\t\t\t\t\n" +
                        "\t\t\t</td>\n" +
                        "\t\t</tr>\n" +
                        "\t\t<tr>\n" +
                        "\t\t\t<td align=\"center\">\n" +
                        "\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                        "\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                        "\t\t\t\t</font></span><table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" align=\"center\" style=\"border-left:1px solid #d8d8d8;border-right:1px solid #d8d8d8\">\n" +
                        "\t\t\t\t\t<tbody><tr>\n" +
                        "\t\t\t\t\t\t<td>\n" +
                        "\t\t\t\t\t\t\t<span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t</font></span><span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                        "\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t</font></span><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"92%\" bgcolor=\"#fff\" align=\"center\" style=\"font-size:12px;color:#333;line-height:20px\">\n" +
                        "\t\t\t\t\t\t\t\t<tbody><tr>\n" +
                        "\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t\t<td>\n" +
                        "\t\t\t\t\t\t\t\t\t <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Hi " + fullName + ",</p>\n" +
                        "\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">\n" +
                        "\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t\t\t You are invited to participate in the project " + project.getDisplayName() + ". To see the Project details, please click on <strong><a href=\"" + url + "\" target=\"_blank\">this link</a></strong> \n" +
                        "\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t\t  </p>\n" +
                        "\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t\t  <p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\"><strong>" + sourceIdentity.getProfile().getFullName() + "</strong></p><span class=\"HOEnZb\"><font color=\"#888888\"><br>\n" +
                        "\n" +
                        "\t\t\t\t\t\t\t\t\t\t\n" +
                        "\t\t\t\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\n" +
                        "\t\t\t\t\t\t</font></span></td></tr></tbody></table><span class=\"HOEnZb\"><font color=\"#888888\">\t\t\t\n" +
                        "\t\t\t\t\n" +
                        "\t\t\t</font></span></td></tr><tr> ";
                if (sendMail(to, subject, mailText, false)) {
                    try {
                        Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user, true);
                        Utils.addToSpace(project, user);
                        spaceService.setManager(project, user, true);
                        Profile uProfile = userId.getProfile();
                        uProfile.setProperty("status", "Invited");
                        Util.getIdentityManager(portalContainerName).updateProfile(uProfile);
                    } catch (MessageException e) {
                        LOG.error(e.getMessage(), e);
                    }
                }

            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Invitation(s) sent successfully.");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("addnonmessaged/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response addNonMsgd(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                               @PathParam("projectId") String projectId,
                               @QueryParam("gcHost") String gcHost,
                               @QueryParam("projectUrl") String projectUrl,
                               List<String> relations) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        UserHandler uh = orgService.getUserHandler();
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        BBCategoryStorage bBCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {

            //Get the Space by its Pretty Name
            Space project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
            for (String rel : relations) {
                ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                User user_ = uh.findUserByName(rel_.getSubContractor().getId());
                projectUrl = projectUrl.replaceAll("portal/", "");
                Profile prProfile = null;
                Profile uProfile = null;
                try {
                    Identity prIdentity = identityManager.getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), true);
                    prProfile = prIdentity.getProfile();
                    Identity userId = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, user_.getUserName(), true);
                    uProfile = userId.getProfile();
                    uProfile.setProperty("itbsent", (new SimpleDateFormat("dd/MM/yy")).format(Utils.getTime()));
                    identityManager.updateProfile(uProfile);
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);

                }
                String url = "http://" + gcHost + "/portal/invitations?userName=" + rel_.getSubContractor().getId() + "&initialURI=" + projectUrl + "/projectSettings";
                String to = user_.getUserName();
                String subject = "Invitation to bid on the " + project.getPrettyName() + " project";
                String mailText = " <div align=center>\n" +
                        "\n" +
                        "        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"width:90%; max-width:790px;\">\n" +
                        "          <tr>\n" +
                        "            <td width=\"100%\" style=\"border-top: 4px solid #707070; border-right: 4px solid #707070; border-bottom: 4px solid #707070; border-left: 4px solid #707070; padding: 8px 12px;\">\n" +
                        "\n" +
                        "\n" +
                        "        \t\t\n" +
                        "                  <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"8\">\n" +
                        "                    <tr>\n" +
                        "                      <td width=\"50%\" align=\"left\" style=\" border-right: 1px solid #c2c2c2;  border-bottom: 1px solid #c2c2c2;\">\n" +
                        "   \n" +
                        "                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n" +
                        "                          <tr>\n" +
                        "                            <td colspan=\"2\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px\">INVITATION TO BID</td>             \n" +
                        "                          </tr>\n" +
                        "                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>To</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + uProfile.getProperty("company") + "</td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>ATTN</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getDisplayName() + "</td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b>&nbsp;&nbsp;&nbsp;</td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(123) 456-7890</td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Email</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + user_.getEmail() + "</td>\n" +
                        "                          </tr>\n" +
                        "                        </table>\n" +
                        "                      </td>\n" +
                        "                      <td width=\"50%\" align=\"center\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; border-bottom: 1px solid #c2c2c2; padding-left: 18px\">\n" +
                        "                        <IMG style=\"-ms-interpolation-mode: bicubic; width:55%; max-width:180px; max-height:60px\"\n" +
                        "                        border=0 \n" +
                        "                        \n" +
                        "                        align=\"middle\" src=\"http://" + gcHost + "/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png\">\n" +
                        "                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"6\" width=\"100%\">\n" +
                        "\n" +
                        "                          <tr><td colspan=\"2\" height=\"20\"></td></tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>From</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">General Contractor Inc<br><a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">ProView Listing</a></td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Contact</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getFullName() + "</td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Title</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">" + sourceIdentity.getProfile().getPosition() + "</td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 13px\"><b>Phone / Fax</b></td>\n" +
                        "                            <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px\">(866) 558-5515 / (866) 558-5516</td>\n" +
                        "                          </tr>\n" +
                        "                          <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                        "                        </table>\n" +
                        "                      </td>\n" +
                        "                    </tr>\n" +
                        "                    <tr>\n" +
                        "                      <td colspan=\"2\" align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                        Hi, <b>" + user_.getFirstName() + "</b>,\n" +
                        "                        <br><br>\n" +
                        "                        We have selected your company to submit a bid on the project listed below.  Please click on the &#8216;Project Details&#8217; for the full project overview and documents.\n" +
                        "                      </td>\n" +
                        "                    </tr>\n" +
                        "                    <tr>\n" +
                        "                      <td colspan=\"2\">\n" +
                        "                        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">\n" +
                        "                          <tr>\n" +
                        "                            <td width=\"15.5%\" valign=\"top\"><img style=\"-ms-interpolation-mode: bicubic; width:100%; max-width:101px; max-height:101px\"\n" +
                        "                                border=0 \n" +
                        "                                alt=\"\" \n" +
                        "                                align=middle src=\"http://\"" + gcHost + project.getAvatarUrl() + ">\n" +
                        "                            </td>\n" +
                        "                            <td width=\"84.5%\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 22px; line-height: 18px;\">\n" +
                        "                              <b>" + project.getDisplayName() + "</b><br>\n" +
                        "                              <span style=\"font-size: 14px; line-height: 16px;\">" + prProfile.getProperty("adress") + "</span>\n" +
                        "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n" +
                        "                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Bids Due</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    " + prProfile.getProperty("bidsDueDate") + "\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Start Date:</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" style=\"font-family:Helvetica, Arial, sans-serif; color:#c81b03; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                   " + prProfile.getProperty("startDate") + "\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                        "                              </table>\n" +
                        "                            </td>\n" +
                        "                          </tr>\n" +
                        "                          <tr>\n" +
                        "                            <td colspan=\"2\">\n" +
                        "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"3\" width=\"100%\">\n" +
                        "                                \n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Project Status</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                   " + prProfile.getProperty("projectStatus") + "\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Number of Buildings</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    " + prProfile.getProperty("nbBuildings") + "\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Stories above ground</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    " + prProfile.getProperty("storiesAboveGrd") + "\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" width=\"30%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Square Footage</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    " + prProfile.getProperty("totalSqFt") + " sq. ft.\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" width=\"30%\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    <b>Project Description</b>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" width=\"70%\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2;\">\n" +
                        "                                    " + project.getDescription() + "\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td colspan=\"2\" align=\"center\" valign=\"middle\" bgcolor=\"#e0e0e0\" style=\"border-left: 1px solid #c2c2c2; border-right: 1px solid #c2c2c2; border-bottom: 1px solid #c2c2c2; padding: 8px 0px\">\n" +
                        "                                    <a href=\"" + url + "\" target=\"_blank\">\n" +
                        "                                    <img style=\"-ms-interpolation-mode: bicubic; width:184px; height:35px\"\n" +
                        "                                      border=0 \n" +
                        "                                      alt=\"\" \n" +
                        "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/details.jpg\" target=\"_blank\"></a>\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr><td colspan=\"2\" height=\"6\"></td></tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td colspan=\"2\" align=\"left\" valign=\"top\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 17px; padding: 10px 0px\">\n" +
                        "                                    You&#8217;ve been selected to bid on the following trade(s). Please respond by clicking on one of the options below.\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr>  \n" +
                        "                              </table>\n" +
                        "\n" +
                        "                              <h1 style=\"text-align: center;\">" + bBCategoryStorage.getBBCategory(rel_.getCategory().getId()).getCatCsiDesc() + "</h1>            \n" +
                        "\n" +
                        "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n" +
                        "                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"right\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + rel_.getProjectId() + "/" + rel_.getCategory().getId() + "/" + rel_.getSubContractor().getId() + "/NOT_BIDDING\" target=\"_blank\">\n" +
                        "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                        "                                      border=0 \n" +
                        "                                      alt=\"\" \n" +
                        "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"center\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + rel_.getProjectId() + "/" + rel_.getCategory().getId() + "/" + rel_.getSubContractor().getId() + "/UNDECIDED\" target=\"_blank\">\n" +
                        "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                        "                                      border=0 \n" +
                        "                                      alt=\"\" \n" +
                        "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" valign=\"middle\"><a href=\"http://" + gcHost + "/rest/bbprojectservice/emailsetsubstatus/" + rel_.getProjectId() + "/" + rel_.getCategory().getId() + "/" + rel_.getSubContractor().getId() + "/BIDDING\" target=\"_blank\">\n" +
                        "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                        "                                      border=0 \n" +
                        "                                      alt=\"\" \n" +
                        "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n" +
                        "                                <tr>\n" +
                        "                                  <td colspan=\"3\" align=\"center\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 14px; border-top: 1px solid #c2c2c2; padding: 10px 0px;\">\n" +
                        "                                    If you no longer would lid to receive bid invitations <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 14px; text-decoration: none;\">click here</a> or call (888) 303-2243\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                              </table>\n" +
                        "\n" +
                        "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\" bgcolor=\"#055092\">\n" +
                        "                                <tr>\n" +
                        "                                  <td align=\"left\" bgcolor=\"#055092\">\n" +
                        "                                    <img style=\"-ms-interpolation-mode: bicubic; width:110px; height:44px\"\n" +
                        "                                      border=0 \n" +
                        "                                      alt=\"\" \n" +
                        "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/tbb.jpg\">\n" +
                        "                                  </td>\n" +
                        "                                  <td align=\"left\" valign=\"middle\" bgcolor=\"#055092\" style=\"font-family:Helvetica, Arial, sans-serif; color:#FFFFFF; font-size: 12px;\">\n" +
                        "                                    <b>AndersonConstruction, Inc</b> has shared this project opportunity with you using BB-Build.  If you need  technical help, please call BB-Build Support at (888) 303-2243\n" +
                        "                                  </td>\n" +
                        "                                </tr>\n" +
                        "                              </table>\n" +
                        "                            </td>\n" +
                        "                          </tr>\n" +
                        "                        </table>\n" +
                        "                      </td>\n" +
                        "                    </tr>\n" +
                        "                  </table>\n" +
                        "          \n" +
                        "  \n" +
                        "\n" +
                        "\n" +
                        "        </td>\n" +
                        "        </tr>\n" +
                        "        </table>\n" +
                        "\n" +
                        "    </div>";
                if (sendMail(to, subject, mailText, false)) {
                    if (Utils.addToSpace(project, rel_.getSubContractor().getId()))
                        projectSubRelationShipStorage.updateProjectSubRelationShip(rel, null, "INVITED", null, null, null, null);

                }

            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", relations.size() + " Amount of Vendors have been sent an Invitation to Bid. To view those vendors add please click on \"Invited\" tab");
            LOG.info(jsonGlobal.get("message"));
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    private void endRequest() {
        if (requestStarted && orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle) orgService).endRequest(PortalContainer.getInstance());
            } catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
            requestStarted = false;
        }
    }

    private void startRequest() {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    @GET
    @Path("getproperties")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getProperties(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        try {

            Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

            if (sourceIdentity == null) {
                LOG.warn("UNAUTHORIZED");
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);

            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            JSONObject json = new JSONObject();
            json.put("email", System.getProperty("gatein.email.smtp.from"));
            json.put("zip", companyInfo.getCompanyZip());
            Calendar calendar = Calendar.getInstance();

            Date date = null;
            try {
                date = Utils.getTime();
                calendar.setTime(date);
            } catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
            int month = calendar.get(Calendar.MONTH);
            String checksum = sourceIdentity.getRemoteId() + "_" + (month + 1) + "bbbuild2015";
            json.put("checksum", Utils.getMd5(checksum));
            return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("creategroup/{groupName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createGroup(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @PathParam("groupName") String groupName) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            LOG.warn("UNAUTHORIZED");
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubGroupStorage subGroupStorage = (SubGroupStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            Date date = Utils.getTime();
            String name = "group" + String.valueOf(date.getTime());
            while (subGroupStorage.getSubGroup(name) != null) {
                name = "group" + String.valueOf(date.getTime() + 1);
            }
            subGroupStorage.createSubGroup(name, groupName);
            LOG.info("Group " + groupName + " created");
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " Group Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getallbbgroups")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getAllBBGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        SubGroupStorage subGroupStorage = (SubGroupStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            List<SubGroupEntity> groups = subGroupStorage.getSubGroups(0, 0);

            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            for (SubGroupEntity group : groups) {
                JSONObject json = new JSONObject();
                json.put("id", group.getId());
                json.put("name", group.getSubGroupName());
                jsonArray.put(json);
            }

            jsonGlobal.put("bbgroups", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getsubbbgroups/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getSubBbgroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                   @PathParam("userName") String userName
    ) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            List<SubCatGroupEntity> relations = subCatGroupRelationStorage.getRelationShipBySubId(userName, 0, 0);

            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            for (SubCatGroupEntity relation : relations) {
                JSONObject json = new JSONObject();
                json.put("id", relation.getId());
                json.put("name", relation.getSubGroup().getSubGroupName() + "-" + relation.getCategory().getFieldName());
                jsonArray.put(json);
            }

            jsonGlobal.put("bbgroups", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("addtogroups")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response AddToGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                @QueryParam("projectId") String projectId,
                                @QueryParam("addtoselected") String addtoselected,
                                @QueryParam("addall") boolean addall,
                                BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);

        List<String> subcats = searchRequest.getSubcats();
        try {

            if (addall) {

                SubCatRunner subCatRunner = new SubCatRunner(addtoselected, searchRequest, RelationShipType.SUB_CAT, ConversationState.getCurrent());

                Thread createSubCatRelation = new Thread(subCatRunner, "Sub Cat Runner Thread");
                createSubCatRelation.start();

                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", searchRequest.getTotRecords() + " Users added to the groups: " + addtoselected);
                return Response.ok(jsonGlobal.toString(), mediaType).build();

            }

            SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
            SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            SubGroupStorage subGroupStorage = (SubGroupStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);

            for (String subcatId : subcats) {
                String[] selectedarray = addtoselected.split(",");
                for (String selectedgroup : selectedarray) {
                    SubGroupEntity subGroup = subGroupStorage.getSubGroup(selectedgroup);
                    SubCatEntity subcat = subCatStorage.getSubCat(subcatId);
                    //In case the user is added to the selected groups, all his subcats have to be updated
                    if (subcat == null) {
                        List<SubCatEntity> subcatsofuser = subCatStorage.getSubCatsBySubId(subcatId, 0, 0);
                        for (SubCatEntity subcatofuser : subcatsofuser) {
                            subCatGroupRelationStorage.createSubCatGroupRelation(selectedgroup, subcatId, subcatofuser.getSubContractor().getId(), subcatofuser.getSubContractor().getDisplayName(), subcatofuser.getCategory().getId(), subcatofuser.getCategory().getCatCsiDesc(), subGroup.getSubGroupName());
                        }
                    } else {
                        subCatGroupRelationStorage.createSubCatGroupRelation(selectedgroup, subcatId, subcat.getSubContractor().getId(), subcat.getSubContractor().getDisplayName(), subcat.getCategory().getId(), subcat.getCategory().getCatCsiDesc(), subGroup.getSubGroupName());
                    }
                }
                LOG.info("SubContractor added to the groups: " + addtoselected);
                endRequest();
            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", subcats.size() + " users added to the groups: " + addtoselected);
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("removefromgroups/{userName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response RemoveFromGroups(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                     @PathParam("userName") String userName,
                                     @QueryParam("selected") String selected,
                                     List<String> subcats) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);


        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            List<SubCatGroupEntity> relations = subCatGroupRelationStorage.getRelationShipBySubId(userName, 0, 0);
            for (SubCatGroupEntity relation : relations) {
                if (!selected.contains(relation.getId())) {
                    subCatGroupRelationStorage.deleteSubCatGroupRelation(relation.getId());
                }

            }
            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Groups Managing done");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getsubcatsbysubid")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getSubCatsBySubId(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                      @QueryParam("SubId") String SubId,
                                      @QueryParam("ProjectId") String ProjectId) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);

            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            List<ProjectSubEntity> relations = projectSubRelationShipStorage.getRelationShipByProjectIdAndSubId(ProjectId, SubId, 0, 0);
            if (relations.size() != 0) {
                for (ProjectSubEntity relation : relations) {
                    JSONObject json = new JSONObject();
                    json.put("Status", relation.getStatus());
                    SubCatEntity subcat = subCatStorage.getSubCat(relation.getSubContractor().getId() + "_" + relation.getCategory().getId());
                    json.put("CatId", subcat.getCategory().getId());
                    json.put("CatDesc", subcat.getCategory().getCatCsiDesc());
                    jsonArray.put(json);
                }
            }

            jsonGlobal.put("Categories", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("getcountforselectall/{projectId}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getcountforselectall(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                         @PathParam("projectId") String projectId,
                                         BbFilteredSearchRequest searchRequest) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {

            JSONObject jsonGlobal = new JSONObject();
            ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
            List<String> SearchConditions = new ArrayList<String>();
            SearchConditions.add(searchRequest.getsSearch_1());
            SearchConditions.add(searchRequest.getsSearch_2());
            SearchConditions.add(searchRequest.getsSearch_3());
            SearchConditions.add(searchRequest.getsSearch_4());
            SearchConditions.add(searchRequest.getsSearch_5());
            SearchConditions.add(searchRequest.getsSearch_6());
            SearchConditions.add(searchRequest.getsSearch_7());
            String SearchKey = searchRequest.getSearchsubs();

            List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
            List<String> filteredgroups = searchRequest.getFilteredGroups();
            if (filteredgroups != null && filteredgroups.size() > 0) {
                for (String filteredgroup : filteredgroups) {
                    List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                    for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                        included.add(projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId()));

                    }
                }
            }
            ListAccess<ProjectSubEntity> tmpList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(true, searchRequest.isVendor(), false, SearchKey, SearchConditions, included, "", "", projectId);

            jsonGlobal.put("invitedCount", tmpList.getSize());
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("sendmessage")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response sendMessage(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @QueryParam("addall") boolean addall, @QueryParam("bidScop") boolean bidScop,
                                BbMessage message) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        ListenerService listenerService = (ListenerService) PortalContainer.getInstance().getComponentInstanceOfType(ListenerService.class);
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        UserHandler uh = orgService.getUserHandler();
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        Boolean addNonInv = message.getAddNonInv();
        String projectId = message.getProjectId();
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);
        String bidScoped = "no";
        if (bidScop == true) bidScoped = "yes";

        Space project = null;
        if (addNonInv != null && addNonInv && projectId != null) {
            project = spaceService.getSpaceByPrettyName(projectId);
            if (project == null) {
                return Response.status(Response.Status.NOT_FOUND).entity("Project not found").build();
            }
        }

        Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, projectId, true);
        if (prIdentity != null && message.getNewEventDate() != null) {
            Profile sProfile = prIdentity.getProfile();
            String oldDate = (String) sProfile.getProperty("bidsDueDate");
            String newDate = sProfile.getProperty("bidsDueDate") == "" ? message.getNewEventDate() : message.getNewEventDate() + oldDate.substring(10, oldDate.length());
            try {
                sProfile.setProperty("bidsDueDate", newDate);
            } catch (Exception e) {
                LOG.error("Unable to update bid due date.");
            }
            Util.getIdentityManager(portalContainerName).saveProfile(sProfile);
            SpaceUtils.endRequest();
        }

        if (addall) {

            if (message.getFilteredSearchRequest().isSendAllMessages()) {
                List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
                List<String> filteredgroups = message.getFilteredSearchRequest().getFilteredGroups();
            }
            LOG.info("Conversation state messaging in rest:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
            LOG.info("Conversation userid messaging in rest:   " + ConversationState.getCurrent().getIdentity().getUserId());

            MessagingRunner messagingRunner = new MessagingRunner(project, portalContainerName, message, ConversationState.getCurrent().getIdentity(), true, Util.getBaseUrl(), bidScoped, ConversationState.getCurrent());
            Thread messagingRunnerThread = new Thread(messagingRunner, "Messaging Runner Thread");
            messagingRunnerThread.start();


            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", "Mails sent");
            return Response.ok(jsonGlobal.toString(), mediaType).build();

        } else {

            String subject = message.getSubject();
            Boolean isDaily = message.getIsDaily();
            Boolean updateEvent = message.getUpdateEvent();
            String newEventDate = message.getNewEventDate();
            List<String> relations = message.getRelations();
            String mailText = message.getMailText();
            try {
                User user_;
                Map<String, String> userscategories = new HashMap<String, String>();
                Map<String, String> userscategoriesid = new HashMap<String, String>();
                for (String rel : relations) {

                    ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);
                    if (!userscategories.isEmpty() && userscategories.containsKey(rel_.getSubContractor().getId())) {
                        userscategories.put(rel_.getSubContractor().getId(), userscategories.get(rel_.getSubContractor().getId()) + "<br />" + rel_.getCategory().getCatCsiDesc());
                        userscategoriesid.put(rel_.getSubContractor().getId(), userscategoriesid.get(rel_.getSubContractor().getId()) + ";" + rel_.getId());
                    } else {
                        userscategories.put(rel_.getSubContractor().getId(), rel_.getCategory().getCatCsiDesc());
                        userscategoriesid.put(rel_.getSubContractor().getId(), rel_.getId());
                    }
                }

                try {
                    int totalSent = 0;
                    Iterator iterator = userscategories.entrySet().iterator();
                    Iterator iteratorid = userscategoriesid.entrySet().iterator();
                    while (iteratorid.hasNext()) {
                        Map.Entry usercats = (Map.Entry) iterator.next();
                        Map.Entry usercatsid = (Map.Entry) iteratorid.next();
                        String[] categoriesofuser = usercats.getValue().toString().split("\\<br />");
                        String[] categoriesidofuser = usercatsid.getValue().toString().split(";");
                        String mailText_ = mailText;
                        String userName = usercatsid.getKey().toString();
                        user_ = uh.findUserByName(userName);
                        if (user_ == null) {
                            LOG.info(userName + " Not yet created sub by the thread import, will try to creat it before messaging ");
                            startRequest();
                            MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
                            GroupHandler gHandler = orgService.getGroupHandler();
                            MembershipHandler mHandler = orgService.getMembershipHandler();
                            ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
                            SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);

                            SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(userName);
                            //Creation of the new user

                            user_ = uh.createUserInstance(userName);
                            user_.setDisplayName(subUserInfo.getDisplayName());

                            if (orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                                user_.setPassword(Utils.getMd5(userName));
                            } else {
                                user_.setPassword(userName);
                            }
                            user_.setEmail(subUserInfo.getEmail().toLowerCase());
                            user_.setLastName(subUserInfo.getLastName());
                            user_.setFirstName(subUserInfo.getFirstName());
                            Date now = new Date();
                            user_.setCreatedDate(now);
                            uh.createUser(user_, false);
                            Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                            mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                            Group usersGroup = gHandler.findGroupById("/platform/users");
                            mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                            LOG.info("SubContractor " + subUserInfo.getDisplayName() + " imported");
                            endRequest();
                        }

                        String trbidbuttons =
                                "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n";
                        int i = 0;
                        for (String rel : categoriesidofuser) {
                            ProjectSubEntity rel_ = projectSubRelationShipStorage.getRelationShip(rel);

                            trbidbuttons +=
                                    "                                <tr><td colspan=\"3\" height=\"5\"><span>" + categoriesofuser[i] + "</span></td></tr>\n" +
                                            "                                <tr>\n" +
                                            "                                  <td align=\"right\" valign=\"middle\"><a href=\"" + Util.getBaseUrl() + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCategory().getId() + "/" + user_.getUserName() + "/NOT_BIDDING\" target=\"_blank\">\n" +
                                            "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                            "                                      border=0 \n" +
                                            "                                      alt=\"\" \n" +
                                            "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n" +
                                            "                                  </td>\n" +
                                            "                                  <td align=\"center\" valign=\"middle\"><a href=\"" + Util.getBaseUrl() + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCategory().getId() + "/" + user_.getUserName() + "/UNDECIDED\" target=\"_blank\">\n" +
                                            "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                            "                                      border=0 \n" +
                                            "                                      alt=\"\" \n" +
                                            "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n" +
                                            "                                  </td>\n" +
                                            "                                  <td align=\"left\" valign=\"middle\"><a href=\"" + Util.getBaseUrl() + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCategory().getId() + "/" + user_.getUserName() + "/BIDDING\" target=\"_blank\">\n" +
                                            "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                            "                                      border=0 \n" +
                                            "                                      alt=\"\" \n" +
                                            "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n" +
                                            "                                  </td>\n" +
                                            "                                </tr>\n" +
                                            "                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n";
                            i++;
                            totalSent++;
                        }
                        trbidbuttons +=
/*                                "                                <tr>\n" +
                                        "                                  <td colspan=\"3\" align=\"left\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 12px; border-top: 1px solid #c2c2c2; padding: 10px 0px;\">\n" +
                                        "                                    <p>The reason you are receiving this email is you are registered in The Blue Book Network and were selected to be a member of this OneTeam Project.</p> If you'd no longer like to receive bid invitations from this GC <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 12px; text-decoration: none;\">click here</a><br />\n" +
                                        "                                    If you'd no longer like to receive bid invitations from the OneTeam system <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 12px; text-decoration: none;\">click here</a> or call (888) 303-2243\n" +
                                        "                                  </td>\n" +
                                        "                                </tr>\n" +*/
                                "                              </table>\n";
                        mailText_ = mailText_.replace("{|CATID|}", trbidbuttons);

                        String to = user_.getUserName();
                        mailText_ = mailText_.replace("{|RECEIVERID|}", user_.getUserName());
                        mailText_ = mailText_.replace("{|RECEIVERFIRSTNAME|}", user_.getFirstName());
                        mailText_ = mailText_.replace("{|RECEIVERLASTNAME|}", user_.getLastName());
                        mailText_ = mailText_.replace("{|CLASSIFICATION|}", usercats.getValue().toString());
                        //  mailText=mailText.replaceAll("\{\|RECEIVERCOMPANYNAME\|\}",rel_.getSubId());
                        if (sendMail(to, subject, mailText_, isDaily)) {
                            for (String rel : categoriesidofuser) {
                                if (addNonInv != null && addNonInv && project != null) {
                                    try {
                                        if (Utils.addToSpace(project, user_.getUserName()))
                                            projectSubRelationShipStorage.updateProjectSubRelationShip(rel, null, "INVITED", null, null, null, bidScoped);
                                    } catch (Exception e) {
                                        LOG.error(e.getMessage(), e);
                                    }
                                }
                            }
                            if (updateEvent != null && updateEvent) {
                                CalendarService calService = (CalendarService) PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                                String CalendarId = project.getPrettyName() + "_space_calendar";
                                DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                                Date duedate = formatter.parse(String.valueOf(newEventDate));
                                CalendarEvent duedateevent = calService.getEventById(project.getPrettyName() + " - bidsDueDate");
                                duedateevent.setFromDateTime(duedate);
                                duedateevent.setToDateTime(duedate);
                                duedateevent.setDescription(project.getDescription());
                                calService.savePublicEvent(CalendarId, duedateevent, false);
                            }

                            LOG.info("message is already sent to " + user_.getDisplayName() + " email= " + user_.getEmail());
                        }
                    }

                    if (projectId != null) {
                        String rawMsgType = message.getMsgType();
                        String prettyMsgType = "";
                        if (rawMsgType != null) {
                            if (rawMsgType.equals("genericITB")) {
                                prettyMsgType = "Invitation to bid";
                            } else if (rawMsgType.equals("addendum")) {
                                prettyMsgType = "Notice of addendum";
                            } else if (rawMsgType.equals("biddateextended")) {
                                prettyMsgType = "Bid date extended";
                            } else if (rawMsgType.equals("remindertobid")) {
                                prettyMsgType = "Reminder to bid";
                            } else if (rawMsgType.equals("noticeofaward")) {
                                prettyMsgType = "Notice of award";
                            } else if (rawMsgType.equals("projectmemo")) {
                                prettyMsgType = "Memo";
                            }
                        }

                        if (projectId != null && !projectId.equals("")) {
                            project = spaceService.getSpaceByPrettyName(projectId);
                        }
                        LOG.warn(project.toString());
/*                        ActivityManager activityManager = (ActivityManager) ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
                        // create activity
                        ExoSocialActivity activity = new ExoSocialActivityImpl();
                        activity.setUserId(sourceIdentity.getId());
                        activity.setBody(null);
                        Map<String, String> templateParams = new HashMap<String, String>();
                        templateParams.put("receiver", UIBBNDefaultActivity.GCS_GROUP);
                        activity.setTemplateParams(templateParams);
                        if (project != null) {
                            Identity spaceIdentity = identityManager.getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), false);

                            if (totalSent == 1)
                              activity.setTitle( totalSent + " " + prettyMsgType + " was sent.");
                            else
                                activity.setTitle( totalSent + " " + prettyMsgType + " were sent.");
                            activity.setType(UIBBNDefaultActivity.ACTIVITY_TYPE);
                            activityManager.saveActivityNoReturn(spaceIdentity, activity);
                        }*/
                        totalSent = 0;
                    }

                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }

                for (String projectSubEntity : relations) {
                    listenerService.broadcast("SendMessage", projectSubEntity, sourceIdentity.getRemoteId());
                }

                JSONObject jsonGlobal = new JSONObject();
                jsonGlobal.put("message", "Mails sent");
                return Response.ok(jsonGlobal.toString(), mediaType).build();
            } catch (Exception e) {
                LOG.error(e.getMessage(), e);
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();


            }
        }
    }


    @GET
    @Path("getusernotifications")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response getUserNotifications(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo
    ) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage) PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);

            JSONObject jsonGlobal = new JSONObject();
            JSONArray jsonArray = new JSONArray();

            List<SimpleNotification> notifs = simpleNotifServiceStorage.getSimpleNotificationsByUserId(sourceIdentity.getRemoteId(), 0, 0);
            int bbimport = 0;
            int bsimport = 0;
            if (notifs.size() != 0) {
                for (SimpleNotification notif : notifs) {

                    JSONObject json = new JSONObject();
                    json.put("summary", notif.getSummary());
                    json.put("notifId", notif.getName());
                    json.put("type", notif.getType());
                    json.put("number", notif.getNumber());
                    jsonArray.put(json);

                }
            }

            jsonGlobal.put("notifs", jsonArray);
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @POST
    @Path("deleteusernotifications")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response deleteUserNotifications(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                            List<String> notifs) throws Exception {

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        try {
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }

            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage) PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);

            JSONObject jsonGlobal = new JSONObject();

            if (notifs.size() != 0) {
                for (String notif : notifs) {
                    simpleNotifServiceStorage.deleteSimpleNotification(notif);
                }
            }

            jsonGlobal.put("message", "Delete done");
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @GET
    @Path("getcompanyinfo")
    public Response getCompanyInfo(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo
    ) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
        try {

            JSONObject company = new JSONObject();
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            company.put("companyName", companyInfo.getCompanyName());
            company.put("companyProview", companyInfo.getCompanyProview());
            company.put("companyStreet", companyInfo.getCompanyStreet());
            company.put("companyState", companyInfo.getCompanyState());
            company.put("companyCity", companyInfo.getCompanyCity());
            company.put("companyZip", companyInfo.getCompanyZip());
            company.put("companyWebSite", companyInfo.getCompanyWebSite());
            company.put("companyPhone", companyInfo.getCompanyPhone());

            company.put("companyAvatar", "/portal/rest/jcr/repository/collaboration/Application%20Data/logos/logo.png");
            return Response.ok(company.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getgeoposition")
    public Response getGeoPosition(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo
    ) throws Exception {


        try {
            PortalContainer portalContainer = PortalContainer.getInstance();
            SettingService settingService = (SettingService) portalContainer.getComponentInstanceOfType(SettingService.class);
            String geoPosition = String.valueOf(settingService.get(GLOBAL, Scope.GLOBAL, "geoPosition") == null ? "" : settingService.get(GLOBAL, Scope.GLOBAL, "geoPosition").getValue());
            String latitude = "";
            String longitude = "";
            if (!geoPosition.equals("") && geoPosition.split(",").length == 2) {
                latitude = geoPosition.split(",")[0].replace(" ", "");
                longitude = geoPosition.split(",")[1].replace(" ", "");
            }
            JSONObject position = new JSONObject();
            position.put("latitude", latitude);
            position.put("longitude", longitude);
            return Response.ok(position.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("getlastaccess")
    public Response getLastAccess(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo
    ) throws Exception {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SettingService settingService = (SettingService) portalContainer.getComponentInstanceOfType(SettingService.class);
        try {
            Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            JSONObject json = new JSONObject();
            DateFormat format = new SimpleDateFormat("MM/dd/yyyy hh:mm a z");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            json.put("lastAccess", String.valueOf(format.format(settingService.get(GLOBAL, Scope.GLOBAL, LAST_ACCESS).getValue())));
            return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    @GET
    @Path("upgradenodetype/{name}")
    public Response upgradeNodType(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                   @PathParam("name") String name
    ) throws Exception {


        PortalContainer portalContainer = PortalContainer.getInstance();
        ChromatticManager manager = (ChromatticManager) portalContainer.getComponentInstanceOfType(ChromatticManager.class);
        SocialChromatticLifeCycle lifeCycle = (SocialChromatticLifeCycle) manager.getLifeCycle(SocialChromatticLifeCycle.SOCIAL_LIFECYCLE_NAME);
        RepositoryService repositoryService = (RepositoryService) portalContainer.getComponentInstanceOfType(RepositoryService.class);
        Session session = null;

        ManageableRepository repository = repositoryService.getCurrentRepository();
        SessionProviderService sessionProviderService = (SessionProviderService) portalContainer.getComponentInstanceOfType(SessionProviderService.class);
        SessionProvider sProvider = sessionProviderService.getSystemSessionProvider(null);
        session = sProvider.getSession(lifeCycle.getWorkspaceName(), repository);
        ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager) session.getWorkspace().getNodeTypeManager();
        try {

            NodeType nodeType = nodeTypeManager.findNodeType(InternalQName.parse("[http://www.exoplatform.org/jcr/tbb/1.0/]projectSubRelationShip"));
            Boolean exist = false;
            for (PropertyDefinition propertyDefinition : nodeType.getPropertyDefinitions()) {
                if (propertyDefinition.getName().equals("tbb:bidScoped")) {
                    exist = true;
                    break;
                }
            }
            if (!exist) {
                LOG.info("Update BBN nodeTypes");
                nodeTypeManager.registerNodeTypes(getModelIS(), ExtendedNodeTypeManager.REPLACE_IF_EXISTS, "text/xml");
                session.save();
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
        return Response.ok("Tenant " + name + " Upgraded", MediaType.APPLICATION_JSON).build();

    }

    @POST
    @Path("createimportnotification/{userId}/{number}")
    public Response createNotification(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                       @PathParam("userId") String userId,
                                       @PathParam("number") int i

    ) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);

        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        try {
            SimpleNotifServiceStorage simpleNotifServiceStorage = (SimpleNotifServiceStorage) PortalContainer.getInstance().getComponentInstanceOfType(SimpleNotifServiceStorage.class);
            simpleNotifServiceStorage.createSimpleNotification(userId, " users imported", BBIMPORT_NOTIF_TYPE, i);

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
        return Response.ok("Notif sent").build();

    }

    @POST
    @Path("sendcsv/{FileName}")
    @Consumes({MediaType.MULTIPART_FORM_DATA})
    public Response sendcsv(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                            @PathParam("FileName") String FileName,
                            @QueryParam("type") String type,
                            File csvfile) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        try {
            if (sourceIdentity == null) {
                return Response.status(Response.Status.UNAUTHORIZED).build();
            }
            if (type == null || type.equals("")) {
                return Response.status(Response.Status.BAD_REQUEST).entity("Unsupported document type").build();
            }
            Attachment attachment = new Attachment();
            attachment.setInputStream(new FileInputStream(csvfile));
            attachment.setMimeType(type);
            attachment.setName(FileName);

            CompanyInfoStorage companyInfoStorage = (CompanyInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(CompanyInfoStorage.class);
            GeneralContractorEntity companyInfo = companyInfoStorage.getCompanyInfo();
            SpaceService spaceService = (SpaceService) PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
            User user = orgService.getUserHandler().findUserByName(sourceIdentity.getRemoteId());
            String mailText = "<table align=\"center\" bgcolor=\"#fff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:12px;color:#666666;line-height:20px;font-family:HelveticaNeue,verdana,arial,tahoma\" width=\"660\">\n" +
                    "\t<tbody>\n" +
                    "\t\t<tr>\n" +
                    "\t\t\t<td align=\"center\" valign=\"middle\">\n" +
                    "\t\t\t<table align=\"center\" bgcolor=\"#fff\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:1px solid #d8d8d8\" width=\"100%\">\n" +
                    "\t\t\t\t<tbody>\n" +
                    "\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t<td height=\"45\" style=\"margin:0;height:45px;font-weight:bold;vertical-align:middle;background-color:#efefef;font-family:HelveticaNeue,arial,tahoma,serif;color:#2f5e92;font-size:18px;text-align:center\" valign=\"middle\">Import CSV Request from Oneteam</td>\n" +
                    "\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t</tbody>\n" +
                    "\t\t\t</table>\n" +
                    "\t\t\t</td>\n" +
                    "\t\t</tr>\n" +
                    "\t\t<tr>\n" +
                    "\t\t\t<td align=\"center\">\n" +
                    "\t\t\t<table align=\"center\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-left:1px solid #d8d8d8;border-right:1px solid #d8d8d8\" width=\"100%\">\n" +
                    "\t\t\t\t<tbody>\n" +
                    "\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t<td>\n" +
                    "\t\t\t\t\t\t<table align=\"center\" bgcolor=\"#fff\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"font-size:12px;color:#333;line-height:20px\" width=\"92%\">\n" +
                    "\t\t\t\t\t\t\t<tbody>\n" +
                    "\t\t\t\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t\t\t\t<td>\n" +
                    "\t\t\t\t\t\t\t\t\t<p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Hi team,</p>\n" +
                    "\n" +
                    "\t\t\t\t\t\t\t\t\t<p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">Import CSV Request from Oneteam, the file is attached:</p>\n" +
                    "\n" +
                    "\t\t\t\t\t\t\t\t\t<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" style=\"width: 500px;\">\n" +
                    "\t\t\t\t\t\t\t\t\t\t<tbody>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td>Tenant</td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td><strong><a href=\"" + Util.getBaseUrl() + "\" target=\"_blank\">" + UsersRestService.getTenantName(Util.getBaseUrl()) + "</a></strong></td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td>Gc Name</td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + user.getFullName() + "</span></td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td>Gc Email</td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + user.getEmail() + "</span></td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td>Company Name</td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + companyInfo.getCompanyName() + "</span></td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t<tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td>Company Phone number</td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t\t<td><span style=\"font-family: HelveticaNeue, verdana, arial, tahoma; font-size: 12px; line-height: 20px;\">" + companyInfo.getCompanyPhone() + "</span></td>\n" +
                    "\t\t\t\t\t\t\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t\t\t\t\t\t\t</tbody>\n" +
                    "\t\t\t\t\t\t\t\t\t</table>\n" +
                    "\n" +
                    "\t\t\t\t\t\t\t\t\t<p style=\"font-family:HelveticaNeue,verdana,arial,tahoma;font-size:13px;margin:25px 0 10px 0;line-height:20px;color:#333\">&nbsp;</p>\n" +
                    "\t\t\t\t\t\t\t\t\t</td>\n" +
                    "\t\t\t\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t\t\t\t</tbody>\n" +
                    "\t\t\t\t\t\t</table>\n" +
                    "\t\t\t\t\t\t</td>\n" +
                    "\t\t\t\t\t</tr>\n" +
                    "\t\t\t\t</tbody>\n" +
                    "\t\t\t</table>\n" +
                    "\t\t\t</td>\n" +
                    "\t\t</tr>\n" +
                    "\t\t<tr>\n" +
                    "\t\t</tr>\n" +
                    "\t</tbody>\n" +
                    "</table>\n";
            String subject = "Import CSV Request from eXo";
            // sendSimpleMail(SUPPORT_MAIL, subject, mailText, attachment);
            return Response.ok("CSV File sent successfully").build();
        } catch (Exception e) {
            LOG.error(e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @GET
    @Path("authenticateuser/{userName}/{password}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response authenticateuser(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                     @PathParam("userName") String userName,
                                     @PathParam("password") String password) throws Exception {
        try {

            JSONObject json = new JSONObject();
            UserHandler uh = orgService.getUserHandler();

            json.put("authenticated", uh.authenticate(userName, password));
            return Response.ok(json.toString(), MediaType.APPLICATION_JSON).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }

    private static void sendSimpleMail(String to, String subject, String mailText, Attachment attachment) {
        MailService mailService = (MailService) PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        Message message = new Message();
        message.setSubject(subject);
        message.setBody(mailText);
        message.setFrom(System.getProperty("gatein.email.smtp.from"));
        message.setMimeType("text/html");
        message.addAttachment(attachment);
        try {
            for (String reciever : to.split(",")) {
                message.setTo(reciever);
                mailService.sendMessage(message);
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

    public InputStream getModelIS() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/portal/tbb-chromattic-nodetypes.xml");
    }

    public void createBBCategory(Node catLocationNode, String catId, String catCsiDesc, String catAbrDesc, String catFullDesc, String groupId, boolean save)
            throws Exception {
        if (!catLocationNode.hasNode(catId)) {
            Node catNode = catLocationNode.addNode(catId, "tbb:category");
            catNode.setProperty("tbb:catAbrDesc", catAbrDesc);
            catNode.setProperty("tbb:catFullDesc", catFullDesc);
            catNode.setProperty("tbb:catCsiDesc", catCsiDesc);
            catNode.setProperty("tbb:groupId", groupId);
            catNode.setProperty("tbb:catCreatedTime", Long.valueOf(System.currentTimeMillis()).longValue());
        }
        if (save) {
            catLocationNode.getSession().save();
        }
    }

    public boolean createSubCat(Node subCatLocationNode, String subId, String catId, SubContractor userProfile, String subRank, String catAbrDesc, String catFullDesc, String catCsiDesc, boolean save)
            throws Exception {
        if (subCatLocationNode.hasNode(subId + "_" + catId)) {
            if (save) {
                subCatLocationNode.getSession().save();
            }
            return false;
        }
        if (userProfile.getUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getUnion() == "") {
            userProfile.setUnion("unknown");
        }

        if (userProfile.getNonUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getNonUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getNonUnion() == "") {
            userProfile.setUnion("unknown");
        }
        Node subCatNode = subCatLocationNode.addNode(subId + "_" + catId, "tbb:subCat");
        subCatNode.setProperty("tbb:subCatId", subId + "_" + catId);
        subCatNode.setProperty("tbb:subId", subId);
        subCatNode.setProperty("tbb:catId", catId);
        subCatNode.setProperty("tbb:subName", userProfile.getFirstName() + " " + userProfile.getLastName());
        subCatNode.setProperty("tbb:subCompany", userProfile.getCompany() == null ? "" : userProfile.getCompany());
        subCatNode.setProperty("tbb:subRank", subRank);
        subCatNode.setProperty("tbb:catAbrDesc", catAbrDesc);
        subCatNode.setProperty("tbb:catFullDesc", catFullDesc);
        subCatNode.setProperty("tbb:catCsiDesc", catCsiDesc);
        subCatNode.setProperty("tbb:subPhone", userProfile.getPhone() == null ? "" : userProfile.getPhone());
        subCatNode.setProperty("tbb:subCity", userProfile.getCity() == null ? "" : userProfile.getCity());
        subCatNode.setProperty("tbb:subState", userProfile.getState() == null ? "" : userProfile.getState());
        subCatNode.setProperty("tbb:subCounty", userProfile.getCounty() == null ? "" : userProfile.getCounty());
        subCatNode.setProperty("tbb:subZip", userProfile.getZip() == null ? "" : userProfile.getZip());
        subCatNode.setProperty("tbb:subUnion", userProfile.getUnion() == null ? "" : userProfile.getUnion());
        subCatNode.setProperty("tbb:subNonUnion", userProfile.getNonUnion() == null ? "" : userProfile.getNonUnion());
        subCatNode.setProperty("tbb:subWeburl", "");

        if (userProfile.getWeburl() == null || userProfile.getWeburl().equals("")) {
            subCatNode.setProperty("tbb:subWeburl", "");

        } else {
            if (userProfile.getWeburl().contains("http"))
                subCatNode.setProperty("tbb:subWeburl", userProfile.getWeburl());
            else {
                subCatNode.setProperty("tbb:subWeburl", "http://" + userProfile.getWeburl());
            }

        }
        if (userProfile.getProview() == null || userProfile.getProview().equals("")) {
            subCatNode.setProperty("tbb:subProview", "");

        } else {
            if (userProfile.getProview().contains("http"))
                subCatNode.setProperty("tbb:subProview", userProfile.getProview());
            else {
                subCatNode.setProperty("tbb:subProview", "http://" + userProfile.getProview());
            }
        }

        if (userProfile.getProviewurl() != null) {
            if (userProfile.getProviewurl().equals("")) {
                subCatNode.setProperty("tbb:subProview", "");

            } else {
                if (userProfile.getProviewurl().contains("http"))
                    subCatNode.setProperty("tbb:subProview", userProfile.getProviewurl());
                else {
                    subCatNode.setProperty("tbb:subProview", "http://" + userProfile.getProviewurl());
                }
            }
        }

        return true;
    }

    public boolean createUserInfo(Node subUserInfoLocationNode, String userId, SubContractor userProfile, boolean save)
            throws Exception {
        if (subUserInfoLocationNode.hasNode(userId)) {
            if (save) {
                subUserInfoLocationNode.getSession().save();
            }
            return false;
        }

        if (userProfile.getUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getUnion() == "") {
            userProfile.setUnion("unknown");
        }

        if (userProfile.getNonUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getNonUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getNonUnion() == "") {
            userProfile.setUnion("unknown");
        }
        Node userInfoNode = subUserInfoLocationNode.addNode(userId, "tbb:subUserInfo");
        userInfoNode.setProperty("tbb:firstName", userProfile.getFirstName());
        userInfoNode.setProperty("tbb:lastName", userProfile.getLastName());
        userInfoNode.setProperty("tbb:displayName", userProfile.getFirstName() + " " + userProfile.getLastName());
        userInfoNode.setProperty("tbb:email", userProfile.getEmail().toLowerCase());
        userInfoNode.setProperty("tbb:notes", userProfile.getNotes());
        userInfoNode.setProperty("tbb:phone", userProfile.getPhone());
        userInfoNode.setProperty("tbb:company", userProfile.getCompany());
        userInfoNode.setProperty("tbb:refUID", userProfile.getRefUID());
        userInfoNode.setProperty("tbb:street", (userProfile.getAddress1() == null) ? userProfile.getStreet() : userProfile.getAddress1());
        userInfoNode.setProperty("tbb:address2", userProfile.getAddress2());
        userInfoNode.setProperty("tbb:city", userProfile.getCity());
        userInfoNode.setProperty("tbb:state", userProfile.getState());
        userInfoNode.setProperty("tbb:county", (userProfile.getCounty() != null) ? userProfile.getCounty() : "");
        userInfoNode.setProperty("tbb:country", userProfile.getCountry());
        userInfoNode.setProperty("tbb:zip", userProfile.getZip());
        userInfoNode.setProperty("tbb:skills", userProfile.getSkills());
        userInfoNode.setProperty("tbb:rank", "0");
        userInfoNode.setProperty("tbb:secondemail", userProfile.getSecondemail());
        userInfoNode.setProperty("tbb:mainPhoneType", userProfile.getMainPhoneType());
        userInfoNode.setProperty("tbb:secondPhone", userProfile.getSecondPhone());
        userInfoNode.setProperty("tbb:secondPhoneType", userProfile.getSecondPhoneType());
        userInfoNode.setProperty("tbb:faxnumber", userProfile.getFaxnumber());
        userInfoNode.setProperty("tbb:prevailingWage", userProfile.getPrevailingWage());
        userInfoNode.setProperty("tbb:union", userProfile.getUnion());
        userInfoNode.setProperty("tbb:nonUnion", userProfile.getNonUnion());
        userInfoNode.setProperty("tbb:tagsArray", userProfile.getTagsArray());
        userInfoNode.setProperty("tbb:StructureEntity", userProfile.getStructure());
        userInfoNode.setProperty("tbb:structureId", userProfile.getStructureId());
        userInfoNode.setProperty("tbb:weburl", "");

        if (userProfile.getWeburl() == null || userProfile.getWeburl().equals("")) {
            userInfoNode.setProperty("tbb:weburl", "");

        } else {
            if (userProfile.getWeburl().contains("http"))
                userInfoNode.setProperty("tbb:weburl", userProfile.getWeburl());
            else {
                userInfoNode.setProperty("tbb:weburl", "http://" + userProfile.getWeburl());
            }

        }
        if (userProfile.getProview() == null || userProfile.getProview().equals("")) {
            userInfoNode.setProperty("tbb:proview", "");

        } else {
            if (userProfile.getProview().contains("http"))
                userInfoNode.setProperty("tbb:proview", userProfile.getProview());
            else {
                userInfoNode.setProperty("tbb:proview", "http://" + userProfile.getProview());
            }
        }

        if (userProfile.getProviewurl() != null) {
            if (userProfile.getProviewurl().equals("")) {
                userInfoNode.setProperty("tbb:proview", "");

            } else {
                if (userProfile.getProviewurl().contains("http"))
                    userInfoNode.setProperty("tbb:proview", userProfile.getProviewurl());
                else {
                    userInfoNode.setProperty("tbb:proview", "http://" + userProfile.getProviewurl());
                }
            }
        }
        if (save) {
            subUserInfoLocationNode.getSession().save();
        }
        return true;
    }

    public boolean createProjectSubRelationShip(Node relationShipLocationNode, String subId, String projectId, String catId, String catCsiDesc, String status, String rank, SubContractor userProfile, boolean save)
            throws Exception {
        if (userProfile.getUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getUnion() == "") {
            userProfile.setUnion("unknown");
        }

        if (userProfile.getNonUnion() == "true") {
            userProfile.setUnion("yes");
        }
        if (userProfile.getNonUnion() == "false") {
            userProfile.setUnion("no");
        }
        if (userProfile.getNonUnion() == "") {
            userProfile.setUnion("unknown");
        }
        if (relationShipLocationNode.hasNode(subId + "_" + projectId + "_" + catId)) {
            Node relation = relationShipLocationNode.getNode(subId + "_" + projectId + "_" + catId);
            relation.setProperty("tbb:subId", subId);
            relation.setProperty("tbb:subName", userProfile.getFirstName() + " " + userProfile.getLastName());
            relation.setProperty("tbb:relRank", rank);
            relation.setProperty("tbb:status", status);
            relation.setProperty("tbb:projectId", projectId);
            relation.setProperty("tbb:relCompany", userProfile.getCompany());
            relation.setProperty("tbb:catCsiDesc", catCsiDesc);
            relation.setProperty("tbb:catId", catId);
            relation.setProperty("tbb:note", "");
            relation.setProperty("tbb:bid", "0");
            relation.setProperty("tbb:relPhone", userProfile.getPhone());
            relation.setProperty("tbb:relCity", userProfile.getCity());
            relation.setProperty("tbb:relState", userProfile.getState());
            relation.setProperty("tbb:relCounty", userProfile.getCounty());
            relation.setProperty("tbb:relUnion", userProfile.getUnion());
            relation.setProperty("tbb:relNonUnion", userProfile.getNonUnion());
            relation.setProperty("tbb:createdTime", Long.valueOf(System.currentTimeMillis()).longValue());

            if (save) {
                relationShipLocationNode.getSession().save();
            }
            return false;
        }
        Node relation = relationShipLocationNode.addNode(subId + "_" + projectId + "_" + catId, "tbb:projectSubRelationShip");
        relation.setProperty("tbb:subId", subId);
        relation.setProperty("tbb:subName", userProfile.getFirstName() + " " + userProfile.getLastName());
        relation.setProperty("tbb:relRank", rank);
        relation.setProperty("tbb:status", status);
        relation.setProperty("tbb:projectId", projectId);
        relation.setProperty("tbb:relCompany", userProfile.getCompany());
        relation.setProperty("tbb:catCsiDesc", catCsiDesc);
        relation.setProperty("tbb:catId", catId);
        relation.setProperty("tbb:note", "");
        relation.setProperty("tbb:bid", "0");
        relation.setProperty("tbb:relPhone", userProfile.getPhone());
        relation.setProperty("tbb:relCity", userProfile.getCity());
        relation.setProperty("tbb:relState", userProfile.getState());
        relation.setProperty("tbb:relCounty", userProfile.getCounty());
        relation.setProperty("tbb:relUnion", userProfile.getUnion());
        relation.setProperty("tbb:relNonUnion", userProfile.getNonUnion());
        relation.setProperty("tbb:createdTime", Long.valueOf(System.currentTimeMillis()).longValue());
        if (save) {
            relationShipLocationNode.getSession().save();
        }
        return true;
    }


    public static String getTenantName(String requestUrl) {

        try {
            URL url = new URL(requestUrl);
            String host = url.getHost().toLowerCase();
            if (host.startsWith("www.")) {
                host = host.substring(4);
            }
            String masterHost = System.getProperty(MASTER_HOST_VARIABLE_NAME);
            if (masterHost == null) {
                masterHost = DEFAULT_MASTER_HOST_NAME;
                LOG.error("System property {}  is not defined. Default value {} is used. ", MASTER_HOST_VARIABLE_NAME,
                        DEFAULT_MASTER_HOST_NAME);
            }

            if (!host.equals(masterHost)) {
                if (host.endsWith(masterHost)) {
                    String tenant = host.split(masterHost)[0];
                    //marker what tenant and masterhost split with '.' dot.
                    int pointPosition = tenant.lastIndexOf(".");
                    if (pointPosition > 0) {
                        host = tenant.substring(0, pointPosition);
                    }
                }
            }
            return host;
        } catch (MalformedURLException e) {
            LOG.error(e.getMessage(), e);
            return null;
        }
    }

    public String getGcGroup(String userName) {
        try {
            Collection<Membership> membershipTypes = orgService.getMembershipHandler().findMembershipsByUserAndGroup(userName, "/organization/gcs");
            List<String> memberShip_ = new ArrayList<String>();
            for (Membership membership : membershipTypes) {
                memberShip_.add(membership.getMembershipType());
            }
            if (memberShip_.contains("gcadmin")) return ("gcadmin");
            if (memberShip_.contains("gcmanager")) return ("gcmanager");
            if (memberShip_.contains("gcmember")) return ("gcmember");
            return ("");
        } catch (Exception e) {
            return ("");
        }
    }

/*
    @GET
    @Path("testcreat/{id}/{firstName}/{lastName}/{companyName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response testCreate(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                     @PathParam("id") String id,
                                     @PathParam("firstName") String firstName,
                                     @PathParam("lastName") String lastName,
                                     @PathParam("companyName") String companyName) throws Exception {
        try {

            JSONObject json = new JSONObject();
            SubContractorDAO subContractorDAO = getService(SubContractorDAO.class,null);
            GeneralContractorDAO generalContractorDAO = getService(GeneralContractorDAO.class,null);
            SubGcDAO subGcDAO = getService(SubGcDAO.class,null);

            SubContractorEntity subContractorEntity = new SubContractorEntity();

            subContractorEntity.setId(id);
            subContractorEntity.setFirstName(firstName);
            subContractorEntity.setLastName(lastName);
            subContractorEntity = subContractorDAO.create(subContractorEntity);

            GeneralContractorEntity generalContractorEntity = new GeneralContractorEntity();
            generalContractorEntity.setCompanyName(companyName);
            generalContractorEntity = generalContractorDAO.create(generalContractorEntity);

            SubGcEntity subGcEntity =new SubGcEntity(subContractorEntity,generalContractorEntity);
            subGcDAO.create(subGcEntity);


            return Response.ok("data created").build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @GET
    @Path("testgetallrelations")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response testGetAllRelations(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        try {
            JSONArray json = new JSONArray();

            SubGcDAO subGcDAO = getService(SubGcDAO.class,null);

            for (SubGcEntity subGcEntity : subGcDAO.findAll()){
                JSONObject data = new JSONObject();
                data.put("firstName",subGcEntity.getSubContractor().getFirstName());
                data.put("LastName",subGcEntity.getSubContractor().getLastName());
                data.put("companyName",subGcEntity.getGeneralcontractor().getCompanyName());
                json.put(data);
            }


            return Response.ok(json.toString()).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }
*/




  /*  @GET
    @Path("Categ/{id}/{fieldName}/{firstName}/{lastName}")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response categ(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                               @PathParam("id") String id,
                               @PathParam("fieldName") String fieldName,
                               @PathParam("firstName") String firstName,
                               @PathParam("lastName") String lastName)
                               throws Exception {
        try {

            JSONObject json = new JSONObject();
            SubContractorDAO subContractorDAO = getService(SubContractorDAO.class,null);
            CategoryDAO categoryDAO = getService(CategoryDAO.class,null);
            SubCatDAO subCatDAO = getService(SubCatDAO.class,null);

            SubContractorEntity subContractorEntity = new SubContractorEntity();
            subContractorEntity.setId(id);
            subContractorEntity.setLastName(lastName);
            subContractorEntity.setFirstName(firstName);
            subContractorEntity = subContractorDAO.create(subContractorEntity);

            CategoryEntity categoryEntity = new CategoryEntity();
            categoryEntity.setFieldName(fieldName);
            categoryEntity = categoryDAO.create(categoryEntity);

            SubCatEntity subCatEntity =new SubCatEntity(categoryEntity,subContractorEntity);
            subCatEntity= subCatDAO.create(subCatEntity);


            return Response.ok("data created successs").build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }



    @GET
    @Path("testgetCateg")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response testgetCateg(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo) throws Exception {
        try {
                JSONArray json = new JSONArray();

            SubCatDAO subCatDAO = getService(SubCatDAO.class,null);

            for (SubCatEntity subCatEntity : subCatDAO.findAll()){
                JSONObject data = new JSONObject();
                data.put("fieldName",subCatEntity.getCategory().getFieldName());
                data.put("FirstName",subCatEntity.getSubContractor().getFirstName());
                data.put("LastName",subCatEntity.getSubContractor().getLastName());


                json.put(data);
            }


            return Response.ok(json.toString()).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }
*/


    @POST
    @Path("createsubCompany")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createSubCompany(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                     SubContractor userIn) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        if (sourceIdentity == null || !isAdmin(ConversationState.getCurrent().getIdentity())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }

        SubCompanyStorage subCompanyStorage = (SubCompanyStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCompanyStorage.class);

        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);


        try {

            LOG.info("cats  imported");
            endRequest();

            JSONObject jsonGlobal = new JSONObject();
            jsonGlobal.put("message", " SubContractor Created");
            return Response.ok(jsonGlobal.toString(), mediaType).build();
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured: " + e.getMessage()).build();
        }
    }


    @POST
    @Path("invitebymail")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response inviteByMail(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                 BbUser userIn) throws Exception {
        try {
            SubGcDAO subGcDAO = getService(SubGcDAO.class, null);
            StaffDAO staffDAO = getService(StaffDAO.class, null);
            SubContractorDAO subContractorDAO = getService(SubContractorDAO.class, null);
            SubStaffCompanyDAO subStaffCompanyDAO = getService(SubStaffCompanyDAO.class, null);
            StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());


            if (staffEntity != null) {
                Long gcId = staffEntity.getGeneralContractorEntity().getId();

                UserHandler uh = orgService.getUserHandler();
                Query query = new Query();
                query.setEmail(userIn.getEmail().toLowerCase());
                ListAccess<User> users = uh.findUsersByQuery(query);
                User user_ = null;
                if (users.getSize() > 0) {
                    user_ = users.load(0, 1)[0];
                }

                if (user_ != null) {
                    SubStaffCompanyEntity subStaffCompanyEntity = subStaffCompanyDAO.find(user_.getUserName());
                    if (subStaffCompanyEntity != null) {

                        SubGcEntity subGcEntity = new SubGcEntity(subStaffCompanyEntity.getSubContractorEntity(), staffEntity.getGeneralContractorEntity());
                        subGcDAO.create(subGcEntity);
                        String confirmUrl = "/portal/login";
                        sendEmail(userIn, gcId, confirmUrl);
                    }

                    return Response.ok("This subcontractor already exists in the system, he has been added to your contacts").build();
                } else {
                    String confirmUrl = "/portal/gc-portal/subscribe?gcid=" + gcId;
                    sendEmail(userIn, gcId, confirmUrl);
                    return Response.ok("mail sent").build();
                }


            } else {
                return Response.status(Response.Status.UNAUTHORIZED).entity("Not A staff on any gc").build();
            }

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
    }


    @POST
    @Path("invitebymailSub")
    @Consumes({MediaType.APPLICATION_JSON})
    public Response inviteByMailSub(@Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo,
                                    List<SubCatEntity> usersIn) throws Exception {
        try {
            SubGcStorage subGcStorage = (SubGcStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGcStorage.class);
            StaffDAO staffDAO = getService(StaffDAO.class, null);
            SubGcDAO subGcDAO = getService(SubGcDAO.class, null);
            StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
            for (SubCatEntity userIn : usersIn) {
                if (subGcDAO.find(userIn.getSubContractor().getId() + "_" + staffEntity.getGeneralContractorEntity().getId()) == null) {
                    SubGcEntity subGcEntity = new SubGcEntity(userIn.getSubContractor(), staffEntity.getGeneralContractorEntity());
                    subGcDAO.create(subGcEntity);
                    BbUser user = new BbUser();
                    user.setFirstName(userIn.getSubContractor().getFirstName());
                    user.setEmail(userIn.getSubContractor().getEmail());
                    user.setLastName(userIn.getSubContractor().getLastName());
                    String confirmUrl = "/portal/login";
                    sendEmail(user, staffEntity.getGeneralContractorEntity().getId(), confirmUrl);
                }
                else {
                    return Response.status(Response.Status.UNAUTHORIZED).entity("The releation is already exist").build();
                }

            }

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).entity("An internal error has occured").build();
        }
        return Response.ok("mail sent").build();
    }




    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }


    private String generateBodyEmail(BbUser user, Long gcId, String confirmUrl) throws FileNotFoundException {

        BbMessage message = null ;
        ProjectSubDAO projectSubDAO = (ProjectSubDAO) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubDAO.class);
        SubCatDAO subCatDAO = (SubCatDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubCatDAO.class);
        SubGcDAO subGcDAO = (SubGcDAO) PortalContainer.getInstance().getComponentInstanceOfType(SubGcDAO.class);




        StaffDAO staffDAO = getService(StaffDAO.class,null);
        StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());
       /* SpaceService spaceService = Util.getSpaceService(portalContainerName);
        Space space =  spaceService.getSpaceByPrettyName(projectId);*/

        String base_url= System.getProperty("gatein.email.domain.url");
        confirmUrl = base_url+confirmUrl;
        confirmUrl.replace("http","https");



        String creator = staffEntity.getFirstName()+" "+staffEntity.getLastName()!= null ? staffEntity.getLastName():"";
        String phone = staffEntity.getGeneralContractorEntity().getCompanyPhone()!= null ? staffEntity.getGeneralContractorEntity().getCompanyPhone():"";
        String mail = staffEntity.getGeneralContractorEntity().getEmail()!= null ? staffEntity.getGeneralContractorEntity().getEmail():"";
        String companyName = staffEntity.getGeneralContractorEntity().getCompanyName()!= null ? staffEntity.getGeneralContractorEntity().getCompanyName():"";
        String contact = staffEntity.getGeneralContractorEntity().getCompanyCountry()+""+staffEntity.getGeneralContractorEntity().getCompanyState()+" "+staffEntity.getGeneralContractorEntity().getCompanyCity();
        LOG.info(" send email hello "+user.getEmail()+" for gc = "+gcId);
        String imagePath = base_url+"/exo-community-webui-portlet/skin/images";
        Map<String, String> props = new HashMap<String, String>();
        props.put("imagepath",imagePath);

        props.put("confirmUrl",confirmUrl);
        props.put("CREATOR",creator);
        props.put("MAIL",mail);
        props.put("FULL_NAME",user.getFirstName()+ " "+ user.getLastName());
        props.put("FIRST_NAME",user.getFirstName());
        props.put("CONTACT",contact);
        props.put("PHONE",phone);
        props.put("COMPANYNAME",companyName);

        return this.resolveTemplate(props);
    }
    private String resolveTemplate(Map<String, String> properties) throws FileNotFoundException {

        String templateContent = generateBodyEmailContent();
        if (templateContent != null) {
            for (Map.Entry<String, String> property : properties.entrySet()) {
                if(null != property.getKey() && null != property.getValue())
                    templateContent = templateContent.replace("${" + property.getKey() + "}", property.getValue());
            }
        }
        return templateContent;
    }

    private String generateBodyEmailContent(){
        try {
            InputStream bodyEmailIS =  this.getClass().getResourceAsStream("/html/template_register_email.html");
            Scanner scanner = new Scanner(bodyEmailIS);
            StringBuilder sb = new StringBuilder();

            try {
                while (scanner.hasNextLine()) {
                    sb.append(scanner.nextLine()).append(System.getProperty("line.separator"));
                }
            } finally {
                scanner.close();
            }
            return sb.toString();

        } catch (Exception e) {
            LOG.error(" ==== ERR cannot get body email content ", e);
        }
        return null;

    }

    public void sendEmail(BbUser user, Long gcId, String confirmUrl) {
        LOG.debug("=== send register  email to "+user.getEmail()+") ");
        MailService mailService = getService(MailService.class,null);
        Message message = new Message();
        message.setReceiver(user.getEmail());
        message.setTo(user.getEmail());
        try {
            String body = this.generateBodyEmail(user,gcId, confirmUrl);
            message.setBody(body);
            message.setFrom(System.getProperty("gatein.email.smtp.from"));
            message.setMimeType("text/html");
            message.setSubject("INVITATION TO COLLABORATE");
            mailService.sendMessage(message);
        } catch (FileNotFoundException e) {
            LOG.error("=== register: send confirmation email: cannot file email temmplate ");
        } catch (Exception e) {
            LOG.error("=== Registration process: send confirmation email "+e.getMessage());
        }
    }

}
