package org.exoplatform.ps.service.listener;

import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.integration.notification.PSCreateProjectPlugin;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.service.rest.Util;

import javax.ws.rs.core.Response;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

public class CreateProjectListener extends Listener<Space,String> {

    @Override
    public void onEvent(Event<Space, String> event) throws Exception {

        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        List<StaffEntity> receivers_ = staffDAO.getStaffByGcAndRole("manager",0,0);

        Set<String> receivers = new HashSet<String>();

        for(StaffEntity staffEntity : receivers_){
            receivers.add(staffEntity.getId());
        }

        Space project = event.getSource();
        String creator = event.getData();


        // Send Notification

        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PSCreateProjectPlugin.PROJECT, project).append(PSCreateProjectPlugin.CREATOR,creator).append(PSCreateProjectPlugin.RECEIVERS,receivers);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(PSCreateProjectPlugin.ID))).execute(ctx);

        //Create events on calendar

        DateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd hh:mma z");
        DateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy");
        Identity prIdentity = Util.getIdentityManager("portal").getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), true);
        Profile sProfile = prIdentity.getProfile();

        Identity sourceIdentity = Util.getAuthenticatedUserIdentity("portal");
        String owner = sourceIdentity.getRemoteId();
        String[] parts = {owner};
        String[] partStatus = {owner + ":yes"};

        CalendarService calService = (CalendarService) PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        CalendarSetting setting = calService.getCalendarSetting(owner);
        formatter1.setTimeZone(TimeZone.getTimeZone(setting.getTimeZone()));
        Date duedate = formatter1.parse(String.valueOf(sProfile.getProperty("bidsDueDate")));
        CalendarEvent duedateevent = new CalendarEvent();
        duedateevent.setId(project.getPrettyName() + " - bidsDueDate");
        duedateevent.setSummary(project.getDisplayName() + " - Bid Due Date");
        duedateevent.setCalendarId(project.getPrettyName() + "_space_calendar");
        duedateevent.setDescription(project.getDescription());
        duedateevent.setFromDateTime(duedate);
        duedateevent.setToDateTime(duedate);
        duedateevent.setParticipant(parts);
        duedateevent.setParticipantStatus(partStatus);
        calService.savePublicEvent(duedateevent.getCalendarId(), duedateevent, true);

        if (sProfile.getProperty("preBidMeetingDate").toString().compareTo("") != 0) {
            Date prebiddate = formatter1.parse(String.valueOf(sProfile.getProperty("preBidMeetingDate")));
            CalendarEvent prebiddateevent = new CalendarEvent();
            prebiddateevent.setId(project.getPrettyName() + " - preBidMeeting");
            prebiddateevent.setSummary(project.getDisplayName() + "- Pre-Bid Meeting");
            prebiddateevent.setCalendarId(project.getPrettyName() + "_space_calendar");
            prebiddateevent.setDescription(project.getDescription());
            prebiddateevent.setFromDateTime(prebiddate);
            prebiddateevent.setToDateTime(prebiddate);
            prebiddateevent.setParticipant(parts);
            prebiddateevent.setParticipantStatus(partStatus);
            calService.savePublicEvent(prebiddateevent.getCalendarId(), prebiddateevent, true);
        }

        if (sProfile.getProperty("startDate").toString().compareTo("") != 0) {

            Date startdate = formatter1.parse(String.valueOf(sProfile.getProperty("startDate")));
            CalendarEvent startdateevent = new CalendarEvent();
            startdateevent.setId(project.getPrettyName() + " - startDate");
            startdateevent.setSummary(project.getDisplayName() + "- Start Date");
            startdateevent.setCalendarId(project.getPrettyName() + "_space_calendar");
            startdateevent.setDescription(project.getDescription());
            startdateevent.setFromDateTime(startdate);
            startdateevent.setToDateTime(startdate);
            startdateevent.setParticipant(parts);
            startdateevent.setParticipantStatus(partStatus);
            calService.savePublicEvent(startdateevent.getCalendarId(), startdateevent, true);
        }

    }

}


