/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.storage.api;

import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.SubCatEntity;

import java.util.List;

/**

 */
public interface ProjectSubRelationShipStorage {

    public abstract ProjectSubEntity createProjectSubRelationShip(SubCatEntity subCat, String projectId, String status, String note, String relrank, String bidScoped) throws Exception;

    public abstract void deleteProjectSubRelationShip(String relationName) throws Exception;

    public abstract ProjectSubEntity updateProjectSubRelationShip(String relationName, SubCatEntity subCat, String status, String note, String bid, String relrank, String bidScoped) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipBySubId(String subId, int offset, int limit) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipBySubIdAndCatId(String subId, String catId, int offset, int limit) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipByProjectId(String projectId, int offset, int limit) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipByProjectIdAndSearchConditions(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String sortBy, String sortDir, String projectId, long offset, long limit) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipByProjectIdAndStatus(String projectId, String status, int offset, int limit) throws Exception;

    public abstract int getRelationShipCountByProjectIdAndStatus(String projectId, String status) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipByProjectIdAndCatId(String projectId, String catId, int offset, int limit) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipBySubIdAndStatus(String subId, String status, int offset, int limit) throws Exception;

    public abstract List<ProjectSubEntity> getRelationShipByProjectIdAndSubId(String projectId, String subId, int offset, int limit) throws Exception;

    public abstract int getRelationShipCountByProjectIdAndSubId(String projectId, String subId) throws Exception;

    public abstract int getRelationShipCountByProjectIdAndCatId(String projectId, String catId) throws Exception;

    public abstract int getRelationShipCountBySubIdAndStatus(String subId, String status) throws Exception;

    public abstract ProjectSubEntity getRelationShip(String subId, String projectId, String catId) throws Exception;

    public abstract ProjectSubEntity getRelationShip(String SubCatProjectID) throws Exception;

    public abstract int getRelationShipsCountbyProjectIdCatIdAndstatus(String projectId, String catId, String status) throws Exception;

    public abstract int getRelationShipCountBySubId(String subId) throws Exception;

    public abstract int getRelationShipCountByProjectId(String projectId) throws Exception;

    public abstract int getRelationShipCountByProjectIdAndSearchConditions(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String projectId) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipBySubIdListAccess(String subId) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipByProjectIdListAccess(String projectId) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndSearchCondListAccess(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String sortBy, String sortDir, String projectId) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndCatIdListAccess(String projectId, String catId) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndStatusListAccess(String projectId, String status) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipByProjectIdAndSubIdListAccess(String projectId, String subId) throws Exception;

    public abstract ListAccess<ProjectSubEntity> getRelationShipBySubIdAndStatusListAccess(String subId, String status) throws Exception;
}
