package org.exoplatform.ps.storage.impl;

import org.exoplatform.ps.DAO.SubGcDAO;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubGcEntity;
import org.exoplatform.ps.storage.api.SubGcStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.storage.impl.AbstractStorage;

public class SubGcStorageImpl extends AbstractStorage implements SubGcStorage {

    private static final Log LOG = ExoLogger.getLogger(SubGcStorageImpl.class);
    private SubGcDAO subGcDAO = new SubGcDAO();

    public SubGcStorageImpl(SubGcDAO subGcDAO) {
        this.subGcDAO = subGcDAO;
    }


    @Override
    public SubGcEntity createSubGc(SubContractorEntity subContractorEntity, GeneralContractorEntity generalContractorEntity) throws Exception {

       SubGcEntity subGcEntity = new SubGcEntity(subContractorEntity,generalContractorEntity);
        return subGcDAO.create(subGcEntity);
    }

    @Override
    public void deleteSubGc(String id) throws Exception {
        SubGcEntity subGcEntity  = subGcDAO.find(id);
        subGcDAO.delete(subGcEntity);

    }

    @Override
    public SubGcEntity getSubGc(String id) throws Exception {
        SubGcEntity subGcEntity = subGcDAO.find(id);

        return subGcEntity;

    }

    @Override
    public void updateSubCat(String id, SubCatEntity subCatEntity, GeneralContractorEntity generalContractorEntity) throws Exception {

    }
}
