/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.integration.notification;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.integration.notification.TemplateUtils;
import org.exoplatform.ps.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="PSSendITBPlugin", template="war:/notification/templates/mail/PSSendITBPlugin.gtmpl"), @TemplateConfig(pluginId="PSSendMsgPlugin", template="war:/notification/templates/mail/PSSendMsgPlugin.gtmpl"), @TemplateConfig(pluginId="PSCreateProjectPlugin", template="war:/notification/templates/mail/PSCreateProjectPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
    protected static Log log = ExoLogger.getLogger(MailTemplateProvider.class);

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"PSSendITBPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"PSSendMsgPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"PSCreateProjectPlugin"), new TemplateBuilder());
    }

    public static String getExcerpt(String str, int len) {
        if (str == null) {
            return "";
        }
        if (str.length() > len) {
            str = str.substring(0, len);
            int lastSpace = str.lastIndexOf(" ");
            return (lastSpace > 0 ? str.substring(0, lastSpace) : str) + "...";
        }
        return str;
    }

    protected String getDate(String date, String userName) {
        if (date != null) {
            Date date_ = new Date(Long.parseLong(date));
            return TemplateUtils.format(date_, this.getUserTimezone(userName));
        }
        return "";
    }

    public TimeZone getUserTimezone(String username) {
        try {
            CalendarService calService = (CalendarService)CommonsUtils.getService(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception e) {
            log.error((Object)"Can't retrieve timezone", (Throwable)e);
            return null;
        }
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext ctx) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            log.info((Object)("Prepare Mail notif for " + notification.getKey().getId()));
            String creator = notification.getValueOwnerParameter("creator");
            String creatorStaff = notification.getValueOwnerParameter("creatorStaff");
            String gc_contact = notification.getValueOwnerParameter("gc_contact");
            String gc_phone = notification.getValueOwnerParameter("gc_phone");
            String description = notification.getValueOwnerParameter("project_descr");
            String companyname = notification.getValueOwnerParameter("companyname");
            String projectname = notification.getValueOwnerParameter("projectname");
            String ProjectUrl = notification.getValueOwnerParameter("ProjectUrl");
            String url = notification.getValueOwnerParameter("url");
            String subcontractor = notification.getValueOwnerParameter("subcontractor");
            String projectStatus = notification.getValueOwnerParameter("projectstatus");
            String projectType = notification.getValueOwnerParameter("projectType");
            String totalSqFt = notification.getValueOwnerParameter("totalSqFt");
            String ownerType = notification.getValueOwnerParameter("ownerType");
            String categorie = notification.getValueOwnerParameter("categorie");
            String bidsDueDate = notification.getValueOwnerParameter("bids_due");
            String mail = notification.getValueOwnerParameter("mail");
            String sub_company = notification.getValueOwnerParameter("sub_company");
            String phone = notification.getValueOwnerParameter("phone");
            String pre_bid = notification.getValueOwnerParameter("pre_bid");
            String pre_bid_meeting = notification.getValueOwnerParameter("pre_bid_meeting");
            String stories_above_grd = notification.getValueOwnerParameter("stories_above_grd");
            String nbBuildings = notification.getValueOwnerParameter("nbBuildings");
            String contact = notification.getValueOwnerParameter("contact");
            String endDate = notification.getValueOwnerParameter("endDate");
            String start_date = notification.getValueOwnerParameter("start_date");
            String period = notification.getValueOwnerParameter("period");
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            Identity author = identityManager.getOrCreateIdentity("organization", creator, true);
            Profile profile = author.getProfile();
            templateContext.put((Object)"USER", (Object)encoder.encode(profile.getFullName()));
            templateContext.put((Object)"AVATAR", (Object)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)author.getRemoteId()));
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            if (contact != null) {
                templateContext.put((Object)"CONTACT", (Object)contact);
            }
            if (description != null) {
                templateContext.put((Object)"PROJECT_DESCRIPTION", (Object)description);
            }
            if (sub_company != null) {
                templateContext.put((Object)"SUB_COMPANY", (Object)sub_company);
            }
            if (subcontractor != null) {
                templateContext.put((Object)"SUB_CONTRACTOR", (Object)subcontractor);
            }
            if (companyname != null) {
                templateContext.put((Object)"COMPANY_NAME", (Object)companyname);
            }
            if (gc_contact != null) {
                templateContext.put((Object)"GC_CONTACT", (Object)gc_contact);
            }
            if (gc_phone != null) {
                templateContext.put((Object)"GC_PHONE", (Object)gc_phone);
            }
            if (creatorStaff != null) {
                templateContext.put((Object)"CREATORSTAFF", (Object)creatorStaff);
            }
            if (phone != null) {
                templateContext.put((Object)"PHONE", (Object)phone);
            }
            if (start_date != null) {
                templateContext.put((Object)"START_DATE", (Object)start_date);
            }
            if (nbBuildings != null) {
                templateContext.put((Object)"NBRBUILDING", (Object)nbBuildings);
            }
            if (stories_above_grd != null) {
                templateContext.put((Object)"STORIES_ABOVE_GRD", (Object)stories_above_grd);
            }
            templateContext.put((Object)"URLPROJECT", (Object)(url != null ? url : ""));
            if (ProjectUrl != null) {
                templateContext.put((Object)"PROJECTURL", (Object)ProjectUrl);
            }
            if (pre_bid_meeting != null) {
                templateContext.put((Object)"PRE_BID_MEETING", (Object)pre_bid_meeting);
            }
            if (mail != null) {
                templateContext.put((Object)"EMAIL", (Object)mail);
            }
            if (pre_bid != null) {
                templateContext.put((Object)"PRE_BID", (Object)pre_bid);
            }
            if (projectname != null) {
                templateContext.put((Object)"PROJECTNAME", (Object)projectname);
            }
            if (projectStatus != null) {
                templateContext.put((Object)"PROJECTSTATUS", (Object)projectStatus);
            }
            if (projectType != null) {
                templateContext.put((Object)"PROJECTTYPE", (Object)projectType);
            }
            if (totalSqFt != null) {
                templateContext.put((Object)"TOTALSQFT", (Object)totalSqFt);
            }
            if (ownerType != null) {
                templateContext.put((Object)"OWNERTYPE", (Object)ownerType);
            }
            if (categorie != null) {
                templateContext.put((Object)"CATEGORIE", (Object)categorie);
            }
            if (period != null) {
                templateContext.put((Object)"PERIOD", (Object)period);
            }
            if (creator != null) {
                templateContext.put((Object)"CREATOR", (Object)creator);
            }
            if (bidsDueDate != null) {
                templateContext.put((Object)"BIDS_DUE", (Object)bidsDueDate);
            }
            if (endDate != null && !endDate.equals("")) {
                templateContext.put((Object)"END_DATE", (Object)CSUtils.formatDate(endDate, CSUtils.getUserTimezone(notification.getTo())));
            }
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = org.exoplatform.commons.notification.template.TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = org.exoplatform.commons.notification.template.TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap<String, LinkedList<NotificationInfo>> map = new HashMap<String, LinkedList<NotificationInfo>>();
            for (NotificationInfo notif : notifications) {
                String subcontractor = notif.getValueOwnerParameter("subcontractor");
                LinkedList<NotificationInfo> tmp = (LinkedList<NotificationInfo>)map.get(subcontractor);
                if (tmp == null) {
                    tmp = new LinkedList<NotificationInfo>();
                    map.put(subcontractor, tmp);
                }
                tmp.add(notif);
            }
            StringBuilder sb = new StringBuilder();
            for (String subcontractor : map.keySet()) {
                List notifs = (List)map.get(subcontractor);
                NotificationInfo first = (NotificationInfo)notifs.get(0);
                String categorie = first.getValueOwnerParameter("categorie");
                if (notifs.size() == 1) {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                } else {
                    templateContext.digestType(DigestTemplate.ElementType.DIGEST_MORE.getValue());
                }
                sb.append("<li style=\"margin:0 0 13px 14px;font-size:13px;line-height:18px;font-family:HelveticaNeue,Helvetica,Arial,sans-serif\"><div style=\"color: #333;\">");
                String digester = org.exoplatform.commons.notification.template.TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }
    }
}

