/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.service.listener;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.integration.notification.PSCreateProjectPlugin;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.service.rest.Util;

public class CreateProjectListener
extends Listener<Space, String> {
    public void onEvent(Event<Space, String> event) throws Exception {
        StaffDAO staffDAO = (StaffDAO)((Object)PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class));
        List<StaffEntity> receivers_ = staffDAO.getStaffByGcAndRole("manager", 0, 0);
        HashSet<String> receivers = new HashSet<String>();
        for (StaffEntity staffEntity : receivers_) {
            receivers.add(staffEntity.getId());
        }
        Space project = (Space)event.getSource();
        String creator = (String)event.getData();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PSCreateProjectPlugin.PROJECT, (Object)project).append(PSCreateProjectPlugin.CREATOR, (Object)creator).append(PSCreateProjectPlugin.RECEIVERS, receivers);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PSCreateProjectPlugin"))).execute(ctx);
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd hh:mma z");
        SimpleDateFormat formatter2 = new SimpleDateFormat("MM/dd/yyyy");
        Identity prIdentity = Util.getIdentityManager((String)"portal").getOrCreateIdentity("space", project.getPrettyName(), true);
        Profile sProfile = prIdentity.getProfile();
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity((String)"portal");
        String owner = sourceIdentity.getRemoteId();
        String[] parts = new String[]{owner};
        String[] partStatus = new String[]{owner + ":yes"};
        CalendarService calService = (CalendarService)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
        CalendarSetting setting = calService.getCalendarSetting(owner);
        formatter1.setTimeZone(TimeZone.getTimeZone(setting.getTimeZone()));
        Date duedate = formatter1.parse(String.valueOf(sProfile.getProperty("bidsDueDate")));
        CalendarEvent duedateevent = new CalendarEvent();
        duedateevent.setId(project.getPrettyName() + " - bidsDueDate");
        duedateevent.setSummary(project.getDisplayName() + " - Bid Due Date");
        duedateevent.setCalendarId(project.getPrettyName() + "_space_calendar");
        duedateevent.setDescription(project.getDescription());
        duedateevent.setFromDateTime(duedate);
        duedateevent.setToDateTime(duedate);
        duedateevent.setParticipant(parts);
        duedateevent.setParticipantStatus(partStatus);
        calService.savePublicEvent(duedateevent.getCalendarId(), duedateevent, true);
        if (sProfile.getProperty("preBidMeetingDate").toString().compareTo("") != 0) {
            Date prebiddate = formatter1.parse(String.valueOf(sProfile.getProperty("preBidMeetingDate")));
            CalendarEvent prebiddateevent = new CalendarEvent();
            prebiddateevent.setId(project.getPrettyName() + " - preBidMeeting");
            prebiddateevent.setSummary(project.getDisplayName() + "- Pre-Bid Meeting");
            prebiddateevent.setCalendarId(project.getPrettyName() + "_space_calendar");
            prebiddateevent.setDescription(project.getDescription());
            prebiddateevent.setFromDateTime(prebiddate);
            prebiddateevent.setToDateTime(prebiddate);
            prebiddateevent.setParticipant(parts);
            prebiddateevent.setParticipantStatus(partStatus);
            calService.savePublicEvent(prebiddateevent.getCalendarId(), prebiddateevent, true);
        }
        if (sProfile.getProperty("startDate").toString().compareTo("") != 0) {
            Date startdate = formatter1.parse(String.valueOf(sProfile.getProperty("startDate")));
            CalendarEvent startdateevent = new CalendarEvent();
            startdateevent.setId(project.getPrettyName() + " - startDate");
            startdateevent.setSummary(project.getDisplayName() + "- Start Date");
            startdateevent.setCalendarId(project.getPrettyName() + "_space_calendar");
            startdateevent.setDescription(project.getDescription());
            startdateevent.setFromDateTime(startdate);
            startdateevent.setToDateTime(startdate);
            startdateevent.setParticipant(parts);
            startdateevent.setParticipantStatus(partStatus);
            calService.savePublicEvent(startdateevent.getCalendarId(), startdateevent, true);
        }
    }
}

