/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.service.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.utils.CommonsUtils;

public class CSUtils {
    public static Calendar getNextDate(Calendar c, long delay) {
        Calendar next = Calendar.getInstance();
        next.setTime(c.getTime());
        next.setTimeZone(TimeZone.getTimeZone("GMT+01"));
        next.setTimeInMillis(next.getTimeInMillis() + delay);
        while (next.get(7) == 7 || next.get(7) == 1) {
            next.add(5, 1);
        }
        return next;
    }

    public static long getDiffBetweenTwoDates(Calendar c1, Calendar c2) {
        Calendar from = Calendar.getInstance();
        from.setTime(c1.getTime());
        Calendar to = Calendar.getInstance();
        to.setTime(c2.getTime());
        if (from.get(11) > 18) {
            from.add(5, 1);
            from.set(11, 9);
            from.set(12, 0);
        }
        if (from.get(11) < 9) {
            from.set(11, 9);
            from.set(12, 0);
        }
        if (to.get(11) > 18) {
            to.set(11, 18);
            to.set(12, 0);
        }
        if (to.get(11) < 9) {
            to.add(5, -1);
            to.set(11, 18);
            to.set(12, 0);
        }
        while (from.get(7) == 7 || from.get(7) == 1) {
            from.add(5, 1);
            from.set(11, 9);
            from.set(12, 0);
        }
        long diff = to.getTimeInMillis() - from.getTimeInMillis();
        while (from.before(to)) {
            if (from.get(7) == 7 || from.get(7) == 1) {
                diff -= 86400000L;
            }
            from.add(5, 1);
        }
        return diff;
    }

    public static String formatDate(String date, TimeZone timezone) {
        if (date == null) {
            return null;
        }
        Calendar today = Calendar.getInstance(timezone);
        Calendar cal = Calendar.getInstance(timezone);
        cal.setTime(new Date(Long.parseLong(date)));
        String format = "MMM dd yyyy";
        if (cal.get(1) == today.get(1)) {
            format = "MMM dd";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setTimeZone(timezone);
        return df.format(cal.getTime());
    }

    public static TimeZone getUserTimezone(String username) {
        try {
            CalendarService calService = (CalendarService)CommonsUtils.getService(CalendarService.class);
            CalendarSetting setting = calService.getCalendarSetting(username);
            return TimeZone.getTimeZone(setting.getTimeZone());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

