/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ps.storage;

import java.util.List;
import org.chromattic.api.query.Ordering;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.api.query.QueryResult;
import org.chromattic.core.query.QueryImpl;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.chromattic.entity.ProviderEntity;
import org.exoplatform.social.core.identity.IdentityResult;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.AbstractStorage;
import org.exoplatform.social.core.storage.query.JCRProperties;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;
import org.exoplatform.social.core.storage.query.QueryFunction;
import org.exoplatform.social.core.storage.query.WhereExpression;

public class UsersSearch
extends AbstractStorage {
    public static final String ASTERISK_STR = "*";
    public static final String PERCENT_STR = "%";
    public static final char ASTERISK_CHAR = '*';
    public static final String SPACE_STR = " ";
    public static final String EMPTY_STR = "";
    public static final String SLASH_STR = "/";
    private static final Log LOG = ExoLogger.getLogger(UsersSearch.class);
    private int size = 0;

    public List<Identity> search(Boolean isVendor, String searchCondition, List<Identity> excludedIdentityList, long offset, long limit, String orderBy, String order) throws IdentityStorageException {
        QueryBuilder builder = this.getSession().createQueryBuilder(ProfileEntity.class);
        WhereExpression whereExpression = new WhereExpression();
        ProviderEntity providerEntity = (ProviderEntity)this.getProviderRoot().getProviders().get("organization");
        if (providerEntity != null) {
            whereExpression.like(JCRProperties.path, (Object)(providerEntity.getPath() + SLASH_STR + PERCENT_STR)).and().not().equals(ProfileEntity.deleted, (Object)"true");
        } else {
            whereExpression.not().equals(ProfileEntity.deleted, (Object)"true");
        }
        PropertyLiteralExpression rankCondition = new PropertyLiteralExpression(String.class, "void-rank");
        PropertyLiteralExpression cateCondition = new PropertyLiteralExpression(String.class, "void-categories");
        PropertyLiteralExpression companyCondition = new PropertyLiteralExpression(String.class, "void-company");
        if (isVendor.booleanValue()) {
            whereExpression.and().not().contains(rankCondition, (Object)"8");
            whereExpression.and().not().contains(rankCondition, (Object)"null");
        }
        if (excludedIdentityList != null & excludedIdentityList.size() > 0) {
            for (Identity identity : excludedIdentityList) {
                whereExpression.and().not().equals(ProfileEntity.parentId, (Object)identity.getId());
            }
        }
        if (searchCondition != null) {
            whereExpression.and().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.fullName), (Object)(PERCENT_STR + searchCondition.toLowerCase() + PERCENT_STR)).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.firstName), (Object)(PERCENT_STR + searchCondition.toLowerCase() + PERCENT_STR)).or().like(whereExpression.callFunction(QueryFunction.LOWER, ProfileEntity.lastName), (Object)(PERCENT_STR + searchCondition.toLowerCase() + PERCENT_STR)).or().like(whereExpression.callFunction(QueryFunction.LOWER, companyCondition), (Object)(PERCENT_STR + searchCondition.toLowerCase() + PERCENT_STR)).or().like(whereExpression.callFunction(QueryFunction.LOWER, cateCondition), (Object)(PERCENT_STR + searchCondition.toLowerCase() + PERCENT_STR));
        }
        builder.where(whereExpression.toString());
        if (!orderBy.equals(EMPTY_STR)) {
            if (order.equals("asc")) {
                builder.orderBy(orderBy, Ordering.ASC);
            }
            if (order.equals("desc")) {
                builder.orderBy(orderBy, Ordering.DESC);
            }
        }
        QueryImpl queryImpl = (QueryImpl)builder.get();
        ((org.exoplatform.services.jcr.impl.core.query.QueryImpl)queryImpl.getNativeQuery()).setCaseInsensitiveOrder(true);
        QueryResult results = queryImpl.objects();
        this.size = results.size();
        if (limit == 0L) {
            limit = results.size();
        }
        IdentityResult identityResult = new IdentityResult(offset, limit, (long)results.size());
        while (results.hasNext()) {
            ProfileEntity profileEntity = (ProfileEntity)results.next();
            Identity identity = this.createIdentityFromEntity(profileEntity.getIdentity());
            Profile profile = this.getStorage().loadProfile(new Profile(identity));
            identity.setProfile(profile);
            identityResult.add(identity);
            if (identityResult.addMore()) continue;
            break;
        }
        return identityResult.result();
    }

    public int getSize() {
        return this.size;
    }

    private Identity createIdentityFromEntity(IdentityEntity identityEntity) {
        return this.getStorage().findIdentityById(identityEntity.getId());
    }

    private IdentityStorage getStorage() {
        ExoContainer container = ExoContainerContext.getContainerByName((String)"portal");
        return (IdentityStorage)container.getComponentInstanceOfType(IdentityStorage.class);
    }
}

