package org.exoplatform.ps.DAO;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.CategoryEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;

public class CategoryDAO extends GenericDAOJPAImpl<CategoryEntity, String> {

    private static final Logger LOG = LoggerFactory.getLogger(CategoryDAO.class);

    public List<CategoryEntity> getAll(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psCategoryEntity.getAll", CategoryEntity.class)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psCategoryEntity.getAll", CategoryEntity.class)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", e);
            throw e;
        }
    }

}