package org.exoplatform.ps.DAO;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;

public class ProjectSubDAO extends GenericDAOJPAImpl<ProjectSubEntity, String> {

    private static final Logger LOG = LoggerFactory.getLogger(ProjectSubDAO.class);


    public List<ProjectSubEntity> getRelationShipBySubId(String subId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findBySubId", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findBySubId", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and SubtId = '" + subId + "'.", e);
            throw e;
        }
    }



    public List<ProjectSubEntity> getRelationShipBySubCat(String subId, String catId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByCatSubId", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .setParameter("catId",catId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByCatSubId", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .setParameter("catId",catId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and SubtId = '" + subId + "' and CatId = '" + catId + "'.", e);
            throw e;
        }
    }




    public List<ProjectSubEntity> getRelationShipByProjectIdAndStatus (String projectId, String status, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdStatus", ProjectSubEntity.class)
                        .setParameter("projectId",projectId)
                        .setParameter("status",status)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdStatus", ProjectSubEntity.class)
                        .setParameter("projectId",projectId)
                        .setParameter("status",status)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and projectId = '" + projectId + "' and status = '" + status + "'.", e);
            throw e;
        }
    }


    public List<ProjectSubEntity> getRelationShipByProjectId (String projectId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectId", ProjectSubEntity.class)
                        .setParameter("projectId",projectId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectId", ProjectSubEntity.class)
                        .setParameter("projectId",projectId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and projectId = '" + projectId , e);
            throw e;
        }
    }

    public List<ProjectSubEntity> getRelationShipByProjectIdAndCatId (String projectId,String catId, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdCatId", ProjectSubEntity.class)
                        .setParameter("projectId", projectId)
                        .setParameter("catId", catId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findByProjectIdCatId", ProjectSubEntity.class)
                        .setParameter("projectId", projectId)
                        .setParameter("catId", catId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and projectId = '" + projectId + "' and CatId = '" + catId, e);
            throw e;
        }

    }

        public List<ProjectSubEntity> getRelationShipBySubIdAndStatus (String subId,String status, int offset, int limit) {

        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdStatus", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .setParameter("status",status)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdStatus", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .setParameter("status",status)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and subId = '" + subId + "' and status = '" + status , e);
            throw e;
        }
    }


    public ProjectSubEntity getRelationShip (String subId,String projectId, String catId) {

         return getEntityManager().createNamedQuery("psProjectSubEntity.findAll", ProjectSubEntity.class)
                .setParameter("subId",subId)
                .setParameter("projectId",projectId)
                .setParameter("catId",catId)
                .getSingleResult();

    }



          public List<ProjectSubEntity> getRelationShipByProjectIdAndSubId (String projectId,String subId, int offset, int limit) {

           try {
               if (offset >= 0 && limit > 0) {
                  return getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdProjectId", ProjectSubEntity.class)
                          .setParameter("subId",subId)
                        .setParameter("projectId",projectId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
               } else {
                   return getEntityManager().createNamedQuery("psProjectSubEntity.findBySubIdProjectId", ProjectSubEntity.class)
                        .setParameter("subId",subId)
                        .setParameter("projectId",projectId)
                        .getResultList();
                      }
               }  catch (Exception e) {
            LOG.warn("Exception while attempting to get SubCat with offset = '" + offset + "' and limit = '" + limit + "'." + "' and subId = '" + subId + "' and projectId = '" + projectId , e);
            throw e;
              }
           }






    public int getRelationShipCountByProjectIdAndCatId(String projectId, String catId) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndCatId", Long.class)
                      .setParameter("projectId", projectId)
                      .setParameter("catId", catId)
                      .getSingleResult().intValue();
    }

    public int getRelationShipCountBySubId(String subId) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountBySubId", Long.class)
                      .setParameter("subId", subId)
                      .getSingleResult().intValue();
    }

    public int getRelationShipCountByProjectId(String projectId) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectId", Long.class)
                      .setParameter("projectId", projectId)
                      .getSingleResult().intValue();
    }

    public int getRelationShipsCountbyProjectIdCatIdAndstatus(String projectId, String catId, String status) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdCatIdAndstatus", Long.class)
                      .setParameter("projectId", projectId)
                      .setParameter("catId", catId)
                      .setParameter("status", status)
                      .getSingleResult().intValue();
    }

    public int getRelationShipCountByProjectIdAndSubId(String projectId, String subId) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndSubId", Long.class)
                      .setParameter("projectId", projectId)
                      .setParameter("subId", subId)
                      .getSingleResult().intValue();
    }

    public int getRelationShipCountBySubIdAndStatus(String subId, String status) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountBySubIdAndStatus", Long.class)
                      .setParameter("subId", subId)
                      .setParameter("status", status)
                      .getSingleResult().intValue();
    }

    public int getRelationShipCountByProjectIdAndStatus(String projectId, String status) {
          return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndStatus", Long.class)
                      .setParameter("projectId", projectId)
                      .setParameter("status", status)
                      .getSingleResult().intValue();
    }


    public int getRelationShipCountByProjectIdAndSearchConditions(boolean isInvitedTable, boolean isVendor, boolean isMessaged, String searchCondition, List<String> SearchConditions, List<ProjectSubEntity> include, String projectId) {

        try {
            return  getEntityManager().createNamedQuery("psProjectSubEntity.findCountByProjectIdAndStatus", Long.class)
                    .setParameter("projectId", projectId)
                    .getSingleResult().intValue();


        } catch (Exception e) {
            LOG.error("Exception while attempting " , e);
            throw e;
        }

    }

}