package org.exoplatform.ps.DAO;

import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.entity.SubGcEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;


public class SubGcDAO extends GenericDAOJPAImpl<SubGcEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(SubGcDAO.class);

    public List<SubGcEntity> getStaffByGc(Long gcId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("pSSubGCEntity.getSubsGcByGc", SubGcEntity.class)
                        .setParameter("gcId",gcId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("pSSubGCEntity.getSubsGcByGc", SubGcEntity.class)
                        .setParameter("gcId",gcId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", e);
            throw e;
        }
    }


    public List<SubContractorEntity> getSubsByGc(Long gcId, int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("pSSubGCEntity.getSubCatsByGc", SubContractorEntity.class)
                        .setParameter("gcId",gcId)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("pSSubGCEntity.getSubCatsByGc", SubContractorEntity.class)
                        .setParameter("gcId",gcId)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", e);
            throw e;
        }
    }


    public int getSubCatsByGcCount (Long gcId) {
        try {
                return getEntityManager().createNamedQuery("pSSubGCEntity.getSubCatsByGcCount", Long.class)
                        .setParameter("gcId",gcId)
                        .getSingleResult().intValue();

        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests.", e);
            throw e;
        }
    }

}