package org.exoplatform.ps.DAO;


import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.ps.entity.SubGroupEntity;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

import java.util.List;

public class SubGroupDAO extends GenericDAOJPAImpl<SubGroupEntity, String> {
    private static final Logger LOG = LoggerFactory.getLogger(SubGroupDAO.class);


    public List<SubGroupEntity> getAll(int offset, int limit) {
        try {
            if (offset >= 0 && limit > 0) {
                return getEntityManager().createNamedQuery("psSubGroupEntity.getAll", SubGroupEntity.class)
                        .setFirstResult(offset)
                        .setMaxResults(limit)
                        .getResultList();
            } else {
                return getEntityManager().createNamedQuery("psSubGroupEntity.getAll", SubGroupEntity.class)
                        .getResultList();
            }
        } catch (Exception e) {
            LOG.warn("Exception while attempting to get requests with offset = '" + offset + "' and limit = '" + limit + "'.", e);
            throw e;
        }
    }

}