/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;

/**
 */
@PrimaryType(name = "tbb:category")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class BBCategory {

    public static final PropertyLiteralExpression<Long> createdTime =
            new PropertyLiteralExpression<Long>(Long.class, "tbb:catCreatedTime");

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();

    @Property(name = "tbb:catAbrDesc")
    public abstract String getAbrDesc();

    public abstract void setAbrDesc(String catAbrDesc);

    @Property(name = "tbb:catFullDesc")
    public abstract String getFullDesc();

    public abstract void setFullDesc(String catFullDesc);

    @Property(name = "tbb:catCsiDesc")
    public abstract String getCsiDesc();

    public abstract void setCsiDesc(String catCsiDesc);

    @Property(name = "tbb:groupId")
    public abstract String getGroupId();

    public abstract void setGroupId(String groupId);

    @Property(name = "tbb:catCreatedTime")
    public abstract Long getCreatedTime();

    public abstract void setCreatedTime(Long createdTime);

}