/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;

/**
 */
@PrimaryType(name = "tbb:companyInfo")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class CompanyInfo {

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();


    @Property(name = "tbb:companyName")
    public abstract String getCompanyName();

    public abstract void setCompanyName(String companyName);

    @Property(name = "tbb:companyStreet")
    public abstract String getCompanyStreet();

    public abstract void setCompanyStreet(String companyStreet);

    @Property(name = "tbb:companyCity")
    public abstract String getCompanyCity();

    public abstract void setCompanyCity(String companyCity);


    @Property(name = "tbb:companyState")
    public abstract String getCompanyState();

    public abstract void setCompanyState(String companyState);

    @Property(name = "tbb:companyZip")
    public abstract String getCompanyZip();

    public abstract void setCompanyZip(String companyZip);

    @Property(name = "tbb:companyCountry")
    public abstract String getCompanyCountry();

    public abstract void setCompanyCountry(String companyZip);

    @Property(name = "tbb:companyPhone")
    public abstract String getCompanyPhone();

    public abstract void setCompanyPhone(String companyPhone);

    @Property(name = "tbb:companyWebSite")
    public abstract String getCompanyWebSite();

    public abstract void setCompanyWebSite(String companyWebSite);


    @Property(name = "tbb:companyProview")
    public abstract String getCompanyProview();

    public abstract void setCompanyProview(String companyProview);

}