/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;

/**
 */
@PrimaryType(name = "tbb:field")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class Field {

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();

    /**
     * The fieldName
     */
    @Property(name = "tbb:fieldName")
    public abstract String getFieldName();

    public abstract void setFieldName(String fieldName);

    /**
     * The Label
     */

    @Property(name = "tbb:label")
    public abstract String getLabel();

    public abstract void setLabel(String label);

    /**
     * The type
     */

    @Property(name = "tbb:type")
    public abstract String getType();

    public abstract void setType(String type);

    /**
     * The value
     */

    @Property(name = "tbb:value")
    public abstract String getValue();

    public abstract void setValue(String value);

    /**
     * The type
     */

    @Property(name = "tbb:required")
    public abstract boolean getRequired();

    public abstract void setRequired(boolean required);

}