/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.exoplatform.ps.chromattic.entity;

import org.chromattic.api.annotations.*;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.social.core.storage.query.PropertyLiteralExpression;

/**
 */
@PrimaryType(name = "tbb:projectSubRelationShip")
@FormattedBy(BaseEncodingObjectFormatter.class)
@NamingPrefix("tbb")
public abstract class ProjectSubRelationShip {

    public static final PropertyLiteralExpression<Long> createdTime =
            new PropertyLiteralExpression<Long>(Long.class, "tbb:createdTime");

    @Id
    public abstract String getId();

    @Name
    public abstract String getName();

    @Path
    public abstract String getPath();

    /**
     * The status of the relationship, including three values: PENDING, ATTENDING, DECLINED and MAYBE.
     */
    @Property(name = "tbb:status")
    public abstract String getStatus();

    public abstract void setStatus(String status);

    /**
     * The rsubId
     */

    @Property(name = "tbb:subId")
    public abstract String getSubId();

    public abstract void setSubId(String subId);

    @Property(name = "tbb:subName")
    public abstract String getSubName();

    public abstract void setSubName(String subName);

    /**
     * The projectID
     */

    @Property(name = "tbb:projectId")
    public abstract String getProjectId();

    public abstract void setProjectId(String projectId);

    @Property(name = "tbb:relRank")

    public abstract String getRelRank();

    public abstract void setRelRank(String relRank);

    @Property(name = "tbb:relCompany")
    public abstract String getRelCompany();

    public abstract void setRelCompany(String relCompany);

    @Property(name = "tbb:catCsiDesc")
    public abstract String getCatCsiDesc();

    public abstract void setCatCsiDesc(String catCsiDesc);

    /**
     * The catID
     */

    @Property(name = "tbb:catId")
    public abstract String getCatId();

    public abstract void setCatId(String CatId);

    @Property(name = "tbb:note")
    public abstract String getNote();

    public abstract void setNote(String note);

    @Property(name = "tbb:bid")
    public abstract String getBid();

    public abstract void setBid(String bid);

    @Property(name = "tbb:relPhone")
    public abstract String getRelPhone();

    public abstract void setRelPhone(String relPhone);

    @Property(name = "tbb:relCity")
    public abstract String getRelCity();

    public abstract void setRelCity(String relCity);

    @Property(name = "tbb:relState")
    public abstract String getRelState();

    public abstract void setRelState(String relState);

    @Property(name = "tbb:relCounty")
    public abstract String getRelCounty();

    public abstract void setRelCounty(String relCounty);

    @Property(name = "tbb:relUnion")
    public abstract String getRelUnion();

    public abstract void setRelUnion(String relUnion);

    @Property(name = "tbb:relNonUnion")
    public abstract String getRelNonUnion();

    public abstract void setRelNonUnion(String relNonUnion);

    @Property(name = "tbb:bidScoped")
    public abstract String getBidScoped();

    public abstract void setBidScoped(String bidScoped);

    /**
     * The time when the relationship is created.
     */
    @Property(name = "tbb:createdTime")
    public abstract Long getCreatedTime();

    public abstract void setCreatedTime(Long createdTime);

}