package org.exoplatform.ps.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * Base abstract class for entities which will hold definitions for created, last modified by and created,
 * last modified by date.
 */
@MappedSuperclass
public abstract class AbstractAuditingEntity implements Serializable {
    private static final long serialVersionUID = 1L;


    @Column(name = "CREATED_DATE", nullable = false)

    protected Date createdDate = new Date();



    @Column(name = "LAST_MODIFIED_DATE")

    protected Date lastModifiedDate = new Date ();


    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }


    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}
