package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;
import java.util.Collection;

@Entity(name = "PSGeneralContractorEntity")
@ExoEntity
@Table(name = "PS_ADDON_GENERAL_CONTRACTOR")
@Data
public class GeneralContractorEntity extends AbstractAuditingEntity  {



    @Id
    @Column(name = "GENERAL_CONTRACTOR_ID")
    @SequenceGenerator(name = "SEQ_PS_GENERAL_CONTRACTOR_ID")
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_PS_GENERAL_CONTRACTOR_ID")
    private Long    id;




    @OneToMany
    @JoinColumn(name = "STAFF_ID")
    private Collection<StaffEntity> staffEntity;


    @Column(name = "COMPANY_NAME")
    private String  companyName;


    @Column(name = "COMPANY_STREET")
    private String  companyStreet;

    @Column(name = "COMPANY_CITY")
    private String  companyCity;

    @Column(name = "EMAIL")
    private String  email;

    @Column(name = "COMPANY_STATE")
    private String  companyState;

    @Column(name = "COMPANY_ZIP")
    private String  companyZip;

    @Column(name = "COMPANY_COUNTRY")
    private String  companyCountry;

    @Column(name = "COMPANY_PHONE")
    private String  companyPhone;

    @Column(name = "COMPANY_WEBSITE")
    private String  companyWebSite;

    @Column(name = "COMPANY_PROVIEW")
    private String  companyProview;

    @Column(name = "STORY")
    private String  story;

    @Column(name = "PROJECT_EXP")
    private String  projectExp;

    @Column(name = "ASSO_MBR")
    private String  assoMbr;

    @Column(name = "SERVICE_AREAS")
    private String  serviceArea;

    @Column(name = "UNION_STATUS")
    private String  unionStatus;

    @Column(name = "ENTREPRISE_TYPE")
    private String  entrepriseType;


    @Column(name = "GC_USER")
    private String  gcUser;

    @Column(name = "AVATAR_ID")
    private Long  avatarId;

}
