package org.exoplatform.ps.entity;


import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;
import java.util.Calendar;

@Entity(name = "PSProjectSubEntity")
@ExoEntity
@Table(name = "PS_ADDON_PROJECT_SUB")
@Data


@NamedQueries({
        @NamedQuery(name = "psProjectSubEntity.findByCatSubId", query = "SELECT a FROM PSProjectSubEntity a where a.category.id  = :catId  AND  a.subContractor.id  = :subId"),
        @NamedQuery(name = "psProjectSubEntity.findByProjectIdStatus", query = "SELECT a FROM PSProjectSubEntity a where a.projectId  = :projectId  AND  a.status = :status"),
        @NamedQuery(name = "psProjectSubEntity.findBySubIdStatus", query = "SELECT a FROM PSProjectSubEntity a where a.subContractor.id  = :subId  AND  a.status = :status"),
        @NamedQuery(name = "psProjectSubEntity.findCountByProjectIdCatIdAndstatus", query = "SELECT a FROM PSProjectSubEntity a where a.projectId = :projectId AND a.category.id  = :catId AND  a.status = :status"),
        @NamedQuery(name = "psProjectSubEntity.findAll", query = "SELECT a FROM PSProjectSubEntity a where a.subContractor.id = :subId AND a.projectId = :projectId AND a.category.id  = :catId"),
        @NamedQuery(name = "psProjectSubEntity.findBySubIdProjectId", query = "SELECT a FROM PSProjectSubEntity a where a.projectId  = :projectId  AND a.subContractor.id  = :subId "),
        @NamedQuery(name = "psProjectSubEntity.findByProjectIdCatId", query = "SELECT a FROM PSProjectSubEntity a where a.projectId  = :projectId  AND  a.category.id = :catId"),
        @NamedQuery(name = "psProjectSubEntity.findByProjectId", query = "SELECT a FROM PSProjectSubEntity a where a.projectId  = :projectId"),
        @NamedQuery(name = "psProjectSubEntity.findCountByProjectIdAndCatId", query = "SELECT  count(a) FROM PSProjectSubEntity a where  a.projectId = :projectId AND a.category.id = :catId"),
        @NamedQuery(name = "psProjectSubEntity.findCountByProjectIdAndSubId", query = "SELECT  count(a) FROM PSProjectSubEntity a where  a.projectId = :projectId AND a.subContractor.id = :subId"),
        @NamedQuery(name = "psProjectSubEntity.findCountBySubIdAndStatus" , query = "SELECT  count(a) FROM PSProjectSubEntity a where  a.subContractor.id = :subId AND a.status = :status"),
        @NamedQuery(name = "psProjectSubEntity.findCountByProjectIdAndStatus", query = "SELECT  count(a) FROM PSProjectSubEntity a where  a.projectId = :projectId AND a.status = :status"),
        @NamedQuery(name = "psProjectSubEntity.findCountBySubId", query = "SELECT  count(a) FROM PSProjectSubEntity a where a.subContractor.id  = :subId "),
        @NamedQuery(name = "psProjectSubEntity.findCountByProjectId" , query = "SELECT  count(a) FROM PSProjectSubEntity a where a.projectId = :projectId "),
        @NamedQuery(name = "psProjectSubEntity.findBySubId", query = "SELECT a FROM PSProjectSubEntity a where a.subContractor.id  = :subId")

})
public class ProjectSubEntity {


    @Id
    @Column(name = "PROJECT_SUB_ID" , nullable = false)
    private String    id;

    @ManyToOne
    @JoinColumn(name = "CATEGORY_ID", nullable = false)
    private CategoryEntity category ;

    @ManyToOne
    @JoinColumn(name = "SUB_CONTRACTOR_ID", nullable = false)
    private SubContractorEntity subContractor;


    @Column(name = "PROJECT_ID", nullable = false)
    private String projectId;

    @Column(name = "PATH")
    private String  path;

    @Column(name = "NOTE")
    private String  note;

    @Column(name = "STATUS")
    private String  status;


    @Column(name = "BID")
    private String  bid;

    @Column(name = "BIDSCOPED")
    private String  bidScoped;

    @Column(name = "UPDATEDATE")
    @Temporal(TemporalType.TIMESTAMP)
    private Calendar updatedate;

}
