package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;

@Entity(name = "PSSubCatEntity")
@ExoEntity
@Table(name = "PS_ADDON_SUB_CAT")
@Data

@NamedQueries({
        @NamedQuery(name = "psSubCatEntity.getBySub", query = "SELECT a FROM PSSubCatEntity a where a.subContractor.id = :subId"),
        @NamedQuery(name = "psSubCatEntity.serch", query = "SELECT  count(a) FROM PSSubCatEntity a "),
        @NamedQuery(name = "psSubCatEntity.getByCat", query = "SELECT a FROM PSSubCatEntity a where a.category.id  = :catId"),
        @NamedQuery(name = "psSubCatEntity.getSubCatByonemail", query = "SELECT a FROM PSSubCatEntity a where a.subContractor.email  = :email"),
        @NamedQuery(name = "psSubCatEntity.getByMail", query = "SELECT a FROM PSSubCatEntity a where a.subContractor.email  = :email"),
        @NamedQuery(name = "psSubCatEntity.getSubCatByGc", query = "SELECT a FROM PSSubCatEntity a, PSSubGCEntity b where a.subContractor.id  = b.subContractor.id and b.generalcontractor.id  = :gc"),

})

public class SubCatEntity {


    @Id
    @Column(name = "SUB_CAT_ID", nullable = false)
    private String    id;

    @ManyToOne
    @JoinColumn(name = "CATEGORY_ID", nullable = false)
    private CategoryEntity category ;




    @ManyToOne
    @JoinColumn(name = "SUB_CONTRACTOR_ID", nullable = false)
    private SubContractorEntity subContractor;



    public SubCatEntity() {
    }


}
