package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;
import javax.persistence.*;


@Entity(name = "PSSubCatGroupEntity")
@ExoEntity
@Table(name = "PS_ADDON_SUB_CAT_GROUP")
@Data

@NamedQueries({
        @NamedQuery(name = "psSubCatGroupEntity.getBySubCatId", query = "SELECT a FROM PSSubCatGroupEntity a where a.subCat.id = :subCatId"),
        @NamedQuery(name = "psSubCatGroupEntity.getBySubGroupId", query = "SELECT a FROM PSSubCatGroupEntity a where a.subGroup.id = :subGroupId"),
        @NamedQuery(name = "psSubCatGroupEntity.getBySubId", query = "SELECT a FROM PSSubCatGroupEntity a where a.subContractor.id = :subId")

})

public class SubCatGroupEntity {

    @Id
    @Column(name = "SUB_CAT_GROUP_ID", nullable = false)
    private String    id;


    @ManyToOne
    @JoinColumn(name = "GENERAL_CONTRACTOR_ID", nullable = false)
    private GeneralContractorEntity generalcontractor ;

    @ManyToOne
    @JoinColumn(name = "CATEGORY_ID", nullable = false)
    private CategoryEntity category ;

    @ManyToOne
    @JoinColumn(name = "SUB_CAT_GROUP_ID", nullable = false)
    private SubGroupEntity subGroup ;

    @ManyToOne
    @JoinColumn(name = "SUB_CAT_ID", nullable = false)
    private SubCatEntity subCat ;

    @ManyToOne
    @JoinColumn(name = "SUB_CONTRACTOR_ID", nullable = false)
    private SubContractorEntity subContractor;


}
