package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;

@Entity(name = "PSSubCompanyEntity")
@ExoEntity
@Table(name = "PS_ADDON_SUB_COMPANY")
@Data

public class SubCompanyEntity {

    @Id
    @Column(name = "SUB_COMPANY_ID")
    @SequenceGenerator(name = "SEQ_PS_SUB_COMPANY_ID")
    @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_PS_SUB_COMPANY_ID")
    private Long    id;


    @ManyToOne
    @JoinColumn(name = "SUB_CONTRACTOR_ID")
    private SubContractorEntity subContractorEntity;

    @Column(name = "FIRST_NAME", nullable = false)
    private String  firstName;

    @Column(name = "LAST_NAME")
    private String  lastName;


    @Column(name = "DISPLAY_NAME")
    private String  displayName;


}
