package org.exoplatform.ps.entity;


import lombok.Data;
import org.exoplatform.commons.api.persistence.ExoEntity;

import javax.persistence.*;

@Entity(name = "PSSubContractorEntity")
@ExoEntity
@Table(name = "PS_ADDON_SUB_CONTRACTOR")

@Data

@NamedQueries({
        @NamedQuery(name = "psSubContractorEntity.getAll", query = "SELECT a FROM PSSubContractorEntity a"),
        @NamedQuery(name = "psSubContractorEntity.getcompany", query = "SELECT a FROM PSSubContractorEntity a where a.company = :company")
})
public class SubContractorEntity extends AbstractAuditingEntity {



    @Id
    @Column(name = "SUB_CONTRACTOR_ID", nullable = false)
    private String    id;


/*
    @ManyToMany
    @JoinColumn(name = "STRUCTURE_ID", nullable = false)
    private StructureEntity structure ;*/

    @Column(name = "FIRST_NAME", nullable = false)
    private String  firstName;

    @Column(name = "LAST_NAME")
    private String  lastName;


    @Column(name = "DISPLAY_NAME")
    private String  displayName;


    @Column(name = "EMAIL")
    private String  email;

    @Column(name = "SECONDE_EMAIL")
    private String  secondemail;

    @Column(name = "WEBSITE")
    private String  webSite;

    @Column(name = "NOTES")
    private String  notes;

    @Column(name = "STORY")
    private String  story;

    @Column(name = "PHONE")
    private String  phone;

    @Column(name = "MAIN_PHONE_TYPE")
    private String  mainPhoneType;

    @Column(name = "SECOND_PHONE")
    private String  secondPhone;

    @Column(name = "SECOND_PHONE_TYPE")
    private String  secondPhoneType;

    @Column(name = "FAX_NUMBER")
    private String  faxnumber;

    @Column(name = "COMPANY")
    private String  company;

    @Column(name = "REFUID")
    private String  refUID;

    @Column(name = "CITY")
    private String  city;

    @Column(name = "STATE")
    private String  state;

    @Column(name = "COUNTRY")
    private String  country;


    @Column(name = "LONLAT")
    private String  lonlat;

    @Column(name = "STREET")
    private String  street;

    @Column(name = "ADRESS2")
    private String  address2;

    @Column(name = "ZIP")
    private String  zip;

    @Column(name = "SKILLS")
    private String skills;

    @Column(name = "RANK")
    private String  rank;

    @Column(name = "PROVIEW")
    private String  proview;

    @Column(name = "PREVAILINGWAGE")
    private String  prevailingWage;

    @Column(name = "SUB_UNION")
    private String  union;

    @Column(name = "NON_UNION")
    private String  nonUnion;

    @Column(name = "WEBURL")
    private String  weburl;

    @Column(name = "ASSO_MBR")
    private String  assoMbr;

    @Column(name = "PROJECT_EXP")
    private String  projectExp;

    @Column(name = "SERVICE_AREAS")
    private String  serviceArea;

    @Column(name = "PREFERRED_BRANDS")
    private String  preferredBrands;

    @Column(name = "MANAGER")
    private String  manager;

    @Column(name = "AVATAR_ID")
    private Long  avatarId;

}
