package org.exoplatform.ps.integration.notification;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.entity.GeneralContractorEntity;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PSCreateProjectPlugin extends BaseNotificationPlugin {

    private static final Log LOG = ExoLogger.getLogger(PSCreateProjectPlugin.class);

    public final static String ID = "PSCreateProjectPlugin";

    public final static ArgumentLiteral<Space> PROJECT = new ArgumentLiteral<Space>(Space.class, "PROJECT");
    public final static ArgumentLiteral<String> CREATOR = new ArgumentLiteral<String>(String.class, "creator");
    public static final ArgumentLiteral<Set> RECEIVERS = new ArgumentLiteral<Set>(Set.class, "receivers");



    IdentityManager identityManager;

    public PSCreateProjectPlugin(InitParams initParams, IdentityManager identityManager) {

        super(initParams);
        this.identityManager = identityManager;

    }

    @Override

    public String getId() {

        return ID;

    }

    @Override
    public boolean isValid(NotificationContext ctx) {

        return true;

    }


    @Override
    protected NotificationInfo makeNotification(NotificationContext ctx) {

        //ArgumentLiteral<GeneralContractorEntity> GCADMIN = new ArgumentLiteral<GeneralContractorEntity>(GeneralContractorEntity.class, "gcAdmin");
        Set<String> receivers = new HashSet<String>();
        String creator = ctx.value(CREATOR);
        final String portalContainerName = "portal";
        Space space = ctx.value(PROJECT);



        Identity prIdentity = Util.getIdentityManager(portalContainerName).getOrCreateIdentity(SpaceIdentityProvider.NAME, space.getPrettyName(), true);
        String IdGc = String.valueOf(prIdentity.getProfile().getProperty("gc"));
        long gcId = Long.parseLong(IdGc);

        return NotificationInfo.instance()

                .setFrom("Create Project")
                .to(new LinkedList<String>(ctx.value(RECEIVERS)))
                .with(NotificationUtils.CREATOR, creator)
                .with(NotificationUtils.PROJECTNAME, space.getDisplayName())
                .with(NotificationUtils.PROJECT_DESCRIPTION, space.getDescription())
                .with(NotificationUtils.PROJECTURL, space.getUrl())
                .with(NotificationUtils.URLPROJECT, CommonsUtils.getCurrentDomain()+"/portal/g/:spaces:"+space.getUrl()+"/"+space.getUrl()+"/projectSettings")
                .key(getKey()).end();

    }
}
