package org.exoplatform.ps.integration.notification;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class PSSendMsgPlugin extends BaseNotificationPlugin {

    private static final Log LOG = ExoLogger.getLogger(PSSendMsgPlugin.class);

    public final static String ID = "PSSendMsgPlugin";

    public final static ArgumentLiteral<ProjectSubEntity> PROJECT = new ArgumentLiteral<ProjectSubEntity>(ProjectSubEntity.class, "PROJECT");
    public final static ArgumentLiteral<String> POSTER = new ArgumentLiteral<String>(String.class, "poster");




    IdentityManager identityManager;

    public PSSendMsgPlugin(InitParams initParams, IdentityManager identityManager) {

        super(initParams);
        this.identityManager = identityManager;

    }


    @Override

    public String getId() {

        return ID;

    }

    @Override
    public boolean isValid(NotificationContext ctx) {

        return true;

    }


    @Override
    protected NotificationInfo makeNotification(NotificationContext ctx) {

        ProjectSubEntity projectSubEntity = ctx.value(PROJECT);
        Set<String> receivers = new HashSet<String>();


        receivers.add(projectSubEntity.getSubContractor().getId());
        StringBuilder projectId = new StringBuilder("SendMsg");
        projectId.append("-").append(projectSubEntity.getId());
        String poster = ctx.value(POSTER);
        String projectid=projectSubEntity.getProjectId();
        final String portalContainerName = "portal";
        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        Space project_ = spaceService.getSpaceByPrettyName(projectid);

        return NotificationInfo.instance()

                .setFrom("SendMsg")
                .to(new LinkedList<String>(receivers))
                .with(NotificationUtils.CREATOR, poster)
                .with(NotificationUtils.SUB_CONTRACTOR,projectSubEntity.getSubContractor().getDisplayName() )
                .with(NotificationUtils.CATEGORIE, projectSubEntity.getCategory().getCatCsiDesc())
                .with(NotificationUtils.PROJECTNAME, project_.getDisplayName())
                .with(NotificationUtils.PROJECTURL, project_.getUrl())
                .with(NotificationUtils.URLPROJECT,"http://localhost:8080/portal/g/:spaces:"+project_.getUrl()+"/"+project_.getUrl())
                .key(getKey()).end();

    }
}
