/*
 * Copyright (C) 2003-2015 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.integration.notification;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ps.service.util.CSUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;
import org.gatein.common.text.EntityEncoder;

import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

@TemplateConfigs(
   templates = {
       @TemplateConfig( pluginId= PSSendITBPlugin.ID, template="war:/notification/templates/web/PSSendITBPlugin.gtmpl"),
       @TemplateConfig( pluginId= PSSendMsgPlugin.ID, template="war:/notification/templates/web/PSSendMsgPlugin.gtmpl"),
       @TemplateConfig( pluginId= PSCreateProjectPlugin.ID, template="war:/notification/templates/web/PSCreateProjectPlugin.gtmpl")
   }
)


public class WebTemplateProvider extends TemplateProvider {

  protected DateFormat formatter = new SimpleDateFormat("E MMM dd HH:mm:ss Z yyyy");
  protected static Log log = ExoLogger.getLogger(WebTemplateProvider.class);
  
  public WebTemplateProvider(InitParams initParams) {
    super(initParams);

    this.templateBuilders.put(PluginKey.key(PSSendITBPlugin.ID), new TemplateBuilder());
    this.templateBuilders.put(PluginKey.key(PSSendMsgPlugin.ID), new TemplateBuilder());
    this.templateBuilders.put(PluginKey.key(PSCreateProjectPlugin.ID), new TemplateBuilder());
  }

  private class TemplateBuilder extends AbstractTemplateBuilder {
    @Override
    protected MessageInfo makeMessage(NotificationContext ctx) {
      NotificationInfo notification = ctx.getNotificationInfo();
      String pluginId = notification.getKey().getId();      

      String language = getLanguage(notification);
      TemplateContext templateContext = TemplateContext.newChannelInstance(getChannelKey(), pluginId, language);
      
      String creator = notification.getValueOwnerParameter(NotificationUtils.CREATOR);
      String url = notification.getValueOwnerParameter(NotificationUtils.URLPROJECT);
      String subcontractor = notification.getValueOwnerParameter(NotificationUtils.SUB_CONTRACTOR);
      String categorie = notification.getValueOwnerParameter(NotificationUtils.CATEGORIE);
      String projectname = notification.getValueOwnerParameter(NotificationUtils.PROJECTNAME);
      String ProjectUrl = notification.getValueOwnerParameter(NotificationUtils.PROJECTURL);
      String userName = notification.getValueOwnerParameter(NotificationUtils.USER_NAME);
      String endDate = notification.getValueOwnerParameter(NotificationUtils.END_DATE);
      String period = notification.getValueOwnerParameter(NotificationUtils.PERIOD);

      EntityEncoder encoder = HTMLEntityEncoder.getInstance();
      IdentityManager identityManager = CommonsUtils.getService(IdentityManager.class);
      Identity identity = identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, creator, true);
      Profile profile = identity.getProfile();
      templateContext.put("USER", encoder.encode(profile.getFullName().toString()));
      templateContext.put("AVATAR", profile.getAvatarUrl() != null ? profile.getAvatarUrl() : LinkProvider.PROFILE_DEFAULT_AVATAR_URL);
      templateContext.put("PROFILE_URL", LinkProviderUtils.getRedirectUrl("user", identity.getRemoteId()));
      //
        templateContext.put("URLPROJECT", url != null ? url:"");

      if(subcontractor!=null) {
        templateContext.put("SUB_CONTRACTOR", subcontractor);
      }


      if(ProjectUrl!=null) {
        templateContext.put("PROJECTURL", ProjectUrl);
      }

      if(categorie!=null) {
        templateContext.put("CATEGORIE", categorie);
      }

      if(projectname!=null) {
        templateContext.put("PROJECTNAME", projectname);
      }

      if(creator!=null) {
        templateContext.put("CREATOR", creator);
      }



      if(period!=null) {
        templateContext.put("PERIOD", period);
      }


      if (endDate != null && !endDate.equals("")) {
        templateContext.put("END_DATE", CSUtils.formatDate(endDate, CSUtils.getUserTimezone(notification.getTo())));
      }


      templateContext.put("READ", Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) ? "read" : "unread");
      templateContext.put("NOTIFICATION_ID", notification.getId());
      Calendar lastModified = Calendar.getInstance();
      lastModified.setTimeInMillis(notification.getLastModifiedDate());
      templateContext.put("LAST_UPDATED_TIME", TimeConvertUtils.convertXTimeAgoByTimeServer(lastModified.getTime(),"EE, dd yyyy", new Locale(language), TimeConvertUtils.YEAR));

      //
      String body = TemplateUtils.processGroovy(templateContext);
      //binding the exception throws by processing template
      ctx.setException(templateContext.getException());
      MessageInfo messageInfo = new MessageInfo();
      return messageInfo.body(body).end();
    }

    @Override
    protected boolean makeDigest(NotificationContext ctx, Writer writer) {
      return false;
    }

  };


}
