package org.exoplatform.ps.listeners;

import org.exoplatform.ps.chromattic.entity.SubUserInfo;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;

import javax.jcr.*;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Medamine on 27/06/2014.
 */
public class CustomizeProjectDriveListener extends SpaceListenerPlugin {


    final public static String SPECIAL_CHARACTER_REPLACEMENT = "___";
    private static final Log LOG = ExoLogger.getLogger(CustomizeProjectDriveListener.class);
    final static private String GROUPS_PATH = "groupsPath";
    public static String WORKSPACE = "collaboration";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    /**
     * RepositoryService used to get current Repository
     */
    private final RepositoryService repositoryService_;
    private ManageDriveService driveService_;
    private SpaceService spaceService_;

    /**
     * NodeHierarchyCreator Service : used to get complet path to a given user Folder
     */
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String groupsPath_;

    private Identity userIdentity;
    private IdentityManager identityManager;

    private static final String SYMLINK_PARENT_NAME        = "My Project Documents";

    private static final String SYMLIN_TYPE         = "exo:symlink";

    private static final String PRIVATE_DRIVE_EXT   = "/Private";

    private final static String WORKSPACE_PROPERTY  = "exo:workspace";

    private final static String UUID                = "exo:uuid";

    private final static String GROP_FOLDER_PATH        = "/Groups";

    private final static String PRIMARY_TYPE        = "exo:primaryType";

    private static final String EXO_OWNER           = "exo:owner";

    public CustomizeProjectDriveListener(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, ManageDriveService driveService, SpaceService spaceService) throws Exception {
        this.repositoryService_ = repositoryService;
        nodeHierarchyCreator_ = nodeHierarchyCreator;
        driveService_ = driveService;
        spaceService_ = spaceService;

    }

    private static Node createFolder(Session session, Node parentNode, String name) throws Exception {
        Node orgIntServNode = parentNode.addNode(name, "nt:folder");
        if (orgIntServNode.canAddMixin("exo:privilegeable"))
            orgIntServNode.addMixin("exo:privilegeable");
        Map<String, String[]> permissionsMap = new HashMap<String, String[]>();
        String subgroupIdentity = "*:/organization/subcontractors";
        String gcsgroupIdentity = "*:/organization/gcs";
        String rootIdentity = PropertyManager.getProperty("exo.super.user");
        permissionsMap.put(subgroupIdentity, PermissionType.DEFAULT_AC);
        permissionsMap.put(gcsgroupIdentity, PermissionType.ALL);
        permissionsMap.put(rootIdentity, PermissionType.ALL);
        permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
        permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
        if (permissionsMap != null && !permissionsMap.isEmpty())
            ((ExtendedNode) orgIntServNode).setPermissions(permissionsMap);
        parentNode.getSession().save();
        orgIntServNode.getSession().save();
        return orgIntServNode;
    }

    private static Node createToBeTreatedFolder(Session session, Node parentNode, String name) throws Exception {
        Node orgIntServNode = parentNode.addNode(name, "nt:folder");
        if (orgIntServNode.canAddMixin("exo:privilegeable"))
            orgIntServNode.addMixin("exo:privilegeable");
        Map<String, String[]> permissionsMap = new HashMap<String, String[]>();
        String rootIdentity = PropertyManager.getProperty("exo.super.user");
        String gcsAdminGroupIdentity = "gcadmin:/organization/gcs";
        String gcsManagerGroupIdentity = "gcmanager:/organization/gcs";
        permissionsMap.put(gcsAdminGroupIdentity, PermissionType.ALL);
        permissionsMap.put(gcsManagerGroupIdentity, PermissionType.ALL);
        permissionsMap.put(rootIdentity, PermissionType.ALL);
        permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
        permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
        if (permissionsMap != null && !permissionsMap.isEmpty())
            ((ExtendedNode) orgIntServNode).setPermissions(permissionsMap);
        parentNode.getSession().save();
        orgIntServNode.getSession().save();
        return orgIntServNode;
    }

    @Override
    public void spaceCreated(SpaceLifeCycleEvent event) {
        LOG.info("CustomizeProjectDriveListener Launched");
        Space space = event.getSpace();
        Session session = null;
        try {
            /*Created Project default folders and add permissions to needed users*/
            session = repositoryService_.getCurrentRepository().getSystemSession(WORKSPACE);
            Node rootNode = session.getRootNode();
            Node groupFolder = rootNode.getNode("Groups" + space.getGroupId() + "/Documents");
            Map<String, String[]> permissionsMap = new HashMap<String, String[]>();
            String subgroupIdentity = "*:/organization/subcontractors";
            String gcsgroupIdentity = "*:/organization/gcs";
            String rootIdentity = PropertyManager.getProperty("exo.super.user");
            permissionsMap.put(subgroupIdentity, PermissionType.DEFAULT_AC);
            permissionsMap.put(gcsgroupIdentity, PermissionType.ALL);
            permissionsMap.put(rootIdentity, PermissionType.ALL);
            permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
            permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
            if (permissionsMap != null && !permissionsMap.isEmpty())
                ((ExtendedNode) groupFolder).setPermissions(permissionsMap);
            Node bid = createFolder(session, groupFolder, "BID DOCUMENTS");
            createFolder(session, bid, "Drawings");
            createFolder(session, bid, "Specs");
            createFolder(session, bid, "Addenda");
            createFolder(session, groupFolder, "Project Photos");
            createFolder(session, groupFolder, "Project Contracts");
            createFolder(session, groupFolder, "Transmittals");
            createToBeTreatedFolder(session, groupFolder, "DOCs to be TREATED");
            groupsPath_ = nodeHierarchyCreator_.getJcrPath(GROUPS_PATH);
            String groupId = space.getGroupId();
            String name = space.getPrettyName();
            String workspace = WORKSPACE;
            String permissions = "*:".concat(groupId);
            String homePath = groupsPath_ + groupId + "/Documents";
            String views = "BBIcons, BBList";
            String icon = "";
            boolean viewPreferences = false;
            boolean viewNonDocument = true;
            boolean viewSideBar = true;
            boolean showHiddenNode = false;
            String allowCreateFolder = "true";
            String allowNodeTypesOnTree = "*";
            driveService_.addDrive(name, workspace, permissions, homePath, views, icon, viewPreferences,
                    viewNonDocument, viewSideBar, showHiddenNode, allowCreateFolder, allowNodeTypesOnTree);
            session.save();
            /* add the PLAN_ROOM_TEAM user as member of the project to be able to manage project documents */
            Utils.addToSpace(space,PLAN_ROOM_TEAM);
        } catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), e);
        } finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void spaceRemoved(SpaceLifeCycleEvent event) {

    }

    @Override
    public void applicationActivated(SpaceLifeCycleEvent event) {

    }

    @Override
    public void applicationAdded(SpaceLifeCycleEvent event) {

    }

    @Override
    public void applicationDeactivated(SpaceLifeCycleEvent event) {

    }

    @Override
    public void applicationRemoved(SpaceLifeCycleEvent event) {

    }

    @Override
    public void grantedLead(SpaceLifeCycleEvent event) {

    }

    @Override
    public void joined(SpaceLifeCycleEvent event) {
        Session session = null;
        Node userfolder = null;
        try {
            session = repositoryService_.getCurrentRepository().getSystemSession(WORKSPACE);
            Node SubmittalsFolder = session.getRootNode().getNode("Groups" + event.getSpace().getGroupId() + "/Documents/Transmittals");
            SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
            SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(event.getSource());
            if (userInfo != null && userInfo.getCompany() != null) {
                String companyName = userInfo.getCompany();
                if (!companyName.equals("")) {
                    if (!SubmittalsFolder.hasNode(Text.escapeIllegalJcrChars(org.exoplatform.services.cms.impl.Utils.cleanString(companyName))))
                        userfolder = SubmittalsFolder.addNode(Text.escapeIllegalJcrChars(org.exoplatform.services.cms.impl.Utils.cleanString(companyName)), "nt:folder");
                    userfolder = SubmittalsFolder.getNode(Text.escapeIllegalJcrChars(org.exoplatform.services.cms.impl.Utils.cleanString(companyName)));
                    if (userfolder.canAddMixin("exo:privilegeable"))
                        userfolder.addMixin("exo:privilegeable");
                    Map<String, String[]> permissionsMap = new HashMap<String, String[]>();
                    String gcsgroupIdentity = "*:/organization/gcs";
                    String rootIdentity = PropertyManager.getProperty("exo.super.user");
                    permissionsMap.put(event.getTarget(), PermissionType.ALL);
                    permissionsMap.put(gcsgroupIdentity, PermissionType.ALL);
                    permissionsMap.put(rootIdentity, PermissionType.ALL);
                    permissionsMap.put(PLAN_ROOM_TEAM, PermissionType.ALL);
                    permissionsMap.put(INTEGRATION_USER, PermissionType.ALL);
                    if (permissionsMap != null && !permissionsMap.isEmpty())
                        ((ExtendedNode) userfolder).setPermissions(permissionsMap);
                    SubmittalsFolder.getSession().save();
                    userfolder.getSession().save();
                }
            }
            // createLink(event.getSource(),session,event.getSpace());
        }catch(PathNotFoundException PNFE) {
            LOG.error("Groups" + event.getSpace().getGroupId() + "/Documents/Transmittals Not Found");

        } catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), e);
        }
    }



    @Override
    public void left(SpaceLifeCycleEvent event) {
        Session session = null;
        try {
            String userName= event.getSource();
            Space  space=event.getSpace();
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            session = repositoryService_.getCurrentRepository().getSystemSession(WORKSPACE);
            Node userNode = nodeHierarchyCreator_.getUserNode(sessionProvider, userName);

            String privatePathUserFolder = userNode.getPath().concat(PRIVATE_DRIVE_EXT);

            Node symLinkParent = (Node) session.getItem(privatePathUserFolder);

            if (!symLinkParent.hasNode(SYMLINK_PARENT_NAME)) {
                    return;
            } else {
                symLinkParent = symLinkParent.getNode(SYMLINK_PARENT_NAME);
            }

            Node linkNode = null;
            if  (symLinkParent.hasNode(space.getDisplayName())){
                linkNode = symLinkParent.getNode(space.getDisplayName());
                linkNode.remove();
                symLinkParent.getSession().save();
            }


        } catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void revokedLead(SpaceLifeCycleEvent event) {

    }

    @Override
    public void spaceRenamed(SpaceLifeCycleEvent event) {

    }

    @Override
    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {

    }

    @Override
    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {

    }

    @Override
    public void spaceAccessEdited(SpaceLifeCycleEvent event) {

    }

    @Override
    public void addInvitedUser(SpaceLifeCycleEvent event) {
        // TODO Auto-generated method stub

    }


    @Override
    public void addPendingUser(SpaceLifeCycleEvent event) {
        // TODO Auto-generated method stub

    }

    @Override
    public void spaceRegistrationEdited(SpaceLifeCycleEvent event) {

    }

    @Override
    public void spaceBannerEdited(SpaceLifeCycleEvent spaceLifeCycleEvent) {

    }

    private void createLink(String userName, Session session, Space space) throws Exception
    {

        SessionProvider sessionProvider = SessionProvider.createSystemProvider();



        /** path to private user drive*/
        String privatePathUserFolder = "";

        /** path to group user drive*/
        String groupPathFolder = "";

        try {

            Node userNode = nodeHierarchyCreator_.getUserNode(sessionProvider, userName);

            privatePathUserFolder = userNode.getPath().concat(PRIVATE_DRIVE_EXT);

            groupPathFolder = GROP_FOLDER_PATH;

            groupPathFolder=groupPathFolder+space.getGroupId()+"/Documents";


            Node symLinkParent = (Node) session.getItem(privatePathUserFolder);

            if (!symLinkParent.hasNode(SYMLINK_PARENT_NAME)) {
                symLinkParent = symLinkParent.addNode(SYMLINK_PARENT_NAME, "nt:folder");
                if (symLinkParent.canAddMixin("exo:privilegeable"))
                    symLinkParent.addMixin("exo:privilegeable");
                ((ExtendedNode)symLinkParent).setPermission(IdentityConstants.ANY, new String[]{PermissionType.READ});
                symLinkParent.getSession().save();
            } else {
                symLinkParent = symLinkParent.getNode(SYMLINK_PARENT_NAME);
            }

            Node targetNode = (Node) session.getItem(groupPathFolder);

            Node linkNode = null;
            if  (!symLinkParent.hasNode(space.getDisplayName())){
                linkNode = createLink(symLinkParent,SYMLIN_TYPE,targetNode,space.getDisplayName());

                ((ExtendedNode)linkNode).setPermission(IdentityConstants.ANY, new String[]{PermissionType.READ});

                linkNode.save();
            }


        } catch (Exception e) {

            LOG.error("An error occurs while processing the creation of Spaces Symlink " ,e.getMessage());

        }  finally {

            if (session != null) {
                session.logout();
            }

            if (sessionProvider != null) {
                sessionProvider.close();
            }

        }
    }


    private Node createLink(Node parent, String linkType, Node target, String linkName) throws RepositoryException {
        if (!target.isNodeType(SYMLIN_TYPE)) {
            if (target.canAddMixin("mix:referenceable")) {
                target.addMixin("mix:referenceable");
                target.getSession().save();
            }
            if (linkType == null || linkType.trim().length() == 0)
                linkType = SYMLIN_TYPE;
            if (linkName == null || linkName.trim().length() == 0)
                linkName = target.getName();
            Node linkNode = parent.addNode(linkName, linkType);
            try {
                updateAccessPermissionToLink(linkNode, target);
            } catch(Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("CAN NOT UPDATE ACCESS PERMISSIONS FROM TARGET NODE TO LINK NODE", e.getMessage());
                }
            }
            linkNode.setProperty(WORKSPACE_PROPERTY, target.getSession().getWorkspace().getName());
            linkNode.setProperty(PRIMARY_TYPE, target.getPrimaryNodeType().getName());
            linkNode.setProperty(UUID, target.getUUID());
            linkNode.getSession().save();

            return linkNode;
        }
        return null;
    }

    private boolean canChangePermission(Node node) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(PermissionType.CHANGE_PERMISSION);
            return true;
        } catch(AccessControlException e) {
            return false;
        }
    }

    private void updateAccessPermissionToLink(Node linkNode, Node targetNode) throws Exception {
        if(canChangePermission(linkNode)) {
            if(linkNode.canAddMixin("exo:privilegeable")) {
                linkNode.addMixin("exo:privilegeable");
                ((ExtendedNode)linkNode).setPermission(getNodeOwner(linkNode),PermissionType.ALL);
            }
            removeCurrentIdentites(linkNode);
            Map<String, String[]> perMap = new HashMap<String, String[]>();
            List<String> permsList = new ArrayList<String>();
            List<String> idList = new ArrayList<String>();
            for(AccessControlEntry accessEntry : ((ExtendedNode)targetNode).getACL().getPermissionEntries()) {
                if(!idList.contains(accessEntry.getIdentity())) {
                    idList.add(accessEntry.getIdentity());
                    permsList = ((ExtendedNode)targetNode).getACL().getPermissions(accessEntry.getIdentity());
                    perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[permsList.size()]));
                }
            }
            ((ExtendedNode)linkNode).setPermissions(perMap);
        }
    }

    private String getNodeOwner(Node node) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if(node.hasProperty(EXO_OWNER)) {
            return node.getProperty(EXO_OWNER).getString();
        }
        return IdentityConstants.SYSTEM;
    }
    private void removeCurrentIdentites(Node linkNode) throws AccessControlException, RepositoryException {
        String currentUser = linkNode.getSession().getUserID();
        if (currentUser != null)
            ((ExtendedNode)linkNode).setPermission(currentUser, PermissionType.ALL);
        for(AccessControlEntry accessEntry : ((ExtendedNode)linkNode).getACL().getPermissionEntries()) {
            if(canRemovePermission(linkNode, accessEntry.getIdentity())
                    && ((ExtendedNode)linkNode).getACL().getPermissions(accessEntry.getIdentity()).size() > 0
                    && !accessEntry.getIdentity().equals(currentUser)) {
                ((ExtendedNode) linkNode).removePermission(accessEntry.getIdentity());
            }
        }
    }
    private boolean canRemovePermission(Node node, String identity) throws ValueFormatException,
            PathNotFoundException, RepositoryException {
        String owner = getNodeOwner(node);
        if(identity.equals(IdentityConstants.SYSTEM)) return false;
        if(owner != null && owner.equals(identity)) return false;
        return true;
    }


}
