package org.exoplatform.ps.listeners;

import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.ps.DAO.GeneralContractorDAO;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.DAO.SubContractorDAO;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

/**
 * Created by Medamine on 27/03/2015.
 */
public class LoginListener extends Listener<ConversationRegistry, ConversationState> {
/*

    private static final String GCS_GROUP = "/organization/gcs";

    private static final String SUBS_GROUP = "/organization/subcontractors";
    private static final String ADMIN_GROUP = "/platform/administrators";
    private static final String USERS_GROUP = "/platform/users";
    private static final String PLAN_ROOM_TEAM = "planroomteam";
    private static final String INTEGRATION_USER = "integrationuser";
    private static final String GC_TIMEZONE = "gcTimeZone";
    private static final String LAST_ACCESS = "lastAccess";
*/
    private static final Log LOG = ExoLogger.getLogger(LoginListener.class);
    private final OrganizationService orgService;
    private final CalendarService calendarService;
    private final SettingService settingService;
    private final StaffDAO staffDAO;

    public LoginListener(OrganizationService orgService, SettingService settingService, CalendarService calendarService, StaffDAO staffDAO) throws Exception {
        this.calendarService = calendarService;
        this.settingService = settingService;
        this.orgService = orgService;
        this.staffDAO = staffDAO;
    }


    @Override
    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        LOG.info("LoginListener started");


/*        String userId = event.getData().getIdentity().getUserId();
        String rootIdentity = PropertyManager.getProperty("exo.super.user");


        if (!(userId.equals(rootIdentity)||userId.equals(PLAN_ROOM_TEAM)||userId.equals(INTEGRATION_USER))) {
            settingService.set(Context.GLOBAL, Scope.GLOBAL, LAST_ACCESS, SettingValue.create(System.currentTimeMillis()));
            Boolean isAdmin = event.getData().getIdentity().isMemberOf(ADMIN_GROUP);
            Boolean isGc = event.getData().getIdentity().isMemberOf(GCS_GROUP);
            Boolean isSub = event.getData().getIdentity().isMemberOf(SUBS_GROUP);
            if (isAdmin && !isGc && !isSub) {
                MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
                GroupHandler gHandler = orgService.getGroupHandler();
                MembershipHandler mHandler = orgService.getMembershipHandler();
                UserHandler uh = orgService.getUserHandler();
                User user = uh.findUserByName(userId);
                LOG.info("Adding SubContractor " + user.getFullName() + " to Gc Group as gcAdmin");
                mHandler.removeMembershipByUser(userId, true);
                Group gcGroup = gHandler.findGroupById(GCS_GROUP);
                mHandler.linkMembership(user, gcGroup, mtHandler.findMembershipType("gcadmin"), true);
                Group usersGroup = gHandler.findGroupById(USERS_GROUP);
                mHandler.linkMembership(user, usersGroup, mtHandler.findMembershipType("member"), true);
            }
        }
        CalendarSetting calendarSettings = calendarService.getCalendarSetting(userId);
        if (settingService.get(GLOBAL, Scope.GLOBAL, GC_TIMEZONE) != null) {
            calendarSettings.setTimeZone(settingService.get(GLOBAL, Scope.GLOBAL, GC_TIMEZONE).getValue().toString());
            calendarService.saveCalendarSetting(userId, calendarSettings);
        }*/
    }
}
