package org.exoplatform.ps.listeners;

import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

/**
 * Created by bechir on 12/03/15.
 */
public class UserTimeZoneListener extends UserEventListener {

    private static final String GC_TIMEZONE = "gcTimeZone";

    private static final Log LOG = ExoLogger.getLogger(UserTimeZoneListener.class);

    private final CalendarService calendarService;
    private final SettingService settingService;

    public UserTimeZoneListener(SettingService settingService, CalendarService calendarService) {
        this.calendarService = calendarService;
        this.settingService = settingService;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            CalendarSetting calendarSettings = calendarService.getCalendarSetting(user.getUserName());
            if (settingService.get(Context.GLOBAL, Scope.GLOBAL, GC_TIMEZONE) != null) {
                calendarSettings.setTimeZone(settingService.get(Context.GLOBAL, Scope.GLOBAL, GC_TIMEZONE).getValue().toString());
                calendarService.saveCalendarSetting(user.getUserName(), calendarSettings);
            }
        }
    }
}
