/*
 * Copyright (C) 2003-2014 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.ps.rest;

import org.exoplatform.ps.chromattic.entity.SubUserInfo;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.json.JSONArray;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Path("/bbasservice")
public class ASRestService implements ResourceContainer {
    private static final String portalContainerName = "portal";
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final String GCS_GROUP = "/organization/gcs";
    private static final Log LOG = ExoLogger.getLogger(ASRestService.class.getName());
    OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);

    @GET
    @Path("getGroupMembers/{group}/{isGCReceiver}")
    public Response getGroupMembers(@PathParam("group") String group, @PathParam("isGCReceiver") boolean isGCReceiver, @QueryParam("term") String term) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat("json", SUPPORTED_FORMATS);
        JSONArray jsonArray = new JSONArray();
        if (sourceIdentity == null) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        for (String groupMember : getGroupMembers(group, isGCReceiver)) {
            if (groupMember.toLowerCase().contains(term.toLowerCase())) {
                jsonArray.put(groupMember);
            }
        }
        return Response.ok(jsonArray.toString(), mediaType).build();
    }

    public List<String> getGroupMembers(String group, boolean isGCReceiver) throws Exception {
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
        List<String> groupMembers = new ArrayList<String>();
        for (String groupId : group.split(";")) {
            ListAccess<User> users;
            if (groupId.equals("gcs")) {
                users = orgService.getUserHandler().findUsersByGroupId(GCS_GROUP);
            } else {
                users = orgService.getUserHandler().findUsersByGroupId("/spaces/" + groupId);
            }
            for (User user : users.load(0, users.getSize())) {
                if (!user.getUserName().equals(sourceIdentity.getRemoteId())) {
                    if (isGCMember(user.getUserName()) && isGCMember(sourceIdentity.getRemoteId())) {
                        continue;
                    }
                    if (!isGCReceiver || (isGCReceiver && isGCMember(user.getUserName()))) {
                        if (isGCMember(user.getUserName())) {
                            groupMembers.add(user.getFullName()
                                    + "(Internal Employees)");
                            continue;
                        }
                        SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(user.getUserName());
                        groupMembers.add(user.getDisplayName() + "(" + userInfo.getCompany() + ")");
                    }
                }

            }
        }
        return groupMembers;
    }

    private boolean isGCMember(String userName) throws Exception {
        Collection<Group> groupsList = orgService.getGroupHandler().findGroupsOfUser(userName);
        for (Group group : groupsList) {
            if (group.getId().equals(GCS_GROUP)) {
                return true;
            }
        }
        return false;
    }
}