package org.exoplatform.ps.rest;

import org.exoplatform.ps.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by kevin on 1/2/15.
 */
public class ChangeBidScopeStatusRunner implements Runnable {

    private static final Log LOG = ExoLogger.getLogger(ChangeBidScopeStatusRunner.class.getName());
    private String projectId;
    private String uid;
    private String refuid;
    private String bidStatus;

    private ConversationState myConversationState;

    ChangeBidScopeStatusRunner(String uid, String projectId, String refuid, String bidStatus, ConversationState conversationState) {

        this.uid = uid;
        this.projectId = projectId;
        this.refuid = refuid;
        this.bidStatus = bidStatus;
    }

    @Override
    public void run() {
        if (bidStatus.equals("AWARDED")) bidStatus = "BIDDING";
        if (bidStatus.equals("UNDECIDED")) bidStatus = "REVIEWING";
        if (bidStatus.equals("BIDDING") || bidStatus.equals("REVIEWING")|| bidStatus.equals("NOT_BIDDING")){
            LOG.info("Updating BidScop tatus");
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = null;
            try {
                date = Utils.getTime();
                calendar.setTime(date);
            } catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
            int month = calendar.get(Calendar.MONTH);
            String checksum = uid + "_" + (month + 1) + "bbbuild2015";
            checksum = Utils.getMd5(checksum);
            String webPage = "http://www.theProjectSpace.com/wsnsa.dll/WService=wsbrk1/web_api/woupd_bidstat.p?appname=bb-build&uid=" + uid + "&ProjectID=" + projectId + "&refuid=" + refuid + "&CheckSum=" + checksum + "&bidStatus=" + bidStatus;
            URL url = new URL(webPage);
            HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
            if (urlConnection.getResponseCode() == 200) {
                LOG.info("Status updated: " + urlConnection.getResponseMessage());
            } else {
                LOG.info("Status not updated: " + urlConnection.getResponseMessage());
            }
        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }else LOG.info("Wrong Status");
    }


}
