package org.exoplatform.ps.rest;

import org.exoplatform.ps.DTO.SubContractor;
import org.exoplatform.ps.chromattic.entity.SubUserInfo;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.model.BbUser;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.Utils;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.identity.provider.SpaceIdentityProvider;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ImportRunner implements Runnable {
    private static final Log LOG = ExoLogger.getLogger(ImportRunner.class.getName());
    private static final String portalContainerName = "portal";
    private static Boolean requestStarted = false;
    OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    private List<SubContractor> users = new ArrayList<SubContractor>(1);
    private Identity sourceIdentity;
    private String projectId;
    private ChromatticLifeCycle tbb;
    private ChromatticManager chromatticManager;
    private ConversationState myConversationState;

    ImportRunner(List<SubContractor> users, String projectId, Identity sourceIdentity, ConversationState conversationState) {
        this.users = users;
        this.projectId = projectId;
        this.sourceIdentity = sourceIdentity;
        this.myConversationState = conversationState;
    }


    @Override
    public void run() {
        LOG.info("==================Importing Runner Thread started==================");
        Long start = System.currentTimeMillis();
        //try {


        try {
            RequestLifeCycle.begin(PortalContainer.getInstance());
            ConversationState.setCurrent(myConversationState);
            LOG.info("Conversation state import:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
            createVendors();

        } catch (Exception e) {

            LOG.error(e.getMessage(), e);
        } finally {
            RequestLifeCycle.end();

            LOG.info("=============================== Importing Runner Thread ended in " + String.valueOf(System.currentTimeMillis() - start) + " ms ===============================.");
        }

    }


    public synchronized void createVendors() throws Exception {
        IdentityManager identityManager = (IdentityManager) PortalContainer.getInstance().getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService) PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);

        UserHandler uh = orgService.getUserHandler();
        MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
        GroupHandler gHandler = orgService.getGroupHandler();
        MembershipHandler mHandler = orgService.getMembershipHandler();
        Space project = null;

        if (projectId != null && !projectId.equals("")) {
            project = spaceService.getSpaceByPrettyName(projectId);
        }

        LOG.info("Conversation state import:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
        LOG.info("PortalContainer import:   " + PortalContainer.getInstance().getName());
        User user_ = null;
        int i = 0;
        for (SubContractor userIn : users) {
            LOG.info("Importing user " + userIn.getFirstName() + " " + userIn.getLastName());
            String name = "gc_" + userIn.getUserid();
            name = name.toLowerCase();
            name = name.replace(" ", "");
            name = name.replace(".", "");
            Query query = new Query();
            query.setEmail(userIn.getEmail().toLowerCase());

            try {
                if (!orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl") && uh.findUsersByQuery(query).getSize() > 0) {
                    if (uh.findUserByName(name) == null) {
                        user_ = uh.findUsersByQuery(query).load(0, 1)[0];
                        LOG.warn(userIn.getEmail() + " already exists, Email should be changed");
                        String newEmail = "change_me" + user_.getUserName() + "@gmail.com";
                        user_.setEmail(newEmail);
                        startRequest();
                        uh.saveUser(user_, false);
                        endRequest();
                        SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);
                        chromatticManager = (ChromatticManager) PortalContainer.getInstance().getComponentInstanceOfType(ChromatticManager.class);
                        tbb = chromatticManager.getLifeCycle("tbb");
                        chromatticManager.beginRequest();
                        ChromatticSession session = tbb.getChromattic().openSession();
                        SubContractorEntity userInfo = subUserInfoStorage.getSubUserInfo(user_.getUserName());
                        userInfo.setEmail(newEmail);
                        session.save();

                        chromatticManager.endRequest(true);

                    }
                }
            } catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
            try {
                if (uh.findUserByName(name) != null) {
                    startRequest();
                    user_ = uh.findUserByName(name);

                    user_.setDisplayName(userIn.getFirstName() + " " + userIn.getLastName());
                    if (orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                        user_.setPassword(Utils.getMd5(name));
                    } else {
                        user_.setPassword(name);
                    }
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.saveUser(user_, false);
                    endRequest();

                } else {
                    startRequest();

                    user_ = uh.createUserInstance(name);
                    user_.setDisplayName(userIn.getDisplayName());

                    if (orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                        user_.setPassword(Utils.getMd5(name));
                    } else {
                        user_.setPassword(name);
                    }
                    user_.setEmail(userIn.getEmail().toLowerCase());
                    user_.setLastName(userIn.getLastName());
                    user_.setFirstName(userIn.getFirstName());
                    uh.createUser(user_, false);
                    Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                    mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                    Group usersGroup = gHandler.findGroupById("/platform/users");
                    mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                    LOG.info("SubContractor " + userIn.getFirstName() + userIn.getLastName() + " created");
                }
            } catch (Exception e) {

                LOG.error(e.getMessage(), e);
            } finally {
                endRequest();
            }

            if (!userIn.getStatus().equals("notmess") && project != null) {
                try {
                    identityManager.getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), true);
                    Utils.addToSpace(project, user_.getUserName());
                } catch (Exception e) {
                    LOG.error(e.getMessage(), e);
                }
            }
            i++;
        }


        LOG.info("Vendors Created");
        ActivityManager activityManager = (ActivityManager) ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ActivityManager.class);
        // create activity
      /*  ExoSocialActivity activity = new ExoSocialActivityImpl();
        activity.setUserId(sourceIdentity.getId());
        activity.setBody(null);
        Map<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("receiver", UIBBNDefaultActivity.GCS_GROUP);
        activity.setTemplateParams(templateParams);
        if (project != null) {
            Identity spaceIdentity = identityManager.getOrCreateIdentity(SpaceIdentityProvider.NAME, project.getPrettyName(), false);
            activity.setTitle(i + " users imported into this project");
            activity.setType(UIBBNDefaultActivity.ACTIVITY_TYPE);
            activityManager.saveActivityNoReturn(spaceIdentity, activity);
        } else {
            activity.setTitle(i + " users imported");
            activity.setType(UIBBNDefaultActivity.ACTIVITY_TYPE);
            activityManager.saveActivityNoReturn(sourceIdentity, activity);
        }
*/
    }


    private void startRequest() {
        if (orgService instanceof ComponentRequestLifecycle) {
            LOG.info("Conversation state import2:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
            LOG.info("PortalContainer import2:   " + PortalContainer.getInstance().getName());
            ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    private void endRequest() {
        if (requestStarted && orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle) orgService).endRequest(PortalContainer.getInstance());
            } catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
            requestStarted = false;
        }
    }

}
