package org.exoplatform.ps.rest;

import org.exoplatform.ps.DTO.ProjectRelClone;
import org.exoplatform.ps.chromattic.entity.SubUserInfo;
import org.exoplatform.ps.entity.SubContractorEntity;
import org.exoplatform.ps.model.BBProjectRelClone;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.model.BbMessage;
import org.exoplatform.ps.storage.api.ProjectSubRelationShipStorage;
import org.exoplatform.ps.storage.api.SubUserInfoStorage;
import org.exoplatform.ps.utils.RelationShipType;
import org.exoplatform.ps.utils.Utils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.*;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.identity.provider.OrganizationIdentityProvider;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by kevin on 1/2/15.
 */
public class MessagingRunner implements Runnable {

    private static final Log LOG = ExoLogger.getLogger(MessagingRunner.class.getName());
    private static Boolean requestStarted = false;
    OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
    private Space project;
    private String projectId;
    private String portalContainerName;
    private BbFilteredSearchRequest searchRequest;
    private BbMessage bbMessage;
    private Identity sourceIdentity;
    private boolean nonMessageOnly;
    private boolean sendAll;
    private String host;
    private String bidScop;
    private ConversationState myConversationState;

    MessagingRunner(Space project, String portalContainerName, BbMessage message, Identity sourceIdentity, boolean nonMessageOnly, String host, String bidScop, ConversationState conversationState) {

        this.project = project;
        this.projectId = message.getProjectId();
        this.portalContainerName = portalContainerName;
        this.searchRequest = message.getFilteredSearchRequest();
        this.searchRequest.setSubcats(message.getRelations());
        this.bbMessage = message;
        this.bbMessage.setAddNonInv(true);
        this.bbMessage.setRelations(message.getRelations());
        this.sourceIdentity = sourceIdentity;
        this.nonMessageOnly = nonMessageOnly;
        this.sendAll = searchRequest.isSendAllMessages();
        this.myConversationState = conversationState;
        this.host = host;
        this.bidScop = bidScop;

    }

    @Override
    public void run() {

        LOG.info("Messaging Runner Thread started - Preparing to send messages");
        SubCatRunner subCatRunner = null;

        if (nonMessageOnly) {
            subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.GET_NON_MESS, myConversationState);
        } else if (searchRequest.getsSearch_4().equalsIgnoreCase("INVITED")) {
            subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.INVITED_MESS, myConversationState);
        } else {
            subCatRunner = new SubCatRunner(project, projectId, portalContainerName, searchRequest, RelationShipType.PROJECT_SUB, myConversationState);
        }

        List<ProjectRelClone> myNonMsgd = new ArrayList<ProjectRelClone>();
        subCatRunner.setNonMessaged(myNonMsgd);

        Thread createSubCatRelation = new Thread(subCatRunner, "Sub Cat Runner Thread");
        createSubCatRelation.start();

        while (subCatRunner.isRunning()) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                LOG.error("Error while processing messages. {}", e.getMessage());
            }
        }

        try {

            if (myNonMsgd.size() > 0) {
                //Send email if the status was previously "NOT_MESS" and change status to "INVITED"
                // tmpResponse = addNonMsgd(request,response,uriInfo,projectId,gcHost,projectUrl,relations);
                RequestLifeCycle.begin(PortalContainer.getInstance());
//                    ConversationState conversationState = new ConversationState(sourceIdentity);
                ConversationState.setCurrent(myConversationState);
                LOG.info("Conversation state messaging:   " + ConversationState.getCurrent().getAttribute("currentTenant"));
                LOG.info("PortalContainer messaging:   " + PortalContainer.getInstance().getName());
                sendMessage(bbMessage, myNonMsgd, host, bidScop);
            }
        } catch (Exception e) {
            LOG.error("Error while sending messages. {}", e.getMessage());
        } finally {
            LOG.info("Messaging Runner Thread ended - Message send complete.");
            if (myNonMsgd.size() > 0)
                RequestLifeCycle.end();
        }
    }

    private void startRequest() {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
            requestStarted = true;
        }
    }

    private void endRequest() {
        if (requestStarted && orgService instanceof ComponentRequestLifecycle) {
            try {
                ((ComponentRequestLifecycle) orgService).endRequest(PortalContainer.getInstance());
            } catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
            requestStarted = false;
        }
    }

    public synchronized void sendMessage(BbMessage message, List<ProjectRelClone> relationShipsList, String host, String bidScop) throws Exception {

        SpaceService spaceService = Util.getSpaceService(portalContainerName);
        OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
        UserHandler uh = orgService.getUserHandler();
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        String subject = message.getSubject();
        Boolean isDaily = message.getIsDaily();
        Boolean addNonInv = message.getAddNonInv();
        Boolean updateEvent = message.getUpdateEvent();
        String newEventDate = message.getNewEventDate();
        String projectId = message.getProjectId();
        String mailText = message.getMailText();
        try {
            Space project = null;
            if (addNonInv != null && addNonInv && projectId != null) {
                project = spaceService.getSpaceByPrettyName(projectId);
                if (project == null) {
                    throw new Exception("Project not found");
                }
            }
            User user_;
            for (ProjectRelClone rel_ : relationShipsList) {
                user_ = uh.findUserByName(rel_.getSubId());
                if (user_ == null) {
                    LOG.info(rel_.getSubId() + " Not yet created sub by the thread import, will try to create it before messaging ");
                    startRequest();
                    MembershipTypeHandler mtHandler = orgService.getMembershipTypeHandler();
                    GroupHandler gHandler = orgService.getGroupHandler();
                    MembershipHandler mHandler = orgService.getMembershipHandler();
                    ((ComponentRequestLifecycle) orgService).startRequest(PortalContainer.getInstance());
                    SubUserInfoStorage subUserInfoStorage = (SubUserInfoStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubUserInfoStorage.class);

                    SubContractorEntity subUserInfo = subUserInfoStorage.getSubUserInfo(rel_.getSubId());
                    //Creation of the new user

                    user_ = uh.createUserInstance(rel_.getSubId());
                    user_.setDisplayName(subUserInfo.getDisplayName());

                    if (orgService.getClass().getName().equals("org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl")) {
                        user_.setPassword(Utils.getMd5(rel_.getSubId()));
                    } else {
                        user_.setPassword(rel_.getSubId());
                    }
                    user_.setEmail(subUserInfo.getEmail().toLowerCase());
                    user_.setLastName(subUserInfo.getLastName());
                    user_.setFirstName(subUserInfo.getFirstName());
                    Date now = new Date();
                    user_.setCreatedDate(now);
                    uh.createUser(user_, false);
                    Group subGroup = gHandler.findGroupById("/organization/subcontractors");
                    mHandler.linkMembership(user_, subGroup, mtHandler.findMembershipType("member"), false);
                    Group usersGroup = gHandler.findGroupById("/platform/users");
                    mHandler.linkMembership(user_, usersGroup, mtHandler.findMembershipType("member"), false);
                    LOG.info("SubContractor " + subUserInfo.getDisplayName() + " imported");
                    endRequest();
                }
                String to = user_.getUserName();
                String mailText_ = mailText;

                String trbidbuttons =
                        "                              <table border=\"0\" cellspacing=\"0\" cellpadding=\"8\" width=\"100%\">\n";

                trbidbuttons +=
                        "                                <tr><td colspan=\"3\" height=\"5\"><span>" + rel_.getCatCsiDesc() + "</span></td></tr>\n" +
                                "                                <tr>\n" +
                                "                                  <td align=\"right\" valign=\"middle\"><a href=\"" + host + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCatId() + "/" + user_.getUserName() + "/NOT_BIDDING\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/not_bidding.jpg\"></a>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"center\" valign=\"middle\"><a href=\"" + host + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCatId() + "/" + user_.getUserName() + "/UNDECIDED\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/undecided.jpg\"></a>\n" +
                                "                                  </td>\n" +
                                "                                  <td align=\"left\" valign=\"middle\"><a href=\"" + host + "/rest/bbprojectservice/emailsetsubstatus/" + projectId + "/" + rel_.getCatId() + "/" + user_.getUserName() + "/BIDDING\" target=\"_blank\">\n" +
                                "                                    <img style=\"-ms-interpolation-mode: bicubic; width:128px; height:35px\"\n" +
                                "                                      border=0 \n" +
                                "                                      alt=\"\" \n" +
                                "                                      align=middle src=\"http://eblast.berlinproductions.com/emails/itb/TBB-2109-2/images/will_bid.jpg\"></a>\n" +
                                "                                  </td>\n" +
                                "                                </tr>\n" +
                                "                                <tr><td colspan=\"3\" height=\"5\"></td></tr>\n";

                trbidbuttons +=
                        "                                <tr>\n" +
/*                                "                                  <td colspan=\"3\" align=\"left\" valign=\"middle\" style=\"font-family:Helvetica, Arial, sans-serif; color:#000000; font-size: 12px; border-top: 1px solid #c2c2c2; padding: 10px 0px;\">\n" +
                                "                                    <p>The reason you are receiving this email is you are registered in The Blue Book Network and were selected to be a member of this OneTeam Project.</p> If you'd no longer like to receive bid invitations from this GC <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 12px; text-decoration: none;\">click here</a><br />\n" +
                                "                                    If you'd no longer like to receive bid invitations from the OneTeam system <a href=\"#\" target=\"_blank\" style=\"font-family:Helvetica, Arial, sans-serif; color:#0094d1; font-size: 12px; text-decoration: none;\">click here</a> or call (888) 303-2243\n" +
                                "                                  </td>\n" +*/
                                "                                </tr>\n" +
                                "                              </table>\n";
                mailText_ = mailText_.replace("{|CATID|}", trbidbuttons);
                mailText_ = mailText_.replace("{|RECEIVERID|}", rel_.getSubId());
                mailText_ = mailText_.replace("{|RECEIVERFIRSTNAME|}", user_.getFirstName());
                mailText_ = mailText_.replace("{|RECEIVERLASTNAME|}", user_.getLastName());
                mailText_ = mailText_.replace("{|CLASSIFICATION|}", rel_.getCatCsiDesc());
                if (UsersRestService.sendMail(to, subject, mailText_, isDaily)) {
                    if (addNonInv != null && addNonInv && project != null) {
                        try {
                            IdentityManager identityManager=Util.getIdentityManager(portalContainerName);
                            identityManager.getOrCreateIdentity(OrganizationIdentityProvider.NAME, rel_.getSubId(), true);
                            Utils.addToSpace(project, rel_.getSubId());
                            projectSubRelationShipStorage.updateProjectSubRelationShip(rel_.getId(), null, "INVITED", null, null, null, bidScop);
                        } catch (Exception e) {
                            LOG.error(e.getMessage(), e);
                        }
                    }
                    if (updateEvent != null && updateEvent) {
                        CalendarService calService = (CalendarService) PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                        String CalendarId = project.getPrettyName() + "_space_calendar";
                        DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
                        Date duedate = formatter.parse(String.valueOf(newEventDate));
                        CalendarEvent duedateevent = calService.getEventById(project.getPrettyName() + " - bidsDueDate");
                        duedateevent.setFromDateTime(duedate);
                        duedateevent.setToDateTime(duedate);
                        duedateevent.setDescription(project.getDescription());
                        calService.savePublicEvent(CalendarId, duedateevent, false);
                    }

                    LOG.info("message is already sent to " + user_.getDisplayName() + " email= " + user_.getEmail().toLowerCase());
                }
            }

        } catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
    }

}
