package org.exoplatform.ps.rest;

import org.exoplatform.ps.DTO.ProjectRelClone;
import org.exoplatform.ps.chromattic.entity.SubCatGroupRelation;
import org.exoplatform.ps.chromattic.entity.SubGroup;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.SubCatEntity;
import org.exoplatform.ps.entity.SubCatGroupEntity;
import org.exoplatform.ps.entity.SubGroupEntity;
import org.exoplatform.ps.model.BbFilteredSearchRequest;
import org.exoplatform.ps.storage.api.*;
import org.exoplatform.ps.utils.RelationShipType;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by kevin on 12/26/14.
 */
public class SubCatRunner implements Runnable {
    private static final Log LOG = ExoLogger.getLogger(SubCatRunner.class.getName());
    private List<String> subcats = new ArrayList<String>(1);
    private String addtoselected = null;
    private BbFilteredSearchRequest searchRequest;
    private RelationShipType relationShipType;
    private Space project;
    private String projectId;
    private String portalContainerName;
    private boolean isRunning = true;
    private List<ProjectRelClone> nonMessaged = new ArrayList<ProjectRelClone>(1);
    private ConversationState myConversationState;

    SubCatRunner(BbFilteredSearchRequest searchRequest, RelationShipType relationShipType, ConversationState conversationState) {
        this.subcats = searchRequest.getSubcats();
        this.searchRequest = searchRequest;
        this.relationShipType = relationShipType;
        this.myConversationState = conversationState;
    }

    SubCatRunner(String addtoselected, BbFilteredSearchRequest searchRequest, RelationShipType relationShipType, ConversationState conversationState) {
        this.subcats = searchRequest.getSubcats();
        this.addtoselected = addtoselected;
        this.searchRequest = searchRequest;
        this.relationShipType = relationShipType;
        this.myConversationState = conversationState;
    }

    SubCatRunner(Space project, String projectId, String portalContainerName, BbFilteredSearchRequest searchRequest, RelationShipType relationShipType, ConversationState conversationState) {
        this.subcats = searchRequest.getSubcats();
        this.searchRequest = searchRequest;
        this.relationShipType = relationShipType;
        this.project = project;
        this.projectId = projectId;
        this.portalContainerName = portalContainerName;
        this.myConversationState = conversationState;
    }

    @Override
    public void run() {

        if (RelationShipType.SUB_CAT == relationShipType) {
            processSubCatGroups();
        } else if (RelationShipType.PROJECT_SUB == relationShipType) {
            processProjectSub(true);
        } else if (RelationShipType.GET_NON_MESS == relationShipType) {
            processProjectSub(false);
        } else if (RelationShipType.DELETE_ALL == relationShipType) {
            deleteAll(true);
        } else if (RelationShipType.CANCEL_REJECT == relationShipType) {
            deleteAll(false);
        } else if (RelationShipType.INVITED_MESS == relationShipType) {
            processProjectSub(false);
        }
    }

    public boolean isRunning() {
        return isRunning;
    }

    public void setNonMessaged(List<ProjectRelClone> nonMessaged) {
        this.nonMessaged = nonMessaged;
    }

    /*
    Need to have a way to only delete "some" 
    in this case no need to loop through all subcats. 
    There will be a list of selected users sent from the UI.
     */
    private synchronized void deleteAll(boolean fullDelete) {
        RequestLifeCycle.begin(PortalContainer.getInstance());
        LOG.info("Sub Cat Runner Thread started - Deleting Users");

        ConversationState.setCurrent(myConversationState);

        LOG.debug("is fullDelete is set to :" + fullDelete);

        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        OrganizationService orgService = (OrganizationService) PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);

        UserHandler uh = orgService.getUserHandler();

        List<String> SearchConditions = new ArrayList<String>();

        SearchConditions.add(searchRequest.getsSearch_1());
        SearchConditions.add(searchRequest.getsSearch_2());
        SearchConditions.add(searchRequest.getsSearch_3());
        SearchConditions.add(searchRequest.getsSearch_4());
        SearchConditions.add(searchRequest.getsSearch_5());
        SearchConditions.add(searchRequest.getsSearch_6());
        SearchConditions.add(searchRequest.getsSearch_7());
        SearchConditions.add(searchRequest.getsSearch_9());
        SearchConditions.add(searchRequest.getsSearch_10());
        SearchConditions.add(searchRequest.getSearchsubs());

        int total = 0;
        int numToProcess = 100;
        int lastProcessed = 0;
        int numProcessed = 0;
        int numRemaining = 0;

        try {
            Identity sourceIdentity = null;
            SpaceService spaceService = null;
            if (null != projectId) {
                sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
                spaceService = Util.getSpaceService(portalContainerName);
            }

            if (!fullDelete) {

                List<String> filteredgroups = searchRequest.getFilteredGroups();
                if (filteredgroups != null && filteredgroups.size() > 0) {
                    SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                    for (String filteredgroup : filteredgroups) {
                        List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                        for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                            ProjectSubEntity relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                if (subcats.contains(relationShip.getId())) continue;
                                if (!relationShip.getStatus().equalsIgnoreCase(SearchConditions.get(3))) continue;
                                if (null != project) {
                                    if(projectSubRelationShipStorage.getRelationShipCountBySubId(subCatGroupRelation.getSubContractor().getId())==0)
                                    {
                                        if (spaceService.isInvitedUser(project, relationShip.getSubContractor().getId())) {
                                            spaceService.removeInvitedUser(project, relationShip.getSubContractor().getId());
                                        } else if (spaceService.isMember(project, relationShip.getSubContractor().getId())) {
                                            spaceService.removeMember(project, relationShip.getSubContractor().getId());
                                        }
                                    }

                                }
                                projectSubRelationShipStorage.deleteProjectSubRelationShip(relationShip.getId());

                            } catch (Exception e) {
                                LOG.error(e.getMessage(), e);                            }
                        }
                    }
                } else {
                    ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<ProjectSubEntity>(1), "tbb:subId", "asc", projectId);
                    LOG.debug(relList.getSize());
                    for (ProjectSubEntity sub : relList.load(0, relList.getSize())) {
                        if (null != project) {
                            if(projectSubRelationShipStorage.getRelationShipCountBySubId(sub.getSubContractor().getId())==0) {
                                if (spaceService.isInvitedUser(project, sub.getSubContractor().getId())) {
                                    spaceService.removeInvitedUser(project, sub.getSubContractor().getId());
                                } else if (spaceService.isMember(project, sub.getSubContractor().getId())) {
                                    spaceService.removeMember(project, sub.getSubContractor().getId());
                                }
                            }
                        }
                        projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                    }
                }
            } else {
                if (searchRequest.getSubSelect().size() == 0) {

                    total = subCatStorage.subCatSearchCount(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());

                    List<SubCatEntity> subCatList = subCatStorage.subCatSearch(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                    LOG.debug(subCatList.size());
                    BBCategoryStorage bbCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);

                    List<String> names = new ArrayList<String>(1);
                    for (SubCatEntity subcat : subCatList) {
                        names.add(subcat.getSubContractor().getId());
                    }

                    while (subCatList.size() > 0) {
                        for (String uName : names) {
                            if (subcats.contains(uName)) continue;
                            ListAccess<ProjectSubEntity> sublist = projectSubRelationShipStorage.getRelationShipBySubIdListAccess(uName);
                            for (ProjectSubEntity sub : sublist.load(0, sublist.getSize())) {
                                if(projectSubRelationShipStorage.getRelationShipCountBySubId(sub.getSubContractor().getId())==0) {
                                if (null != project) {
                                    if (spaceService.isInvitedUser(project, sub.getSubContractor().getId())) {
                                        spaceService.removeInvitedUser(project, sub.getSubContractor().getId());
                                    } else if (spaceService.isMember(project, sub.getSubContractor().getId())) {
                                        spaceService.removeMember(project, sub.getSubContractor().getId());
                                    }
                                }
                                }
                                projectSubRelationShipStorage.deleteProjectSubRelationShip(sub.getId());
                            }

                            LOG.info("Relationship Removed");

                            List<SubCatEntity> subcats = subCatStorage.getSubCatsBySubId(uName, 0, 0);

                            for (SubCatEntity subcat : subcats) {
                                bbCategoryStorage.deleteBBCategory(subcat.getCategory().getId());
                                subCatStorage.deleteSubCat(subcat.getCategory().getId());
                            }

                            // Before updating  user, check if the userName exists or not
                            User user = uh.findUserByName(uName);
                            if (user == null) {
                                LOG.warn(uName + " user name don't exists");
                                continue;
                            }
                            user.setPassword("pass");

                            LOG.info("SubContractor  deleted");
                        }

                        numProcessed++;
                        lastProcessed++;

                        if (lastProcessed >= total) break;

                        if (numProcessed >= numToProcess || numProcessed >= numRemaining) {
                            RequestLifeCycle.end();
                            Thread.sleep(1000);
                            RequestLifeCycle.begin(PortalContainer.getInstance());
                            numProcessed = 0;
                            subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                            projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
                            if (null != projectId) {
                                sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
                                spaceService = Util.getSpaceService(portalContainerName);
                            }
                            bbCategoryStorage = (BBCategoryStorage) PortalContainer.getInstance().getComponentInstanceOfType(BBCategoryStorage.class);
                            subCatList.clear();
                            names.clear();
                            subCatList = subCatStorage.subCatSearch(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", 0, numToProcess);
                            numRemaining = subCatList.size();
                            for (SubCatEntity subcat : subCatList) {
                                names.add(subcat.getSubContractor().getId());
                            }
                        }
                    }

                }

            }
        } catch (Exception e) {
            LOG.error("Error while processing subCats. {}", e.getMessage());
        } finally {
            LOG.info("Sub Cat Runner Thread ended - Deleted Users");
            RequestLifeCycle.end();
            isRunning = false;
        }

    }

    private synchronized void buildInvitedMessList() {

    }

    private synchronized void processProjectSub(boolean createNonMess) {
        RequestLifeCycle.begin(PortalContainer.getInstance());
        LOG.info("Sub Cat Runner Thread started - Creating Project Sub Relationships");
        ConversationState.setCurrent(myConversationState);

        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        ProjectSubRelationShipStorage projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
        IdentityManager identityManager = Util.getIdentityManager(portalContainerName);

        List<String> SearchConditions = new ArrayList<String>();
        SearchConditions.add(searchRequest.getsSearch_1());
        SearchConditions.add(searchRequest.getsSearch_2());
        SearchConditions.add(searchRequest.getsSearch_3());
        SearchConditions.add(searchRequest.getsSearch_4());
        SearchConditions.add(searchRequest.getsSearch_5());
        SearchConditions.add(searchRequest.getsSearch_6());
        SearchConditions.add(searchRequest.getsSearch_7());
        SearchConditions.add(searchRequest.getsSearch_9());
        SearchConditions.add(searchRequest.getsSearch_10());
        SearchConditions.add(searchRequest.getSearchsubs());

        int total = 0;
        int numToProcess = 100;
        int lastProcessed = 0;
        int numProcessed = 0;

        try {

            if (searchRequest.getFilteredGroups() != null && searchRequest.getFilteredGroups().size() > 0) {
                SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                List<ProjectSubEntity> included = new ArrayList<ProjectSubEntity>();
                List<String> filteredgroups = searchRequest.getFilteredGroups();
                if (filteredgroups != null && filteredgroups.size() > 0) {
                    for (String filteredgroup : filteredgroups) {
                        List<SubCatGroupEntity> subCatGroupRelations = subCatGroupRelationStorage.getRelationShipBySubGroupId(filteredgroup, 0, 0);
                        for (SubCatGroupEntity subCatGroupRelation : subCatGroupRelations) {
                            ProjectSubEntity relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subCatGroupRelation.getSubContractor().getId(), projectId, subCatGroupRelation.getCategory().getId());
                                if (subcats.contains(relationShip.getId())) continue;
                            } catch (Exception e) {
                                if (createNonMess) {
                                    if (subCatGroupRelation.getSubContractor().getId() != "" && subCatGroupRelation.getCategory().getId()!= "") {
                                        SubCatEntity subcat = subCatStorage.getSubCat(subCatGroupRelation.getSubContractor().getId() + "_" + subCatGroupRelation.getCategory().getId());
                                        relationShip = projectSubRelationShipStorage.createProjectSubRelationShip(subcat, project.getPrettyName(), "NOT_MESS", "", subcat.getSubContractor().getRank(), "no");
                                        LOG.info("SubContractor " + subcat.getId() + " added to the project: " + project.getPrettyName());
                                    } else {
                                        LOG.warn("Sub Id or category is null, relationship will not be created");
                                    }

                                    if (relationShip.getStatus().equals("NOT_MESS")) {
                                        nonMessaged.add(new ProjectRelClone(relationShip));
                                    }
                                }
                            }

                            try {
                                if (!createNonMess && relationShip != null && relationShip.getStatus().equals(SearchConditions.get(3))) {
                                    nonMessaged.add(new ProjectRelClone(relationShip));
                                }
                            } catch (Exception e) {
                                LOG.error(e.getMessage(), e);                            }
                        }
                    }
                }

            } else {
                if (SearchConditions.get(3).equalsIgnoreCase("NOT_MESS") || SearchConditions.get(3).equalsIgnoreCase("INVITED")) {
                    ListAccess<ProjectSubEntity> relList = projectSubRelationShipStorage.getRelationShipByProjectIdAndSearchCondListAccess(false, false, false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<ProjectSubEntity>(1), "tbb:subId", "asc", projectId);
                    LOG.debug(relList.getSize());
                    for (ProjectSubEntity relationShip : relList.load(0, relList.getSize())) {
                        nonMessaged.add(new ProjectRelClone(relationShip));

                    }
                } else {
                    total = subCatStorage.subCatSearchCount(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                    List<SubCatEntity> subCatList = subCatStorage.subCatSearch(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                    LOG.debug(subCatList.size());
                    while (subCatList.size() > 0) {
                        for (SubCatEntity subcat : subCatList) {
                            if (subcats.contains(subcat.getId())) continue;
                            ProjectSubEntity relationShip = null;
                            try {
                                relationShip = projectSubRelationShipStorage.getRelationShip(subcat.getSubContractor().getId(), projectId, subcat.getCategory().getId());
                                if (subcats.contains(relationShip.getId())) continue;
                            } catch (Exception e) {
                                if (createNonMess) {
                                    if (subcat.getSubContractor().getId() != "" && subcat.getCategory().getId() != "") {
                                        relationShip = projectSubRelationShipStorage.createProjectSubRelationShip(subcat, project.getPrettyName(), "NOT_MESS", "", subcat.getSubContractor().getRank(), "no");
                                        LOG.info("SubContractor " + subcat.getId() + " added to the project: " + project.getPrettyName());
                                    } else {
                                        LOG.warn("Sub Id or category is null, relationship will not be created");
                                    }

                                    if (relationShip.getStatus().equals("NOT_MESS")) {
                                        nonMessaged.add(new ProjectRelClone(relationShip));
                                    }
                                }

                            }

                            try {
                                if (!createNonMess && relationShip != null && relationShip.getStatus().equals("NOT_MESS")) {
                                    nonMessaged.add(new ProjectRelClone(relationShip));
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                            numProcessed++;
                            lastProcessed++;
                        }

                        if (lastProcessed >= total || nonMessaged.size() == Integer.parseInt(searchRequest.getTotRecords()))
                            break;

                        if (numProcessed >= numToProcess) {
                            RequestLifeCycle.end();
                            Thread.sleep(1000);
                            RequestLifeCycle.begin(PortalContainer.getInstance());
                            numProcessed = 0;
                            subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
                            projectSubRelationShipStorage = (ProjectSubRelationShipStorage) PortalContainer.getInstance().getComponentInstanceOfType(ProjectSubRelationShipStorage.class);
                            subCatList.clear();
                            subCatList = subCatStorage.subCatSearch(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);

                        }
                    }
                }
            }
        } catch (Exception e) {
            LOG.error("Error while processing subCats. {}", e.getMessage());
        } finally {
            LOG.info("Sub Cat Runner Thread ended - Created Project Sub Relationships");
            RequestLifeCycle.end();
            isRunning = false;
        }

    }

    private synchronized void processSubCatGroups() {
        RequestLifeCycle.begin(PortalContainer.getInstance());
        LOG.info("Sub Cat Runner Thread started - Creating Sub Cat Groups");

        ConversationState.setCurrent(myConversationState);

        SubCatGroupRelationStorage subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
        SubCatStorage subCatStorage = (SubCatStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatStorage.class);
        SubGroupStorage subGroupStorage = (SubGroupStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);

        List<String> SearchConditions = new ArrayList<String>();
        SearchConditions.add(searchRequest.getsSearch_1());
        SearchConditions.add(searchRequest.getsSearch_2());
        SearchConditions.add(searchRequest.getsSearch_3());
        SearchConditions.add(searchRequest.getsSearch_4());
        SearchConditions.add(searchRequest.getsSearch_5());
        SearchConditions.add(searchRequest.getsSearch_6());
        SearchConditions.add(searchRequest.getsSearch_7());
        SearchConditions.add(searchRequest.getSearchsubs());
        SearchConditions.add(searchRequest.getsSearch_8());
        SearchConditions.add(searchRequest.getsSearch_9());


        int total = 0;
        int numToProcess = 100;
        int lastProcessed = 0;
        int numProcessed = 0;

        try {

            List<String> filteredgroups = searchRequest.getFilteredGroups();
            List<SubCatEntity> subCatList = new ArrayList<SubCatEntity>(1);
            if (filteredgroups != null && filteredgroups.size() > 0) {
                for (String filteredgroup : filteredgroups) {
                    if ("ranked-vendors".equalsIgnoreCase(filteredgroup)) {
                        total = subCatStorage.subCatSearchCount(true, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                        subCatList = subCatStorage.subCatSearch(true, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                    }
                }
            } else {
                total = subCatStorage.subCatSearchCount(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>());
                subCatList = subCatStorage.subCatSearch(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
            }

            String[] selectedarray = addtoselected.split(",");

            while (subCatList.size() > 0) {
                for (SubCatEntity subcat : subCatList) {
                    String subcatId = subcat.getId();
                    if (subcats.contains(subcatId)) continue;
                    for (String selectedgroup : selectedarray) {
                        SubGroupEntity subGroup = subGroupStorage.getSubGroup(selectedgroup);
                        subCatGroupRelationStorage.createSubCatGroupRelation(selectedgroup, subcatId, subcat.getSubContractor().getId(), subcat.getSubContractor().getDisplayName(), subcat.getCategory().getId(), subcat.getCategory().getCatCsiDesc(), subGroup.getSubGroupName());
                    }
                    LOG.info("SubContractor " + subcatId + " added to the groups: " + addtoselected);
                    numProcessed++;
                    lastProcessed++;
                }

                if (lastProcessed >= total) break;

                if (numProcessed >= numToProcess) {
                    RequestLifeCycle.end();
                    Thread.sleep(1000);
                    RequestLifeCycle.begin(PortalContainer.getInstance());
                    numProcessed = 0;
                    subCatGroupRelationStorage = (SubCatGroupRelationStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubCatGroupRelationStorage.class);
                    subGroupStorage = (SubGroupStorage) PortalContainer.getInstance().getComponentInstanceOfType(SubGroupStorage.class);
                    subCatList.clear();
                    subCatList = subCatStorage.subCatSearch(false, searchRequest.getSearchsubs(), SearchConditions, new ArrayList<SubCatEntity>(), new ArrayList<SubCatEntity>(), "tbb:subid", "asc", lastProcessed, numToProcess);
                }
            }

        } catch (Exception e) {
            LOG.error("Error while processing subCats. {}", e.getMessage());
        } finally {
            LOG.info("Sub Cat Runner Thread ended - Created Sub Cat Groups");
            RequestLifeCycle.end();
            isRunning = false;
        }
    }
}