package org.exoplatform.ps.service.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ps.DAO.StaffDAO;
import org.exoplatform.ps.entity.ProjectSubEntity;
import org.exoplatform.ps.entity.StaffEntity;
import org.exoplatform.ps.integration.notification.PSSendITBPlugin;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.security.ConversationState;

public class SendItbListener extends Listener<ProjectSubEntity,String> {

    @Override
    public void onEvent(Event<ProjectSubEntity,  String> event) throws Exception {
        ProjectSubEntity projectSubEntity = event.getSource();
        StaffDAO staffDAO = (StaffDAO) PortalContainer.getInstance().getComponentInstanceOfType(StaffDAO.class);
        StaffEntity staffEntity = staffDAO.find(ConversationState.getCurrent().getIdentity().getUserId());

        String creatorStaff = staffEntity.getFirstName()+" "+staffEntity.getLastName();
        String companyname = staffEntity.getGeneralContractorEntity().getCompanyName();
        String phone = staffEntity.getGeneralContractorEntity().getCompanyPhone();
        String contact = staffEntity.getFirstName()+" "+staffEntity.getLastName();


        String poster = event.getData();

        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(PSSendITBPlugin.PROJECT, projectSubEntity).append(PSSendITBPlugin.POSTER, poster)
                .append(PSSendITBPlugin.CREATORSTAFF, creatorStaff)
                .append(PSSendITBPlugin.GC_PHONE, phone)
                .append(PSSendITBPlugin.COMPANY_NAME, companyname)
                .append(PSSendITBPlugin.GC_CONTACT, contact);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(PSSendITBPlugin.ID))).execute(ctx);
    }
}
